/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.providers.maildir;

import gnu.mail.providers.ReadOnlyMessage;
import gnu.mail.providers.maildir.MaildirFolder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public final class MaildirMessage
extends ReadOnlyMessage {
    static final String PASSED = "Passed";
    File file;
    String uniq;

    MaildirMessage(MaildirFolder folder, File file, String uniq, String info, int msgnum) throws MessagingException {
        super(folder, msgnum);
        this.file = file;
        this.uniq = uniq;
        if (info != null && info.startsWith("2,")) {
            int len = info.length();
            block8: for (int i = 2; i < len; ++i) {
                switch (info.charAt(i)) {
                    case 'D': {
                        this.flags.add(Flags.Flag.DRAFT);
                        continue block8;
                    }
                    case 'F': {
                        this.flags.add(Flags.Flag.FLAGGED);
                        continue block8;
                    }
                    case 'P': {
                        this.flags.add(PASSED);
                        continue block8;
                    }
                    case 'R': {
                        this.flags.add(Flags.Flag.ANSWERED);
                        continue block8;
                    }
                    case 'S': {
                        this.flags.add(Flags.Flag.SEEN);
                        continue block8;
                    }
                    case 'T': {
                        this.flags.add(Flags.Flag.DELETED);
                    }
                }
            }
        }
    }

    MaildirMessage(MaildirFolder folder, MimeMessage message, int msgnum) throws MessagingException {
        super(message);
        this.folder = folder;
        this.msgnum = msgnum;
    }

    protected void setExpunged(boolean expunged) {
        super.setExpunged(expunged);
    }

    @Override
    public synchronized void setFlags(Flags flag, boolean set) throws MessagingException {
        if (set) {
            this.flags.add(flag);
        } else {
            this.flags.remove(flag);
        }
        if (flag.contains(Flags.Flag.SEEN)) {
            ((MaildirFolder)this.folder).setSeen(this, set);
        }
    }

    String getUniq() {
        return this.uniq;
    }

    String getInfo() throws MessagingException {
        return MaildirMessage.getInfo(this.flags);
    }

    static String getInfo(Flags flags) throws MessagingException {
        StringBuffer buffer = new StringBuffer();
        buffer.append('2');
        buffer.append(',');
        if (flags.contains(Flags.Flag.DRAFT)) {
            buffer.append('D');
        }
        if (flags.contains(Flags.Flag.FLAGGED)) {
            buffer.append('F');
        }
        if (flags.contains(PASSED)) {
            buffer.append('P');
        }
        if (flags.contains(Flags.Flag.ANSWERED)) {
            buffer.append('R');
        }
        if (flags.contains(Flags.Flag.SEEN)) {
            buffer.append('S');
        }
        if (flags.contains(Flags.Flag.DELETED)) {
            buffer.append('T');
        }
        return buffer.toString();
    }

    void fetchHeaders() throws MessagingException {
        if (this.headers != null) {
            return;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
            this.headers = this.createInternetHeaders(in);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    void fetch() throws MessagingException {
        if (this.content != null) {
            return;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
            this.parse(in);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw new MessagingException(e.getMessage(), (Exception)e);
        }
    }

    public String[] getHeader(String name) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getHeader(name, delimiter);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getAllHeaders();
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getMatchingHeaders(names);
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getNonMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        if (this.headers == null) {
            this.fetchHeaders();
        }
        return super.getNonMatchingHeaderLines(names);
    }

    public DataHandler getDataHandler() throws MessagingException {
        if (this.content == null) {
            this.fetch();
        }
        return super.getDataHandler();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.content == null) {
            this.fetch();
        }
        return super.getContentStream();
    }

    public boolean equals(Object other) {
        if (other instanceof MimeMessage) {
            MimeMessage message = (MimeMessage)other;
            return message.getFolder() == this.getFolder() && message.getMessageNumber() == this.getMessageNumber();
        }
        return false;
    }
}

