/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javajs.util.P3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class GromacsReader
extends AtomSetCollectionReader {
    @Override
    protected void initializeReader() {
        this.setIsPDB();
        this.asc.newAtomSet();
        this.setModelPDB(true);
    }

    @Override
    protected boolean checkLine() throws Exception {
        this.checkCurrentLineForScript();
        this.asc.setAtomSetName(this.line.trim());
        this.readAtoms();
        this.readUnitCell();
        this.continuing = false;
        return false;
    }

    private void readAtoms() throws Exception {
        int n = this.parseIntStr(this.rd());
        int n2 = 0;
        while (n2 < n) {
            this.rd();
            int n3 = this.line.length();
            if (n3 != 44 && n3 != 68) {
                Logger.warn("line cannot be read for GROMACS atom data: " + this.line);
            } else {
                Atom atom = new Atom();
                atom.sequenceNumber = this.parseIntRange(this.line, 0, 5);
                this.setAtomName(atom, this.parseTokenRange(this.line, 5, 9).trim(), this.line.substring(11, 15).trim());
                atom.atomSerial = this.parseIntRange(this.line, 15, 20);
                atom.x = this.parseFloatRange(this.line, 20, 28) * 10.0f;
                atom.y = this.parseFloatRange(this.line, 28, 36) * 10.0f;
                atom.z = this.parseFloatRange(this.line, 36, 44) * 10.0f;
                if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                    Logger.warn("line cannot be read for GROMACS atom data: " + this.line);
                    atom.set(0.0f, 0.0f, 0.0f);
                }
                this.setAtomCoord(atom);
                atom.elementSymbol = this.deduceElementSymbol(atom.group3, atom.atomName);
                if (this.filterAtom(atom, n2)) {
                    atom.isHetero = false;
                    this.asc.addAtom(atom);
                    if (n3 >= 69) {
                        float f = this.parseFloatRange(this.line, 44, 52) * 10.0f;
                        float f2 = this.parseFloatRange(this.line, 52, 60) * 10.0f;
                        float f3 = this.parseFloatRange(this.line, 60, 68) * 10.0f;
                        if (!(Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3))) {
                            this.asc.addVibrationVector(atom.index, f, f2, f3);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void setAtomName(Atom atom, String string, String string2) {
        atom.atomName = string2;
        if (string.equals("SOL") && string2.length() == 3 && "OW1;HW2;HW3".indexOf(string2) >= 0) {
            string = "WAT";
        }
        atom.group3 = string;
    }

    String deduceElementSymbol(String string, String string2) {
        if (string2.length() <= 2 && string.equals(string2)) {
            return string2;
        }
        char c = string2.length() == 4 ? string2.charAt(0) : (char)'\u0000';
        char c2 = string2.charAt(string2.length() == 4 ? 1 : 0);
        boolean bl = this.vwr.getJBR().isHetero(string);
        if (Atom.isValidSymNoCase(c, c2)) {
            return bl || c != 'H' ? "" + c + c2 : "H";
        }
        if (Atom.isValidSym1(c2)) {
            return "" + c2;
        }
        if (Atom.isValidSym1(c)) {
            return "" + c;
        }
        return "Xx";
    }

    private void readUnitCell() throws Exception {
        if (this.rd() == null) {
            return;
        }
        String[] stringArray = this.getTokens();
        if (stringArray.length < 3 || !this.doApplySymmetry) {
            return;
        }
        float f = 10.0f * this.parseFloatStr(stringArray[0]);
        float f2 = 10.0f * this.parseFloatStr(stringArray[1]);
        float f3 = 10.0f * this.parseFloatStr(stringArray[2]);
        this.setUnitCell(f, f2, f3, 90.0f, 90.0f, 90.0f);
        this.setSpaceGroupName("P1");
        Atom[] atomArray = this.asc.atoms;
        P3 p3 = P3.new3(0.5f, 0.5f, 0.5f);
        int n = this.asc.ac;
        while (--n >= 0) {
            this.setAtomCoord(atomArray[n]);
            atomArray[n].add(p3);
        }
    }
}

