/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.tools.plugin;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.tools.plugin.DiffusionMethods;
import org.gephi.tools.plugin.Painter;
import org.gephi.tools.spi.NodePressingEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolSelectionType;
import org.gephi.tools.spi.ToolUI;
import org.gephi.ui.tools.plugin.BrushPanel;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class Brush
implements Tool {
    private ToolEventListener[] listeners;
    private BrushPanel brushPanel;
    private float[] color = new float[]{1.0f, 0.0f, 0.0f};
    private float intensity = 0.3f;
    private DiffusionMethods.DiffusionMethod diffusionMethod = DiffusionMethods.DiffusionMethod.NEIGHBORS;

    public void select() {
    }

    public void unselect() {
        this.listeners = null;
        this.brushPanel = null;
    }

    private void brush(Node[] nodes) {
        float b;
        float g;
        float r;
        for (Node node : nodes) {
            r = node.r();
            g = node.g();
            b = node.b();
            r = this.intensity * this.color[0] + (1.0f - this.intensity) * r;
            g = this.intensity * this.color[1] + (1.0f - this.intensity) * g;
            b = this.intensity * this.color[2] + (1.0f - this.intensity) * b;
            node.setR(r);
            node.setG(g);
            node.setB(b);
        }
        for (Node node : this.getDiffusedNodes(nodes)) {
            r = node.r();
            g = node.g();
            b = node.b();
            r = this.intensity * this.color[0] + (1.0f - this.intensity) * r;
            g = this.intensity * this.color[1] + (1.0f - this.intensity) * g;
            b = this.intensity * this.color[2] + (1.0f - this.intensity) * b;
            node.setR(r);
            node.setG(g);
            node.setB(b);
        }
    }

    private Node[] getDiffusedNodes(Node[] input) {
        GraphModel model = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel();
        switch (this.diffusionMethod) {
            case NEIGHBORS: {
                return DiffusionMethods.getNeighbors(model.getGraphVisible(), input);
            }
            case NEIGHBORS_OF_NEIGHBORS: {
                return DiffusionMethods.getNeighborsOfNeighbors(model.getGraphVisible(), input);
            }
            case PREDECESSORS: {
                if (model.isDirected()) {
                    return DiffusionMethods.getPredecessors(model.getDirectedGraphVisible(), input);
                }
                return DiffusionMethods.getNeighbors(model.getGraphVisible(), input);
            }
            case SUCCESSORS: {
                if (model.isDirected()) {
                    return DiffusionMethods.getSuccessors(model.getDirectedGraphVisible(), input);
                }
                return DiffusionMethods.getNeighbors(model.getGraphVisible(), input);
            }
        }
        return new Node[0];
    }

    public ToolEventListener[] getListeners() {
        this.listeners = new ToolEventListener[1];
        this.listeners[0] = new NodePressingEventListener(){

            public void pressingNodes(Node[] nodes) {
                Brush.this.diffusionMethod = Brush.this.brushPanel.getDiffusionMethod();
                Brush.access$202(Brush.this, Brush.this.brushPanel.getColor().getColorComponents(Brush.this.color));
                Brush.this.intensity = Brush.this.brushPanel.getIntensity();
                Brush.this.brush(nodes);
            }

            public void released() {
            }
        };
        return this.listeners;
    }

    public ToolUI getUI() {
        return new ToolUI(){

            public JPanel getPropertiesBar(Tool tool) {
                Brush.this.brushPanel = new BrushPanel();
                Brush.this.brushPanel.setDiffusionMethod(Brush.this.diffusionMethod);
                Brush.this.brushPanel.setColor(new Color(Brush.this.color[0], Brush.this.color[1], Brush.this.color[2]));
                Brush.this.brushPanel.setIntensity(Brush.this.intensity);
                return Brush.this.brushPanel;
            }

            public String getName() {
                return NbBundle.getMessage(Brush.class, (String)"Brush.name");
            }

            public Icon getIcon() {
                return new ImageIcon(this.getClass().getResource("/org/gephi/tools/plugin/resources/brush.png"));
            }

            public String getDescription() {
                return NbBundle.getMessage(Painter.class, (String)"Brush.description");
            }

            public int getPosition() {
                return 110;
            }
        };
    }

    public ToolSelectionType getSelectionType() {
        return ToolSelectionType.SELECTION;
    }

    static /* synthetic */ float[] access$202(Brush x0, float[] x1) {
        x0.color = x1;
        return x1;
    }
}

