/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.IceBox.AlreadyStartedException;
import com.zeroc.IceBox.AlreadyStoppedException;
import com.zeroc.IceBox.ServiceManagerPrx;
import com.zeroc.IceGrid.AdapterDescriptor;
import com.zeroc.IceGrid.AdapterDynamicInfo;
import com.zeroc.IceGrid.AdminSessionPrx;
import com.zeroc.IceGrid.DbEnvDescriptor;
import com.zeroc.IceGrid.DeploymentException;
import com.zeroc.IceGrid.FileIteratorPrx;
import com.zeroc.IceGrid.FileNotAvailableException;
import com.zeroc.IceGrid.NodeUnreachableException;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGrid.ServerNotExistException;
import com.zeroc.IceGrid.ServerState;
import com.zeroc.IceGrid.ServiceDescriptor;
import com.zeroc.IceGrid.ServiceInstanceDescriptor;
import com.zeroc.IceGridGUI.LiveActions;
import com.zeroc.IceGridGUI.LiveDeployment.Adapter;
import com.zeroc.IceGridGUI.LiveDeployment.Communicator;
import com.zeroc.IceGridGUI.LiveDeployment.DbEnv;
import com.zeroc.IceGridGUI.LiveDeployment.Editor;
import com.zeroc.IceGridGUI.LiveDeployment.MetricsView;
import com.zeroc.IceGridGUI.LiveDeployment.Node;
import com.zeroc.IceGridGUI.LiveDeployment.Server;
import com.zeroc.IceGridGUI.LiveDeployment.ServiceEditor;
import com.zeroc.IceGridGUI.LiveDeployment.ShowLogFileDialog;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class Service
extends Communicator {
    private final ServiceInstanceDescriptor _instanceDescriptor;
    private final ServiceDescriptor _serviceDescriptor;
    private final PropertySetDescriptor _serverInstancePSDescriptor;
    private final Utils.Resolver _resolver;
    private List<Adapter> _adapters = new LinkedList<Adapter>();
    private List<DbEnv> _dbEnvs = new LinkedList<DbEnv>();
    private boolean _started = false;
    private static ServiceEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;
    private static Icon _startedIcon;
    private static Icon _stoppedIcon;

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[25];
        ServerState serverState = ((Server)this._parent).getState();
        if (serverState != null) {
            boolean bl = actions[15] = this._serviceDescriptor.logs.length > 0;
        }
        if (serverState == ServerState.Active) {
            boolean bl = actions[12] = serverState == ServerState.Active;
            if (((Server)this._parent).hasServiceObserver()) {
                actions[0] = !this._started;
                actions[1] = this._started;
            } else {
                actions[0] = true;
                actions[1] = true;
            }
        }
        return actions;
    }

    @Override
    public void start() {
        ServiceManagerPrx serviceManager = ServiceManagerPrx.uncheckedCast((ObjectPrx)((Server)this._parent).getAdminFacet("IceBox.ServiceManager"));
        if (serviceManager != null) {
            String prefix = "Starting service '" + this._id + "'...";
            this.getCoordinator().getStatusBar().setText(prefix);
            try {
                serviceManager.startServiceAsync(this._id).whenComplete((result, ex) -> {
                    if (ex == null || ex instanceof AlreadyStartedException) {
                        this.amiSuccess(prefix);
                    } else {
                        this.amiFailure(prefix, "Failed to start service " + this._id, ex.toString());
                    }
                });
            }
            catch (LocalException e) {
                this.failure(prefix, "Failed to start service " + this._id, e.toString());
            }
        }
    }

    @Override
    public void stop() {
        ServiceManagerPrx serviceManager = ServiceManagerPrx.uncheckedCast((ObjectPrx)((Server)this._parent).getAdminFacet("IceBox.ServiceManager"));
        if (serviceManager != null) {
            String prefix = "Stopping service '" + this._id + "'...";
            this.getCoordinator().getStatusBar().setText(prefix);
            try {
                serviceManager.stopServiceAsync(this._id).whenComplete((result, ex) -> {
                    if (ex == null || ex instanceof AlreadyStoppedException) {
                        this.amiSuccess(prefix);
                    } else {
                        this.amiFailure(prefix, "Failed to stop service " + this._id, ex.toString());
                    }
                });
            }
            catch (LocalException e) {
                this.failure(prefix, "Failed to stop service " + this._id, e.toString());
            }
        }
    }

    @Override
    public void retrieveLogFile() {
        assert (this._serviceDescriptor.logs.length > 0);
        String path = null;
        if (this._serviceDescriptor.logs.length == 1) {
            path = this._resolver.substitute(this._serviceDescriptor.logs[0]);
        } else {
            Object[] pathArray = new Object[this._serviceDescriptor.logs.length];
            int i = 0;
            for (String log : this._serviceDescriptor.logs) {
                pathArray[i++] = this._resolver.substitute(log);
            }
            path = (String)JOptionPane.showInputDialog(this.getCoordinator().getMainFrame(), "Which log file do you want to retrieve?", "Retrieve Log File", 3, null, pathArray, pathArray[0]);
        }
        if (path != null) {
            final String fPath = path;
            this.getRoot().openShowLogFileDialog(new ShowLogFileDialog.FileIteratorFactory(){

                @Override
                public FileIteratorPrx open(int count) throws FileNotAvailableException, ServerNotExistException, NodeUnreachableException, DeploymentException {
                    AdminSessionPrx session = Service.this.getRoot().getCoordinator().getSession();
                    return session.openServerLog(Service.this._parent.getId(), fPath, count);
                }

                @Override
                public String getTitle() {
                    return "Service " + Service.this._parent.getId() + "/" + Service.this._id + " " + new File(fPath).getName();
                }

                @Override
                public String getDefaultFilename() {
                    return new File(fPath).getName();
                }
            });
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Icon icon;
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _startedIcon = Utils.getIcon("/icons/16x16/service_running.png");
            _stoppedIcon = Utils.getIcon("/icons/16x16/service.png");
        }
        Icon icon2 = icon = this._started ? _startedIcon : _stoppedIcon;
        if (expanded) {
            _cellRenderer.setOpenIcon(icon);
        } else {
            _cellRenderer.setClosedIcon(icon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public Editor getEditor() {
        if (_editor == null) {
            _editor = new ServiceEditor(this.getCoordinator());
        }
        _editor.show(this);
        return _editor;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        LiveActions la = this.getCoordinator().getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(0));
            _popup.add(la.get(1));
            _popup.addSeparator();
            _popup.add(la.get(12));
            _popup.add(la.get(15));
        }
        la.setTarget(this);
        return _popup;
    }

    @Override
    protected CompletableFuture<ObjectPrx> getAdminAsync() {
        return CompletableFuture.completedFuture(((Server)this._parent).getAdmin());
    }

    @Override
    protected String getServerDisplayName() {
        return "Server " + this._parent.getId();
    }

    @Override
    protected String getDisplayName() {
        return "Service " + this._parent.getId() + "/" + this._id;
    }

    @Override
    protected String getDefaultFileName() {
        return this._parent.getId() + "-" + this._id;
    }

    ObjectPrx getAdminFacet(String facet) {
        String facetName = "IceBox.Service." + this._id + "." + facet;
        try {
            if (Integer.valueOf((String)((Server)this._parent).getProperties().get("IceBox.UseSharedCommunicator." + this._id)) > 0) {
                facetName = "IceBox.SharedCommunicator." + facet;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ((Server)this._parent).getAdminFacet(facetName);
    }

    Service(Server parent, String serviceName, Utils.Resolver resolver, ServiceInstanceDescriptor descriptor, ServiceDescriptor serviceDescriptor, PropertySetDescriptor serverInstancePSDescriptor) {
        super(parent, serviceName, 3);
        this._resolver = resolver;
        this._instanceDescriptor = descriptor;
        this._serviceDescriptor = serviceDescriptor;
        this._serverInstancePSDescriptor = serverInstancePSDescriptor;
        this._childrenArray[0] = this._metrics;
        this._childrenArray[1] = this._adapters;
        this._childrenArray[2] = this._dbEnvs;
        this.createAdapters();
        this.createDbEnvs();
    }

    void stopShowIceLogDialog() {
        if (this._showIceLogDialog != null) {
            this._showIceLogDialog.stopped();
        }
    }

    boolean updateAdapter(AdapterDynamicInfo info) {
        for (Adapter p : this._adapters) {
            if (!p.update(info)) continue;
            return true;
        }
        return false;
    }

    int updateAdapters(List<AdapterDynamicInfo> infoList) {
        int result = 0;
        Iterator<Adapter> p = this._adapters.iterator();
        while (p.hasNext() && result < infoList.size()) {
            Adapter adapter = p.next();
            if (!adapter.update(infoList)) continue;
            ++result;
        }
        return result;
    }

    void nodeDown() {
        for (Adapter p : this._adapters) {
            p.update((AdapterDynamicInfo)null);
        }
    }

    boolean isStarted() {
        return this._started;
    }

    void started() {
        if (!this._started) {
            this._started = true;
            if (this.getRoot().getTree().isExpanded(this.getPath())) {
                this.fetchMetricsViewNames();
            }
            this.getRoot().getTreeModel().nodeChanged(this);
        }
    }

    void stopped() {
        if (this._started) {
            this._started = false;
            this._metricsRetrieved = false;
            if (!this._metrics.isEmpty()) {
                this._metrics.clear();
                this.rebuild(this);
            }
            this.getRoot().getTreeModel().nodeChanged(this);
        }
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    ServiceDescriptor getServiceDescriptor() {
        return this._serviceDescriptor;
    }

    ServiceInstanceDescriptor getInstanceDescriptor() {
        return this._instanceDescriptor;
    }

    SortedMap<String, String> getProperties() {
        LinkedList<Utils.ExpandedPropertySet> psList = new LinkedList<Utils.ExpandedPropertySet>();
        Node node = (Node)this._parent.getParent();
        String applicationName = ((Server)this._parent).getApplication().name;
        psList.add(node.expand(this._serviceDescriptor.propertySet, applicationName, this._resolver));
        if (this._instanceDescriptor != null) {
            psList.add(node.expand(this._instanceDescriptor.propertySet, applicationName, this._resolver));
        }
        if (this._serverInstancePSDescriptor != null) {
            psList.add(node.expand(this._serverInstancePSDescriptor, applicationName, this._resolver));
        }
        return Utils.propertySetsToMap(psList, this._resolver);
    }

    private void createAdapters() {
        for (AdapterDescriptor p : this._serviceDescriptor.adapters) {
            String adapterName = Utils.substitute(p.name, this._resolver);
            String adapterId = Utils.substitute(p.id, this._resolver);
            ObjectPrx proxy = null;
            if (adapterId.length() > 0) {
                proxy = ((Node)this._parent.getParent()).getProxy(adapterId);
            }
            this.insertSortedChild(new Adapter(this, adapterName, this._resolver, adapterId, p, proxy), this._adapters, null);
        }
    }

    private void createDbEnvs() {
        for (DbEnvDescriptor p : this._serviceDescriptor.dbEnvs) {
            String dbEnvName = Utils.substitute(p.name, this._resolver);
            this.insertSortedChild(new DbEnv(this, dbEnvName, this._resolver, p), this._dbEnvs, null);
        }
    }

    void rebuild(Service service) {
        this._adapters = service._adapters;
        this._dbEnvs = service._dbEnvs;
        this._childrenArray[0] = this._metrics = service._metrics;
        this._childrenArray[1] = this._adapters;
        this._childrenArray[2] = this._dbEnvs;
        for (Adapter adapter : this._adapters) {
            adapter.reparent(this);
        }
        for (DbEnv dbEnv : this._dbEnvs) {
            dbEnv.reparent(this);
        }
        for (MetricsView metrics : this._metrics) {
            metrics.reparent(this);
        }
        this.getRoot().getTreeModel().nodeStructureChanged(this);
    }
}

