/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.impl;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesAndCommentsBinder;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesBinders;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderImpl;

final class MarkerOptionalData
extends BitSet {
    private final TIntObjectHashMap<Throwable> myDebugAllocationPositions = new TIntObjectHashMap();
    private final TIntObjectHashMap<String> myDoneErrors = new TIntObjectHashMap();
    private final TIntObjectHashMap<WhitespacesAndCommentsBinder> myLeftBinders = new TIntObjectHashMap();
    private final TIntObjectHashMap<WhitespacesAndCommentsBinder> myRightBinders = new TIntObjectHashMap();
    private final TIntHashSet myCollapsed = new TIntHashSet();

    MarkerOptionalData() {
    }

    void clean(int markerId) {
        if (this.get(markerId)) {
            this.set(markerId, false);
            this.myLeftBinders.remove(markerId);
            this.myRightBinders.remove(markerId);
            this.myDoneErrors.remove(markerId);
            this.myCollapsed.remove(markerId);
            this.myDebugAllocationPositions.remove(markerId);
        }
    }

    void compact() {
        this.myLeftBinders.compact();
        this.myRightBinders.compact();
        this.myDebugAllocationPositions.compact();
        this.myCollapsed.compact();
        this.myDoneErrors.compact();
    }

    @Nullable
    String getDoneError(int markerId) {
        return (String)this.myDoneErrors.get(markerId);
    }

    boolean isCollapsed(int markerId) {
        return this.myCollapsed.contains(markerId);
    }

    void setErrorMessage(int markerId, @NotNull String message) {
        if (message == null) {
            MarkerOptionalData.$$$reportNull$$$0(0);
        }
        this.markAsHavingOptionalData(markerId);
        this.myDoneErrors.put(markerId, (Object)message);
    }

    void markCollapsed(int markerId) {
        this.markAsHavingOptionalData(markerId);
        this.myCollapsed.add(markerId);
    }

    private void markAsHavingOptionalData(int markerId) {
        this.set(markerId);
    }

    void notifyAllocated(int markerId) {
        this.markAsHavingOptionalData(markerId);
        this.myDebugAllocationPositions.put(markerId, (Object)new Throwable("Created at the following trace."));
    }

    Throwable getAllocationTrace(PsiBuilderImpl.StartMarker marker) {
        return (Throwable)this.myDebugAllocationPositions.get(marker.markerId);
    }

    WhitespacesAndCommentsBinder getBinder(int markerId, boolean right) {
        WhitespacesAndCommentsBinder binder = (WhitespacesAndCommentsBinder)this.getBinderMap(right).get(markerId);
        return binder != null ? binder : MarkerOptionalData.getDefaultBinder(right);
    }

    void assignBinder(int markerId, @NotNull WhitespacesAndCommentsBinder binder, boolean right) {
        if (binder == null) {
            MarkerOptionalData.$$$reportNull$$$0(1);
        }
        TIntObjectHashMap<WhitespacesAndCommentsBinder> map2 = this.getBinderMap(right);
        if (binder != MarkerOptionalData.getDefaultBinder(right)) {
            this.markAsHavingOptionalData(markerId);
            map2.put(markerId, (Object)binder);
        } else {
            map2.remove(markerId);
        }
    }

    private static WhitespacesAndCommentsBinder getDefaultBinder(boolean right) {
        return right ? WhitespacesBinders.DEFAULT_RIGHT_BINDER : WhitespacesBinders.DEFAULT_LEFT_BINDER;
    }

    private TIntObjectHashMap<WhitespacesAndCommentsBinder> getBinderMap(boolean right) {
        return right ? this.myRightBinders : this.myLeftBinders;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/impl/MarkerOptionalData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setErrorMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "assignBinder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

