/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskpath;

import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.taskpath.ProjectFinderByTaskPath;
import org.gradle.execution.taskpath.ResolvedTaskPath;

public class TaskPathResolver {
    private final ProjectFinderByTaskPath projectFinder;

    TaskPathResolver(ProjectFinderByTaskPath projectFinder) {
        this.projectFinder = projectFinder;
    }

    public TaskPathResolver() {
        this(new ProjectFinderByTaskPath());
    }

    public ResolvedTaskPath resolvePath(String path, ProjectInternal startFrom) {
        ProjectInternal project;
        String prefix;
        String taskName;
        if (path.contains(":")) {
            int idx = path.lastIndexOf(":");
            taskName = path.substring(idx + 1);
            prefix = path.substring(0, idx + 1);
            String projectPath = ":".equals(prefix) ? prefix : path.substring(0, idx);
            project = this.projectFinder.findProject(projectPath, startFrom);
        } else {
            project = startFrom;
            taskName = path;
            prefix = "";
        }
        return new ResolvedTaskPath(prefix, taskName, project);
    }
}

