/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.transfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.transfer.OWLObjectDataFlavor;
import org.semanticweb.owlapi.model.OWLObject;

public class TransferableOWLObject
implements Transferable {
    private List<OWLObject> owlObjects;
    private Map<DataFlavor, TransferHandler> dataFlavorMap;
    private TransferHandler stringTransferHandler;

    public TransferableOWLObject(OWLModelManager owlModelManager, List<? extends OWLObject> objects) {
        this.owlObjects = new ArrayList<OWLObject>(objects);
        this.dataFlavorMap = new HashMap<DataFlavor, TransferHandler>();
        this.dataFlavorMap.put(OWLObjectDataFlavor.OWL_OBJECT_DATA_FLAVOR, () -> new ArrayList<OWLObject>(this.owlObjects));
        this.stringTransferHandler = () -> {
            StringBuilder builder = new StringBuilder();
            for (OWLObject obj : this.owlObjects) {
                builder.append(owlModelManager.getRendering(obj));
                builder.append("\n");
            }
            return builder.toString();
        };
        this.dataFlavorMap.put(DataFlavor.stringFlavor, this.stringTransferHandler);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavors = new DataFlavor[this.dataFlavorMap.size()];
        System.arraycopy(this.dataFlavorMap.keySet().toArray(), 0, dataFlavors, 0, dataFlavors.length);
        return dataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.dataFlavorMap.keySet().contains(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        TransferHandler handler = this.dataFlavorMap.get(flavor);
        if (handler == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return handler.getTransferData();
    }

    private static interface TransferHandler {
        public Object getTransferData();
    }
}

