/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ivy.plugins.resolver.util.URLLister;

public class FileURLLister
implements URLLister {
    private File basedir;

    public FileURLLister() {
        this(null);
    }

    public FileURLLister(File file) {
        this.basedir = file;
    }

    @Override
    public boolean accept(String string) {
        return string.startsWith("file");
    }

    @Override
    public List listAll(URL uRL) throws IOException {
        File file;
        String string = uRL.getPath();
        File file2 = file = this.basedir == null ? new File(string) : new File(this.basedir, string);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            ArrayList<URL> arrayList = new ArrayList<URL>(stringArray.length);
            URL uRL2 = uRL.getPath().endsWith("/") ? uRL : new URL(uRL.toExternalForm() + "/");
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(new URL(uRL2, stringArray[i]));
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    public String toString() {
        return "file lister";
    }
}

