/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.light;

import com.sun.scenario.effect.Color4f;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class Light {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Type type;
    private Color4f color;

    Light(Type type) {
        this(type, Color4f.WHITE);
    }

    Light(Type type, Color4f color4f) {
        if (type == null) {
            throw new InternalError("Light type must be non-null");
        }
        this.type = type;
        this.setColor(color4f);
    }

    public Type getType() {
        return this.type;
    }

    public Color4f getColor() {
        return this.color;
    }

    public void setColor(Color4f color4f) {
        if (color4f == null) {
            throw new IllegalArgumentException("Color must be non-null");
        }
        Color4f color4f2 = this.color;
        this.color = color4f;
        this.firePropertyChange("color", color4f2, color4f);
    }

    public abstract float[] getNormalizedLightPosition();

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    public static enum Type {
        DISTANT,
        POINT,
        SPOT;

    }
}

