/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.WeakListChangeListener;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;

public class TableRow<T>
extends IndexedCell<T> {
    private InvalidationListener indexInvalidationListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableRow.this.indexChanged();
            TableRow.this.updateSelection();
            TableRow.this.updateFocus();
        }
    };
    private ListChangeListener<TablePosition> selectedListener = new ListChangeListener<TablePosition>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TablePosition> change) {
            TableRow.this.updateSelection();
        }
    };
    private final InvalidationListener focusedListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableRow.this.updateFocus();
        }
    };
    private final InvalidationListener editingListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableRow.this.updateEditing();
        }
    };
    private final WeakListChangeListener weakSelectedListener = new WeakListChangeListener<TablePosition>(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private ReadOnlyObjectWrapper<TableView<T>> tableView;
    private static final String DEFAULT_STYLE_CLASS = "table-row-cell";

    public TableRow() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.indexProperty().addListener(this.indexInvalidationListener);
    }

    @Override
    void indexChanged() {
        this.updateItem();
    }

    private void setTableView(TableView<T> tableView) {
        this.tableViewPropertyImpl().set(tableView);
    }

    public final TableView<T> getTableView() {
        return this.tableView == null ? null : (TableView)this.tableView.get();
    }

    public final ReadOnlyObjectProperty<TableView<T>> tableViewProperty() {
        return this.tableViewPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TableView<T>> tableViewPropertyImpl() {
        if (this.tableView == null) {
            this.tableView = new ReadOnlyObjectWrapper<TableView<T>>(){
                private WeakReference<TableView<T>> weakTableViewRef;

                @Override
                protected void invalidated() {
                    TableView.TableViewFocusModel<Object> tableViewFocusModel;
                    TableView.TableViewSelectionModel<Object> tableViewSelectionModel;
                    if (this.weakTableViewRef != null) {
                        TableView tableView = (TableView)this.weakTableViewRef.get();
                        if (tableView != null) {
                            tableViewSelectionModel = tableView.getSelectionModel();
                            if (tableViewSelectionModel != null) {
                                tableViewSelectionModel.getSelectedCells().removeListener(TableRow.this.weakSelectedListener);
                            }
                            if ((tableViewFocusModel = tableView.getFocusModel()) != null) {
                                tableViewFocusModel.focusedCellProperty().removeListener(TableRow.this.weakFocusedListener);
                            }
                            tableView.editingCellProperty().removeListener(TableRow.this.weakEditingListener);
                        }
                        this.weakTableViewRef = null;
                    }
                    if (TableRow.this.getTableView() != null) {
                        tableViewSelectionModel = TableRow.this.getTableView().getSelectionModel();
                        if (tableViewSelectionModel != null) {
                            tableViewSelectionModel.getSelectedCells().addListener(TableRow.this.weakSelectedListener);
                        }
                        if ((tableViewFocusModel = TableRow.this.getTableView().getFocusModel()) != null) {
                            tableViewFocusModel.focusedCellProperty().addListener(TableRow.this.weakFocusedListener);
                        }
                        TableRow.this.getTableView().editingCellProperty().addListener(TableRow.this.weakEditingListener);
                        this.weakTableViewRef = new WeakReference(this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return TableRow.this;
                }

                @Override
                public String getName() {
                    return "tableView";
                }
            };
        }
        return this.tableView;
    }

    private void updateItem() {
        boolean bl;
        TableView<T> tableView = this.getTableView();
        if (tableView == null || tableView.getItems() == null) {
            return;
        }
        ObservableList<T> observableList = tableView.getItems();
        boolean bl2 = bl = this.getIndex() >= 0 && this.getIndex() < observableList.size();
        if (bl) {
            Object e = observableList.get(this.getIndex());
            if (e == null || !e.equals(this.getItem())) {
                this.updateItem(e, false);
            }
        } else {
            this.updateItem(null, true);
        }
    }

    private void updateSelection() {
        if (this.getIndex() == -1) {
            return;
        }
        TableView<T> tableView = this.getTableView();
        boolean bl = tableView != null && tableView.getSelectionModel() != null && !tableView.getSelectionModel().isCellSelectionEnabled() && tableView.getSelectionModel().isSelected(this.getIndex());
        this.updateSelected(bl);
    }

    private void updateFocus() {
        if (this.getIndex() == -1) {
            return;
        }
        TableView<T> tableView = this.getTableView();
        boolean bl = tableView != null && tableView.getSelectionModel() != null && !tableView.getSelectionModel().isCellSelectionEnabled() && tableView.getFocusModel() != null && tableView.getFocusModel().isFocused(this.getIndex());
        this.setFocused(bl);
    }

    private void updateEditing() {
        boolean bl;
        if (this.getIndex() == -1) {
            return;
        }
        TableView<T> tableView = this.getTableView();
        if (tableView == null) {
            return;
        }
        TableView.TableViewSelectionModel<T> tableViewSelectionModel = this.getTableView().getSelectionModel();
        if (tableViewSelectionModel == null || tableViewSelectionModel.isCellSelectionEnabled()) {
            return;
        }
        TablePosition<T, ?> tablePosition = tableView.getEditingCell();
        boolean bl2 = bl = tablePosition.getRow() == this.getIndex();
        if (!this.isEditing() && bl) {
            this.startEdit();
        } else if (this.isEditing() && !bl) {
            this.cancelEdit();
        }
    }

    public final void updateTableView(TableView<T> tableView) {
        this.setTableView(tableView);
    }
}

