/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

public class CompoundPainter<T>
extends AbstractPainter<T> {
    private Handler handler;
    private Painter[] painters = new Painter[0];
    private AffineTransform transform;
    private boolean clipPreserved = false;
    private boolean checkForDirtyChildPainters = true;
    private boolean clearLocalCacheOnly = false;

    public CompoundPainter() {
        this((Painter[])null);
    }

    public CompoundPainter(Painter ... painters) {
        this.handler = new Handler(this);
        this.setPainters(painters);
    }

    public void setPainters(Painter ... painters) {
        Painter[] old;
        for (Painter p : old = this.getPainters()) {
            if (!(p instanceof AbstractPainter)) continue;
            ((AbstractPainter)p).removePropertyChangeListener(this.handler);
        }
        this.painters = new Painter[painters == null ? 0 : painters.length];
        if (painters != null) {
            System.arraycopy(painters, 0, this.painters, 0, this.painters.length);
        }
        for (Painter p : this.painters) {
            if (!(p instanceof AbstractPainter)) continue;
            ((AbstractPainter)p).addPropertyChangeListener(this.handler);
        }
        this.setDirty(true);
        this.firePropertyChange("painters", old, this.getPainters());
    }

    public final Painter[] getPainters() {
        Painter[] results = new Painter[this.painters.length];
        System.arraycopy(this.painters, 0, results, 0, results.length);
        return results;
    }

    public boolean isClipPreserved() {
        return this.clipPreserved;
    }

    public void setClipPreserved(boolean shouldRestoreState) {
        boolean oldShouldRestoreState = this.isClipPreserved();
        this.clipPreserved = shouldRestoreState;
        this.setDirty(true);
        this.firePropertyChange("clipPreserved", oldShouldRestoreState, shouldRestoreState);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        AffineTransform old = this.getTransform();
        this.transform = transform;
        this.setDirty(true);
        this.firePropertyChange("transform", old, transform);
    }

    @Override
    protected void validate(T object) {
        boolean dirty = false;
        for (Painter p : this.painters) {
            if (!(p instanceof AbstractPainter)) continue;
            AbstractPainter ap = (AbstractPainter)p;
            ap.validate(object);
            if (!ap.isDirty()) continue;
            dirty = true;
            break;
        }
        this.clearLocalCacheOnly = true;
        this.setDirty(dirty);
        this.clearLocalCacheOnly = false;
    }

    public boolean isCheckingDirtyChildPainters() {
        return this.checkForDirtyChildPainters;
    }

    public void setCheckingDirtyChildPainters(boolean b) {
        boolean old = this.isCheckingDirtyChildPainters();
        this.checkForDirtyChildPainters = b;
        this.firePropertyChange("checkingDirtyChildPainters", old, this.isCheckingDirtyChildPainters());
    }

    @Override
    protected boolean isDirty() {
        boolean dirty = super.isDirty();
        if (dirty) {
            return true;
        }
        if (this.isCheckingDirtyChildPainters()) {
            for (Painter p : this.painters) {
                AbstractPainter ap;
                if (!(p instanceof AbstractPainter) || !(ap = (AbstractPainter)p).isDirty()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setDirty(boolean d) {
        boolean old = super.isDirty();
        boolean ours = this.isDirty();
        super.setDirty(d);
        if (d != old && d == ours) {
            this.firePropertyChange("dirty", old, this.isDirty());
        }
    }

    @Override
    public void clearCache() {
        if (!this.clearLocalCacheOnly) {
            for (Painter p : this.painters) {
                if (!(p instanceof AbstractPainter)) continue;
                AbstractPainter ap = (AbstractPainter)p;
                ap.clearCache();
            }
        }
        super.clearCache();
    }

    public void clearLocalCache() {
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPaint(Graphics2D g, T component, int width, int height) {
        for (Painter p : this.getPainters()) {
            Graphics2D temp = (Graphics2D)g.create();
            try {
                p.paint(temp, component, width, height);
                if (!this.isClipPreserved()) continue;
                g.setClip(temp.getClip());
            }
            finally {
                temp.dispose();
            }
        }
    }

    @Override
    protected void configureGraphics(Graphics2D g) {
        AffineTransform tx = this.getTransform();
        if (tx != null) {
            g.setTransform(tx);
        }
    }

    @Override
    protected boolean shouldUseCache() {
        return super.shouldUseCache();
    }

    private static class Handler
    implements PropertyChangeListener {
        private final WeakReference<CompoundPainter<?>> ref;

        public Handler(CompoundPainter<?> painter) {
            this.ref = new WeakReference(painter);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CompoundPainter painter = (CompoundPainter)this.ref.get();
            if (painter == null) {
                AbstractPainter src = (AbstractPainter)evt.getSource();
                src.removePropertyChangeListener(this);
            } else {
                String property = evt.getPropertyName();
                if ("dirty".equals(property) && evt.getNewValue() == Boolean.FALSE) {
                    return;
                }
                painter.setDirty(true);
            }
        }
    }
}

