/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;

public abstract class ErrorManager {
    public static final int UNKNOWN = 0;
    public static final int INFORMATIONAL = 1;
    public static final int WARNING = 16;
    public static final int USER = 256;
    public static final int EXCEPTION = 4096;
    public static final int ERROR = 65536;
    private static DelegatingErrorManager current;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorManager getDefault() {
        Class<ErrorManager> clazz = ErrorManager.class;
        synchronized (ErrorManager.class) {
            if (current != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return current;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ErrorManager.getDefaultDelegate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DelegatingErrorManager getDefaultDelegate() {
        DelegatingErrorManager delegatingErrorManager = new DelegatingErrorManager("");
        try {
            delegatingErrorManager.initialize();
            Class<ErrorManager> clazz = ErrorManager.class;
            synchronized (ErrorManager.class) {
                if (current == null) {
                    current = delegatingErrorManager;
                    ErrorManager.current.r.addLookupListener((LookupListener)current);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            current = delegatingErrorManager;
        }
        catch (LinkageError linkageError) {
            linkageError.printStackTrace();
            current = delegatingErrorManager;
        }
        {
            return current;
        }
    }

    public abstract Throwable attachAnnotations(Throwable var1, Annotation[] var2);

    public abstract Annotation[] findAnnotations(Throwable var1);

    public abstract Throwable annotate(Throwable var1, int var2, String var3, String var4, Throwable var5, Date var6);

    public abstract void notify(int var1, Throwable var2);

    public final void notify(Throwable throwable) {
        this.notify(0, throwable);
    }

    public abstract void log(int var1, String var2);

    public final void log(String string) {
        this.log(1, string);
    }

    public boolean isLoggable(int n) {
        return true;
    }

    public boolean isNotifiable(int n) {
        return this.isLoggable(n);
    }

    public abstract ErrorManager getInstance(String var1);

    public final Throwable annotate(Throwable throwable, String string) {
        return this.annotate(throwable, 0, null, string, null, null);
    }

    public final Throwable annotate(Throwable throwable, Throwable throwable2) {
        return this.annotate(throwable, 0, null, null, throwable2, null);
    }

    @Deprecated
    public final Throwable copyAnnotation(Throwable throwable, Throwable throwable2) {
        return this.annotate(throwable, 0, null, null, throwable2, null);
    }

    private static final class OwnLevel
    extends Level {
        public static final Level USER = new OwnLevel("USER", 1973);
        public static final Level UNKNOWN = new OwnLevel("SEVERE", Level.SEVERE.intValue() + 1);

        private OwnLevel(String string, int n) {
            super(string, n);
        }
    }

    private static final class AnnException
    extends Exception
    implements Callable<LogRecord[]> {
        private List<LogRecord> records;
        private static Map<Throwable, AnnException> extras = new WeakHashMap<Throwable, AnnException>();

        @Override
        public String getMessage() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            List<LogRecord> list = this.records;
            if (list != null) {
                for (LogRecord logRecord : list) {
                    if (logRecord.getMessage() == null) continue;
                    stringBuilder.append(string);
                    stringBuilder.append(logRecord.getMessage());
                    string = "\n";
                }
            }
            return stringBuilder.toString();
        }

        static AnnException findOrCreate(Throwable throwable, boolean bl) {
            AnnException annException;
            block3: {
                try {
                    annException = AnnException.findOrCreate0(throwable, bl);
                }
                catch (IllegalStateException illegalStateException) {
                    assert (bl);
                    annException = extras.get(throwable);
                    if (annException != null) break block3;
                    annException = new AnnException();
                    annException.initCause(throwable);
                    Logger.getLogger(ErrorManager.class.getName()).log(Level.FINE, "getCause was null yet initCause failed for " + throwable, illegalStateException);
                    extras.put(throwable, annException);
                }
            }
            return annException;
        }

        private static AnnException findOrCreate0(Throwable throwable, boolean bl) {
            if (throwable instanceof AnnException) {
                return (AnnException)throwable;
            }
            if (throwable.getCause() == null) {
                if (bl) {
                    throwable.initCause(new AnnException());
                }
                return (AnnException)throwable.getCause();
            }
            return AnnException.findOrCreate0(throwable.getCause(), bl);
        }

        private AnnException() {
        }

        public synchronized void addRecord(LogRecord logRecord) {
            if (this.records == null) {
                this.records = new ArrayList<LogRecord>();
            }
            this.records.add(logRecord);
        }

        @Override
        public LogRecord[] call() {
            List<LogRecord> list = this.records;
            LogRecord[] logRecordArray = new LogRecord[]{};
            return list == null ? logRecordArray : list.toArray(logRecordArray);
        }

        @Override
        public void printStackTrace(PrintStream printStream) {
            super.printStackTrace(printStream);
            this.logRecords(printStream);
        }

        @Override
        public void printStackTrace(PrintWriter printWriter) {
            super.printStackTrace(printWriter);
            this.logRecords(printWriter);
        }

        @Override
        public void printStackTrace() {
            this.printStackTrace(System.err);
        }

        private void logRecords(Appendable appendable) {
            List<LogRecord> list = this.records;
            if (list == null) {
                return;
            }
            try {
                for (LogRecord logRecord : list) {
                    if (logRecord.getMessage() != null) {
                        appendable.append(logRecord.getMessage()).append("\n");
                    }
                    if (logRecord.getThrown() == null) continue;
                    StringWriter stringWriter = new StringWriter();
                    logRecord.getThrown().printStackTrace(new PrintWriter(stringWriter));
                    appendable.append(stringWriter.toString()).append("\n");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static class DelegatingErrorManager
    extends ErrorManager
    implements LookupListener {
        private String name = null;
        private Set<ErrorManager> delegates = new HashSet<ErrorManager>();
        private Logger logger;
        private WeakSet<DelegatingErrorManager> createdByMe = new WeakSet();
        Lookup.Result<ErrorManager> r;
        private static volatile Thread lastThread;

        public DelegatingErrorManager(String string) {
            this.name = string;
        }

        Logger logger() {
            if (this.logger == null) {
                this.logger = Logger.getLogger(this.name);
            }
            return this.logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ErrorManager getInstance(String string) {
            if (string == null || "".equals(string)) {
                return this;
            }
            DelegatingErrorManager delegatingErrorManager = new DelegatingErrorManager(string);
            DelegatingErrorManager delegatingErrorManager2 = this;
            synchronized (delegatingErrorManager2) {
                this.attachNewDelegates(delegatingErrorManager, string);
                this.createdByMe.add((Object)delegatingErrorManager);
            }
            return delegatingErrorManager;
        }

        @Override
        public Throwable attachAnnotations(Throwable throwable, Annotation[] annotationArray) {
            for (ErrorManager errorManager : this.delegates) {
                errorManager.attachAnnotations(throwable, annotationArray);
            }
            return throwable;
        }

        @Override
        public Annotation[] findAnnotations(Throwable throwable) {
            for (ErrorManager errorManager : this.delegates) {
                Annotation[] annotationArray = errorManager.findAnnotations(throwable);
                if (annotationArray == null || annotationArray.length <= 0) continue;
                return annotationArray;
            }
            return new Annotation[0];
        }

        @Override
        public Throwable annotate(Throwable throwable, int n, String string, final String string2, Throwable throwable2, Date date) {
            if (this.delegates.isEmpty()) {
                Object object;
                LogRecord logRecord = new LogRecord(DelegatingErrorManager.convertSeverity(n, true, Level.ALL), string);
                if (throwable2 != null) {
                    logRecord.setThrown(throwable2);
                }
                if (date != null) {
                    logRecord.setMillis(date.getTime());
                }
                if (string2 != null) {
                    object = new ResourceBundle(){

                        @Override
                        public Object handleGetObject(String string) {
                            if ("msg".equals(string)) {
                                return string2;
                            }
                            return null;
                        }

                        @Override
                        public Enumeration<String> getKeys() {
                            return Enumerations.singleton((Object)"msg");
                        }
                    };
                    logRecord.setResourceBundle((ResourceBundle)object);
                    logRecord.setMessage("msg");
                }
                if ((object = AnnException.findOrCreate(throwable, true)) != null) {
                    ((AnnException)object).addRecord(logRecord);
                }
                return throwable;
            }
            for (ErrorManager errorManager : this.delegates) {
                errorManager.annotate(throwable, n, string, string2, throwable2, date);
            }
            return throwable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(int n, Throwable throwable) {
            if (this.delegates.isEmpty()) {
                if (DelegatingErrorManager.enterLogger()) {
                    return;
                }
                try {
                    AnnException annException = (AnnException)AnnException.extras.get(throwable);
                    if (annException != null) {
                        throwable = annException;
                    }
                    this.logger().log(DelegatingErrorManager.convertSeverity(n, true, OwnLevel.UNKNOWN), throwable.getMessage(), throwable);
                }
                finally {
                    DelegatingErrorManager.exitLogger();
                }
                return;
            }
            try {
                for (ErrorManager errorManager : this.delegates) {
                    errorManager.notify(n, throwable);
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                throwable.printStackTrace();
            }
            catch (LinkageError linkageError) {
                linkageError.printStackTrace();
                throwable.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(int n, String string) {
            if (n == 0) {
                throw new IllegalArgumentException("ErrorManager.log(UNKNOWN, ...) is not permitted");
            }
            if (this.delegates.isEmpty()) {
                Level level = DelegatingErrorManager.convertSeverity(n, false, Level.FINE);
                if (DelegatingErrorManager.enterLogger()) {
                    return;
                }
                try {
                    this.logger().log(level, string);
                }
                finally {
                    DelegatingErrorManager.exitLogger();
                }
                return;
            }
            for (ErrorManager errorManager : this.delegates) {
                errorManager.log(n, string);
            }
        }

        private static Level convertSeverity(int n, boolean bl, Level level) {
            Level level2 = level;
            if (n >= 65536) {
                level2 = Level.SEVERE;
            } else if (n >= 4096) {
                level2 = Level.SEVERE;
            } else if (n >= 256) {
                level2 = OwnLevel.USER;
            } else if (n >= 16) {
                level2 = Level.WARNING;
            } else if (n >= 1) {
                level2 = bl ? Level.INFO : Level.FINE;
            }
            return level2;
        }

        @Override
        public boolean isLoggable(int n) {
            if (n == 0) {
                throw new IllegalArgumentException("ErrorManager.isLoggable(UNKNOWN) is not permitted");
            }
            if (this.delegates.isEmpty()) {
                return this.logger().isLoggable(DelegatingErrorManager.convertSeverity(n, false, null));
            }
            for (ErrorManager errorManager : this.delegates) {
                if (!errorManager.isLoggable(n)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isNotifiable(int n) {
            if (n == 0) {
                throw new IllegalArgumentException("ErrorManager.isNotifiable(UNKNOWN) is not permitted");
            }
            if (this.delegates.isEmpty()) {
                return this.logger().isLoggable(DelegatingErrorManager.convertSeverity(n, true, null));
            }
            for (ErrorManager errorManager : this.delegates) {
                if (!errorManager.isNotifiable(n)) continue;
                return true;
            }
            return false;
        }

        public synchronized void setDelegates(Collection<? extends ErrorManager> collection) {
            this.delegates = new LinkedHashSet<ErrorManager>(collection);
            for (DelegatingErrorManager delegatingErrorManager : this.createdByMe) {
                this.attachNewDelegates(delegatingErrorManager, delegatingErrorManager.getName());
            }
        }

        private String getName() {
            return this.name;
        }

        private void attachNewDelegates(DelegatingErrorManager delegatingErrorManager, String string) {
            HashSet<ErrorManager> hashSet = new HashSet<ErrorManager>();
            for (ErrorManager errorManager : this.delegates) {
                hashSet.add(errorManager.getInstance(string));
            }
            delegatingErrorManager.setDelegates(hashSet);
        }

        public void initialize() {
            this.r = Lookup.getDefault().lookupResult(ErrorManager.class);
            this.setDelegates(this.r.allInstances());
        }

        public void resultChanged(LookupEvent lookupEvent) {
            if (this.r != null) {
                this.setDelegates(this.r.allInstances());
            }
        }

        private static boolean enterLogger() {
            if (lastThread == Thread.currentThread()) {
                new Exception("using error manager from inside a logger").printStackTrace();
                return true;
            }
            lastThread = Thread.currentThread();
            return false;
        }

        private static void exitLogger() {
            lastThread = null;
        }
    }

    public static interface Annotation {
        public String getMessage();

        public String getLocalizedMessage();

        public Throwable getStackTrace();

        public Date getDate();

        public int getSeverity();
    }
}

