/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import javax.management.Notification;

public class JMXConnectionNotification
extends Notification {
    private static final long serialVersionUID = -2331308725952627538L;
    public static final String OPENED = "jmx.remote.connection.opened";
    public static final String CLOSED = "jmx.remote.connection.closed";
    public static final String FAILED = "jmx.remote.connection.failed";
    public static final String NOTIFS_LOST = "jmx.remote.connection.notifs.lost";
    private final String connectionId;

    public JMXConnectionNotification(String type, Object source, String connectionId, long sequenceNumber, String message, Object userData) {
        super((String)JMXConnectionNotification.nonNull(type), JMXConnectionNotification.nonNull(source), Math.max(0L, sequenceNumber), System.currentTimeMillis(), message);
        if (type == null || source == null || connectionId == null) {
            throw new NullPointerException("Illegal null argument");
        }
        if (sequenceNumber < 0L) {
            throw new IllegalArgumentException("Negative sequence number");
        }
        this.connectionId = connectionId;
        this.setUserData(userData);
    }

    private static Object nonNull(Object arg) {
        if (arg == null) {
            return "";
        }
        return arg;
    }

    public String getConnectionId() {
        return this.connectionId;
    }
}

