/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import javax.naming.RefAddr;

public class BinaryRefAddr
extends RefAddr {
    private byte[] buf = null;
    private static final long serialVersionUID = -3415254970957330361L;

    public BinaryRefAddr(String addrType, byte[] src) {
        this(addrType, src, 0, src.length);
    }

    public BinaryRefAddr(String addrType, byte[] src, int offset, int count) {
        super(addrType);
        this.buf = new byte[count];
        System.arraycopy(src, offset, this.buf, 0, count);
    }

    @Override
    public Object getContent() {
        return this.buf;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BinaryRefAddr) {
            BinaryRefAddr target = (BinaryRefAddr)obj;
            if (this.addrType.compareTo(target.addrType) == 0) {
                if (this.buf == null && target.buf == null) {
                    return true;
                }
                if (this.buf == null || target.buf == null || this.buf.length != target.buf.length) {
                    return false;
                }
                for (int i = 0; i < this.buf.length; ++i) {
                    if (this.buf[i] == target.buf[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = this.addrType.hashCode();
        for (int i = 0; i < this.buf.length; ++i) {
            hash += this.buf[i];
        }
        return hash;
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer("Address Type: " + this.addrType + "\n");
        str.append("AddressContents: ");
        for (int i = 0; i < this.buf.length && i < 32; ++i) {
            str.append(Integer.toHexString(this.buf[i]) + " ");
        }
        if (this.buf.length >= 32) {
            str.append(" ...\n");
        }
        return str.toString();
    }
}

