/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

class ImagePrinter
implements Printable {
    BufferedImage image;

    ImagePrinter(InputStream stream) {
        try {
            this.image = ImageIO.read(stream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ImagePrinter(URL url) {
        try {
            this.image = ImageIO.read(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int index) {
        if (index > 0 || this.image == null) {
            return 1;
        }
        ((Graphics2D)g).translate(pf.getImageableX(), pf.getImageableY());
        int w = this.image.getWidth(null);
        int h = this.image.getHeight(null);
        int iw = (int)pf.getImageableWidth();
        int ih = (int)pf.getImageableHeight();
        int dw = w;
        int dh = h;
        if (dw > iw) {
            dh = (int)((float)dh * ((float)iw / (float)dw));
            dw = iw;
        }
        if (dh > ih) {
            dw = (int)((float)dw * ((float)ih / (float)dh));
            dh = ih;
        }
        int dx = (iw - dw) / 2;
        int dy = (ih - dh) / 2;
        g.drawImage(this.image, dx, dy, dx + dw, dy + dh, 0, 0, w, h, null);
        return 0;
    }
}

