/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_in extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AL = "Albania";
        final String metaValue_AM = "Armenia";
        final String metaValue_AZ = "Azerbaijan";
        final String metaValue_BG = "Bulgaria";
        final String metaValue_CY = "Siprus";
        final String metaValue_DE = "Jerman";
        final String metaValue_ES = "Spanyol";
        final String metaValue_ET = "Etiopia";
        final String metaValue_FJ = "Fiji";
        final String metaValue_FR = "Prancis";
        final String metaValue_GB = "Inggris";
        final String metaValue_GE = "Georgia";
        final String metaValue_GR = "Yunani";
        final String metaValue_HR = "Kroasia";
        final String metaValue_HT = "Haiti";
        final String metaValue_HU = "Hungaria";
        final String metaValue_ID = "Indonesia";
        final String metaValue_IE = "Irlandia";
        final String metaValue_IS = "Islandia";
        final String metaValue_IT = "Italia";
        final String metaValue_JP = "Jepang";
        final String metaValue_LA = "Laos";
        final String metaValue_LU = "Luksemburg";
        final String metaValue_MK = "Makedonia";
        final String metaValue_MN = "Mongolia";
        final String metaValue_MT = "Malta";
        final String metaValue_NL = "Belanda";
        final String metaValue_NO = "Norwegia";
        final String metaValue_NR = "Nauru";
        final String metaValue_PW = "Palau";
        final String metaValue_RO = "Rumania";
        final String metaValue_RU = "Rusia";
        final String metaValue_SE = "Swedia";
        final String metaValue_SY = "Suriah";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TO = "Tonga";
        final String metaValue_TR = "Turki";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_UA = "Ukraina";
        final String metaValue_VN = "Vietnam";
        final String metaValue_WS = "Samoa";
        final String metaValue_ae = "Avesta";
        final String metaValue_ar = "Arab";
        final String metaValue_bn = "Bengali";
        final String metaValue_bo = "Tibet";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Ibrani";
        final String metaValue_jv = "Jawa";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korea";
        final String metaValue_la = "Latin";
        final String metaValue_ml = "Malayalam";
        final String metaValue_my = "Myanmar";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Sinhala";
        final String metaValue_su = "Sunda";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final String metaValue_tl = "Tagalog";
        final String metaValue_ban = "Bali";
        final String metaValue_bug = "Bugis";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptik";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_men = "Mende";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_pal = "Pahlevi";
        final String metaValue_peo = "Persia Kuno";
        final String metaValue_ssy = "Saho";
        final String metaValue_vai = "Vai";
        final String metaValue_zbl = "Blissymbol";
        final Object[][] data = new Object[][] {
            { "ksh", "Dialek Kolsch" },
            { "Ogam", "Ogham" },
            { "mwl", "Miranda" },
            { "key.colStrength", "Kekuatan Penyortiran" },
            { "Zsym", "Simbol" },
            { "cch", "Atsam" },
            { "mwr", "Marwari" },
            { "type.nu.lanatham", "Angka Tai Tham Tham" },
            { "mwv", "Mentawai" },
            { "Tagb", "Tagbanwa" },
            { "%%NJIVA", "Dialek Gniva/Njiva" },
            { "egy", "Mesir Kuno" },
            { "raj", "Rajasthani" },
            { "Phag", "Phags-pa" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "ter", "Tereno" },
            { "AC", "Pulau Ascension" },
            { "rar", "Rarotonga" },
            { "tet", "Tetun" },
            { "AD", "Andorra" },
            { "AE", "Uni Emirat Arab" },
            { "AF", "Afganistan" },
            { "AG", "Antigua dan Barbuda" },
            { "type.ca.ethiopic", "Kalender Etiopia" },
            { "glk", "Gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "Zona Waktu" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "Teng", "Tenghwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "Prti", "Prasasti Parthia" },
            { "AS", "Samoa Amerika" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Kepulauan Aland" },
            { "key.colNormalization", "Penyortiran Dinormalisasi" },
            { "mye", "Myene" },
            { "AZ", metaValue_AZ },
            { "%%AREVELA", "Armenia Timur" },
            { "BA", "Bosnia dan Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Sebuano" },
            { "BD", "Bangladesh" },
            { "kum", "Kumyk" },
            { "BE", "Belgia" },
            { "gmh", "Jerman Abad Pertengahan" },
            { "BF", "Burkina Faso" },
            { "BG", metaValue_BG },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barthelemy" },
            { "BM", "Bermuda" },
            { "kut", "Kutenai" },
            { "myv", "Eryza" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibia Belanda" },
            { "BR", "Brasil" },
            { "BS", "Bahama" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Pulau Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "Visp", "Ucapan Terlihat" },
            { "type.ca.persian", "Kalender Persia" },
            { "type.nu.hebr", "Angka Ibrani" },
            { "CA", "Kanada" },
            { "CC", "Kepulauan Cocos" },
            { "mzn", "Mazanderani" },
            { "CD", "Kongo - Kinshasa" },
            { "CF", "Republik Afrika Tengah" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Swiss" },
            { "CI", "Cote d\u2019Ivoire" },
            { "CK", "Kepulauan Cook" },
            { "CL", "Cile" },
            { "Kthi", "Kaithi" },
            { "CM", "Kamerun" },
            { "CN", "Tiongkok" },
            { "CO", "Kolombia" },
            { "CP", "Pulau Clipperton" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Tanjung Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Pulau Christmas" },
            { "CY", metaValue_CY },
            { "type.nu.bali", "Angka Bali" },
            { "CZ", "Republik Cheska" },
            { "eka", "Ekajuk" },
            { "DE", metaValue_DE },
            { "goh", "Jerman Kuno" },
            { "ace", "Aceh" },
            { "cgg", "Kiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Angka Devanagari" },
            { "DJ", "Jibuti" },
            { "type.colNumeric.no", "Sortir Digit Satu Per Satu" },
            { "DK", "Denmark" },
            { "ach", "Acoli" },
            { "gon", "Gondi" },
            { "Brai", "Braille" },
            { "Brah", "Brahmi" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "Angka Huruf Kecil Armenia" },
            { "DO", "Republik Dominika" },
            { "gor", "Gorontalo" },
            { "got", "Gothik" },
            { "Mtei", "Meitei Mayek" },
            { "key.variableTop", "Sortir Sebagai Simbol" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "Takr", "Takri" },
            { "DZ", "Aljazair" },
            { "pag", "Pangasina" },
            { "pal", metaValue_pal },
            { "EA", "Ceuta dan Melilla" },
            { "chb", "Chibcha" },
            { "pam", "Pampanga" },
            { "EC", "Ekuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "Estonia" },
            { "tiv", "Tiv" },
            { "EG", "Mesir" },
            { "EH", "Sahara Barat" },
            { "chg", "Chagatai" },
            { "pau", metaValue_PW },
            { "type.colNormalization.yes", "Sortir Unicode Dinormalisasi" },
            { "chk", "Chuuke" },
            { "chn", "Jargon Chinook" },
            { "chm", "Mari" },
            { "chp", "Chipewyan" },
            { "cho", "Koktaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "Uni Eropa" },
            { "elx", "Elam" },
            { "type.ca.gregorian", "Kalender Gregorian" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "Angka Gujarati" },
            { "Inds", "Indus" },
            { "ady", "Adygei" },
            { "aeb", "Arab Tunisia" },
            { "FI", "Finlandia" },
            { "FJ", metaValue_FJ },
            { "FK", "Kepulauan Malvinas" },
            { "FM", "Mikronesia" },
            { "key.va", "Varian Lokal" },
            { "FO", "Kepulauan Faroe" },
            { "Taml", metaValue_ta },
            { "FR", metaValue_FR },
            { "Kpel", metaValue_kpe },
            { "tkl", metaValue_TK },
            { "grb", "Grebo" },
            { "root", "Root" },
            { "type.ca.indian", "Kalender Nasional India" },
            { "grc", "Yunani Kuno" },
            { "GA", "Gabon" },
            { "vot", "Votia" },
            { "GB", metaValue_GB },
            { "GD", "Grenada" },
            { "GE", metaValue_GE },
            { "GF", "Guyana Prancis" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "Tai Le" },
            { "GI", "Gibraltar" },
            { "afh", "Afrihili" },
            { "GL", "Grinlandia" },
            { "enm", "Inggris Abad Pertengahan" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Ekuatorial" },
            { "GR", metaValue_GR },
            { "GS", "Georgia Selatan & Kep. Sandwich Selatan" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "Jerman Pennsylvania" },
            { "GW", "Guinea-Bissau" },
            { "tli", "Tlingit" },
            { "tlh", "Klingon" },
            { "Talu", "Tai Lue Baru" },
            { "GY", "Guyana" },
            { "ckb", "Kurdi Sorani" },
            { "zxx", "Tidak ada konten linguistik" },
            { "Jurc", "Jurchen" },
            { "Vaii", metaValue_vai },
            { "HK", "Hong Kong SAR Tiongkok" },
            { "HM", "Pulau Heard dan Kepulauan McDonald" },
            { "HN", "Honduras" },
            { "HR", metaValue_HR },
            { "agq", "Aghem" },
            { "gsw", "Jerman (Swiss)" },
            { "HT", metaValue_HT },
            { "HU", metaValue_HU },
            { "tmh", "Tamashek" },
            { "IC", "Kepulauan Canary" },
            { "ID", metaValue_ID },
            { "peo", metaValue_peo },
            { "type.nu.kali", "Angka Kayah Li" },
            { "IE", metaValue_IE },
            { "nap", "Neapolitan" },
            { "%%NDYUKA", "Dialek Ndyuka" },
            { "naq", "Nama" },
            { "zza", "Zaza" },
            { "Tang", "Tangut" },
            { "IL", "Israel" },
            { "Nbat", "Nabataea" },
            { "IM", "Pulau Man" },
            { "IN", "India" },
            { "type.co.eor", "Aturan Pengurutan Eropa" },
            { "IO", "Wilayah Inggris di Samudra Hindia" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "Zmth", "Notasi Matematika" },
            { "type.nu.thai", "Angka Thai" },
            { "%%POSIX", "Komputer" },
            { "type.nu.beng", "Angka Bengali" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Kalender Islam" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Yordania" },
            { "JP", metaValue_JP },
            { "%%1606NICT", "Prancis Pertengahan Akhir sampai 1606" },
            { "ain", "Ainu" },
            { "Mend", metaValue_men },
            { "guz", "Gusii" },
            { "tog", "Nyasa Tonga" },
            { "type.nu.knda", "Angka Kannada" },
            { "Kali", "Kayah Li" },
            { "Sidd", "Siddham" },
            { "de_CH", "Jerman Tinggi (Swiss)" },
            { "type.co.phonetic", "Urutan Sortir Fonetik" },
            { "type.ca.buddhist", "Kalender Buddha" },
            { "KE", "Kenya" },
            { "419", "Amerika Latin" },
            { "KG", "Kirgistan" },
            { "KH", "Kamboja" },
            { "KI", "Kiribati" },
            { "KM", "Komoro" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts dan Nevis" },
            { "Zinh", "Warisan" },
            { "KP", "Korea Utara" },
            { "KR", "Korea Selatan" },
            { "Plrd", "Fonetik Pollard" },
            { "KW", "Kuwait" },
            { "tpi", "Tok Pisin" },
            { "KY", "Kepulauan Cayman" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "Sirilik" },
            { "LA", metaValue_LA },
            { "LB", "Lebanon" },
            { "LC", "Saint Lucia" },
            { "phn", "Funisia" },
            { "Cyrs", "Gereja Slavonia Sirilik Lama" },
            { "gwi", "Gwich\u2019in" },
            { "%%LUNA1918", "LUNA1918" },
            { "nds", "Jerman Rendah" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "Akkadia" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "Phlv", "Kitab Pahlevi" },
            { "LT", "Lituania" },
            { "LU", metaValue_LU },
            { "LV", "Latvia" },
            { "Kana", "Katakana" },
            { "Sora", "Sora Sompeng" },
            { "LY", "Libia" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "akz", "Alabama" },
            { "%%LAUKIKA", "LAUKIKA" },
            { "lah", "Lahnda" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "Nshu", "Nushu" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "Lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Kepulauan Marshall" },
            { "ale", "Aleut" },
            { "type.nu.vaii", "Angka Vai" },
            { "MK", metaValue_MK },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", metaValue_MN },
            { "new", "Newari" },
            { "MO", "Makau SAR Tiongkok" },
            { "MP", "Kepulauan Mariana Utara" },
            { "MQ", "Martinik" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "type.colAlternate.non-ignorable", "Sortir Simbol" },
            { "MT", metaValue_MT },
            { "MU", "Mauritius" },
            { "alt", "Altai Selatan" },
            { "MV", "Maladewa" },
            { "MW", "Malawi" },
            { "MX", "Meksiko" },
            { "type.ca.japanese", "Kalender Jepang" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambik" },
            { "Phli", metaValue_pal },
            { "NA", "Namibia" },
            { "type.ca.hebrew", "Kalender Ibrani" },
            { "type.co.dictionary", "Urutan Sortir Kamus" },
            { "NC", "Kaledonia Baru" },
            { "%%WADEGILE", "Wade-Giles Latin" },
            { "tru", "Turoyo" },
            { "%%UCRCOR", "Ortografi Revisi Terpadu" },
            { "NE", "Niger" },
            { "NF", "Kepulauan Norfolk" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "Phlp", "Mazmur Pahlevi" },
            { "NI", "Nikaragua" },
            { "Hmng", "Pahawh Hmong" },
            { "NL", metaValue_NL },
            { "NO", metaValue_NO },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "Phnx", "Phoenix" },
            { "rof", "Rombo" },
            { "tsi", "Tsimshia" },
            { "NZ", "Selandia Baru" },
            { "Merc", "Kursif Meroitik" },
            { "rom", "Romani" },
            { "Mero", "Meroitik" },
            { "crh", "Tatar Krimea" },
            { "type.colAlternate.shifted", "Sortir Abaikan Simbol" },
            { "ang", "Inggris Kuno" },
            { "OM", "Oman" },
            { "%%PETR1708", "PETR1708" },
            { "anp", "Angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Kalender Sipil Islam" },
            { "csb", "Kashubia" },
            { "PE", "Peru" },
            { "ttt", "Tat Muslim" },
            { "PF", "Polinesia Prancis" },
            { "PG", "Papua Nugini" },
            { "PH", "Filipina" },
            { "PK", "Pakistan" },
            { "PL", "Polandia" },
            { "ewo", "Ewondo" },
            { "PM", "Saint Pierre dan Miquelon" },
            { "PN", "Kepulauan Pitcairn" },
            { "type.colBackwards.yes", "Sortir Aksen Terbalik" },
            { "PR", "Puerto Riko" },
            { "Bali", metaValue_ban },
            { "PS", "Wilayah Palestina" },
            { "PT", "Portugal" },
            { "PW", metaValue_PW },
            { "nia", "Nias" },
            { "type.nu.greklow", "Angka Yunani Huruf Kecil" },
            { "PY", "Paraguay" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "Inggris Standar Skotlandia" },
            { "niu", "Niuea" },
            { "QO", "Oseania Luar" },
            { "lez", "Lezghia" },
            { "%%FONUPA", "Fonetik UPA" },
            { "tvl", metaValue_TV },
            { "Tavt", "Tai Viet" },
            { "001", "Dunia" },
            { "002", "Afrika" },
            { "003", "Amerika Utara" },
            { "RE", "R\u00e9union" },
            { "type.colNormalization.no", "Sortir Tanpa Normalisasi" },
            { "005", "Amerika Selatan" },
            { "jbo", "Lojban" },
            { "Rjng", "Rejang" },
            { "009", "Oseania" },
            { "%%SURSILV", "SURSILV" },
            { "RO", metaValue_RO },
            { "RS", "Serbia" },
            { "Mroo", "Mro" },
            { "RU", metaValue_RU },
            { "RW", "Rwanda" },
            { "type.nu.talu", "Angka Tai Lue Baru" },
            { "Mani", "Manikhei" },
            { "Ugar", "Ugaritik" },
            { "key.colAlternate", "Penyortiran Abaikan Simbol" },
            { "Khar", "Kharoshthi" },
            { "SA", "Arab Saudi" },
            { "pon", "Pohnpeia" },
            { "Mand", "Mandae" },
            { "SB", "Kepulauan Solomon" },
            { "twq", "Tasawaq" },
            { "011", "Afrika Bagian Barat" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", metaValue_SE },
            { "013", "Amerika Tengah" },
            { "014", "Afrika Bagian Timur" },
            { "arc", "Aram" },
            { "Loma", "Loma" },
            { "015", "Afrika Bagian Utara" },
            { "SG", "Singapura" },
            { "SH", "Saint Helena" },
            { "type.lb.strict", "Gaya Pemisah Baris Rapat" },
            { "017", "Afrika Bagian Tengah" },
            { "SI", "Slovenia" },
            { "018", "Afrika Bagian Selatan" },
            { "SJ", "Kepulauan Svalbard dan Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "Bamu", "Bamum" },
            { "Wole", "Woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "Araukan" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "Angka Tamil Tradisional" },
            { "SR", "Suriname" },
            { "SS", "Sudan Selatan" },
            { "ST", "Sao Tome dan Principe" },
            { "arq", "Arab Algeria" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", metaValue_SY },
            { "yao", "Yao" },
            { "SZ", "Swaziland" },
            { "arw", "Arawak" },
            { "arz", "Arab Mesir" },
            { "ary", "Arab Maroko" },
            { "yap", "Yapois" },
            { "rtm", "Rotuma" },
            { "TA", "Tristan da Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Sistem Pengukuran A.S." },
            { "021", "Amerika Bagian Utara" },
            { "TC", "Kepulauan Turks dan Caicos" },
            { "yav", "Yangben" },
            { "TD", "Cad" },
            { "TF", "Wilayah Kutub Selatan Prancis" },
            { "ase", "Bahasa Isyarat Amerika" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", metaValue_TK },
            { "029", "Kepulauan Karibia" },
            { "TL", "Timor Leste" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Pencarian Menurut Konsonan Awal Hangul" },
            { "TM", "Turkimenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tunisia" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "Trinidad dan Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "ast", "Astur" },
            { "Orkh", "Orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Skrip Tak Dikenal" },
            { "Sind", "Khudawadi" },
            { "UA", metaValue_UA },
            { "lij", "Liguria" },
            { "rup", "Makedo-Rumania" },
            { "030", "Asia Bagian Timur" },
            { "tyv", "Tuvinia" },
            { "sw_CD", "Kongo Swahili" },
            { "034", "Asia Bagian Selatan" },
            { "hai", "Haida" },
            { "035", "Asia Tenggara" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Urutan Sortir Pinyin" },
            { "type.colHiraganaQuaternary.yes", "Sortir Kana Secara Berbeda" },
            { "039", "Eropa Bagian Selatan" },
            { "Sinh", metaValue_si },
            { "UM", "Kepulauan Terluar A.S." },
            { "US", "Amerika Serikat" },
            { "haw", "Hawaii" },
            { "%%1959ACAD", "Akademik" },
            { "type.co.gb2312han", "Urutan Sortir Tionghoa Aks. Sederhana - GB2312" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "tzm", "Tamazight Maroko Tengah" },
            { "type.co.stroke", "Urutan Sortir Guratan" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vatikan" },
            { "pro", "Provencal Lama" },
            { "VC", "Saint Vincent dan Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Kepulauan Virgin Inggris" },
            { "VI", "Kepulauan Virgin A.S." },
            { "VN", metaValue_VN },
            { "type.colBackwards.no", "Sortir Aksen Secara Normal" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "non", "Norse Kuno" },
            { "053", "Australasia" },
            { "%%AREVMDA", "Armenia Barat" },
            { "054", "Melanesia" },
            { "WF", "Kepulauan Wallis dan Futuna" },
            { "type.co.traditional", "Urutan Sortir Tradisional" },
            { "057", "Wilayah Mikronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "type.nu.finance", "Angka Finansial" },
            { "%%HEPBURN", "Hepburn Latin" },
            { "wae", "Walser" },
            { "WS", metaValue_WS },
            { "Bass", "Bassa Vah" },
            { "type.nu.mtei", "Angka Meetei Mayek" },
            { "wal", "Walamo" },
            { "was", "Washo" },
            { "war", "Warai" },
            { "awa", "Awadhi" },
            { "061", "Polinesia" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Tidak Tertulis" },
            { "Olck", "Chiki Lama" },
            { "wbp", "Warlpiri" },
            { "Batk", "Batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Yaman" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "Aturan Pengurutan Standar" },
            { "fan", "Fang" },
            { "%%ROZAJ", "Resia" },
            { "%%SUTSILV", "SUTSILV" },
            { "fat", "Fanti" },
            { "Sgnw", "Tulisan Isyarat" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Angka Cham" },
            { "ZA", "Afrika Selatan" },
            { "type.nu.sund", "Angka Sunda" },
            { "type.lb.loose", "Gaya Pemisah Baris Renggang" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Angka Georgia" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "Pinyin Latin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Wilayah Tidak Dikenal" },
            { "Runr", "Runik" },
            { "type.ms.metric", "Sistem Metrik" },
            { "type.ca.iso8601", "Kalender ISO-8601" },
            { "lol", "Mongo" },
            { "nso", "Sotho Utara" },
            { "type.nu.telu", "Angka Telugu" },
            { "loz", "Lozi" },
            { "Nkgb", "Naxi Geba" },
            { "type.colHiraganaQuaternary.no", "Sortir Kana Secara Terpisah" },
            { "jmc", "Machame" },
            { "hif", "Hindi Fiji" },
            { "type.nu.hansfin", "Angka Keuangan Tionghoa Sederhana" },
            { "type.colStrength.secondary", "Sortir Aksen" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "Angka Arab Timur Diperluas" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "Angka Lebar Penuh" },
            { "hit", "Hitit" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "Maya", "Hieroglip Maya" },
            { "lrc", "Luri Utara" },
            { "Copt", metaValue_cop },
            { "nwc", "Newari Klasik" },
            { "udm", "Udmurt" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "Kalender Islam (Arab Saudi, penglihatan)" },
            { "Limb", "Limbu" },
            { "sad", "Sandawe" },
            { "type.nu.roman", "Angka Romawi" },
            { "sah", "Sakha" },
            { "sam", "Aram Samaria" },
            { "Aghb", "Albania Kaukasia" },
            { "%%SCOUSE", "Skaus" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "Tfng", "Tifinagh" },
            { "jpr", "Ibrani-Persia" },
            { "type.nu.native", "Digit Asli" },
            { "sba", "Ngambai" },
            { "Guru", "Gurmukhi" },
            { "%%ALUKU", "Dialek Aluku" },
            { "lua", "Luba-Lulua" },
            { "%%BISCAYAN", "BISKAY" },
            { "sbp", "Sangu" },
            { "lui", "Luiseno" },
            { "nyn", "Nyankole" },
            { "nym", "Nyamwezi" },
            { "lun", "Lunda" },
            { "nyo", "Nyoro" },
            { "luo", "Luo" },
            { "fil", "Filipino" },
            { "hmn", "Hmong" },
            { "del", "Delaware" },
            { "lus", "Mizo" },
            { "bal", "Baluchi" },
            { "den", "Slave" },
            { "ban", metaValue_ban },
            { "uga", "Ugarit" },
            { "luy", "Luyia" },
            { "bar", "Bavaria" },
            { "bas", "Basa" },
            { "bax", "Bamun" },
            { "jrb", "Ibrani-Arab" },
            { "es_ES", "Spanyol (Eropa)" },
            { "nzi", "Nzima" },
            { "sco", "Skotlandia" },
            { "scn", "Sisilia" },
            { "aa", "Afar" },
            { "ab", "Abkhaz" },
            { "bbc", "Batak Toba" },
            { "key.colCaseFirst", "Pengurutan Huruf Besar/Huruf Kecil" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "bbj", "Ghomala" },
            { "am", "Amharik" },
            { "Arab", metaValue_ar },
            { "an", "Aragon" },
            { "%%SOLBA", "Dialek Stolvizza/Solbica" },
            { "Jpan", metaValue_JP },
            { "ar", metaValue_ar },
            { "Hrkt", "Katakana atau Hiragana" },
            { "as", "Assam" },
            { "Lina", "Linear A" },
            { "av", "Avar" },
            { "Linb", "Linear B" },
            { "sdh", "Kurdi Selatan" },
            { "ay", "Aymara" },
            { "az", metaValue_AZ },
            { "Khoj", "Khojki" },
            { "%%OSOJS", "Dialek Oseacco/Osojane" },
            { "ba", "Bashkir" },
            { "type.co.unihan", "Urutan Sortir Guratan Radikal" },
            { "be", "Belarusia" },
            { "bg", metaValue_BG },
            { "bi", "Bislama" },
            { "type.nu.java", "Angka Jawa" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Breton" },
            { "bs", "Bosnia" },
            { "see", "Seneca" },
            { "Mymr", metaValue_my },
            { "sei", "Seri" },
            { "type.nu.laoo", "Angka Laos" },
            { "seh", "Sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "Selkup" },
            { "ca", "Katalan" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "%%REVISED", "Ortografi Revisi" },
            { "co", "Korsika" },
            { "Orya", metaValue_or },
            { "cr", "Kree" },
            { "cs", "Cheska" },
            { "cu", "Bahasa Gereja Slavonia" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "type.nu.ethi", "Angka Etiopia" },
            { "Yiii", "Yi" },
            { "da", "Dansk" },
            { "pt_PT", "Portugis (Eropa)" },
            { "de", metaValue_DE },
            { "bej", "Beja" },
            { "din", "Dinka" },
            { "Bugi", metaValue_bug },
            { "bem", "Bemba" },
            { "sga", "Irlandia Kuno" },
            { "type.nu.mong", "Angka Mongolia" },
            { "dv", "Divehi" },
            { "es_419", "Spanyol Amerika Latin" },
            { "bew", "Betawi" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Kalender Tionghoa" },
            { "Lisu", "Lisu" },
            { "dje", "Zarma" },
            { "type.nu.grek", "Angka Yunani" },
            { "ee", "Ewe" },
            { "bfd", "Bafut" },
            { "type.lb.normal", "Gaya Pemisah Baris Normal" },
            { "ro_MD", "Moldavia" },
            { "el", metaValue_GR },
            { "en", metaValue_GB },
            { "eo", "Esperanto" },
            { "lzz", "Laz" },
            { "type.co.big5han", "Urutan Sortir Tionghoa Tradisional - Big5" },
            { "es", metaValue_ES },
            { "et", "Esti" },
            { "eu", "Bask" },
            { "Buhd", "Buhid" },
            { "Hang", "Hangul" },
            { "Samr", "Samaria" },
            { "shi", "Tachelhit" },
            { "hsb", "Sorbia Atas" },
            { "Hani", "Han" },
            { "%%ULSTER", "ULSTER" },
            { "shn", "Shan" },
            { "Hano", "Hanunoo" },
            { "fa", "Persia" },
            { "Hans", "Sederhana" },
            { "type.nu.latn", "Angka Latin" },
            { "Hant", "Tradisional" },
            { "ff", "Fula" },
            { "shu", "Arab Suwa" },
            { "fi", "Suomi" },
            { "fj", metaValue_FJ },
            { "fon", "Fon" },
            { "bgn", "Balochi Barat" },
            { "yue", "Kanton" },
            { "fo", "Faro" },
            { "umb", "Umbundu" },
            { "fr", metaValue_FR },
            { "sid", "Sidamo" },
            { "fy", "Frisia Barat" },
            { "ga", metaValue_IE },
            { "gd", "Gaelik Skotlandia" },
            { "key.colCaseLevel", "Penyortiran Peka Huruf Besar" },
            { "gl", "Galisia" },
            { "gn", "Guarani" },
            { "bho", "Bhojpuri" },
            { "und", "Bahasa Tidak Dikenal" },
            { "type.ca.ethiopic-amete-alem", "Kalender Amete Alem Etiopia" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "ho", "Hiri Motu" },
            { "hr", metaValue_HR },
            { "ht", metaValue_HT },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "Herero" },
            { "%%FONIPA", "Fonetik IPA" },
            { "ia", "Interlingua" },
            { "id", metaValue_ID },
            { "type.nu.tibt", "Angka Tibet" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "frm", "Prancis Abad Pertengahan" },
            { "%%RUMGR", "RUMGR" },
            { "ik", "Inupiak" },
            { "fro", "Prancis Kuno" },
            { "frp", "Arpitan" },
            { "io", "Ido" },
            { "frs", "Frisia Timur" },
            { "bjn", "Banjar" },
            { "frr", "Frisia Utara" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "Inuktitut" },
            { "sli", "Silesia Bawah" },
            { "%%HOGNORSK", "NORWEDIA TINGGI" },
            { "ja", metaValue_JP },
            { "Mlym", metaValue_ml },
            { "Sarb", "Arab Selatan Kuno" },
            { "Sara", "Sarati" },
            { "doi", "Dogri" },
            { "sly", "Selayar" },
            { "type.nu.lepc", "Angka Lepcha" },
            { "bkm", "Kom" },
            { "sma", "Sami Selatan" },
            { "jv", metaValue_jv },
            { "Shaw", "Shavia" },
            { "%%BAUDDHA", "BAUDDHA" },
            { "mad", "Madura" },
            { "smj", "Lule Sami" },
            { "mag", "Magahi" },
            { "maf", "Mafa" },
            { "mai", "Maithili" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_GE },
            { "bla", "Siksika" },
            { "mak", "Makasar" },
            { "sms", "Skolt Sami" },
            { "man", "Mandingo" },
            { "kg", "Kongo" },
            { "Goth", "Gothic" },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "type.colStrength.identical", "Sortir Semua" },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmir" },
            { "Cirt", "Cirth" },
            { "Lepc", "Lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "Kurdi" },
            { "kv", "Komi" },
            { "kw", "Kornish" },
            { "ky", "Kirgiz" },
            { "snk", "Soninke" },
            { "type.colStrength.primary", "Sortir Huruf Dasar Saja" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "type.nu.mlym", "Angka Malayalam" },
            { "lg", "Ganda" },
            { "Roro", "Rongorongo" },
            { "li", "Limburgia" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friuli" },
            { "type.colCaseLevel.no", "Sortir Tidak Peka Huruf Besar" },
            { "lo", "Lao" },
            { "type.ms.uksystem", "Sistem Pengukuran Imperial" },
            { "type.colStrength.tertiary", "Sortir Aksen/Ukuran Huruf/Lebar" },
            { "type.nu.lana", "Angka Tai Tham Hora" },
            { "lt", "Lituavi" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvi" },
            { "sog", "Sogdien" },
            { "mg", "Malagasi" },
            { "mh", "Marshall" },
            { "type.co.ducet", "Aturan Pengurutan Unicode Default" },
            { "mi", "Maori" },
            { "mk", metaValue_MK },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "Marathi" },
            { "ms", "Melayu" },
            { "mt", metaValue_MT },
            { "my", metaValue_my },
            { "Saur", "Saurashtra" },
            { "Armn", metaValue_AM },
            { "mdf", "Moksha" },
            { "mde", "Maba" },
            { "dsb", "Sorbia Rendah" },
            { "Armi", "Aram Imperial" },
            { "na", metaValue_NR },
            { "type.co.search", "Pencarian Tujuan Umum" },
            { "nb", "Bokm\u00e5l Norwegia" },
            { "nd", "Ndebele Utara" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "mdr", "Mandar" },
            { "nl", metaValue_NL },
            { "nn", "Nynorsk Norwegia" },
            { "no", metaValue_NO },
            { "nr", "Ndebele Selatan" },
            { "nv", "Navajo" },
            { "kaa", "Kara-Kalpak" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabyle" },
            { "%%POLYTON", "Politon" },
            { "type.colCaseFirst.lower", "Sortir Huruf Kecil Dahulu" },
            { "oc", "Ositania" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", metaValue_men },
            { "oj", "Ojibwa" },
            { "mer", "Meru" },
            { "type.nu.armn", "Angka Armenia" },
            { "om", "Oromo" },
            { "kaw", "Kawi" },
            { "or", metaValue_or },
            { "Modi", "Modi" },
            { "os", "Ossetia" },
            { "%%ALALC97", "ALA-LC Latin, edisi 1997" },
            { "kbd", "Kabardi" },
            { "mfe", "Morisien" },
            { "srn", "Sranan Tongo" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "srr", "Serer" },
            { "%%LIPAW", "Dialek Lipovaz Resia" },
            { "kbl", "Kanembu" },
            { "pi", "Pali" },
            { "pl", "Polski" },
            { "dum", "Belanda Tengah" },
            { "type.nu.saur", "Angka Saurashtra" },
            { "type.ca.dangi", "Kalender Dangi" },
            { "%%VALLADER", "VALLADER" },
            { "ps", "Pashto" },
            { "pt", "Portugis" },
            { "mga", "Irlandia Abad Pertengahan" },
            { "key.co", "Aturan Pengurutan" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "type.nu.nkoo", "Angka N\u2019Ko" },
            { "bra", "Braj" },
            { "key.ca", "Kalender" },
            { "%%JAUER", "JAUER" },
            { "Laoo", metaValue_LA },
            { "%%SURMIRAN", "SURMIRAN" },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "Sistem 24 Jam (0\u201323)" },
            { "type.hc.h24", "Sistem 24 Jam (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "type.nu.mymr", "Angka Myanmar" },
            { "qu", "Quechua" },
            { "zap", "Zapotek" },
            { "brx", "Bodo" },
            { "Lana", "Lanna" },
            { "kde", "Makonde" },
            { "%%VAIDIKA", "VAIDIKA" },
            { "Ethi", metaValue_ET },
            { "%%JYUTPING", "JYUTPING" },
            { "type.hc.h12", "Sistem 12 Jam (1\u201312)" },
            { "type.hc.h11", "Sistem 12 Jam (0\u201311)" },
            { "rm", "Reto-Roman" },
            { "rn", "Rundi" },
            { "key.cu", "Mata Uang" },
            { "ro", metaValue_RO },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "Angka Oriya" },
            { "type.nu.hanidec", "Angka Desimal Tionghoa" },
            { "ru", metaValue_RU },
            { "bss", "Akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "mic", "Mikmak" },
            { "suk", "Sukuma" },
            { "Dupl", "Stenografi Duployan" },
            { "sa", "Sanskerta" },
            { "%%UCCOR", "Ortografi Terpadu" },
            { "sc", "Sardinia" },
            { "sus", "Susu" },
            { "sd", "Sindhi" },
            { "se", "Sami Utara" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroasia" },
            { "ken", "Kenyang" },
            { "si", metaValue_si },
            { "sux", "Sumeria" },
            { "sk", "Slovak" },
            { "sl", "Sloven" },
            { "Gran", "Grantha" },
            { "sm", metaValue_WS },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "type.nu.arab", "Angka Arab Timur" },
            { "sq", metaValue_AL },
            { "sr", "Serb" },
            { "ss", "Swati" },
            { "Java", metaValue_jv },
            { "st", "Sotho Selatan" },
            { "su", metaValue_su },
            { "%%NEDIS", "Dialek Natiso" },
            { "sv", metaValue_SE },
            { "sw", "Swahili" },
            { "type.nu.hantfin", "Angka Keuangan Tionghoa Tradisional" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", metaValue_ta },
            { "142", "Asia" },
            { "bua", "Buriat" },
            { "143", "Asia Tengah" },
            { "te", metaValue_te },
            { "145", "Asia Bagian Barat" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "Tigrinya" },
            { "kfo", "Koro" },
            { "type.colNumeric.yes", "Sortir Digit Secara Numerik" },
            { "tk", "Turkmen" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "bum", "Bulu" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Angka Jepang" },
            { "tr", metaValue_TR },
            { "ts", "Tsonga" },
            { "swb", "Komoria" },
            { "Cakm", "Chakma" },
            { "tt", "Tatar" },
            { "dyu", "Dyula" },
            { "tw", "Twi" },
            { "ty", "Tahiti" },
            { "%%BISKE", "Dialek San Giorgio/Bila" },
            { "150", "Eropa" },
            { "key.colHiraganaQuaternary", "Penyortiran Kana" },
            { "151", "Eropa Bagian Timur" },
            { "154", "Eropa Bagian Utara" },
            { "dzg", "Dazaga" },
            { "155", "Eropa Bagian Barat" },
            { "ug", "Uyghur" },
            { "Kore", metaValue_ko },
            { "Ital", "Italia Lama" },
            { "Zyyy", "Umum" },
            { "uk", metaValue_UA },
            { "type.colCaseFirst.no", "Sortir Urutan Ukuran Huruf Normal" },
            { "type.colStrength.quaternary", "Sortir Aksen/Ukuran Huruf/Lebar/Kana" },
            { "type.ca.coptic", "Kalender Koptik" },
            { "ur", "Urdu" },
            { "%%1994", "Ortografi Resia Standar" },
            { "xal", "Kalmuk" },
            { "zen", "Zenaga" },
            { "uz", "Uzbek" },
            { "kha", "Khasi" },
            { "%%1996", "Ortografi Jerman 1996" },
            { "Sylo", "Syloti Nagri" },
            { "ve", "Venda" },
            { "Wara", "Varang Kshiti" },
            { "type.ca.roc", "Kalendar Minguo" },
            { "vi", metaValue_VN },
            { "kho", "Khotan" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Siklus Jam (12 vs 24)" },
            { "%%TARASK", "Ortografi Taraskievica" },
            { "vo", "Volapuk" },
            { "key.x", "Penggunaan Pribadi" },
            { "syc", "Suriah Klasik" },
            { "Osma", "Osmanya" },
            { "quc", "K\u02bciche\u02bc" },
            { "gaa", "Ga" },
            { "wa", "Walloon" },
            { "gag", "Gagauz" },
            { "syr", metaValue_SY },
            { "Grek", metaValue_GR },
            { "Lydi", "Lydia" },
            { "Xsux", "Cuneiform Sumero-Akkadia" },
            { "wo", "Wolof" },
            { "zgh", "Tamazight Maroko Standar" },
            { "ar_001", "Arab Standar Modern" },
            { "Cans", "Simbol Aborigin Kanada Kesatuan" },
            { "%%FONXSAMP", "FONXSAMP" },
            { "gay", "Gayo" },
            { "key.colNumeric", "Penyortiran Numerik" },
            { "Mong", metaValue_MN },
            { "mnc", "Manchuria" },
            { "Latf", "Latin Fraktur" },
            { "szl", "Silesia" },
            { "Hluw", "Hieroglif Anatolia" },
            { "gba", "Gbaya" },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "Latin Gaelik" },
            { "type.nu.hans", "Angka Tionghoa Sederhana" },
            { "type.nu.hant", "Angka Tionghoa Tradisional" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "Angka Huruf Kecil Romawi" },
            { "byn", "Blin" },
            { "%%PAMAKA", "Dialek Pamaka" },
            { "Lyci", "Lycia" },
            { "osa", "Osage" },
            { "byv", "Medumba" },
            { "Moon", "Moon" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "%%1694ACAD", "Prancis Modern Awal" },
            { "Syrc", metaValue_SY },
            { "yi", "Yiddish" },
            { "mos", "Mossi" },
            { "Dsrt", "Deseret" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Angka Tradisional" },
            { "es_MX", "Spanyol Meksiko" },
            { "Syrj", "Suriah Barat" },
            { "ota", "Turki Osmani" },
            { "Syre", "Suriah Estrangelo" },
            { "vai", metaValue_vai },
            { "za", "Zhuang" },
            { "Cari", "Karia" },
            { "kln", "Kalenjin" },
            { "zh", "Tionghoa" },
            { "Afak", "Afaka" },
            { "Bopo", "Bopomofo" },
            { "Perm", "Permik Kuno" },
            { "key.lb", "Gaya Pemisah Baris" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "Urutan Sortir Buku Telepon" },
            { "%%MONOTON", "Monoton" },
            { "Geor", metaValue_GE },
            { "Shrd", "Sharada" },
            { "kmb", "Kimbundu" },
            { "type.colCaseLevel.yes", "Sortir Peka Huruf Besar" },
            { "type.nu.jpanfin", "Angka Keuangan Jepang" },
            { "Cham", "Cham" },
            { "gez", "Geez" },
            { "Syrn", "Suriah Timur" },
            { "type.nu.mymrshan", "Angka Myanmar Shan" },
            { "Narb", "Arab Utara Kuno" },
            { "type.nu.olck", "Angka Ol Chiki" },
            { "type.co.reformed", "Urutan Sortir yang Diubah Bentuknya" },
            { "Tglg", metaValue_tl },
            { "Egyd", "Demotik Mesir" },
            { "key.colBackwards", "Penyortiran Aksen Terbalik" },
            { "Egyh", "Hieratik Mesir" },
            { "%%ITIHASA", "ITIHASA" },
            { "Palm", "Palmira" },
            { "ebu", "Embu" },
            { "Egyp", "Hieroglip Mesir" },
            { "Geok", "Georgian Khutsuri" },
            { "zh_Hans", "Tionghoa (Aksara Sederhana)" },
            { "koi", "Komi-Permyak" },
            { "Hung", "Hungaria Kuno" },
            { "kok", "Konkani" },
            { "%%1901", "Ortografi Jerman Tradisional" },
            { "kos", "Kosre" },
            { "vec", "Venesia" },
            { "type.nu.limb", "Angka Limbu" },
            { "zh_Hant", "Tionghoa (Aksara Tradisional)" },
            { "Sund", metaValue_su },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "Angka Khmer" },
            { "Tirh", "Tirhuta" },
            { "ilo", "Iloko" },
            { "%%VALENCIA", "Valencia" },
            { "Cprt", metaValue_CY },
            { "%%BAKU1926", "Alfabet Latin Turki Terpadu" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Angka Gurmukhi" },
            { "mul", "Beberapa Bahasa" },
            { "%%PUTER", "PUTER" },
            { "cad", "Kado" },
            { "key.ms", "Sistem Pengukuran" },
            { "mus", "Bahasa Muskogee" },
            { "Glag", "Glagolitic" },
            { "gil", "Gilbert" },
            { "%%KKCOR", "Ortografi Umum" },
            { "Cher", metaValue_chr },
            { "car", "Karib" },
            { "cay", "Cayuga" },
            { "type.nu.tamldec", "Angka Tamil" },
            { "krc", "Karachai Balkar" },
            { "inh", "Ingushetia" },
            { "kri", "Krio" },
            { "krl", "Karelia" },
            { "efi", "Efik" },
            { "tcy", "Tulu" },
            { "key.nu", "Angka" },
            { "kru", "Kuruk" },
            { "ksb", "Shambala" },
            { "type.colCaseFirst.upper", "Sortir Huruf Besar Dahulu" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
