/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

class WinVistaEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final int TOP_INSET = 0;
    private static final int LEFT_INSET = 3;
    private static final int RIGHT_INSET = 0;
    static final int BOTTOM_INSET = 0;
    private static final TabPainter leftClip = new WinVistaLeftClipPainter();
    private static final TabPainter rightClip = new WinVistaRightClipPainter();
    private static final TabPainter normal = new WinVistaPainter();

    public WinVistaEditorTabCellRenderer() {
        super(leftClip, normal, rightClip, new Dimension(32, 42));
    }

    @Override
    public int getPixelsToAddToSelection() {
        return 0;
    }

    @Override
    public Dimension getPadding() {
        Dimension dimension = super.getPadding();
        dimension.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 32 : 16;
        return dimension;
    }

    private static Color getUnselFillBrightUpperColor() {
        Color color = UIManager.getColor("tab_unsel_fill_bright_upper");
        if (color == null) {
            color = new Color(235, 235, 235);
        }
        return color;
    }

    private static Color getUnselFillDarkUpperColor() {
        Color color = UIManager.getColor("tab_unsel_fill_dark_upper");
        if (color == null) {
            color = new Color(229, 229, 229);
        }
        return color;
    }

    private static Color getUnselFillBrightLowerColor() {
        Color color = UIManager.getColor("tab_unsel_fill_bright_lower");
        if (color == null) {
            color = new Color(214, 214, 214);
        }
        return color;
    }

    private static Color getUnselFillDarkLowerColor() {
        Color color = UIManager.getColor("tab_unsel_fill_dark_lower");
        if (color == null) {
            color = new Color(203, 203, 203);
        }
        return color;
    }

    private static Color getSelFillColor() {
        Color color = UIManager.getColor("tab_sel_fill");
        if (color == null) {
            color = new Color(244, 244, 244);
        }
        return color;
    }

    private static Color getFocusFillUpperColor() {
        Color color = UIManager.getColor("tab_focus_fill_upper");
        if (color == null) {
            color = new Color(242, 249, 252);
        }
        return color;
    }

    private static Color getFocusFillBrightLowerColor() {
        Color color = UIManager.getColor("tab_focus_fill_bright_lower");
        if (color == null) {
            color = new Color(225, 241, 249);
        }
        return color;
    }

    private static Color getFocusFillDarkLowerColor() {
        Color color = UIManager.getColor("tab_focus_fill_dark_lower");
        if (color == null) {
            color = new Color(216, 236, 246);
        }
        return color;
    }

    private static Color getMouseOverFillBrightUpperColor() {
        Color color = UIManager.getColor("tab_mouse_over_fill_bright_upper");
        if (color == null) {
            color = new Color(223, 242, 252);
        }
        return color;
    }

    private static Color getMouseOverFillDarkUpperColor() {
        Color color = UIManager.getColor("tab_mouse_over_fill_dark_upper");
        if (color == null) {
            color = new Color(214, 239, 252);
        }
        return color;
    }

    private static Color getMouseOverFillBrightLowerColor() {
        Color color = UIManager.getColor("tab_mouse_over_fill_bright_lower");
        if (color == null) {
            color = new Color(189, 228, 250);
        }
        return color;
    }

    private static Color getMouseOverFillDarkLowerColor() {
        Color color = UIManager.getColor("tab_mouse_over_fill_dark_lower");
        if (color == null) {
            color = new Color(171, 221, 248);
        }
        return color;
    }

    private static Color getTxtColor() {
        Color color = UIManager.getColor("TabbedPane.foreground");
        if (color == null) {
            color = new Color(0, 0, 0);
        }
        return color;
    }

    static Color getBorderColor() {
        Color color = UIManager.getColor("tab_border");
        if (color == null) {
            color = new Color(137, 140, 149);
        }
        return color;
    }

    private static Color getSelBorderColor() {
        Color color = UIManager.getColor("tab_sel_border");
        if (color == null) {
            color = new Color(60, 127, 177);
        }
        return color;
    }

    private static Color getBorderInnerColor() {
        Color color = UIManager.getColor("tab_border_inner");
        if (color == null) {
            color = new Color(255, 255, 255);
        }
        return color;
    }

    @Override
    public Color getSelectedActivatedForeground() {
        return WinVistaEditorTabCellRenderer.getTxtColor();
    }

    @Override
    public Color getSelectedForeground() {
        return WinVistaEditorTabCellRenderer.getTxtColor();
    }

    void paintTabGradient(Graphics graphics, Polygon polygon) {
        Rectangle rectangle = polygon.getBounds();
        boolean bl = this.isSelected();
        boolean bl2 = bl && this.isActive();
        boolean bl3 = this.isAttention();
        boolean bl4 = this.isArmed();
        if (bl2 && !bl3) {
            ++rectangle.height;
            ColorUtil.vistaFillRectGradient((Graphics2D)graphics, rectangle, WinVistaEditorTabCellRenderer.getFocusFillUpperColor(), WinVistaEditorTabCellRenderer.getFocusFillBrightLowerColor(), WinVistaEditorTabCellRenderer.getFocusFillDarkLowerColor());
        } else if (bl && !bl3) {
            ++rectangle.height;
            graphics.setColor(WinVistaEditorTabCellRenderer.getSelFillColor());
            graphics.fillPolygon(polygon);
        } else if (bl4 && !bl3) {
            ColorUtil.vistaFillRectGradient((Graphics2D)graphics, rectangle, WinVistaEditorTabCellRenderer.getMouseOverFillBrightUpperColor(), WinVistaEditorTabCellRenderer.getMouseOverFillDarkUpperColor(), WinVistaEditorTabCellRenderer.getMouseOverFillBrightLowerColor(), WinVistaEditorTabCellRenderer.getMouseOverFillDarkLowerColor());
        } else if (bl3) {
            Color color = new Color(255, 255, 128);
            Color color2 = new Color(230, 200, 64);
            ColorUtil.xpFillRectGradient((Graphics2D)graphics, rectangle, color, color2);
        } else {
            ColorUtil.vistaFillRectGradient((Graphics2D)graphics, rectangle, WinVistaEditorTabCellRenderer.getUnselFillBrightUpperColor(), WinVistaEditorTabCellRenderer.getUnselFillDarkUpperColor(), WinVistaEditorTabCellRenderer.getUnselFillBrightLowerColor(), WinVistaEditorTabCellRenderer.getUnselFillDarkLowerColor());
        }
    }

    @Override
    protected int getCaptionYAdjustment() {
        return 0;
    }

    @Override
    protected int getIconYAdjustment() {
        return -2;
    }

    @Override
    protected void paintIconAndText(Graphics graphics) {
        if (this.isBusy()) {
            this.setIcon(BusyTabsSupport.getDefault().getBusyIcon(this.isSelected()));
        }
        super.paintIconAndText(graphics);
    }

    String findIconPath() {
        if (this.inCloseButton() && this.isPressed()) {
            return "org/openide/awt/resources/vista_close_pressed.png";
        }
        if (this.inCloseButton()) {
            return "org/openide/awt/resources/vista_close_rollover.png";
        }
        return "org/openide/awt/resources/vista_close_enabled.png";
    }

    private static class WinVistaRightClipPainter
    implements TabPainter {
        private WinVistaRightClipPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 3, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            WinVistaEditorTabCellRenderer winVistaEditorTabCellRenderer = (WinVistaEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = 0;
            int n3 = component.getWidth() + 1;
            int n4 = component.getHeight() - insets.bottom;
            polygon.addPoint(n, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + n4 - 1);
            polygon.addPoint(n, n2 + n4 - 1);
            return polygon;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinVistaEditorTabCellRenderer winVistaEditorTabCellRenderer = (WinVistaEditorTabCellRenderer)component;
            graphics.translate(n, n2);
            Color color = winVistaEditorTabCellRenderer.isActive() && winVistaEditorTabCellRenderer.isSelected() || winVistaEditorTabCellRenderer.isArmed() ? WinVistaEditorTabCellRenderer.getSelBorderColor() : WinVistaEditorTabCellRenderer.getBorderColor();
            graphics.setColor(color);
            boolean bl = false;
            graphics.drawLine(0, 0, n3, 0);
            graphics.setColor(WinVistaEditorTabCellRenderer.getBorderColor());
            if (!winVistaEditorTabCellRenderer.isSelected()) {
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            } else {
                graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, n4 - 1);
            }
            graphics.setColor(WinVistaEditorTabCellRenderer.getBorderInnerColor());
            graphics.drawLine(1, 1, n3, 1);
            if (winVistaEditorTabCellRenderer.isSelected()) {
                ++n4;
            }
            graphics.drawLine(0, 1, 0, n4 - 2);
            graphics.translate(-n, -n2);
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            WinVistaEditorTabCellRenderer winVistaEditorTabCellRenderer = (WinVistaEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(winVistaEditorTabCellRenderer);
            winVistaEditorTabCellRenderer.paintTabGradient(graphics, polygon);
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }
    }

    private static class WinVistaLeftClipPainter
    implements TabPainter {
        private WinVistaLeftClipPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 3, 0, 0);
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            WinVistaEditorTabCellRenderer winVistaEditorTabCellRenderer = (WinVistaEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = 0;
            int n3 = winVistaEditorTabCellRenderer.isRightmost() ? component.getWidth() - 1 : component.getWidth();
            int n4 = component.getHeight() - insets.bottom;
            polygon.addPoint(n, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + n4 - 1);
            polygon.addPoint(n, n2 + n4 - 1);
            return polygon;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinVistaEditorTabCellRenderer winVistaEditorTabCellRenderer = (WinVistaEditorTabCellRenderer)component;
            graphics.translate(n, n2);
            Color color = winVistaEditorTabCellRenderer.isActive() && winVistaEditorTabCellRenderer.isSelected() || winVistaEditorTabCellRenderer.isArmed() ? WinVistaEditorTabCellRenderer.getSelBorderColor() : WinVistaEditorTabCellRenderer.getBorderColor();
            graphics.setColor(color);
            boolean bl = false;
            graphics.drawLine(0, 0, n3 - 1, 0);
            if (winVistaEditorTabCellRenderer.isActive() && winVistaEditorTabCellRenderer.isNextTabSelected() || winVistaEditorTabCellRenderer.isNextTabArmed()) {
                graphics.setColor(WinVistaEditorTabCellRenderer.getSelBorderColor());
            }
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 2);
            graphics.setColor(WinVistaEditorTabCellRenderer.getBorderColor());
            if (!winVistaEditorTabCellRenderer.isSelected()) {
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            } else {
                graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, n4 - 1);
            }
            graphics.setColor(WinVistaEditorTabCellRenderer.getBorderInnerColor());
            graphics.drawLine(0, 1, n3 - 2, 1);
            if (winVistaEditorTabCellRenderer.isSelected()) {
                ++n4;
            }
            graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 2);
            graphics.translate(-n, -n2);
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            WinVistaEditorTabCellRenderer winVistaEditorTabCellRenderer = (WinVistaEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(winVistaEditorTabCellRenderer);
            winVistaEditorTabCellRenderer.paintTabGradient(graphics, polygon);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return false;
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            rectangle.setBounds(-20, -20, 0, 0);
        }
    }

    private static class WinVistaPainter
    implements TabPainter {
        private WinVistaPainter() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 3, 0, 0);
        }

        @Override
        public void getCloseButtonRectangle(JComponent jComponent, Rectangle rectangle, Rectangle rectangle2) {
            WinVistaEditorTabCellRenderer winVistaEditorTabCellRenderer = (WinVistaEditorTabCellRenderer)jComponent;
            if (!winVistaEditorTabCellRenderer.isShowCloseButton()) {
                rectangle.x = -100;
                rectangle.y = -100;
                rectangle.width = 0;
                rectangle.height = 0;
                return;
            }
            String string = winVistaEditorTabCellRenderer.findIconPath();
            Icon icon = TabControlButtonFactory.getIcon(string);
            int n = icon.getIconWidth();
            int n2 = icon.getIconHeight();
            rectangle.x = rectangle2.x + rectangle2.width - n - 2;
            rectangle.y = rectangle2.y + Math.max(0, rectangle2.height / 2 - n2 / 2);
            rectangle.width = n;
            rectangle.height = n2;
        }

        @Override
        public Polygon getInteriorPolygon(Component component) {
            WinVistaEditorTabCellRenderer winVistaEditorTabCellRenderer = (WinVistaEditorTabCellRenderer)component;
            Insets insets = this.getBorderInsets(component);
            Polygon polygon = new Polygon();
            int n = 0;
            int n2 = 0;
            int n3 = winVistaEditorTabCellRenderer.isRightmost() ? component.getWidth() - 1 : component.getWidth();
            int n4 = component.getHeight() - insets.bottom;
            polygon.addPoint(n, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + insets.top);
            polygon.addPoint(n + n3, n2 + n4 - 1);
            polygon.addPoint(n, n2 + n4 - 1);
            return polygon;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            WinVistaEditorTabCellRenderer winVistaEditorTabCellRenderer = (WinVistaEditorTabCellRenderer)component;
            graphics.translate(n, n2);
            Color color = winVistaEditorTabCellRenderer.isActive() && winVistaEditorTabCellRenderer.isSelected() || winVistaEditorTabCellRenderer.isArmed() ? WinVistaEditorTabCellRenderer.getSelBorderColor() : WinVistaEditorTabCellRenderer.getBorderColor();
            graphics.setColor(color);
            boolean bl = false;
            if (winVistaEditorTabCellRenderer.isLeftmost()) {
                graphics.drawLine(0, 0, 0, n4 - 1);
            }
            graphics.drawLine(0, 0, n3 - 1, 0);
            if (winVistaEditorTabCellRenderer.isActive() && winVistaEditorTabCellRenderer.isNextTabSelected() || winVistaEditorTabCellRenderer.isNextTabArmed()) {
                graphics.setColor(WinVistaEditorTabCellRenderer.getSelBorderColor());
            }
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 2);
            graphics.setColor(WinVistaEditorTabCellRenderer.getBorderColor());
            if (!winVistaEditorTabCellRenderer.isSelected()) {
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            } else {
                graphics.drawLine(n3 - 1, n4 - 1, n3 - 1, n4 - 1);
            }
            graphics.setColor(WinVistaEditorTabCellRenderer.getBorderInnerColor());
            graphics.drawLine(1, 1, n3 - 2, 1);
            if (winVistaEditorTabCellRenderer.isSelected()) {
                ++n4;
            }
            if (winVistaEditorTabCellRenderer.isLeftmost()) {
                graphics.drawLine(1, 1, 1, n4 - 2);
            } else {
                graphics.drawLine(0, 1, 0, n4 - 2);
            }
            graphics.drawLine(n3 - 2, 1, n3 - 2, n4 - 2);
            graphics.translate(-n, -n2);
        }

        @Override
        public void paintInterior(Graphics graphics, Component component) {
            WinVistaEditorTabCellRenderer winVistaEditorTabCellRenderer = (WinVistaEditorTabCellRenderer)component;
            Polygon polygon = this.getInteriorPolygon(winVistaEditorTabCellRenderer);
            winVistaEditorTabCellRenderer.paintTabGradient(graphics, polygon);
            Rectangle rectangle = new Rectangle();
            this.getCloseButtonRectangle(winVistaEditorTabCellRenderer, rectangle, new Rectangle(0, 0, winVistaEditorTabCellRenderer.getWidth(), winVistaEditorTabCellRenderer.getHeight()));
            if (!graphics.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                return;
            }
            String string = winVistaEditorTabCellRenderer.findIconPath();
            Icon icon = TabControlButtonFactory.getIcon(string);
            icon.paintIcon(winVistaEditorTabCellRenderer, graphics, rectangle.x, rectangle.y);
        }

        @Override
        public boolean supportsCloseButton(JComponent jComponent) {
            return jComponent instanceof TabDisplayer ? ((TabDisplayer)jComponent).isShowCloseButton() : true;
        }
    }
}

