/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.lib.profiler.common.GlobalProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.api.Bundle;
import org.openide.util.NbPreferences;

public final class ProfilerIDESettings
implements GlobalProfilingSettings {
    public static final String DO_NOT_SHOW_ATTACH_SETTINGS = "dns-attach-settings";
    public static final String DO_NOT_SHOW_JDK_DIALOG = "dns-jdk-dialog";
    public static final String DO_NOT_SHOW_PID_WINDOWS = "dns-pid-windows4";
    public static final int CPU_ENTIRE_APP = 0;
    public static final int CPU_PART_APP = 1;
    public static final int CPU_STARTUP = 2;
    public static final int CPU_PROFILING_POINTS = 3;
    public static final int OOME_DETECTION_NONE = 0;
    public static final int OOME_DETECTION_PROJECTDIR = 1;
    public static final int OOME_DETECTION_TEMPDIR = 2;
    public static final int OOME_DETECTION_CUSTOMDIR = 3;
    public static final int SNAPSHOT_WINDOW_OPEN_NEVER = 0;
    public static final int SNAPSHOT_WINDOW_OPEN_PROFILER = 1;
    public static final int SNAPSHOT_WINDOW_SHOW_PROFILER = 2;
    public static final int SNAPSHOT_WINDOW_OPEN_FIRST = 3;
    public static final int SNAPSHOT_WINDOW_OPEN_EACH = 4;
    public static final int SNAPSHOT_WINDOW_CLOSE_NEVER = 0;
    public static final int SNAPSHOT_WINDOW_CLOSE_PROFILER = 1;
    public static final int SNAPSHOT_WINDOW_HIDE_PROFILER = 2;
    public static final int OPEN_ALWAYS = 1;
    public static final int OPEN_MONITORING = 2;
    public static final int OPEN_NEVER = 3;
    private static final ProfilerIDESettings defaultInstance = new ProfilerIDESettings();
    private Map<String, String> dnsaMap;
    private final String AUTO_OPEN_SNAPSHOT_KEY_55 = "autoOpenSnapshot";
    private final String AUTO_SAVE_SNAPSHOT_KEY_55 = "autoSaveSnapshot";
    private final String CALIBRATION_PORT_NO_KEY_55 = "calibrationPortNo";
    private final String CPU_TASK_KEY_55 = "cpuTaskDefault";
    private final String LIVE_CPU_KEY_55 = "displayLiveResultsCPU";
    private final String LIVE_FRAGMENT_KEY_55 = "displayLiveResultsFragment";
    private final String LIVE_MEMORY_KEY_55 = "displayLiveResultsMemory";
    private final String MEMORY_TASK_ALLOCATIONS_KEY_55 = "memoryTaskAllocationsDefault";
    private final String PLATFORM_NAME_KEY_55 = "javaPlatformForProfiling";
    private final String PORT_NO_KEY_55 = "portNo";
    private final String RECORD_STACK_TRACES_KEY_55 = "recordStackTracesDefault";
    private final String THREADS_MONITORING_KEY_55 = "threadsMonitoringDefault";
    private final String TO_BEHAVIOR_KEY_55 = "telemetryOverviewBehavior";
    private final String TRACK_EVERY_KEY_55 = "trackEveryDefault";
    private final String TV_BEHAVIOR_KEY_55 = "threadsViewBehavior";
    private final String AUTO_OPEN_SNAPSHOT_KEY = "AUTO_OPEN_SNAPSHOT";
    private final String AUTO_SAVE_SNAPSHOT_KEY = "AUTO_SAVE_SNAPSHOT";
    private final String CALIBRATION_PORT_NO_KEY = "CALIBRATION_PORT_NO";
    private final String CPU_TASK_KEY = "CPU_TASK";
    private final String CUSTOM_HEAPDUMP_PATH_KEY = "CUSTOM_HEAPDUMP_PATH";
    private final String DNSA_SETTINGS_KEY = "DNSA_SETTINGS";
    private final String HEAPWALKER_ANALYSIS_ENABLED_KEY = "HEAPWALKER_ANALYSIS_ENABLED";
    private final String INSTR_FILTER_KEY = "INSTR_FILTER";
    private final String LIVE_CPU_KEY = "LIVE_CPU";
    private final String LIVE_FRAGMENT_KEY = "LIVE_FRAGMENT";
    private final String LIVE_MEMORY_KEY = "LIVE_MEMORY";
    private final String MEMORY_TASK_ALLOCATIONS_KEY = "MEMORY_TASK_ALLOCATIONS";
    private final String OOME_DETECTION_MODE_KEY = "OOME_DETECTION_MODE";
    private final String PLATFORM_NAME_KEY = "PLATFORM_NAME";
    private final String PORT_NO_KEY = "PORT_NO";
    private final String PPOINTS_DEPENDENCIES_INCLUDE_KEY = "PPOINTS_DEPENDENCIES_INCLUDE";
    private final String RECORD_STACK_TRACES_KEY = "RECORD_STACK_TRACES";
    private final String THREADS_MONITORING_KEY = "THREADS_MONITORING";
    private final String TO_BEHAVIOR_KEY = "TO_BEHAVIOR";
    private final String TRACK_EVERY_KEY = "TRACK_EVERY";
    private final String TV_BEHAVIOR_KEY = "TV_BEHAVIOR";
    private final String LCV_BEHAVIOR_KEY = "LCV_BEHAVIOR";
    private final String NO_DATA_HINT_KEY = "NO_DATA_HINT";
    private final String SNAPSHOT_WINDOW_OPEN_POLICY_KEY = "SNAPSHOT_WINDOW_OPEN_POLICY";
    private final String SNAPSHOT_WINDOW_CLOSE_POLICY_KEY = "SNAPSHOT_WINDOW_CLOSE_POLICY";
    private final String ENABLE_EXPERT_SETTINGS_KEY = "ENABLE_EXPERT_SETTINGS";
    private final String LOG_PROFILER_STATUS_KEY = "LOG_PROFILER_STATUS";
    private final String REOPEN_SNAPSHOTS_KEY = "REOPEN_SNAPSHOTS_KEY";
    private final String REOPEN_HDUMPS_KEY = "REOPEN_HDUMPS_KEY";
    private final String SOURCES_COLORING_KEY = "SOURCES_COLORING_KEY";
    private final String CUSTOM_HEAPDUMP_PATH_DEFAULT = "";
    private final String PLATFORM_NAME_DEFAULT = "PLATFORM_NAME_DEFAULT";
    private final String INSTR_FILTER_DEFAULT = "###";
    private final boolean AUTO_OPEN_SNAPSHOT_DEFAULT = true;
    private final boolean AUTO_SAVE_SNAPSHOT_DEFAULT = false;
    private final boolean HEAPWALKER_ANALYSIS_ENABLED_DEFAULT = false;
    private final boolean LIVE_CPU_DEFAULT = false;
    private final boolean LIVE_FRAGMENT_DEFAULT = false;
    private final boolean LIVE_MEMORY_DEFAULT = false;
    private final boolean MEMORY_TASK_ALLOCATIONS_DEFAULT = true;
    private final boolean PPOINTS_DEPENDENCIES_INCLUDE_DEFAULT = true;
    private final boolean RECORD_STACK_TRACES_DEFAULT = false;
    private final boolean THREADS_MONITORING_DEFAULT = true;
    private final int CALIBRATION_PORT_NO_DEFAULT = -1;
    private final int CPU_TASK_DEFAULT = 0;
    private final int OOME_DETECTION_MODE_DEFAULT = 1;
    private final int PORT_NO_DEFAULT = 5140;
    private final int TO_BEHAVIOR_DEFAULT = 2;
    private final int TRACK_EVERY_DEFAULT = 10;
    private final int TV_BEHAVIOR_DEFAULT = 1;
    private final int LCV_BEHAVIOR_DEFAULT = 1;
    private final boolean NO_DATA_HINT_DEFAULT = true;
    private final int SNAPSHOT_WINDOW_OPEN_DEFAULT = 3;
    private final int SNAPSHOT_WINDOW_CLOSE_DEFAULT = 0;
    private final boolean ENABLE_EXPERT_SETTINGS_DEFAULT = false;
    private final boolean LOG_PROFILER_STATUS_DEFAULT = false;
    private final boolean REOPEN_SNAPSHOTS_DEFAULT = false;
    private final boolean REOPEN_HDUMPS_DEFAULT = false;
    private final boolean SOURCES_COLORING_DEFAULT = false;
    private ProfilingSettings pSettings;
    private Boolean sourcesColoringEnabled;

    public static ProfilerIDESettings getInstance() {
        return defaultInstance;
    }

    private ProfilerIDESettings() {
    }

    public ProfilingSettings getDefaultProfilingSettings() {
        if (this.pSettings == null) {
            this.pSettings = this.loadProfilingSettings();
        }
        return this.pSettings;
    }

    public void saveDefaultProfilingSettings() {
        if (this.pSettings != null) {
            this.storeProfilingSettings(this.pSettings);
        }
    }

    public ProfilingSettings createDefaultProfilingSettings() {
        ProfilingSettings profilingSettings = new ProfilingSettings();
        this.getDefaultProfilingSettings().copySettingsInto(profilingSettings);
        return profilingSettings;
    }

    private ProfilingSettings loadProfilingSettings() {
        Preferences preferences = this.getPreferences();
        ProfilingSettings profilingSettings = new ProfilingSettings();
        profilingSettings.setSamplingFrequency(preferences.getInt("profiler.settings.cpu.sampling.frequency", 10));
        profilingSettings.setCPUProfilingType(preferences.getInt("profiler.settings.cpu.profiling.type", 0));
        profilingSettings.setSamplingInterval(preferences.getInt("profiler.settings.sampling.interval", -10));
        profilingSettings.setExcludeWaitTime(preferences.getBoolean("profiler.settings.cpu.exclude.wait.time", true));
        profilingSettings.setInstrumentSpawnedThreads(preferences.getBoolean("profiler.settings.instrument.spawned.threads", false));
        profilingSettings.setNProfiledThreadsLimit(preferences.getInt("profiler.settings.n.profiled.threads.limit", 128));
        profilingSettings.setInstrScheme(preferences.getInt("profiler.settings.instr.scheme", 1));
        profilingSettings.setInstrumentMethodInvoke(preferences.getBoolean("profiler.settings.instrument.method.invoke", true));
        profilingSettings.setInstrumentGetterSetterMethods(preferences.getBoolean("profiler.settings.istrument.getter.setter.methods", false));
        profilingSettings.setInstrumentEmptyMethods(preferences.getBoolean("profiler.settings.instrument.empty.methods", false));
        profilingSettings.setAllocTrackEvery(preferences.getInt("profiler.settings.obj.alloc.stack.sampling.interval", 1));
        profilingSettings.setRunGCOnGetResultsInMemoryProfiling(preferences.getBoolean("profiler.settings.run.gc.on.get.results.in.memory.profiling", false));
        profilingSettings.setThreadsSamplingEnabled(preferences.getBoolean("profiler.settings.threads.sampling.enabled", false));
        return profilingSettings;
    }

    private void storeProfilingSettings(ProfilingSettings profilingSettings) {
        Preferences preferences = this.getPreferences();
        preferences.putInt("profiler.settings.cpu.sampling.frequency", profilingSettings.getSamplingFrequency());
        preferences.putInt("profiler.settings.cpu.profiling.type", profilingSettings.getCPUProfilingType());
        preferences.putInt("profiler.settings.sampling.interval", profilingSettings.getSamplingInterval());
        preferences.putBoolean("profiler.settings.cpu.exclude.wait.time", profilingSettings.getExcludeWaitTime());
        preferences.putBoolean("profiler.settings.instrument.spawned.threads", profilingSettings.getInstrumentSpawnedThreads());
        preferences.putInt("profiler.settings.n.profiled.threads.limit", profilingSettings.getNProfiledThreadsLimit());
        preferences.putInt("profiler.settings.instr.scheme", profilingSettings.getInstrScheme());
        preferences.putBoolean("profiler.settings.instrument.method.invoke", profilingSettings.getInstrumentMethodInvoke());
        preferences.putBoolean("profiler.settings.istrument.getter.setter.methods", profilingSettings.getInstrumentGetterSetterMethods());
        preferences.putBoolean("profiler.settings.instrument.empty.methods", profilingSettings.getInstrumentEmptyMethods());
        preferences.putInt("profiler.settings.obj.alloc.stack.sampling.interval", profilingSettings.getAllocTrackEvery());
        preferences.putBoolean("profiler.settings.run.gc.on.get.results.in.memory.profiling", profilingSettings.getRunGCOnGetResultsInMemoryProfiling());
        preferences.putBoolean("profiler.settings.threads.sampling.enabled", profilingSettings.getThreadsSamplingEnabled());
    }

    public void setAutoOpenSnapshot(boolean bl) {
        this.getPreferences().putBoolean("AUTO_OPEN_SNAPSHOT", bl);
    }

    public boolean getAutoOpenSnapshot() {
        return this.getPreferences().getBoolean("AUTO_OPEN_SNAPSHOT", true);
    }

    public void setAutoSaveSnapshot(boolean bl) {
        this.getPreferences().putBoolean("AUTO_SAVE_SNAPSHOT", bl);
    }

    public boolean getAutoSaveSnapshot() {
        return this.getPreferences().getBoolean("AUTO_SAVE_SNAPSHOT", false);
    }

    public void setCalibrationPortNo(int n) {
        this.getPreferences().putInt("CALIBRATION_PORT_NO", n);
    }

    public int getCalibrationPortNo() {
        int n = this.getPreferences().getInt("CALIBRATION_PORT_NO", -1);
        if (n == -1) {
            return this.getPortNo() + 1;
        }
        return n;
    }

    public void setCpuTaskDefault(int n) {
        this.getPreferences().putInt("CPU_TASK", n);
    }

    public int getCpuTaskDefault() {
        return this.getPreferences().getInt("CPU_TASK", 0);
    }

    public void setCustomHeapdumpPath(String string) {
        this.getPreferences().put("CUSTOM_HEAPDUMP_PATH", string);
    }

    public String getCustomHeapdumpPath() {
        return this.getPreferences().get("CUSTOM_HEAPDUMP_PATH", "");
    }

    public void setDisplayLiveResultsCPU(boolean bl) {
        this.getPreferences().putBoolean("LIVE_CPU", bl);
    }

    public boolean getDisplayLiveResultsCPU() {
        return this.getPreferences().getBoolean("LIVE_CPU", false);
    }

    public void setDisplayLiveResultsFragment(boolean bl) {
        this.getPreferences().putBoolean("LIVE_FRAGMENT", bl);
    }

    public boolean getDisplayLiveResultsFragment() {
        return this.getPreferences().getBoolean("LIVE_FRAGMENT", false);
    }

    public void setDisplayLiveResultsMemory(boolean bl) {
        this.getPreferences().putBoolean("LIVE_MEMORY", bl);
    }

    public boolean getDisplayLiveResultsMemory() {
        return this.getPreferences().getBoolean("LIVE_MEMORY", false);
    }

    public void setShowNoDataHint(boolean bl) {
        this.getPreferences().putBoolean("NO_DATA_HINT", bl);
    }

    public boolean getShowNoDataHint() {
        return this.getPreferences().getBoolean("NO_DATA_HINT", true);
    }

    public void setSnapshotWindowOpenPolicy(int n) {
        this.getPreferences().putInt("SNAPSHOT_WINDOW_OPEN_POLICY", n);
    }

    public int getSnapshotWindowOpenPolicy() {
        return this.getPreferences().getInt("SNAPSHOT_WINDOW_OPEN_POLICY", 3);
    }

    public void setSnapshotWindowClosePolicy(int n) {
        this.getPreferences().putInt("SNAPSHOT_WINDOW_CLOSE_POLICY", n);
    }

    public int getSnapshotWindowClosePolicy() {
        return this.getPreferences().getInt("SNAPSHOT_WINDOW_CLOSE_POLICY", 0);
    }

    public void setEnableExpertSettings(boolean bl) {
        this.getPreferences().putBoolean("ENABLE_EXPERT_SETTINGS", true);
    }

    public boolean getEnableExpertSettings() {
        return true;
    }

    public void setLogProfilerStatus(boolean bl) {
        this.getPreferences().putBoolean("LOG_PROFILER_STATUS", bl);
    }

    public boolean getLogProfilerStatus() {
        return this.getPreferences().getBoolean("LOG_PROFILER_STATUS", false);
    }

    public void setReopenSnapshots(boolean bl) {
        this.getPreferences().putBoolean("REOPEN_SNAPSHOTS_KEY", bl);
    }

    public boolean getReopenSnapshots() {
        return this.getPreferences().getBoolean("REOPEN_SNAPSHOTS_KEY", false);
    }

    public void setReopenHeapDumps(boolean bl) {
        this.getPreferences().putBoolean("REOPEN_HDUMPS_KEY", bl);
    }

    public boolean getReopenHeapDumps() {
        return this.getPreferences().getBoolean("REOPEN_HDUMPS_KEY", false);
    }

    public void setSourcesColoringEnabled(boolean bl) {
        this.getPreferences().putBoolean("SOURCES_COLORING_KEY", bl);
        this.sourcesColoringEnabled = bl;
    }

    public boolean isSourcesColoringEnabled() {
        if (this.sourcesColoringEnabled == null) {
            this.sourcesColoringEnabled = this.getPreferences().getBoolean("SOURCES_COLORING_KEY", false);
        }
        return this.sourcesColoringEnabled;
    }

    public void setDoNotShowAgain(String string, String string2) {
        if (string2 != null) {
            this.getDNSAMap().put(string, string2);
        } else {
            this.getDNSAMap().remove(string);
        }
        this.storeDNSAMap();
    }

    public String getDoNotShowAgain(String string) {
        return this.getDNSAMap().get(string);
    }

    public void setHeapWalkerAnalysisEnabled(boolean bl) {
        this.getPreferences().putBoolean("HEAPWALKER_ANALYSIS_ENABLED", bl);
    }

    public boolean getHeapWalkerAnalysisEnabled() {
        return this.getPreferences().getBoolean("HEAPWALKER_ANALYSIS_ENABLED", false);
    }

    public void setIncludeProfilingPointsDependencies(boolean bl) {
        this.getPreferences().putBoolean("PPOINTS_DEPENDENCIES_INCLUDE", bl);
    }

    public boolean getIncludeProfilingPointsDependencies() {
        return this.getPreferences().getBoolean("PPOINTS_DEPENDENCIES_INCLUDE", true);
    }

    public void setInstrFilterDefault(String string) {
        this.getPreferences().put("INSTR_FILTER", string);
    }

    public String getInstrFilterDefault() {
        return this.getPreferences().get("INSTR_FILTER", "###");
    }

    public void setJavaPlatformForProfiling(String string) {
        this.getPreferences().put("PLATFORM_NAME", string == null ? "PLATFORM_NAME_DEFAULT" : string);
    }

    public String getJavaPlatformForProfiling() {
        String string = this.getPreferences().get("PLATFORM_NAME", "PLATFORM_NAME_DEFAULT");
        return "PLATFORM_NAME_DEFAULT".equals(string) ? null : string;
    }

    public void setMemoryTaskAllocationsDefault(boolean bl) {
        this.getPreferences().putBoolean("MEMORY_TASK_ALLOCATIONS", bl);
    }

    public boolean getMemoryTaskAllocationsDefault() {
        return this.getPreferences().getBoolean("MEMORY_TASK_ALLOCATIONS", true);
    }

    public boolean isOOMDetectionEnabled() {
        return this.getOOMDetectionMode() != 0;
    }

    public void setOOMDetectionMode(int n) {
        this.getPreferences().putInt("OOME_DETECTION_MODE", n);
    }

    public int getOOMDetectionMode() {
        return this.getPreferences().getInt("OOME_DETECTION_MODE", 1);
    }

    public void setPortNo(int n) {
        this.getPreferences().putInt("PORT_NO", n);
    }

    public int getPortNo() {
        return this.getPreferences().getInt("PORT_NO", 5140);
    }

    public void setRecordStackTracesDefault(boolean bl) {
        this.getPreferences().putBoolean("RECORD_STACK_TRACES", bl);
    }

    public boolean getRecordStackTracesDefault() {
        return this.getPreferences().getBoolean("RECORD_STACK_TRACES", false);
    }

    public void setTelemetryOverviewBehavior(int n) {
        this.getPreferences().putInt("TO_BEHAVIOR", n);
    }

    public int getTelemetryOverviewBehavior() {
        return this.getPreferences().getInt("TO_BEHAVIOR", 2);
    }

    public void setThreadsMonitoringDefault(boolean bl) {
        this.getPreferences().putBoolean("THREADS_MONITORING", bl);
    }

    public boolean getThreadsMonitoringDefault() {
        return this.getPreferences().getBoolean("THREADS_MONITORING", true);
    }

    public void setThreadsViewBehavior(int n) {
        this.getPreferences().putInt("TV_BEHAVIOR", n);
    }

    public int getThreadsViewBehavior() {
        return this.getPreferences().getInt("TV_BEHAVIOR", 1);
    }

    public void setLockContentionViewBehavior(int n) {
        this.getPreferences().putInt("LCV_BEHAVIOR", n);
    }

    public int getLockContentionViewBehavior() {
        return this.getPreferences().getInt("LCV_BEHAVIOR", 1);
    }

    public void setTrackEveryDefault(int n) {
        this.getPreferences().putInt("TRACK_EVERY", n);
    }

    public int getTrackEveryDefault() {
        return this.getPreferences().getInt("TRACK_EVERY", 10);
    }

    public void clearDoNotShowAgainMap() {
        this.getDNSAMap().clear();
        this.storeDNSAMap();
    }

    public String displayName() {
        return Bundle.ProfilerIDESettings_Name();
    }

    private Map<String, String> getDNSAMap() {
        if (this.dnsaMap != null) {
            return this.dnsaMap;
        }
        this.dnsaMap = new HashMap<String, String>();
        String string = this.getPreferences().get("DNSA_SETTINGS", null);
        if (string != null) {
            String[] stringArray = string.split(":");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(",");
                assert (stringArray2.length == 2);
                this.dnsaMap.put(stringArray2[0], stringArray2[1]);
            }
        }
        return this.dnsaMap;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(ProfilerIDESettings.class);
    }

    private void storeDNSAMap() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.getDNSAMap().entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry<String, String> entry = object.next();
            stringBuilder.append((Object)entry.getKey()).append(",").append((Object)entry.getValue());
            if (!object.hasNext()) continue;
            stringBuilder.append(":");
        }
        object = stringBuilder.toString();
        if (((String)object).length() > 0) {
            this.getPreferences().put("DNSA_SETTINGS", (String)object);
        } else {
            this.getPreferences().remove("DNSA_SETTINGS");
        }
    }
}

