/*
 * Decompiled with CFR 0.152.
 */
package infovis.panel;

import infovis.panel.DoubleBoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultDoubleBoundedRangeModel
implements DoubleBoundedRangeModel {
    protected transient ChangeEvent changeEvent;
    protected EventListenerList listenerList = new EventListenerList();
    private double value = 0.0;
    private double extent = 0.0;
    private double min = 0.0;
    private double max = 100.0;
    private boolean isAdjusting = false;

    public DefaultDoubleBoundedRangeModel() {
    }

    public DefaultDoubleBoundedRangeModel(double value, double extent, double min, double max) {
        if (!(max >= min && value >= min && value + extent >= value && value + extent <= max)) {
            throw new IllegalArgumentException("invalid range properties");
        }
        this.value = value;
        this.extent = extent;
        this.min = min;
        this.max = max;
    }

    public double getValueDouble() {
        return this.value;
    }

    public int getValue() {
        return Math.round((float)this.getValueDouble());
    }

    public double getExtentDouble() {
        return this.extent;
    }

    public int getExtent() {
        return Math.round((float)this.getExtentDouble());
    }

    public double getMinimumDouble() {
        return this.min;
    }

    public int getMinimum() {
        return (int)this.getMinimumDouble();
    }

    public double getMaximumDouble() {
        return this.max;
    }

    public int getMaximum() {
        return (int)this.getMaximumDouble();
    }

    public void setValue(double n) {
        double newValue = Math.max(n, this.min);
        if (newValue + this.extent > this.max) {
            newValue = this.max - this.extent;
        }
        this.setRangeProperties(newValue, this.extent, this.min, this.max, this.isAdjusting);
    }

    public void setValue(int newValue) {
        this.setValue((double)newValue);
    }

    public void setExtent(double n) {
        double newExtent = Math.max(0.0, n);
        if (this.value + newExtent > this.max) {
            newExtent = this.max - this.value;
        }
        this.setRangeProperties(this.value, newExtent, this.min, this.max, this.isAdjusting);
    }

    public void setExtent(int newExtent) {
        this.setExtent((double)newExtent);
    }

    public void setMinimum(double n) {
        double newMax = Math.max(n, this.max);
        double newValue = Math.max(n, this.value);
        double newExtent = Math.min(newMax - newValue, this.extent);
        this.setRangeProperties(newValue, newExtent, n, newMax, this.isAdjusting);
    }

    public void setMinimum(int newMinimum) {
        this.setMinimum((double)newMinimum);
    }

    public void setMaximum(double n) {
        double newMin = Math.min(n, this.min);
        double newExtent = Math.min(n - newMin, this.extent);
        double newValue = Math.min(n - newExtent, this.value);
        this.setRangeProperties(newValue, newExtent, newMin, n, this.isAdjusting);
    }

    public void setMaximum(int newMaximum) {
        this.setMaximum((double)newMaximum);
    }

    public void setValueIsAdjusting(boolean b) {
        this.setRangeProperties(this.value, this.extent, this.min, this.max, b);
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void setRangeProperties(double newValue, double newExtent, double newMin, double newMax, boolean adjusting) {
        if (newMin > newMax) {
            newMin = newMax;
        }
        if (newValue > newMax) {
            newMax = newValue;
        }
        if (newValue < newMin) {
            newMin = newValue;
        }
        if (newExtent + newValue > newMax) {
            newExtent = newMax - newValue;
        }
        if (newExtent < 0.0) {
            newExtent = 0.0;
        }
        if (newValue != this.value || newExtent != this.extent || newMin != this.min || newMax != this.max || adjusting != this.isAdjusting) {
            this.value = newValue;
            this.extent = newExtent;
            this.min = newMin;
            this.max = newMax;
            this.isAdjusting = adjusting;
            this.fireStateChanged();
        }
    }

    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
        this.setRangeProperties((double)value, (double)extent, (double)min, (double)max, adjusting);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

