import ts = require("./typesystem");
import { Status } from "./typesystem";
import tsInterfaces = require("./typesystem-interfaces");
export declare class MetaInfo extends ts.TypeInformation {
    private _name;
    private _value;
    constructor(_name: string, _value: any, inhertitable?: boolean);
    private static CLASS_IDENTIFIER_MetaInfo;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is MetaInfo;
    value(): any;
    requiredType(): ts.RootType;
    facetName(): string;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class Description extends MetaInfo {
    constructor(value: string);
    private static CLASS_IDENTIFIER_Description;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is Description;
    kind(): tsInterfaces.MetaInformationKind;
    protected validateSelfIndividual(parentStatus: Status, registry: ts.TypeRegistry): Status;
}
export declare class NotScalar extends MetaInfo {
    constructor();
    private static CLASS_IDENTIFIER_NotScalar;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is NotScalar;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class ImportedByChain extends MetaInfo {
    private _typeName;
    constructor(_typeName: string);
    private static CLASS_IDENTIFIER_ImportedByChain;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is ImportedByChain;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class AcceptAllScalarsAsStrings extends MetaInfo {
    constructor();
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class SkipValidation extends MetaInfo {
    constructor();
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class DisplayName extends MetaInfo {
    constructor(value: string);
    private static CLASS_IDENTIFIER_DisplayName;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is DisplayName;
    kind(): tsInterfaces.MetaInformationKind;
    protected validateSelfIndividual(parentStatus: Status, registry: ts.TypeRegistry): Status;
}
export declare class Usage extends MetaInfo {
    constructor(value: string);
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class Annotation extends MetaInfo implements tsInterfaces.IAnnotation {
    protected path: string;
    protected ofExample: boolean;
    private _index;
    constructor(name: string, value: any, path: string, ofExample?: boolean, _index?: number);
    private _ownerFacet;
    name(): string;
    definition(): tsInterfaces.IParsedType;
    validateSelfIndividual(parentStatus: ts.Status, registry: ts.TypeRegistry): ts.Status;
    kind(): tsInterfaces.MetaInformationKind;
    ownerFacet(): tsInterfaces.ITypeFacet;
    setOwnerFacet(ownerFacet: tsInterfaces.ITypeFacet): void;
    getPath(): string;
}
export declare class FacetDeclaration extends MetaInfo {
    private name;
    private _type;
    private optional;
    private builtIn;
    constructor(name: string, _type: ts.AbstractType, optional: boolean, builtIn?: boolean);
    private static CLASS_IDENTIFIER_FacetDeclaration;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is FacetDeclaration;
    actualName(): string;
    isOptional(): boolean;
    type(): ts.AbstractType;
    kind(): tsInterfaces.MetaInformationKind;
    isBuiltIn(): boolean;
    validateSelfIndividual(parentStatue: ts.Status, registry: ts.TypeRegistry): ts.Status;
}
export declare class CustomFacet extends MetaInfo {
    constructor(name: string, value: any);
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class Example extends MetaInfo {
    constructor(value: any);
    validateSelfIndividual(parentStatus: ts.Status, registry: ts.TypeRegistry): ts.Status;
    validateValue(registry: ts.TypeRegistry): ts.Status;
    validateAnnotations(registry: ts.TypeRegistry): ts.Status;
    example(): any;
    asXMLString(): string;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class Required extends MetaInfo {
    constructor(value: any);
    validateSelfIndividual(result: ts.Status, registry: ts.TypeRegistry): ts.Status;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class HasPropertiesFacet extends MetaInfo {
    constructor();
    private static CLASS_IDENTIFIER_HasPropertiesFacet;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is HasPropertiesFacet;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class AllowedTargets extends MetaInfo {
    constructor(value: any);
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class Examples extends MetaInfo {
    constructor(value: any);
    examples(): any[];
    asXMLStrings(): string[];
    validateSelfIndividual(parentStatus: ts.Status, registry: ts.TypeRegistry): ts.Status;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class XMLInfo extends MetaInfo {
    constructor(o: any);
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class Default extends MetaInfo {
    constructor(value: any);
    validateSelfIndividual(result: ts.Status, registry: ts.TypeRegistry): ts.Status;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class SchemaPath extends MetaInfo {
    constructor(path: string);
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class SourceMap extends MetaInfo {
    constructor(value: Object);
    private static CLASS_IDENTIFIER_SourceMap;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is SourceMap;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class TypeAttributeValue extends MetaInfo {
    constructor(value: any);
    private static CLASS_IDENTIFIER_TypeAttributeValue;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is TypeAttributeValue;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class ParserMetadata extends MetaInfo {
    constructor(value: Object);
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class Discriminator extends ts.TypeInformation {
    property: string;
    constructor(property: string);
    requiredType(): ts.InheritedType;
    value(): string;
    facetName(): string;
    validateSelfIndividual(result: ts.Status, registry: ts.TypeRegistry): ts.Status;
    kind(): tsInterfaces.MetaInformationKind;
}
export declare class DiscriminatorValue extends ts.Constraint {
    _value: any;
    protected strict: boolean;
    constructor(_value: any, strict?: boolean);
    private static CLASS_IDENTIFIER_DiscriminatorValue;
    getClassIdentifier(): string[];
    static isInstance(instance: any): instance is DiscriminatorValue;
    check(i: any, path: tsInterfaces.IValidationPath): Status;
    facetName(): string;
    validateSelfIndividual(st: ts.Status, registry: ts.TypeRegistry): ts.Status;
    requiredType(): ts.InheritedType;
    value(): any;
    kind(): tsInterfaces.MetaInformationKind;
    isStrict(): boolean;
}
export interface ChainingData {
    kind: string;
    value: string;
}
