/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.MaxScoreSumPropagator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class BlockMaxConjunctionScorer
extends Scorer {
    final Scorer[] scorers;
    final MaxScoreSumPropagator maxScorePropagator;
    float minScore;
    final double[] minScores;
    double score;

    BlockMaxConjunctionScorer(Weight weight, Collection<Scorer> scorersList) throws IOException {
        super(weight);
        for (Scorer scorer : this.scorers = scorersList.toArray(new Scorer[scorersList.size()])) {
            scorer.advanceShallow(0);
        }
        this.maxScorePropagator = new MaxScoreSumPropagator(scorersList);
        Comparator comparator = (s1, s2) -> {
            int cmp;
            try {
                cmp = Float.compare(s2.getMaxScore(Integer.MAX_VALUE), s1.getMaxScore(Integer.MAX_VALUE));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (cmp == 0) {
                cmp = Long.compare(s1.iterator().cost(), s2.iterator().cost());
            }
            return cmp;
        };
        Arrays.sort(this.scorers, comparator);
        this.minScores = new double[this.scorers.length];
    }

    @Override
    public DocIdSetIterator iterator() {
        final Scorer leadScorer = this.scorers[0];
        final DocIdSetIterator[] iterators = (DocIdSetIterator[])Arrays.stream(this.scorers).map(Scorer::iterator).toArray(DocIdSetIterator[]::new);
        final DocIdSetIterator lead = iterators[0];
        return new DocIdSetIterator(){
            float maxScore;
            int upTo = -1;

            @Override
            public int docID() {
                return lead.docID();
            }

            @Override
            public long cost() {
                return lead.cost();
            }

            private void moveToNextBlock(int target) throws IOException {
                this.upTo = BlockMaxConjunctionScorer.this.advanceShallow(target);
                this.maxScore = BlockMaxConjunctionScorer.this.getMaxScore(this.upTo);
                BlockMaxConjunctionScorer.this.minScores[BlockMaxConjunctionScorer.this.minScores.length - 1] = BlockMaxConjunctionScorer.this.minScore > 0.0f ? (double)Math.nextDown(BlockMaxConjunctionScorer.this.minScore) : 0.0;
                for (int i = BlockMaxConjunctionScorer.this.scorers.length - 1; i > 0; --i) {
                    double minScore = BlockMaxConjunctionScorer.this.minScores[i];
                    float clauseMaxScore = BlockMaxConjunctionScorer.this.scorers[i].getMaxScore(this.upTo);
                    if (minScore > (double)clauseMaxScore) {
                        BlockMaxConjunctionScorer.this.minScores[i - 1] = minScore - (double)clauseMaxScore;
                        assert (BlockMaxConjunctionScorer.this.minScores[i - 1] + (double)clauseMaxScore <= minScore);
                        continue;
                    }
                    BlockMaxConjunctionScorer.this.minScores[i - 1] = 0.0;
                }
            }

            private int advanceTarget(int target) throws IOException {
                if (target > this.upTo) {
                    this.moveToNextBlock(target);
                }
                while (true) {
                    assert (this.upTo >= target);
                    if (this.maxScore >= BlockMaxConjunctionScorer.this.minScore) {
                        return target;
                    }
                    if (this.upTo == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    target = this.upTo + 1;
                    this.moveToNextBlock(target);
                }
            }

            @Override
            public int nextDoc() throws IOException {
                return this.advance(this.docID() + 1);
            }

            @Override
            public int advance(int target) throws IOException {
                return this.doNext(lead.advance(this.advanceTarget(target)));
            }

            private int doNext(int doc) throws IOException {
                block0: while (true) {
                    int nextTarget;
                    assert (doc == lead.docID());
                    if (doc == Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    if (doc > this.upTo && (nextTarget = this.advanceTarget(doc)) != doc) {
                        doc = lead.advance(nextTarget);
                        continue;
                    }
                    assert (doc <= this.upTo);
                    if (BlockMaxConjunctionScorer.this.minScore > 0.0f) {
                        BlockMaxConjunctionScorer.this.score = leadScorer.score();
                        if (BlockMaxConjunctionScorer.this.score < BlockMaxConjunctionScorer.this.minScores[0]) {
                            doc = lead.advance(this.advanceTarget(doc + 1));
                            continue;
                        }
                    }
                    for (int i = 1; i < iterators.length; ++i) {
                        int next;
                        DocIdSetIterator other = iterators[i];
                        if (other.docID() < doc && (next = other.advance(doc)) > doc) {
                            doc = lead.advance(this.advanceTarget(next));
                            continue block0;
                        }
                        assert (other.docID() == doc);
                        if (!(BlockMaxConjunctionScorer.this.minScore > 0.0f)) continue;
                        BlockMaxConjunctionScorer.this.score += (double)BlockMaxConjunctionScorer.this.scorers[i].score();
                        if (!(BlockMaxConjunctionScorer.this.score < BlockMaxConjunctionScorer.this.minScores[i])) continue;
                        doc = lead.advance(this.advanceTarget(doc + 1));
                        continue block0;
                    }
                    break;
                }
                if (!(BlockMaxConjunctionScorer.this.minScore > 0.0f)) {
                    BlockMaxConjunctionScorer.this.score = 0.0;
                    for (Scorer scorer : BlockMaxConjunctionScorer.this.scorers) {
                        BlockMaxConjunctionScorer.this.score += (double)scorer.score();
                    }
                }
                return doc;
            }
        };
    }

    @Override
    public int docID() {
        return this.scorers[0].docID();
    }

    @Override
    public float score() throws IOException {
        return (float)this.score;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        int result = this.scorers[0].advanceShallow(target);
        for (int i = 1; i < this.scorers.length; ++i) {
            this.scorers[i].advanceShallow(target);
        }
        return result;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        double sum = 0.0;
        for (Scorer scorer : this.scorers) {
            sum += (double)scorer.getMaxScore(upTo);
        }
        return (float)sum;
    }

    @Override
    public void setMinCompetitiveScore(float score) throws IOException {
        this.minScore = score;
        this.maxScorePropagator.setMinCompetitiveScore(score);
    }

    @Override
    public Collection<Scorable.ChildScorable> getChildren() {
        ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>();
        for (Scorer scorer : this.scorers) {
            children.add(new Scorable.ChildScorable(scorer, "MUST"));
        }
        return children;
    }
}

