/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.preview;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.OutputStream;
import org.gephi.io.exporter.spi.ByteExporter;
import org.gephi.io.exporter.spi.VectorExporter;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.RenderTarget;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class PDFExporter
implements ByteExporter,
VectorExporter,
LongTask {
    private ProgressTicket progress;
    private Workspace workspace;
    private OutputStream stream;
    private boolean cancel = false;
    private PDFTarget target;
    private float marginTop = 18.0f;
    private float marginBottom = 18.0f;
    private float marginLeft = 18.0f;
    private float marginRight = 18.0f;
    private boolean landscape = false;
    private Rectangle pageSize = PageSize.A4;

    public boolean execute() {
        Progress.start((ProgressTicket)this.progress);
        PreviewController controller = (PreviewController)Lookup.getDefault().lookup(PreviewController.class);
        controller.getModel(this.workspace).getProperties().putValue("visibility-ratio", (Object)1.0);
        controller.refreshPreview(this.workspace);
        PreviewProperties props = controller.getModel(this.workspace).getProperties();
        Rectangle size = new Rectangle(this.pageSize);
        if (this.landscape) {
            size = new Rectangle(this.pageSize.rotate());
        }
        Color col = props.getColorValue("background-color");
        size.setBackgroundColor(new BaseColor(col.getRed(), col.getGreen(), col.getBlue()));
        Document document = new Document(size);
        PdfWriter pdfWriter = null;
        try {
            pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)this.stream);
            pdfWriter.setPdfVersion(PdfWriter.PDF_VERSION_1_5);
            pdfWriter.setFullCompression();
        }
        catch (DocumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        document.open();
        PdfContentByte cb = pdfWriter.getDirectContent();
        cb.saveState();
        props.putValue("pdf.landscape", (Object)this.landscape);
        props.putValue("pdf.pagesize", (Object)size);
        props.putValue("pdf.margin.top", (Object)new Float(this.marginTop));
        props.putValue("pdf.margin.left", (Object)new Float(this.marginLeft));
        props.putValue("pfd.margin.bottom", (Object)new Float(this.marginBottom));
        props.putValue("pdf.margin.right", (Object)new Float(this.marginRight));
        props.putValue("pdf.contentbyte", (Object)cb);
        this.target = (PDFTarget)controller.getRenderTarget("pdf", this.workspace);
        if (this.target instanceof LongTask) {
            ((LongTask)this.target).setProgressTicket(this.progress);
        }
        try {
            controller.render((RenderTarget)this.target, this.workspace);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        cb.restoreState();
        document.close();
        Progress.finish((ProgressTicket)this.progress);
        props.putValue("pdf.contentbyte", null);
        props.putValue("pdf.pagesize", null);
        return !this.cancel;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public float getMarginBottom() {
        return this.marginBottom;
    }

    public float getMarginLeft() {
        return this.marginLeft;
    }

    public float getMarginRight() {
        return this.marginRight;
    }

    public float getMarginTop() {
        return this.marginTop;
    }

    public Rectangle getPageSize() {
        return this.pageSize;
    }

    public void setMarginBottom(float marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setMarginLeft(float marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setMarginRight(float marginRight) {
        this.marginRight = marginRight;
    }

    public void setMarginTop(float marginTop) {
        this.marginTop = marginTop;
    }

    public void setPageSize(Rectangle pageSize) {
        this.pageSize = pageSize;
    }

    public void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean cancel() {
        this.cancel = true;
        if (this.target instanceof LongTask) {
            ((LongTask)this.target).cancel();
        }
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }
}

