/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.io.File;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;

public class SourceInfo {
    private File _sourceFile = null;
    private String _sourceName = null;
    private FILE_TYPE _fileType = null;
    private String _fileTitle = null;
    private DataPoint[] _points = null;
    private int _numPoints = 0;
    private int[] _pointIndices = null;

    public SourceInfo(File file, FILE_TYPE fILE_TYPE) {
        this._sourceFile = file;
        this._sourceName = file.getName();
        this._fileType = fILE_TYPE;
    }

    public SourceInfo(String string, FILE_TYPE fILE_TYPE) {
        this._sourceFile = null;
        this._sourceName = string;
        this._fileType = fILE_TYPE;
    }

    public void setFileTitle(String string) {
        this._fileTitle = string;
    }

    public File getFile() {
        return this._sourceFile;
    }

    public String getName() {
        return this._sourceName;
    }

    public FILE_TYPE getFileType() {
        return this._fileType;
    }

    public String getFileTitle() {
        return this._fileTitle;
    }

    public int getNumPoints() {
        return this._numPoints;
    }

    public void setPointIndices(boolean[] blArray) {
        this._numPoints = blArray.length;
        this._pointIndices = new int[this._numPoints];
        int n = 0;
        int n2 = 0;
        while (n2 < this._numPoints) {
            if (blArray[n2]) {
                this._pointIndices[n++] = n2;
            }
            ++n2;
        }
    }

    public void populatePointObjects(Track track, int n) {
        if (this._numPoints == 0) {
            this._numPoints = n;
        }
        if (n > 0) {
            this._points = new DataPoint[n];
            int n2 = track.getNumPoints();
            System.arraycopy(track.cloneContents(), n2 - n, this._points, 0, n);
        }
    }

    public int getIndex(DataPoint dataPoint) {
        int n = -1;
        int n2 = 0;
        while (n2 < this._points.length) {
            if (this._points[n2] == dataPoint) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return n;
        }
        if (this._pointIndices == null) {
            return n;
        }
        return this._pointIndices[n];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FILE_TYPE {
        TEXT,
        GPX,
        KML,
        NMEA,
        GPSBABEL,
        GPSIES,
        JSON;

    }
}

