/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.reader.impl;

import org.jetbrains.kotlin.org.jline.reader.LineReader;

public class ReaderUtils {
    public static boolean isSet(LineReader reader, LineReader.Option option) {
        return reader != null && reader.isSet(option);
    }

    public static String getString(LineReader reader, String name, String def) {
        Object v2 = reader != null ? reader.getVariable(name) : null;
        return v2 != null ? v2.toString() : def;
    }

    public static boolean getBoolean(LineReader reader, String name, boolean def) {
        Object v2;
        Object object = v2 = reader != null ? reader.getVariable(name) : null;
        if (v2 instanceof Boolean) {
            return (Boolean)v2;
        }
        if (v2 != null) {
            String s = v2.toString();
            return s.isEmpty() || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("1") || s.equalsIgnoreCase("true");
        }
        return def;
    }

    public static int getInt(LineReader reader, String name, int def) {
        Object v2;
        int nb = def;
        Object object = v2 = reader != null ? reader.getVariable(name) : null;
        if (v2 instanceof Number) {
            return ((Number)v2).intValue();
        }
        if (v2 != null) {
            nb = 0;
            try {
                nb = Integer.parseInt(v2.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nb;
    }

    public static long getLong(LineReader reader, String name, long def) {
        Object v2;
        long nb = def;
        Object object = v2 = reader != null ? reader.getVariable(name) : null;
        if (v2 instanceof Number) {
            return ((Number)v2).longValue();
        }
        if (v2 != null) {
            nb = 0L;
            try {
                nb = Long.parseLong(v2.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return nb;
    }
}

