/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.collect.ImmutableSortedMap;
import java.util.SortedSet;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.execution.TaskFingerprinter;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskFingerprinter
implements TaskFingerprinter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskFingerprinter.class);
    private final FileCollectionFingerprinterRegistry fingerprinterRegistry;

    public DefaultTaskFingerprinter(FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        this.fingerprinterRegistry = fingerprinterRegistry;
    }

    @Override
    public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprintTaskFiles(TaskInternal task, SortedSet<? extends TaskFilePropertySpec> fileProperties) {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (TaskFilePropertySpec taskFilePropertySpec : fileProperties) {
            FileCollectionFingerprinter fingerprinter = this.fingerprinterRegistry.getFingerprinter(taskFilePropertySpec.getNormalizer());
            LOGGER.debug("Fingerprinting property {} for {}", (Object)taskFilePropertySpec, (Object)task);
            CurrentFileCollectionFingerprint result = fingerprinter.fingerprint(taskFilePropertySpec.getPropertyFiles());
            builder.put((Object)taskFilePropertySpec.getPropertyName(), (Object)result);
        }
        return builder.build();
    }
}

