/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.testing.TestFilter;

public class DefaultTestFilter
implements TestFilter {
    private final Set<String> includeTestNames = new HashSet<String>();
    private final Set<String> excludeTestNames = new HashSet<String>();
    private final Set<String> commandLineIncludeTestNames = new HashSet<String>();
    private boolean failOnNoMatching = true;

    private void validateName(String name) {
        if (name == null || name.length() == 0) {
            throw new InvalidUserDataException("Selected test name cannot be null or empty.");
        }
    }

    @Override
    public TestFilter includeTestsMatching(String testNamePattern) {
        this.validateName(testNamePattern);
        this.includeTestNames.add(testNamePattern);
        return this;
    }

    @Override
    public TestFilter excludeTestsMatching(String testNamePattern) {
        this.validateName(testNamePattern);
        this.excludeTestNames.add(testNamePattern);
        return this;
    }

    @Override
    public TestFilter includeTest(String className, String methodName) {
        return this.addToFilteringSet(this.includeTestNames, className, methodName);
    }

    @Override
    public TestFilter excludeTest(String className, String methodName) {
        return this.addToFilteringSet(this.excludeTestNames, className, methodName);
    }

    private TestFilter addToFilteringSet(Set<String> filter, String className, String methodName) {
        this.validateName(className);
        if (methodName == null || methodName.trim().isEmpty()) {
            filter.add(className + ".*");
        } else {
            filter.add(className + "." + methodName);
        }
        return this;
    }

    @Override
    public void setFailOnNoMatchingTests(boolean failOnNoMatchingTests) {
        this.failOnNoMatching = failOnNoMatchingTests;
    }

    @Override
    public boolean isFailOnNoMatchingTests() {
        return this.failOnNoMatching;
    }

    @Override
    @Input
    public Set<String> getIncludePatterns() {
        return this.includeTestNames;
    }

    @Override
    public Set<String> getExcludePatterns() {
        return this.excludeTestNames;
    }

    @Override
    public TestFilter setIncludePatterns(String ... testNamePatterns) {
        return this.setFilteringPatterns(this.includeTestNames, testNamePatterns);
    }

    @Override
    public TestFilter setExcludePatterns(String ... testNamePatterns) {
        return this.setFilteringPatterns(this.excludeTestNames, testNamePatterns);
    }

    private TestFilter setFilteringPatterns(Set<String> filter, String ... testNamePatterns) {
        for (String name : testNamePatterns) {
            this.validateName(name);
        }
        filter.clear();
        filter.addAll(Arrays.asList(testNamePatterns));
        return this;
    }

    @Input
    public Set<String> getCommandLineIncludePatterns() {
        return this.commandLineIncludeTestNames;
    }

    public TestFilter setCommandLineIncludePatterns(Collection<String> testNamePatterns) {
        for (String name : testNamePatterns) {
            this.validateName(name);
        }
        this.commandLineIncludeTestNames.clear();
        this.commandLineIncludeTestNames.addAll(testNamePatterns);
        return this;
    }
}

