/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.ExecuteScheduledTransformationStepBuildOperationDetails;
import org.gradle.api.internal.artifacts.transform.ExecuteScheduledTransformationStepBuildOperationType;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.Try;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;

public abstract class TransformationNode
extends Node {
    private static final AtomicInteger ORDER_COUNTER = new AtomicInteger();
    private final int order = ORDER_COUNTER.incrementAndGet();
    protected final TransformationStep transformationStep;
    protected Try<TransformationSubject> transformedSubject;

    public static TransformationNode chained(TransformationStep current, TransformationNode previous, ExecutionGraphDependenciesResolver executionGraphDependenciesResolver) {
        return new ChainedTransformationNode(current, previous, executionGraphDependenciesResolver);
    }

    public static TransformationNode initial(TransformationStep initial, ResolvableArtifact artifact, ExecutionGraphDependenciesResolver executionGraphDependenciesResolver) {
        return new InitialTransformationNode(initial, artifact, executionGraphDependenciesResolver);
    }

    protected TransformationNode(TransformationStep transformationStep) {
        this.transformationStep = transformationStep;
    }

    public abstract void execute(BuildOperationExecutor var1, ArtifactTransformListener var2);

    public String toString() {
        return this.transformationStep.getDisplayName();
    }

    private Try<TransformationSubject> getTransformedSubject() {
        if (this.transformedSubject == null) {
            throw new IllegalStateException(String.format("Transformation %s has been scheduled and is now required, but did not execute, yet.", this.transformationStep.getDisplayName()));
        }
        return this.transformedSubject;
    }

    public Set<Node> getFinalizers() {
        return Collections.emptySet();
    }

    public void prepareForExecution() {
    }

    @Nullable
    public Project getProject() {
        return null;
    }

    public Throwable getNodeFailure() {
        return null;
    }

    public void rethrowNodeFailure() {
    }

    public int compareTo(Node other) {
        if (((Object)((Object)this)).getClass() != other.getClass()) {
            return ((Object)((Object)this)).getClass().getName().compareTo(other.getClass().getName());
        }
        TransformationNode otherTransformation = (TransformationNode)other;
        return this.order - otherTransformation.order;
    }

    protected void processDependencies(Action<Node> processHardSuccessor, Set<Node> dependencies) {
        for (Node dependency : dependencies) {
            this.addDependencySuccessor(dependency);
            processHardSuccessor.execute((Object)dependency);
        }
    }

    private abstract class ArtifactTransformationStepBuildOperation
    implements CallableBuildOperation<Try<TransformationSubject>> {
        private ArtifactTransformationStepBuildOperation() {
        }

        public final BuildOperationDescriptor.Builder description() {
            String transformerName = TransformationNode.this.transformationStep.getDisplayName();
            String subjectName = this.describeSubject();
            String basicName = subjectName + " with " + transformerName;
            return BuildOperationDescriptor.displayName((String)("Transform " + basicName)).progressDisplayName("Transforming " + basicName).operationType(BuildOperationCategory.TRANSFORM).details((Object)new ExecuteScheduledTransformationStepBuildOperationDetails(TransformationNode.this, transformerName, subjectName));
        }

        protected abstract String describeSubject();

        public Try<TransformationSubject> call(BuildOperationContext context) {
            Try<TransformationSubject> transformedSubject = this.transform();
            context.setResult((Object)ExecuteScheduledTransformationStepBuildOperationType.RESULT);
            transformedSubject.getFailure().ifPresent(failure -> context.failed(failure));
            return transformedSubject;
        }

        protected abstract Try<TransformationSubject> transform();
    }

    private static class ChainedTransformationNode
    extends TransformationNode {
        private final TransformationNode previousTransformationNode;
        private final ExecutionGraphDependenciesResolver dependenciesResolver;

        public ChainedTransformationNode(TransformationStep transformationStep, TransformationNode previousTransformationNode, ExecutionGraphDependenciesResolver dependenciesResolver) {
            super(transformationStep);
            this.previousTransformationNode = previousTransformationNode;
            this.dependenciesResolver = dependenciesResolver;
        }

        @Override
        public void execute(BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
            this.transformedSubject = (Try)buildOperationExecutor.call((CallableBuildOperation)new ArtifactTransformationStepBuildOperation(){

                @Override
                protected Try<TransformationSubject> transform() {
                    return previousTransformationNode.getTransformedSubject().flatMap(transformedSubject -> transformationStep.transform((TransformationSubject)transformedSubject, dependenciesResolver));
                }

                @Override
                protected String describeSubject() {
                    return (String)previousTransformationNode.getTransformedSubject().map(subject -> subject.getDisplayName()).orElseMapFailure(failure -> failure.getMessage());
                }
            });
        }

        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
            this.addDependencySuccessor(this.previousTransformationNode);
            processHardSuccessor.execute((Object)this.previousTransformationNode);
            this.processDependencies(processHardSuccessor, dependencyResolver.resolveDependenciesFor(null, (Object)this.dependenciesResolver.computeDependencyNodes(this.transformationStep)));
        }
    }

    private static class InitialTransformationNode
    extends TransformationNode {
        private final ResolvableArtifact artifact;
        private final ExecutionGraphDependenciesResolver dependenciesResolver;

        public InitialTransformationNode(TransformationStep transformationStep, ResolvableArtifact artifact, ExecutionGraphDependenciesResolver dependenciesResolver) {
            super(transformationStep);
            this.artifact = artifact;
            this.dependenciesResolver = dependenciesResolver;
        }

        @Override
        public void execute(BuildOperationExecutor buildOperationExecutor, ArtifactTransformListener transformListener) {
            this.transformedSubject = (Try)buildOperationExecutor.call((CallableBuildOperation)new ArtifactTransformationStepBuildOperation(){

                @Override
                protected Try<TransformationSubject> transform() {
                    File file;
                    try {
                        file = artifact.getFile();
                    }
                    catch (ResolveException e) {
                        return Try.failure((Throwable)e);
                    }
                    catch (RuntimeException e) {
                        return Try.failure((Throwable)((Object)new DefaultLenientConfiguration.ArtifactResolveException("artifacts", transformationStep.getDisplayName(), "artifact transform", Collections.singleton(e))));
                    }
                    TransformationSubject initialArtifactTransformationSubject = TransformationSubject.initial(artifact.getId(), file);
                    return transformationStep.transform(initialArtifactTransformationSubject, dependenciesResolver);
                }

                @Override
                protected String describeSubject() {
                    return "artifact " + artifact.getId().getDisplayName();
                }
            });
        }

        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
            this.processDependencies(processHardSuccessor, dependencyResolver.resolveDependenciesFor(null, (Object)this.artifact));
            this.processDependencies(processHardSuccessor, dependencyResolver.resolveDependenciesFor(null, (Object)this.dependenciesResolver.computeDependencyNodes(this.transformationStep)));
        }
    }
}

