/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Map;
import javajs.util.BS;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.api.Interface;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.util.BSUtil;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class ShapeManager {
    private ModelSet ms;
    public Shape[] shapes;
    public Viewer vwr;
    private static final int[] hoverable = new int[]{31, 25, 24, 22, 36};
    private static int clickableMax = hoverable.length - 1;
    public final BS bsRenderableAtoms;
    public final BS bsSlabbedInternal;
    private final int[] navMinMax = new int[4];

    public ShapeManager(Viewer viewer) {
        this.vwr = viewer;
        this.bsRenderableAtoms = new BS();
        this.bsSlabbedInternal = new BS();
    }

    public void setParallel() {
        this.resetShapes();
        this.loadDefaultShapes(this.vwr.ms);
    }

    public void findNearestShapeAtomIndex(int n, int n2, Atom[] atomArray, BS bS) {
        if (this.shapes != null) {
            int n3 = 0;
            while (n3 < this.shapes.length && atomArray[0] == null) {
                if (this.shapes[n3] != null) {
                    this.shapes[n3].findNearestAtomIndex(n, n2, atomArray, bS);
                }
                ++n3;
            }
        }
    }

    public Object getShapePropertyIndex(int n, String string, int n2) {
        if (this.shapes == null || this.shapes[n] == null) {
            return null;
        }
        this.vwr.setShapeErrorState(n, "get " + string);
        Object object = this.shapes[n].getProperty(string, n2);
        this.vwr.setShapeErrorState(-1, null);
        return object;
    }

    public boolean getShapePropertyData(int n, String string, Object[] objectArray) {
        if (this.shapes == null || this.shapes[n] == null) {
            return false;
        }
        this.vwr.setShapeErrorState(n, "get " + string);
        boolean bl = this.shapes[n].getPropertyData(string, objectArray);
        this.vwr.setShapeErrorState(-1, null);
        return bl;
    }

    public int getShapeIdFromObjectName(String string) {
        if (this.shapes != null) {
            int n = 16;
            while (n < 30) {
                if (this.shapes[n] != null && this.shapes[n].getIndexFromName(string) >= 0) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public void loadDefaultShapes(ModelSet modelSet) {
        this.ms = modelSet;
        if (this.shapes != null) {
            int n = 0;
            while (n < this.shapes.length) {
                if (this.shapes[n] != null) {
                    this.shapes[n].setModelSet(modelSet);
                }
                ++n;
            }
        }
        this.loadShape(0);
        this.loadShape(1);
    }

    public Shape loadShape(int n) {
        if (this.shapes == null) {
            return null;
        }
        if (this.shapes[n] != null) {
            return this.shapes[n];
        }
        if (n == 2 || n == 3 || n == 4) {
            return null;
        }
        String string = JC.getShapeClassName(n, false);
        Shape shape = (Shape)Interface.getInterface(string, this.vwr, "shape");
        if (shape == null) {
            return null;
        }
        this.vwr.setShapeErrorState(n, "allocate");
        shape.initializeShape(this.vwr, this.ms, n);
        this.vwr.setShapeErrorState(-1, null);
        this.shapes[n] = shape;
        return this.shapes[n];
    }

    public void notifyAtomPositionsChanged(int n, BS bS, M4 m4) {
        Integer n2 = n;
        BS bS2 = this.vwr.getModelUndeletedAtomsBitSet(n);
        int n3 = 0;
        while (n3 < 37) {
            if (this.shapes[n3] != null) {
                this.setShapePropertyBs(n3, "refreshTrajectories", new Object[]{n2, bS, m4}, bS2);
            }
            ++n3;
        }
    }

    public void releaseShape(int n) {
        if (this.shapes != null) {
            this.shapes[n] = null;
        }
    }

    public void resetShapes() {
        this.shapes = new Shape[37];
    }

    public void setShapeSizeBs(int n, int n2, RadiusData radiusData, BS bS) {
        if (this.shapes == null) {
            return;
        }
        if (bS == null && (n != 1 || n2 != Integer.MAX_VALUE)) {
            bS = this.vwr.bsA();
        }
        if (radiusData != null && radiusData.value != 0.0f && radiusData.vdwType == VDW.TEMP) {
            this.ms.getBfactor100Lo();
        }
        this.vwr.setShapeErrorState(n, "set size");
        if (radiusData == null ? n2 != 0 : radiusData.value != 0.0f) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setShapeSizeRD(n2, radiusData, bS);
        }
        this.vwr.setShapeErrorState(-1, null);
    }

    public void setLabel(Object object, BS bS) {
        if (object == null) {
            if (this.shapes[5] == null) {
                return;
            }
        } else {
            this.loadShape(5);
            this.setShapeSizeBs(5, 0, null, bS);
        }
        this.setShapePropertyBs(5, "label", object, bS);
    }

    public void setShapePropertyBs(int n, String string, Object object, BS bS) {
        if (this.shapes == null || this.shapes[n] == null) {
            return;
        }
        if (bS == null) {
            bS = this.vwr.bsA();
        }
        this.vwr.setShapeErrorState(n, "set " + string);
        this.shapes[n].setProperty(string.intern(), object, bS);
        this.vwr.setShapeErrorState(-1, null);
    }

    boolean checkFrankclicked(int n, int n2) {
        Shape shape = this.shapes[36];
        return shape != null && shape.wasClicked(n, n2);
    }

    Map<String, Object> checkObjectClicked(int n, int n2, int n3, BS bS, boolean bl) {
        Map<String, Object> map = null;
        if (this.vwr.getPickingMode() == 2) {
            return this.shapes[5].checkObjectClicked(n, n2, n3, bS, false);
        }
        if (n3 != 0 && this.vwr.getBondPicking() && (map = this.shapes[1].checkObjectClicked(n, n2, n3, bS, false)) != null) {
            return map;
        }
        int n4 = 0;
        while (n4 < clickableMax) {
            Shape shape = this.shapes[hoverable[n4]];
            if (shape != null && (map = shape.checkObjectClicked(n, n2, n3, bS, bl)) != null) {
                return map;
            }
            ++n4;
        }
        return null;
    }

    boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BS bS, int n6) {
        boolean bl = false;
        int n7 = n6 > 0 ? n6 + 1 : 37;
        int n8 = n6;
        while (!bl && n8 < n7) {
            if (this.shapes[n8] != null) {
                bl = this.shapes[n8].checkObjectDragged(n, n2, n3, n4, n5, bS);
            }
            ++n8;
        }
        return bl;
    }

    boolean checkObjectHovered(int n, int n2, BS bS, boolean bl) {
        Shape shape = this.shapes[1];
        if (bl && shape != null && shape.checkObjectHovered(n, n2, bS)) {
            return true;
        }
        int n3 = 0;
        while (n3 < hoverable.length) {
            shape = this.shapes[hoverable[n3]];
            if (shape != null && shape.checkObjectHovered(n, n2, bS)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void deleteShapeAtoms(Object[] objectArray, BS bS) {
        if (this.shapes != null) {
            int n = 0;
            while (n < 37) {
                if (this.shapes[n] != null) {
                    this.setShapePropertyBs(n, "deleteModelAtoms", objectArray, bS);
                }
                ++n;
            }
        }
    }

    void deleteVdwDependentShapes(BS bS) {
        if (bS == null) {
            bS = this.vwr.bsA();
        }
        if (this.shapes[24] != null) {
            this.shapes[24].setProperty("deleteVdw", null, bS);
        }
        if (this.shapes[25] != null) {
            this.shapes[25].setProperty("deleteVdw", null, bS);
        }
    }

    public float getAtomShapeValue(int n, Group group, int n2) {
        int n3 = JC.shapeTokenIndex(n);
        if (n3 < 0 || this.shapes[n3] == null) {
            return 0.0f;
        }
        int n4 = this.shapes[n3].getSize(n2);
        if (n4 == 0) {
            if ((group.shapeVisibilityFlags & this.shapes[n3].vf) == 0) {
                return 0.0f;
            }
            n4 = this.shapes[n3].getSizeG(group);
        }
        return (float)n4 / 2000.0f;
    }

    public void replaceGroup(Group group, Group group2) {
        if (this.shapes == null) {
            return;
        }
        int n = 9;
        while (n < 16) {
            if (this.shapes[n] != null) {
                this.shapes[n].replaceGroup(group, group2);
            }
            ++n;
        }
    }

    void getObjectMap(Map<String, ?> map, boolean bl) {
        if (this.shapes == null) {
            return;
        }
        Boolean bl2 = bl;
        int n = 16;
        while (n < 30) {
            this.getShapePropertyData(n, "getNames", new Object[]{map, bl2});
            ++n;
        }
    }

    Object getProperty(Object object) {
        if (object.equals("getShapes")) {
            return this.shapes;
        }
        return null;
    }

    public Shape getShape(int n) {
        return this.shapes == null ? null : this.shapes[n];
    }

    public void resetBioshapes(BS bS) {
        if (this.shapes == null) {
            return;
        }
        int n = 0;
        while (n < this.shapes.length) {
            if (this.shapes[n] != null && this.shapes[n].isBioShape) {
                this.shapes[n].setModelSet(this.ms);
                this.shapes[n].setShapeSizeRD(0, null, bS);
                this.shapes[n].setProperty("color", (Object)PAL.NONE, bS);
            }
            ++n;
        }
    }

    public void setAtomLabel(String string, int n) {
        if (this.shapes != null) {
            this.shapes[5].setProperty("label:" + string, n, null);
        }
    }

    void setModelVisibility() {
        Shape[] shapeArray = this.shapes;
        if (shapeArray == null || shapeArray[0] == null) {
            return;
        }
        BS bS = this.vwr.getVisibleFramesBitSet();
        int n = 8;
        while (n < 33) {
            if (shapeArray[n] != null) {
                shapeArray[n].setModelVisibilityFlags(bS);
            }
            ++n;
        }
        n = this.vwr.getBoolean(603979922) ? 1 : 0;
        BS bS2 = this.vwr.slm.bsDeleted;
        Atom[] atomArray = this.ms.at;
        this.ms.clearVisibleSets();
        if (atomArray.length > 0) {
            int n2 = this.ms.ac;
            while (--n2 >= 0) {
                Atom atom = atomArray[n2];
                atom.shapeVisibilityFlags &= 0xFFFFFFC0;
                if (bS2 != null && bS2.get(n2) || !bS.get(atom.mi)) continue;
                int n3 = 1;
                if (this.ms.isAtomHidden(n2) || n == 0 && atom.getElementNumber() == 1) continue;
                n3 |= 8;
                if (atom.madAtom != 0) {
                    n3 |= 0x10;
                }
                atom.setShapeVisibility(n3, true);
            }
        }
        this.setShapeVis();
    }

    private void setShapeVis() {
        int n = 0;
        while (n < 37) {
            Shape shape = this.shapes[n];
            if (shape != null) {
                shape.setAtomClickability();
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int[] finalizeAtoms(BS var1_1, boolean var2_2) {
        block22: {
            block23: {
                var3_3 = this.vwr;
                var4_4 = var3_3.tm;
                if (var2_2) {
                    var3_3.finalizeTransformParameters();
                }
                if (var1_1 != null) {
                    var5_5 = this.ms.getAtomSetCenter(var1_1);
                    var6_6 = new P3();
                    var4_4.transformPt3f((T3)var5_5, (P3)var6_6);
                    var6_6.add(var4_4.ptOffset);
                    var4_4.unTransformPoint((T3)var6_6, (T3)var6_6);
                    var6_6.sub((T3)var5_5);
                    var3_3.setAtomCoordsRelative((T3)var6_6, var1_1);
                    var4_4.ptOffset.set(0.0f, 0.0f, 0.0f);
                    var4_4.bsSelectedAtoms = null;
                }
                var5_5 = this.bsRenderableAtoms;
                this.ms.getAtomsInFrame((BS)var5_5);
                var6_6 = this.ms.vibrations;
                var7_7 = var6_6 != null && var4_4.vibrationOn != false;
                var8_8 = this.ms.bsModulated != null && this.ms.occupancies != null;
                var9_9 = this.ms.at;
                var11_10 = false;
                var12_11 = this.bsSlabbedInternal;
                var12_11.clearAll();
                var13_12 = var5_5.nextSetBit(0);
                while (var13_12 >= 0) {
                    var14_15 = var9_9[var13_12];
                    v0 = var15_18 = var7_7 != false && var14_15.hasVibration() != false ? var4_4.transformPtVib(var14_15, var6_6[var13_12]) : var4_4.transformPt(var14_15);
                    if (var15_18.z == 1 && var4_4.internalSlab && var4_4.xyzIsSlabbedInternal(var14_15)) {
                        var12_11.set(var13_12);
                    }
                    var14_15.sX = var15_18.x;
                    var14_15.sY = var15_18.y;
                    var14_15.sZ = var15_18.z;
                    var16_21 = Math.abs(var14_15.madAtom);
                    if (var16_21 == Atom.MAD_GLOBAL) {
                        var16_21 = (int)(var3_3.getFloat(0x44000001) * 2000.0f);
                    }
                    var14_15.sD = (short)var3_3.tm.scaleToScreen(var15_18.z, var16_21);
                    if (var8_8 && var6_6[var13_12] != null && (var10_14 = var6_6[var13_12].getOccupancy100(var7_7)) != -2147483648) {
                        var11_10 = true;
                        var14_15.setShapeVisibility(2, false);
                        if (var10_14 >= 0 && var10_14 < 50) {
                            var14_15.setShapeVisibility(24, false);
                        } else {
                            var14_15.setShapeVisibility(8 | (var14_15.madAtom > 0 ? 16 : 0), true);
                        }
                        this.ms.occupancies[var14_15.i] = Math.abs(var10_14);
                    }
                    var13_12 = var5_5.nextSetBit(var13_12 + 1);
                }
                if (var11_10) {
                    this.setShapeVis();
                }
                var13_13 = var3_3.gdata;
                if (!var4_4.slabEnabled) break block22;
                var14_16 = var3_3.getBoolean(603979940);
                var15_19 = var3_3.getBoolean(603979939);
                var16_21 = var13_13.slab;
                var17_22 = var13_13.depth;
                if (!var14_16) break block23;
                var18_23 = this.ms.getMolecules();
                var19_25 = this.ms.getMoleculeCountInModel(-1);
                var20_28 = 0;
                while (var20_28 < var19_25) {
                    block24: {
                        var21_29 = var18_23[var20_28];
                        var22_30 = 0;
                        var23_31 = var21_29.firstAtomIndex;
                        if (var5_5.get(var23_31)) ** GOTO lbl68
                        break block24;
                        while (!var13_13.isClippedZ(var9_9[var23_31].sZ - (var9_9[var23_31].sD >> 1))) {
                            ++var22_30;
                            ++var23_31;
lbl68:
                            // 2 sources

                            if (var22_30 < var21_29.ac) continue;
                        }
                        if (var22_30 != var21_29.ac) {
                            var23_31 = var21_29.firstAtomIndex;
                            var24_32 = 0;
                            while (var24_32 < var21_29.ac) {
                                var5_5.clear(var23_31);
                                var9_9[var23_31++].sZ = 0;
                                ++var24_32;
                            }
                        }
                    }
                    ++var20_28;
                }
            }
            var18_24 = var5_5.nextSetBit(0);
            while (var18_24 >= 0) {
                var19_26 = var9_9[var18_24];
                if (var13_13.isClippedZ(var19_26.sZ - (var15_19 != false ? var9_9[var18_24].sD >> 1 : 0))) {
                    var19_26.setClickable(0);
                    var20_28 = (var15_19 != false ? -1 : 1) * var19_26.sD / 2;
                    if (var19_26.sZ + var20_28 < var16_21 || var19_26.sZ - var20_28 > var17_22 || !var13_13.isInDisplayRange(var19_26.sX, var19_26.sY)) {
                        var5_5.clear(var18_24);
                    }
                }
                var18_24 = var5_5.nextSetBit(var18_24 + 1);
            }
        }
        if (this.ms.ac == 0 || !var3_3.getShowNavigationPoint()) {
            return null;
        }
        var14_17 = 0x7FFFFFFF;
        var15_20 = -2147483648;
        var16_21 = 0x7FFFFFFF;
        var17_22 = -2147483648;
        var18_24 = var5_5.nextSetBit(0);
        while (var18_24 >= 0) {
            var19_27 = var9_9[var18_24];
            if (var19_27.sX < var14_17) {
                var14_17 = var19_27.sX;
            }
            if (var19_27.sX > var15_20) {
                var15_20 = var19_27.sX;
            }
            if (var19_27.sY < var16_21) {
                var16_21 = var19_27.sY;
            }
            if (var19_27.sY > var17_22) {
                var17_22 = var19_27.sY;
            }
            var18_24 = var5_5.nextSetBit(var18_24 + 1);
        }
        this.navMinMax[0] = var14_17;
        this.navMinMax[1] = var15_20;
        this.navMinMax[2] = var16_21;
        this.navMinMax[3] = var17_22;
        return this.navMinMax;
    }

    public void setModelSet(ModelSet modelSet) {
        this.ms = this.vwr.ms = modelSet;
    }

    public void checkInheritedShapes() {
        if (this.shapes[24] == null) {
            return;
        }
        this.setShapePropertyBs(24, "remapInherited", null, null);
    }

    public void restrictSelected(boolean bl, boolean bl2) {
        BS bS = this.vwr.slm.getSelectedAtomsNoSubset();
        if (bl2) {
            this.vwr.slm.invertSelection();
            BS bS2 = this.vwr.slm.bsSubset;
            if (bS2 != null) {
                bS = this.vwr.slm.getSelectedAtomsNoSubset();
                bS.and(bS2);
                this.vwr.select(bS, false, 0, true);
                BSUtil.invertInPlace(bS, this.vwr.ms.ac);
                bS.and(bS2);
            }
        }
        BSUtil.andNot(bS, this.vwr.slm.bsDeleted);
        boolean bl3 = this.vwr.getBoolean(0x24000024);
        if (!bl) {
            this.vwr.setBooleanProperty("bondModeOr", true);
        }
        this.setShapeSizeBs(1, 0, null, null);
        this.setShapePropertyBs(1, "type", 32768, null);
        this.setShapeSizeBs(1, 0, null, null);
        this.setShapePropertyBs(1, "type", 1023, null);
        BS bS3 = this.vwr.bsA();
        int n = 21;
        while (--n >= 0) {
            if (n == 6 || this.getShape(n) == null) continue;
            this.setShapeSizeBs(n, 0, null, bS3);
        }
        if (this.getShape(21) != null) {
            this.setShapePropertyBs(21, "off", bS3, null);
        }
        this.setLabel(null, bS3);
        if (!bl) {
            this.vwr.setBooleanProperty("bondModeOr", bl3);
        }
        this.vwr.select(bS, false, 0, true);
    }
}

