/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;

public class Block
extends Statement {
    public Statement[] statements;
    public int explicitDeclarations;
    public BlockScope scope;

    public Block(int n) {
        this.explicitDeclarations = n;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        LocalVariableBinding[] localVariableBindingArray;
        if (this.statements == null) {
            return flowInfo;
        }
        int n = (flowInfo.reachMode() & 3) != 0 ? 1 : 0;
        boolean bl = blockScope.compilerOptions().enableSyntacticNullAnalysisForFields;
        for (Statement statement : this.statements) {
            if ((n = statement.complainIfUnreachable(flowInfo, this.scope, n, true)) < 2) {
                flowInfo = statement.analyseCode(this.scope, flowContext, flowInfo);
            }
            flowContext.mergeFinallyNullInfo(flowInfo);
            if (!bl) continue;
            flowContext.expireNullCheckedFieldInfo();
        }
        if (this.scope != blockScope) {
            this.scope.checkUnclosedCloseables(flowInfo, flowContext, null, null);
        }
        if (this.explicitDeclarations > 0 && (localVariableBindingArray = this.scope.locals) != null) {
            int n2 = this.scope.localIndex;
            for (int i = 0; i < n2; ++i) {
                flowInfo.resetAssignmentInfo(localVariableBindingArray[i]);
            }
        }
        return flowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        if (this.statements != null) {
            int n2 = this.statements.length;
            for (int i = 0; i < n2; ++i) {
                this.statements[i].generateCode(this.scope, codeStream);
            }
        }
        if (this.scope != blockScope) {
            codeStream.exitUserScope(this.scope);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public boolean isEmptyBlock() {
        return this.statements == null;
    }

    public StringBuffer printBody(int n, StringBuffer stringBuffer) {
        if (this.statements == null) {
            return stringBuffer;
        }
        for (int i = 0; i < this.statements.length; ++i) {
            this.statements[i].printStatement(n + 1, stringBuffer);
            stringBuffer.append('\n');
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        Block.printIndent(n, stringBuffer);
        stringBuffer.append("{\n");
        this.printBody(n, stringBuffer);
        return Block.printIndent(n, stringBuffer).append('}');
    }

    @Override
    public void resolve(BlockScope blockScope) {
        if ((this.bits & 8) != 0) {
            blockScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        if (this.statements != null) {
            this.scope = this.explicitDeclarations == 0 ? blockScope : new BlockScope(blockScope, this.explicitDeclarations);
            int n = this.statements.length;
            for (int i = 0; i < n; ++i) {
                this.statements[i].resolve(this.scope);
            }
        }
    }

    public void resolveUsing(BlockScope blockScope) {
        if ((this.bits & 8) != 0) {
            blockScope.problemReporter().undocumentedEmptyBlock(this.sourceStart, this.sourceEnd);
        }
        this.scope = blockScope;
        if (this.statements != null) {
            int n = this.statements.length;
            for (int i = 0; i < n; ++i) {
                this.statements[i].resolve(this.scope);
            }
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.statements != null) {
            int n = this.statements.length;
            for (int i = 0; i < n; ++i) {
                this.statements[i].traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void branchChainTo(BranchLabel branchLabel) {
        if (this.statements != null) {
            this.statements[this.statements.length - 1].branchChainTo(branchLabel);
        }
    }

    @Override
    public boolean doesNotCompleteNormally() {
        int n = this.statements == null ? 0 : this.statements.length;
        return n > 0 && this.statements[n - 1].doesNotCompleteNormally();
    }

    @Override
    public boolean completesByContinue() {
        int n = this.statements == null ? 0 : this.statements.length;
        return n > 0 && this.statements[n - 1].completesByContinue();
    }
}

