'''OpenGL extension EXT.compiled_vertex_array

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.compiled_vertex_array to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines an interface which allows static vertex array
	data to be cached or pre-compiled for more efficient rendering.  This
	is useful for implementations which can cache the transformed results
	of array data for reuse by several DrawArrays, ArrayElement, or
	DrawElements commands.  It is also useful for implementations which
	can transfer array data to fast memory for more efficient processing.
	
	For example, rendering an M by N mesh of quadrilaterals can be
	accomplished by setting up vertex arrays containing all of the
	vertexes in the mesh and issuing M DrawElements commands each of
	which operate on 2 * N vertexes.  Each DrawElements command after
	the first will share N vertexes with the preceding DrawElements
	command.  If the vertex array data is locked while the DrawElements
	commands are executed, then OpenGL may be able to transform each
	of these shared vertexes just once.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/compiled_vertex_array.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.EXT.compiled_vertex_array import *
from OpenGL.raw.GL.EXT.compiled_vertex_array import _EXTENSION_NAME

def glInitCompiledVertexArrayEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION