/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.reftable;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.SymbolicRef;

public abstract class Reftable
implements AutoCloseable {
    protected boolean includeDeletes;

    public static Reftable from(Collection<Ref> refs) {
        try {
            ReftableConfig cfg = new ReftableConfig();
            cfg.setIndexObjects(false);
            cfg.setAlignBlocks(false);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            new ReftableWriter().setConfig(cfg).begin(buf).sortAndWriteRefs(refs).finish();
            return new ReftableReader(BlockSource.from(buf.toByteArray()));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void setIncludeDeletes(boolean deletes) {
        this.includeDeletes = deletes;
    }

    public abstract RefCursor allRefs() throws IOException;

    public abstract RefCursor seekRef(String var1) throws IOException;

    public abstract RefCursor byObjectId(AnyObjectId var1) throws IOException;

    public abstract LogCursor allLogs() throws IOException;

    public LogCursor seekLog(String refName) throws IOException {
        return this.seekLog(refName, Long.MAX_VALUE);
    }

    public abstract LogCursor seekLog(String var1, long var2) throws IOException;

    @Nullable
    public Ref exactRef(String refName) throws IOException {
        try (RefCursor rc = this.seekRef(refName);){
            Ref ref2 = rc.next() ? rc.getRef() : null;
            return ref2;
        }
    }

    public boolean hasRef(String refName) throws IOException {
        try (RefCursor rc = this.seekRef(refName);){
            boolean bl = rc.next();
            return bl;
        }
    }

    public boolean hasId(AnyObjectId id) throws IOException {
        try (RefCursor rc = this.byObjectId(id);){
            boolean bl = rc.next();
            return bl;
        }
    }

    @Nullable
    public Ref resolve(Ref symref) throws IOException {
        return this.resolve(symref, 0);
    }

    private Ref resolve(Ref ref2, int depth) throws IOException {
        if (!ref2.isSymbolic()) {
            return ref2;
        }
        Ref dst = ref2.getTarget();
        if (5 <= depth) {
            return null;
        }
        if ((dst = this.exactRef(dst.getName())) == null) {
            return ref2;
        }
        if ((dst = this.resolve(dst, depth + 1)) == null) {
            return null;
        }
        return new SymbolicRef(ref2.getName(), dst);
    }

    @Override
    public abstract void close() throws IOException;
}

