/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.intervals.CachingMatchesIterator;
import org.apache.lucene.search.intervals.ConjunctionIntervalsSource;
import org.apache.lucene.search.intervals.IntervalFunction;
import org.apache.lucene.search.intervals.IntervalIterator;
import org.apache.lucene.search.intervals.IntervalMatches;
import org.apache.lucene.search.intervals.IntervalMatchesIterator;
import org.apache.lucene.search.intervals.IntervalsSource;

class MinimizingConjunctionIntervalsSource
extends ConjunctionIntervalsSource {
    MinimizingConjunctionIntervalsSource(List<IntervalsSource> subSources, IntervalFunction function) {
        super(subSources, function);
    }

    @Override
    public MatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        ArrayList<CachingMatchesIterator> subs = new ArrayList<CachingMatchesIterator>();
        for (IntervalsSource source : this.subSources) {
            MatchesIterator mi = source.matches(field, ctx, doc);
            if (mi == null) {
                return null;
            }
            subs.add(new CachingMatchesIterator(mi));
        }
        IntervalIterator it = this.function.apply(subs.stream().map(m -> IntervalMatches.wrapMatches((MatchesIterator)m, doc)).collect(Collectors.toList()));
        if (it.advance(doc) != doc) {
            return null;
        }
        if (it.nextInterval() == Integer.MAX_VALUE) {
            return null;
        }
        return new ConjunctionMatchesIterator(it, subs);
    }

    private static class ConjunctionMatchesIterator
    implements IntervalMatchesIterator {
        final IntervalIterator iterator;
        final List<CachingMatchesIterator> subs;
        boolean cached = true;

        private ConjunctionMatchesIterator(IntervalIterator iterator, List<CachingMatchesIterator> subs) {
            this.iterator = iterator;
            this.subs = subs;
        }

        public boolean next() throws IOException {
            if (this.cached) {
                this.cached = false;
                return true;
            }
            return this.iterator.nextInterval() != Integer.MAX_VALUE;
        }

        public int startPosition() {
            return this.iterator.start();
        }

        public int endPosition() {
            return this.iterator.end();
        }

        public int startOffset() throws IOException {
            int start = Integer.MAX_VALUE;
            int endPos = this.endPosition();
            for (CachingMatchesIterator s : this.subs) {
                start = Math.min(start, s.startOffset(endPos));
            }
            return start;
        }

        public int endOffset() throws IOException {
            int end = 0;
            int endPos = this.endPosition();
            for (CachingMatchesIterator s : this.subs) {
                end = Math.max(end, s.endOffset(endPos));
            }
            return end;
        }

        @Override
        public int gaps() {
            return this.iterator.gaps();
        }

        public MatchesIterator getSubMatches() throws IOException {
            ArrayList<MatchesIterator> mis = new ArrayList<MatchesIterator>();
            int endPos = this.endPosition();
            for (CachingMatchesIterator s : this.subs) {
                mis.add(s.getSubMatches(endPos));
            }
            return MatchesUtils.disjunction(mis);
        }

        public Query getQuery() {
            return null;
        }
    }
}

