/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import java.util.Arrays;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.TimestampMap;

public final class TimestampBooleanMap
extends TimestampMap<Boolean> {
    private boolean[] values;

    public TimestampBooleanMap() {
        this.values = new boolean[0];
    }

    public TimestampBooleanMap(int capacity) {
        super(capacity);
        this.values = new boolean[capacity];
    }

    public TimestampBooleanMap(double[] keys, boolean[] vals) {
        super(keys);
        this.values = new boolean[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public boolean getBoolean(double timestamp) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public boolean getBoolean(double timestamp, boolean defaultValue) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    protected Object getMin(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        double lowBound = interval.getLow();
        double highBound = interval.getHigh();
        int index = Arrays.binarySearch(this.array, lowBound);
        if (index < 0) {
            index = -index - 1;
        }
        boolean t = false;
        for (int i = index; i < this.size && this.array[i] <= highBound; ++i) {
            boolean val = this.values[i];
            if (!val) {
                return Boolean.FALSE;
            }
            t = true;
        }
        if (t) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    protected Object getMax(Interval interval) {
        if (this.size == 0) {
            return null;
        }
        double lowBound = interval.getLow();
        double highBound = interval.getHigh();
        int index = Arrays.binarySearch(this.array, lowBound);
        if (index < 0) {
            index = -index - 1;
        }
        boolean f = false;
        for (int i = index; i < this.size && this.array[i] <= highBound; ++i) {
            boolean val = this.values[i];
            if (val) {
                return Boolean.TRUE;
            }
            f = true;
        }
        if (f) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Class<Boolean> getTypeClass() {
        return Boolean.class;
    }

    public boolean[] toBooleanArray() {
        return (boolean[])this.toPrimitiveArray();
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST);
    }

    @Override
    protected Boolean getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (boolean[])array;
    }
}

