/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import javajs.J2SRequireImport;
import javajs.api.GenericColor;
import javajs.awt.Font;
import javajs.util.BS;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.PT;
import jspecview.api.AnnotationData;
import jspecview.api.JSVPanel;
import jspecview.api.VisibleInterface;
import jspecview.common.Annotation;
import jspecview.common.ColorParameters;
import jspecview.common.ColoredAnnotation;
import jspecview.common.Coordinate;
import jspecview.common.ImageView;
import jspecview.common.Integral;
import jspecview.common.IntegralData;
import jspecview.common.Measurement;
import jspecview.common.MeasurementData;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.PeakData;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PlotWidget;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.common.ViewData;
import jspecview.common.XYScaleConverter;
import jspecview.dialog.JSVDialog;
import org.jmol.api.GenericGraphics;
import org.jmol.util.Logger;

@J2SRequireImport(value={JSVDialog.class})
class GraphSet
implements XYScaleConverter {
    private static final int ARROW_RESET = -1;
    private static final int ARROW_HOME = 0;
    private static final int ARROW_LEFT = 1;
    private static final int ARROW_RIGHT = 2;
    private static final int ARROW_UP = 3;
    private static final int ARROW_DOWN = 4;
    private GraphSet gs2dLinkedX;
    private GraphSet gs2dLinkedY;
    private boolean cur1D2Locked;
    private Lst<Highlight> highlights = new Lst();
    Lst<Spectrum> spectra = new Lst();
    private boolean isSplittable = true;
    private boolean allowStacking = true;
    private Lst<Annotation> annotations;
    private MeasurementData selectedSpectrumMeasurements;
    private MeasurementData selectedSpectrumIntegrals;
    private Annotation lastAnnotation;
    Measurement pendingMeasurement;
    private Integral pendingIntegral;
    private Lst<Spectrum> graphsTemp = new Lst();
    private PlotWidget[] widgets;
    private boolean isLinked;
    private boolean haveSingleYScale;
    static final double RT2 = Math.sqrt(2.0);
    private static GenericColor veryLightGrey;
    private int iSpectrumMovedTo;
    private int iSpectrumClicked;
    private int iSpectrumSelected = -1;
    private boolean stackSelected = false;
    private BS bsSelected = new BS();
    ViewData viewData;
    boolean reversePlot;
    int nSplit = 1;
    int yStackOffsetPercent = 0;
    boolean showAllStacked = true;
    Lst<ViewData> viewList;
    ImageView imageView;
    private PanelData pd;
    private boolean sticky2Dcursor;
    int nSpectra;
    private double fracX = 1.0;
    private double fracY = 1.0;
    private double fX0 = 0.0;
    private double fY0 = 0.0;
    private PlotWidget zoomBox1D;
    private PlotWidget zoomBox2D;
    private PlotWidget pin1Dx0;
    private PlotWidget pin1Dx1;
    private PlotWidget pin1Dy0;
    private PlotWidget pin1Dy1;
    private PlotWidget pin1Dx01;
    private PlotWidget pin1Dy01;
    private PlotWidget pin2Dx0;
    private PlotWidget pin2Dx1;
    private PlotWidget pin2Dy0;
    private PlotWidget pin2Dy1;
    private PlotWidget pin2Dx01;
    private PlotWidget pin2Dy01;
    private PlotWidget cur2Dx0;
    private PlotWidget cur2Dx1;
    private PlotWidget cur1D2x1;
    private PlotWidget cur1D2x2;
    private PlotWidget cur2Dy;
    private int xPixel0;
    private int yPixel0;
    private int xPixel1;
    private int yPixel1;
    private int xVArrows;
    private int xHArrows;
    private int yHArrows;
    private int xPixel00;
    private int yPixel00;
    private int xPixel11;
    private int yPixel11;
    private int yPixel000;
    private int xPixels;
    private int yPixels;
    private int xPixel10;
    private int xPixels0;
    private boolean allowStackedYScale = true;
    private boolean drawXAxisLeftToRight;
    private boolean xAxisLeftToRight = true;
    private int iPreviousSpectrumClicked = -1;
    private boolean haveSelectedSpectrum;
    private boolean zoomEnabled;
    private int currentZoomIndex;
    private double lastClickX = Double.NaN;
    private int lastPixelX = Integer.MAX_VALUE;
    private int height;
    private int width;
    private int right;
    private int top;
    private int left;
    private int bottom;
    private PeakInfo piMouseOver;
    private final Coordinate coordTemp = new Coordinate();
    private static final int minNumOfPointsForZoom = 3;
    private final int FONT_PLAIN = 0;
    private final int FONT_BOLD = 1;
    private final int FONT_ITALIC = 2;
    private boolean is2DSpectrum;
    private Measurement selectedMeasurement;
    private Integral selectedIntegral;
    private double lastXMax = Double.NaN;
    private int lastSpecClicked = -1;
    private static final int MIN_DRAG_PIXELS = 5;
    private boolean inPlotMove;
    private int xPixelMovedTo = -1;
    private int xPixelMovedTo2 = -1;
    private double yValueMovedTo;
    private double xValueMovedTo;
    private boolean haveLeftRightArrows;
    private int xPixelPlot1;
    private int xPixelPlot0;
    private int yPixelPlot0;
    private int yPixelPlot1;
    private Double nextClickForSetPeak;
    private int closerX;
    private int closerY;
    private int splitterX;
    private int splitterY;
    Map<Double, String> mapX = new Hashtable<Double, String>();
    private static final int ONLINE_CUTOFF = 2;
    private boolean triggered = true;
    private int lastIntDragX;
    private int nextClickMode;
    static final int SHIFT_PEAK = 1;
    static final int SHIFT_SETX = 2;
    static final int SHIFT_X = 3;
    static final int SHIFT_CLICKED = 4;
    private Map<String, AnnotationData> dialogs;
    private Object[] aIntegrationRatios;
    private JSVPanel jsvp;
    private Object image2D;
    private GenericColor[] plotColors;
    private GenericGraphics g2d;
    private Object gMain;
    private final int COLOR_GREY = -3;
    private final int COLOR_BLACK = -2;
    private final int COLOR_INTEGRAL = -1;

    GraphSet(PanelData pd) {
        this.pd = pd;
        this.jsvp = pd.jsvp;
        this.g2d = pd.g2d;
    }

    private int setSpectrumMovedTo(int i) {
        this.iSpectrumMovedTo = i;
        return this.iSpectrumMovedTo;
    }

    private void setSpectrumClicked(int i) {
        this.stackSelected = this.showAllStacked;
        if (i < 0 || this.iSpectrumClicked != i) {
            this.lastClickX = Double.NaN;
            this.lastPixelX = Integer.MAX_VALUE;
        }
        this.iSpectrumClicked = this.setSpectrumSelected(this.setSpectrumMovedTo(i));
    }

    private int setSpectrumSelected(int i) {
        boolean isNew = i != this.iSpectrumSelected;
        this.iSpectrumSelected = i;
        if (isNew) {
            this.getCurrentView();
        }
        return this.iSpectrumSelected;
    }

    void closeDialogsExcept(Annotation.AType type) {
        if (this.dialogs != null) {
            for (Map.Entry<String, AnnotationData> e : this.dialogs.entrySet()) {
                AnnotationData ad = e.getValue();
                if (!(ad instanceof JSVDialog) || type != Annotation.AType.NONE && ad.getAType() == type) continue;
                ((JSVDialog)ad).setVisible(false);
            }
        }
    }

    void dispose() {
        this.spectra = null;
        this.viewData = null;
        this.viewList = null;
        this.annotations = null;
        this.lastAnnotation = null;
        this.pendingMeasurement = null;
        this.imageView = null;
        this.graphsTemp = null;
        this.widgets = null;
        this.disposeImage();
        if (this.dialogs != null) {
            for (Map.Entry<String, AnnotationData> e : this.dialogs.entrySet()) {
                AnnotationData ad = e.getValue();
                if (!(ad instanceof JSVDialog)) continue;
                ((JSVDialog)ad).dispose();
            }
        }
        this.dialogs = null;
    }

    private boolean isDrawNoSpectra() {
        return this.iSpectrumSelected == Integer.MIN_VALUE;
    }

    private int getFixedSelectedSpectrumIndex() {
        return Math.max(this.iSpectrumSelected, 0);
    }

    Spectrum getSpectrum() {
        return this.getSpectrumAt(this.getFixedSelectedSpectrumIndex()).getCurrentSubSpectrum();
    }

    Spectrum getSpectrumAt(int index) {
        return (Spectrum)this.spectra.get(index);
    }

    int getSpectrumIndex(Spectrum spec) {
        int i = this.spectra.size();
        while (--i >= 0) {
            if (this.spectra.get(i) != spec) continue;
            return i;
        }
        return -1;
    }

    private void addSpec(Spectrum spec) {
        this.spectra.addLast(spec);
        ++this.nSpectra;
    }

    void splitStack(boolean doSplit) {
        if (doSplit && this.isSplittable) {
            this.nSplit = this.nSpectra;
            this.showAllStacked = false;
            this.setSpectrumClicked(this.iSpectrumSelected);
            this.pd.currentSplitPoint = this.iSpectrumSelected;
        } else {
            this.nSplit = 1;
            this.showAllStacked = this.allowStacking && !doSplit;
            this.setSpectrumClicked(this.iSpectrumSelected);
        }
        this.stackSelected = false;
        GraphSet.setFractionalPositions(this.pd, this.pd.graphSets, PanelData.LinkMode.NONE);
        this.pd.setTaintedAll();
    }

    private void setPositionForFrame(int iSplit) {
        if (iSplit < 0) {
            iSplit = 0;
        }
        int marginalHeight = this.height - 50;
        this.xPixel00 = (int)((double)this.width * this.fX0);
        this.xPixel11 = (int)((double)this.xPixel00 + (double)this.width * this.fracX - 1.0);
        this.xHArrows = this.xPixel00 + 25;
        this.xVArrows = this.xPixel11 - this.right / 2;
        this.xPixel0 = this.xPixel00 + (int)((double)this.left * (1.0 - this.fX0));
        this.xPixel10 = this.xPixel1 = this.xPixel11 - this.right;
        this.xPixels0 = this.xPixels = this.xPixel1 - this.xPixel0 + 1;
        this.yPixel000 = (this.fY0 == 0.0 ? 25 : 0) + (int)((double)this.height * this.fY0);
        this.yPixel00 = this.yPixel000 + (int)((double)marginalHeight * this.fracY * (double)iSplit);
        this.yPixel11 = this.yPixel00 + (int)((double)marginalHeight * this.fracY) - 1;
        this.yHArrows = this.yPixel11 - 12;
        this.yPixel0 = this.yPixel00 + this.top / 2;
        this.yPixel1 = this.yPixel11 - this.bottom / 2;
        this.yPixels = this.yPixel1 - this.yPixel0 + 1;
        if (this.imageView != null && this.is2DSpectrum) {
            this.setImageWindow();
            if (this.pd.display1D) {
                double widthRatio = this.pd.display1D ? 1.0 * (double)(this.xPixels0 - this.imageView.xPixels) / (double)this.xPixels0 : 1.0;
                this.xPixels = (int)Math.floor(widthRatio * (double)this.xPixels0 * 0.8);
                this.xPixel1 = this.xPixel0 + this.xPixels - 1;
            } else {
                this.xPixels = 0;
                this.xPixel1 = this.imageView.xPixel0 - 30;
            }
        }
    }

    private boolean hasPoint(int xPixel, int yPixel) {
        return xPixel >= this.xPixel00 && xPixel <= this.xPixel11 && yPixel >= this.yPixel000 && yPixel <= this.yPixel11 * this.nSplit;
    }

    private boolean isInPlotRegion(int xPixel, int yPixel) {
        return xPixel >= this.xPixel0 && xPixel <= this.xPixel1 && yPixel >= this.yPixel0 && yPixel <= this.yPixel1;
    }

    int getSplitPoint(int yPixel) {
        return Math.max(0, Math.min((yPixel - this.yPixel000) / (this.yPixel11 - this.yPixel00), this.nSplit - 1));
    }

    private boolean isSplitWidget(int xPixel, int yPixel) {
        return this.isFrameBox(xPixel, yPixel, this.splitterX, this.splitterY);
    }

    private boolean isCloserWidget(int xPixel, int yPixel) {
        return this.isFrameBox(xPixel, yPixel, this.closerX, this.closerY);
    }

    private void initGraphSet(int startIndex, int endIndex) {
        if (veryLightGrey == null) {
            veryLightGrey = this.g2d.getColor3(200, 200, 200);
        }
        this.setPlotColors(ColorParameters.defaultPlotColors);
        this.xAxisLeftToRight = this.getSpectrumAt(0).shouldDisplayXAxisIncreasing();
        this.setDrawXAxis();
        int[] startIndices = new int[this.nSpectra];
        int[] endIndices = new int[this.nSpectra];
        this.bsSelected.setBits(0, this.nSpectra);
        this.allowStackedYScale = true;
        if (endIndex <= 0) {
            endIndex = Integer.MAX_VALUE;
        }
        this.isSplittable = this.nSpectra > 1;
        this.allowStacking = ((Spectrum)this.spectra.get(0)).isStackable();
        this.showAllStacked = this.allowStacking && this.nSpectra > 1;
        for (int i = 0; i < this.nSpectra; ++i) {
            int iLast = ((Spectrum)this.spectra.get(i)).getXYCoords().length - 1;
            startIndices[i] = Coordinate.intoRange(startIndex, 0, iLast);
            endIndices[i] = Coordinate.intoRange(endIndex, 0, iLast);
            this.allowStackedYScale &= ((Spectrum)this.spectra.get(i)).getYUnits().equals(((Spectrum)this.spectra.get(0)).getYUnits()) && ((Spectrum)this.spectra.get(i)).getUserYFactor() == ((Spectrum)this.spectra.get(0)).getUserYFactor();
        }
        this.getView(0.0, 0.0, 0.0, 0.0, startIndices, endIndices, null, null);
        this.viewList = new Lst();
        this.viewList.addLast(this.viewData);
    }

    private synchronized void getView(double x1, double x2, double y1, double y2, int[] startIndices, int[] endIndices, ScaleData[] viewScales, ScaleData[] yScales) {
        Lst<Spectrum> graphs = this.graphsTemp.size() == 0 ? this.spectra : this.graphsTemp;
        Lst<Spectrum> subspecs = this.getSpectrumAt(0).getSubSpectra();
        boolean dontUseSubspecs = subspecs == null || subspecs.size() == 2 && ((Spectrum)subspecs.get(1)).isImaginary();
        boolean is2D = !this.getSpectrumAt(0).is1D();
        boolean useFirstSubSpecOnly = false;
        if (is2D && useFirstSubSpecOnly || dontUseSubspecs && y1 == y2) {
            graphs = this.spectra;
        } else if (y1 == y2) {
            this.viewData = new ViewData(subspecs, y1, y2, this.getSpectrum().isContinuous());
            graphs = null;
        }
        if (graphs != null) {
            this.viewData = new ViewData(graphs, y1, y2, startIndices, endIndices, this.getSpectrumAt(0).isContinuous(), is2D);
            if (x1 != x2) {
                this.getScale().setXRange(x1, x2);
            }
        }
        if (viewScales != null) {
            ScaleData.copyScaleFactors(viewScales, this.viewData.getScaleData());
            if (yScales != null) {
                ScaleData.copyYScales(yScales, this.viewData.getScaleData());
            }
            this.getCurrentView();
        }
    }

    private boolean isNearby(Coordinate a1, Coordinate a2, XYScaleConverter c, int range) {
        double x = a1.getXVal();
        int xp1 = c.toPixelX(x);
        int yp1 = this.toPixelY(a1.getYVal());
        x = a2.getXVal();
        int xp2 = c.toPixelX(x);
        int yp2 = this.toPixelY(a2.getYVal());
        return Math.abs(xp1 - xp2) + Math.abs(yp1 - yp2) < range;
    }

    void setReversePlot(boolean val) {
        this.reversePlot = val;
        if (this.reversePlot) {
            this.closeDialogsExcept(Annotation.AType.NONE);
        }
        this.setDrawXAxis();
    }

    private void setDrawXAxis() {
        this.drawXAxisLeftToRight = this.xAxisLeftToRight ^ this.reversePlot;
        for (int i = 0; i < this.spectra.size(); ++i) {
            ((Spectrum)this.spectra.get(i)).setExportXAxisDirection(this.drawXAxisLeftToRight);
        }
    }

    private boolean isInTopBar(int xPixel, int yPixel) {
        return xPixel == this.fixX(xPixel) && yPixel > this.pin1Dx0.yPixel0 - 2 && yPixel < this.pin1Dx0.yPixel1;
    }

    private boolean isInTopBar2D(int xPixel, int yPixel) {
        return this.imageView != null && xPixel == this.imageView.fixX(xPixel) && yPixel > this.pin2Dx0.yPixel0 - 2 && yPixel < this.pin2Dx0.yPixel1;
    }

    private boolean isInRightBar(int xPixel, int yPixel) {
        return yPixel == this.fixY(yPixel) && xPixel > this.pin1Dy0.xPixel1 && xPixel < this.pin1Dy0.xPixel0 + 2;
    }

    private boolean isInRightBar2D(int xPixel, int yPixel) {
        return this.imageView != null && yPixel == this.fixY(yPixel) && xPixel > this.pin2Dy0.xPixel1 && xPixel < this.pin2Dy0.xPixel0 + 2;
    }

    private double toX0(int xPixel) {
        return ((ViewData)this.viewList.get(0)).getScale().toX0(this.fixX(xPixel), this.xPixel0, this.xPixel1, this.drawXAxisLeftToRight);
    }

    private double toY0(int yPixel) {
        return ((ViewData)this.viewList.get(0)).getScale().toY0(this.fixY(yPixel), this.yPixel0, this.yPixel1);
    }

    @Override
    public double toX(int xPixel) {
        if (this.imageView != null && this.imageView.isXWithinRange(xPixel)) {
            return this.imageView.toX(xPixel);
        }
        return this.getScale().toX(this.fixX(xPixel), this.xPixel1, this.drawXAxisLeftToRight);
    }

    @Override
    public double toY(int yPixel) {
        return this.getScale().toY(yPixel, this.yPixel0);
    }

    @Override
    public int toPixelX(double dx) {
        return this.getScale().toPixelX(dx, this.xPixel0, this.xPixel1, this.drawXAxisLeftToRight);
    }

    @Override
    public int toPixelY(double yVal) {
        return this.getScale().toPixelY(yVal, this.yPixel1);
    }

    private int toPixelX0(double x) {
        return ((ViewData)this.viewList.get(0)).getScale().toPixelX0(x, this.xPixel0, this.xPixel1, this.drawXAxisLeftToRight);
    }

    private int toPixelY0(double y) {
        return this.fixY(((ViewData)this.viewList.get(0)).getScale().toPixelY0(y, this.yPixel0, this.yPixel1));
    }

    @Override
    public int fixX(int xPixel) {
        return Coordinate.intoRange(xPixel, this.xPixel0, this.xPixel1);
    }

    @Override
    public int fixY(int yPixel) {
        return Coordinate.intoRange(yPixel, this.yPixel0, this.yPixel1);
    }

    @Override
    public int getXPixel0() {
        return this.xPixel0;
    }

    @Override
    public int getXPixels() {
        return this.xPixels;
    }

    @Override
    public int getYPixels() {
        return this.yPixels;
    }

    @Override
    public ScaleData getScale() {
        return this.viewData.getScale();
    }

    private int toPixelYint(double yVal) {
        return this.yPixel1 - (int)(Double.isNaN(yVal) ? -2.147483648E9 : (double)this.yPixels * yVal);
    }

    private Annotation findAnnotation2D(Coordinate xy) {
        int i = this.annotations.size();
        while (--i >= 0) {
            Annotation a = (Annotation)this.annotations.get(i);
            if (!this.isNearby(a, xy, this.imageView, 10)) continue;
            return a;
        }
        return null;
    }

    private void addAnnotation(Annotation annotation, boolean isToggle) {
        if (this.annotations == null) {
            this.annotations = new Lst();
        }
        boolean removed = false;
        int i = this.annotations.size();
        while (--i >= 0) {
            if (!(annotation.is2D ? this.isNearby((Coordinate)this.annotations.get(i), annotation, this.imageView, 10) : annotation.equals((Coordinate)this.annotations.get(i)))) continue;
            removed = true;
            this.annotations.removeItemAt(i);
        }
        if (!(annotation.text.length() <= 0 || removed && isToggle)) {
            this.annotations.addLast(annotation);
        }
    }

    private void setImageWindow() {
        this.imageView.setPixelWidthHeight((int)((this.pd.display1D ? 0.6 : 1.0) * (double)this.xPixels0), this.yPixels);
        this.imageView.setXY0(this.getSpectrumAt(0), (int)Math.floor(this.xPixel10 - this.imageView.xPixels), this.yPixel0);
    }

    private boolean findNearestMaxMin() {
        if (this.nSpectra > 1 && this.iSpectrumClicked < 0) {
            return false;
        }
        this.xValueMovedTo = this.getSpectrum().findXForPeakNearest(this.xValueMovedTo);
        this.setXPixelMovedTo(this.xValueMovedTo, Double.MAX_VALUE, 0, 0);
        return !Double.isNaN(this.xValueMovedTo);
    }

    void setXPixelMovedTo(double x1, double x2, int xPixel1, int xPixel2) {
        if (x1 == Double.MAX_VALUE && x2 == Double.MAX_VALUE) {
            this.xPixelMovedTo = xPixel1;
            this.xPixelMovedTo2 = xPixel2;
            if (this.isLinked && this.sticky2Dcursor) {
                this.pd.setlinkedXMove(this, this.toX(this.xPixelMovedTo), false);
            }
            return;
        }
        if (x1 != Double.MAX_VALUE) {
            this.xPixelMovedTo = this.toPixelX(x1);
            if (this.fixX(this.xPixelMovedTo) != this.xPixelMovedTo) {
                this.xPixelMovedTo = -1;
            }
            this.xPixelMovedTo2 = -1;
            if (x1 != 1.0E10) {
                this.setSpectrumClicked(this.getFixedSelectedSpectrumIndex());
            }
        }
        if (x2 != Double.MAX_VALUE) {
            this.xPixelMovedTo2 = this.toPixelX(x2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processPendingMeasurement(int xPixel, int yPixel, int clickCount) {
        if (!this.isInPlotRegion(xPixel, yPixel) || this.is2dClick(xPixel, yPixel)) {
            this.pendingMeasurement = null;
            return;
        }
        x = this.toX(xPixel);
        y = this.toY(yPixel);
        x0 = x;
        switch (clickCount) {
            case 0: {
                this.pendingMeasurement.setPt2(this.toX(xPixel), this.toY(yPixel));
                break;
            }
            case 2: 
            case 3: {
                if (this.iSpectrumClicked < 0) {
                    return;
                }
                spec = (Spectrum)this.spectra.get(this.iSpectrumClicked);
                this.setScale(this.iSpectrumClicked);
                if (clickCount != 3) {
                    m = this.findMeasurement(this.selectedSpectrumMeasurements, xPixel, yPixel, 1);
                    if (m != null) {
                        x = m.getXVal();
                        y = m.getYVal();
                    } else {
                        m = this.findMeasurement(this.selectedSpectrumMeasurements, xPixel, yPixel, 2);
                        if (m != null) {
                            x = m.getXVal2();
                            y = m.getYVal2();
                        } else {
                            x = this.getNearestPeak(spec, x, y);
                        }
                    }
                }
                this.pendingMeasurement = new Measurement().setM1(x, y, spec);
                this.pendingMeasurement.setPt2(x0, y);
                this.pd.setTaintedAll();
                this.pd.repaint();
                break;
            }
            case -3: 
            case -2: 
            case 1: {
                v0 = isOK = this.pendingMeasurement != null && this.isVisible(this.getDialog(Annotation.AType.Measurements, -1)) != false;
                if (!isOK) ** GOTO lbl54
                this.setScale(this.getSpectrumIndex(this.pendingMeasurement.spec));
                if (clickCount == 3) ** GOTO lbl42
                if (!this.findNearestMaxMin()) {
                    isOK = false;
                } else {
                    xPixel = this.xPixelMovedTo;
lbl42:
                    // 2 sources

                    x = this.toX(xPixel);
                    y = this.toY(yPixel);
                    this.pendingMeasurement.setPt2(x, y);
                    if (this.pendingMeasurement.text.length() == 0) {
                        isOK = false;
                    } else {
                        this.setMeasurement(this.pendingMeasurement);
                        if (clickCount != 1) {
                            isOK = false;
                        } else {
                            this.setSpectrumClicked(this.getSpectrumIndex(this.pendingMeasurement.spec));
                            this.pendingMeasurement = new Measurement().setM1(x, y, this.pendingMeasurement.spec);
                        }
                    }
                }
lbl54:
                // 5 sources

                if (!isOK) {
                    this.pendingMeasurement = null;
                }
                this.pd.setTaintedAll();
                this.pd.repaint();
                break;
            }
            case 5: {
                if (this.findNearestMaxMin()) {
                    iSpec = this.getFixedSelectedSpectrumIndex();
                    if (Double.isNaN(this.lastXMax) || this.lastSpecClicked != iSpec || this.pendingMeasurement == null) {
                        this.lastXMax = this.xValueMovedTo;
                        this.lastSpecClicked = iSpec;
                        this.pendingMeasurement = new Measurement().setM1(this.xValueMovedTo, this.yValueMovedTo, (Spectrum)this.spectra.get(iSpec));
                        break;
                    }
                    this.pendingMeasurement.setPt2(this.xValueMovedTo, this.yValueMovedTo);
                    if (this.pendingMeasurement.text.length() > 0) {
                        this.setMeasurement(this.pendingMeasurement);
                    }
                    this.pendingMeasurement = null;
                    this.lastXMax = NaN;
                    break;
                }
                this.lastXMax = NaN;
            }
        }
    }

    private boolean checkIntegralNormalizationClick(int xPixel, int yPixel) {
        if (this.selectedSpectrumIntegrals == null) {
            return false;
        }
        Integral integral = (Integral)this.findMeasurement(this.selectedSpectrumIntegrals, xPixel, yPixel, -5);
        if (integral == null) {
            return false;
        }
        this.selectedIntegral = integral;
        this.pd.normalizeIntegral();
        this.updateDialog(Annotation.AType.Integration, -1);
        this.setSpectrumClicked(this.getSpectrumIndex(integral.spec));
        return true;
    }

    private double getNearestPeak(Spectrum spec, double x, double y) {
        double x0 = Coordinate.getNearestXWithYAbove(spec.getXYCoords(), x, y, spec.isInverted(), false);
        double x1 = Coordinate.getNearestXWithYAbove(spec.getXYCoords(), x, y, spec.isInverted(), true);
        return Double.isNaN(x0) ? x1 : (Double.isNaN(x1) ? x0 : (Math.abs(x0 - x) < Math.abs(x1 - x) ? x0 : x1));
    }

    private Measurement findMeasurement(MeasurementData measurements, int xPixel, int yPixel, int iPt) {
        if (measurements == null || measurements.size() == 0) {
            return null;
        }
        if (iPt == 0) {
            Measurement m = this.findMeasurement(measurements, xPixel, yPixel, -1);
            if (m != null || measurements.get(0) instanceof Integral) {
                return m;
            }
            return this.findMeasurement(measurements, xPixel, yPixel, -2);
        }
        int i = measurements.size();
        block5: while (--i >= 0) {
            int y2;
            int y1;
            int x1;
            int x2;
            Measurement m = (Measurement)measurements.get(i);
            if (m instanceof Integral) {
                x1 = x2 = this.toPixelX(m.getXVal2());
                y1 = this.toPixelYint(m.getYVal());
                y2 = this.toPixelYint(m.getYVal2());
            } else {
                x1 = this.toPixelX(m.getXVal());
                x2 = this.toPixelX(m.getXVal2());
                y2 = iPt == -2 ? this.yPixel1 - 2 : this.toPixelY(m.getYVal());
                y1 = y2;
            }
            switch (iPt) {
                case 1: {
                    if (Math.abs(xPixel - x1) + Math.abs(yPixel - y1) >= 4) continue block5;
                    return m;
                }
                case 2: {
                    if (Math.abs(xPixel - x2) + Math.abs(yPixel - y2) >= 4) continue block5;
                    return m;
                }
                case -5: {
                    y1 = y2 = (y1 + y2) / 2;
                    x2 = x1 + 20;
                }
            }
            if (!GraphSet.isOnLine(xPixel, yPixel, x1, y1, x2, y2)) continue;
            return m;
        }
        return null;
    }

    private void setMeasurement(Measurement m) {
        int iSpec = this.getSpectrumIndex(m.spec);
        AnnotationData ad = this.getDialog(Annotation.AType.Measurements, iSpec);
        if (ad == null) {
            ad = new MeasurementData(Annotation.AType.Measurements, m.spec);
            this.addDialog(iSpec, Annotation.AType.Measurements, ad);
        }
        ad.getData().addLast(m.copyM());
        this.updateDialog(Annotation.AType.Measurements, -1);
    }

    private boolean checkArrowUpDownClick(int xPixel, int yPixel) {
        double f;
        boolean ok = false;
        double d = this.isArrowClick(xPixel, yPixel, 3) ? RT2 : (f = this.isArrowClick(xPixel, yPixel, 4) ? 1.0 / RT2 : 0.0);
        if (f != 0.0) {
            if (this.nSplit > 1) {
                this.setSpectrumSelected(this.iSpectrumMovedTo);
            }
            if ((this.nSpectra == 1 || this.iSpectrumSelected >= 0) && ((Spectrum)this.spectra.get(this.getFixedSelectedSpectrumIndex())).isTransmittance()) {
                f = 1.0 / f;
            }
            this.viewData.scaleSpectrum(this.imageView == null ? this.iSpectrumSelected : -2, f);
            ok = true;
        } else if (this.isArrowClick(xPixel, yPixel, -1)) {
            this.resetViewCompletely();
            ok = true;
        }
        if (ok) {
            if (this.imageView != null) {
                this.update2dImage(false);
                this.resetPinsFromView();
            }
            this.pd.setTaintedAll();
        }
        return ok;
    }

    void resetViewCompletely() {
        this.clearViews();
        if (this.showAllStacked && !this.stackSelected) {
            this.closeDialogsExcept(Annotation.AType.NONE);
        }
        this.viewData.resetScaleFactors();
        this.updateDialogs();
    }

    private boolean checkArrowLeftRightClick(int xPixel, int yPixel) {
        if (this.haveLeftRightArrows) {
            int dx;
            int n = this.isArrowClick(xPixel, yPixel, 1) ? -1 : (dx = this.isArrowClick(xPixel, yPixel, 2) ? 1 : 0);
            if (dx != 0) {
                this.setSpectrumClicked((this.iSpectrumSelected + dx) % this.nSpectra);
                return true;
            }
            if (this.isArrowClick(xPixel, yPixel, 0)) {
                if (this.showAllStacked) {
                    this.showAllStacked = false;
                    this.setSpectrumClicked(this.getFixedSelectedSpectrumIndex());
                    return true;
                }
                this.showAllStacked = this.allowStacking;
                this.setSpectrumSelected(-1);
                this.stackSelected = false;
            }
        }
        return false;
    }

    private boolean isArrowClick(int xPixel, int yPixel, int type) {
        switch (type) {
            case -1: 
            case 3: 
            case 4: {
                int pt = (this.yPixel00 + this.yPixel11) / 2 + (type == 3 ? -1 : (type == 4 ? 1 : 0)) * 15;
                return Math.abs(this.xVArrows - xPixel) < 10 && Math.abs(pt - yPixel) < 10;
            }
            case 0: 
            case 1: 
            case 2: {
                int pt = this.xHArrows + (type == 1 ? -1 : (type == 2 ? 1 : 0)) * 15;
                return Math.abs(pt - xPixel) < 10 && Math.abs(this.yHArrows - yPixel) < 10;
            }
        }
        return false;
    }

    private void setWidgetValueByUser(PlotWidget pw) {
        String sval = pw == this.cur2Dy ? "" + this.imageView.toSubspectrumIndex(pw.yPixel0) : (pw == this.pin1Dx01 ? "" + Math.min(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()) + " - " + Math.max(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()) : (pw == this.pin1Dy01 ? "" + Math.min(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()) + " - " + Math.max(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()) : (pw == this.pin2Dx01 ? "" + Math.min(this.pin2Dx0.getXVal(), this.pin2Dx1.getXVal()) + " - " + Math.max(this.pin2Dx0.getXVal(), this.pin2Dx1.getXVal()) : (pw == this.pin2Dy01 ? "" + (int)Math.min(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) + " - " + (int)Math.max(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) : "" + pw.getValue()))));
        if ((sval = this.pd.getInput("New value?", "Set Slider", sval)) == null) {
            return;
        }
        sval = sval.trim();
        try {
            if (pw == this.pin1Dx01 || pw == this.pin1Dy01 || pw == this.pin2Dx01 || pw == this.pin2Dy01) {
                int pt = sval.indexOf("-", 1);
                if (pt < 0) {
                    return;
                }
                double val1 = Double.valueOf(sval.substring(0, pt));
                double val2 = Double.valueOf(sval.substring(pt + 1));
                if (pw == this.pin1Dx01) {
                    this.doZoom(val1, this.pin1Dy0.getYVal(), val2, this.pin1Dy1.getYVal(), true, false, false, true, true);
                } else if (pw == this.pin1Dy01) {
                    this.doZoom(this.pin1Dx0.getXVal(), val1, this.pin1Dx1.getXVal(), val2, this.imageView == null, this.imageView == null, false, false, true);
                } else if (pw == this.pin2Dx01) {
                    this.imageView.setView0(this.imageView.toPixelX0(val1), this.pin2Dy0.yPixel0, this.imageView.toPixelX0(val2), this.pin2Dy1.yPixel0);
                    this.doZoom(val1, this.pin1Dy0.getYVal(), val2, this.pin1Dy1.getYVal(), false, false, false, true, true);
                } else if (pw == this.pin2Dy01) {
                    this.imageView.setView0(this.pin2Dx0.xPixel0, this.imageView.toPixelY0(val1), this.pin2Dx1.xPixel0, this.imageView.toPixelY0(val2));
                    this.doZoom(this.imageView.toX(this.imageView.xPixel0), this.getScale().minY, this.imageView.toX(this.imageView.xPixel0 + this.imageView.xPixels - 1), this.getScale().maxY, false, false, false, false, true);
                }
            } else {
                double val = Double.valueOf(sval);
                if (pw.isXtype) {
                    double val2 = pw == this.pin1Dx0 || pw == this.cur2Dx0 || pw == this.pin2Dx0 ? this.pin1Dx1.getXVal() : this.pin1Dx0.getXVal();
                    this.doZoom(val, 0.0, val2, 0.0, !pw.is2D, false, false, true, true);
                } else if (pw == this.cur2Dy) {
                    this.setCurrentSubSpectrum((int)val);
                } else if (pw == this.pin2Dy0 || pw == this.pin2Dy1) {
                    int val2 = pw == this.pin2Dy0 ? this.pin2Dy1.yPixel0 : this.pin2Dy0.yPixel0;
                    this.imageView.setView0(this.pin2Dx0.xPixel0, this.imageView.subIndexToPixelY((int)val), this.pin2Dx1.xPixel0, val2);
                } else {
                    double val2 = pw == this.pin1Dy0 ? this.pin1Dy1.getYVal() : this.pin1Dy0.getYVal();
                    this.doZoom(this.pin1Dx0.getXVal(), val, this.pin1Dx1.getXVal(), val2, this.imageView == null, this.imageView == null, false, false, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeAllHighlights(Spectrum spec) {
        if (spec == null) {
            this.highlights.clear();
        } else {
            int i = this.highlights.size();
            while (--i >= 0) {
                if (((Highlight)this.highlights.get((int)i)).spectrum != spec) continue;
                this.highlights.removeItemAt(i);
            }
        }
    }

    private Coordinate setCoordClicked(int xPixel, double x, double y) {
        if (y == 0.0) {
            this.nextClickForSetPeak = null;
        }
        if (Double.isNaN(x)) {
            this.pd.coordClicked = null;
            this.pd.coordsClicked = null;
            return null;
        }
        this.lastClickX = x;
        this.pd.coordClicked = new Coordinate().set(this.lastClickX, y);
        this.pd.coordsClicked = this.getSpectrum().getXYCoords();
        this.pd.xPixelClicked = this.lastPixelX = xPixel;
        return this.pd.coordClicked;
    }

    private void setWidgets(boolean needNewPins, int subIndex, boolean doDraw1DObjects) {
        if (needNewPins || this.pin1Dx0 == null) {
            if (this.zoomBox1D == null) {
                this.newPins();
            } else {
                this.resetPinPositions();
            }
        }
        this.setDerivedPins(subIndex);
        this.setPinSliderPositions(doDraw1DObjects);
    }

    private void newPins() {
        this.zoomBox1D = new PlotWidget("zoomBox1D");
        this.pin1Dx0 = new PlotWidget("pin1Dx0");
        this.pin1Dx1 = new PlotWidget("pin1Dx1");
        this.pin1Dy0 = new PlotWidget("pin1Dy0");
        this.pin1Dy1 = new PlotWidget("pin1Dy1");
        this.pin1Dx01 = new PlotWidget("pin1Dx01");
        this.pin1Dy01 = new PlotWidget("pin1Dy01");
        this.cur1D2x1 = new PlotWidget("cur1D2x1");
        this.cur1D2x1.color = ScriptToken.PEAKTABCOLOR;
        this.cur1D2x2 = new PlotWidget("cur1D2x2");
        this.cur1D2x2.color = ScriptToken.PEAKTABCOLOR;
        if (this.imageView != null) {
            this.zoomBox2D = new PlotWidget("zoomBox2D");
            this.pin2Dx0 = new PlotWidget("pin2Dx0");
            this.pin2Dx1 = new PlotWidget("pin2Dx1");
            this.pin2Dy0 = new PlotWidget("pin2Dy0");
            this.pin2Dy1 = new PlotWidget("pin2Dy1");
            this.pin2Dx01 = new PlotWidget("pin2Dx01");
            this.pin2Dy01 = new PlotWidget("pin2Dy01");
            this.cur2Dx0 = new PlotWidget("cur2Dx0");
            this.cur2Dx1 = new PlotWidget("cur2Dx1");
            this.cur2Dy = new PlotWidget("cur2Dy");
            this.pin2Dy0.setY(0.0, this.imageView.toPixelY0(0.0));
            int n = this.getSpectrumAt(0).getSubSpectra().size();
            this.pin2Dy1.setY(n, this.imageView.toPixelY0(n));
        }
        this.setWidgetX(this.pin1Dx0, this.getScale().minX);
        this.setWidgetX(this.pin1Dx1, this.getScale().maxX);
        this.setWidgetY(this.pin1Dy0, this.getScale().minY);
        this.setWidgetY(this.pin1Dy1, this.getScale().maxY);
        this.widgets = new PlotWidget[]{this.zoomBox1D, this.zoomBox2D, this.pin1Dx0, this.pin1Dx01, this.pin1Dx1, this.pin1Dy0, this.pin1Dy01, this.pin1Dy1, this.pin2Dx0, this.pin2Dx01, this.pin2Dx1, this.pin2Dy0, this.pin2Dy01, this.pin2Dy1, this.cur2Dx0, this.cur2Dx1, this.cur2Dy, this.cur1D2x1, this.cur1D2x2};
    }

    private void setWidgetX(PlotWidget pw, double x) {
        pw.setX(x, this.toPixelX0(x));
    }

    private void setWidgetY(PlotWidget pw, double y) {
        pw.setY(y, this.toPixelY0(y));
    }

    private void resetPinsFromView() {
        if (this.pin1Dx0 == null) {
            return;
        }
        this.setWidgetX(this.pin1Dx0, this.getScale().minXOnScale);
        this.setWidgetX(this.pin1Dx1, this.getScale().maxXOnScale);
        this.setWidgetY(this.pin1Dy0, this.getScale().minYOnScale);
        this.setWidgetY(this.pin1Dy1, this.getScale().maxYOnScale);
    }

    private void resetPinPositions() {
        this.resetX(this.pin1Dx0);
        this.resetY(this.pin1Dy0);
        this.resetY(this.pin1Dy1);
        if (this.imageView == null) {
            if (this.gs2dLinkedX != null) {
                this.resetX(this.cur1D2x1);
            }
            if (this.gs2dLinkedY != null) {
                this.resetX(this.cur1D2x2);
            }
        } else {
            this.pin2Dy0.setY(this.pin2Dy0.getYVal(), this.imageView.toPixelY0(this.pin2Dy0.getYVal()));
            this.pin2Dy1.setY(this.pin2Dy1.getYVal(), this.imageView.toPixelY0(this.pin2Dy1.getYVal()));
        }
    }

    private void resetX(PlotWidget p) {
        this.setWidgetX(p, p.getXVal());
    }

    private void resetY(PlotWidget p) {
        this.setWidgetY(p, p.getYVal());
    }

    private void setPinSliderPositions(boolean doDraw1DObjects) {
        this.pin1Dx1.yPixel0 = this.pin1Dx01.yPixel0 = this.yPixel0 - 5;
        this.pin1Dx0.yPixel0 = this.pin1Dx01.yPixel0;
        this.pin1Dx1.yPixel1 = this.pin1Dx01.yPixel1 = this.yPixel0;
        this.pin1Dx0.yPixel1 = this.pin1Dx01.yPixel1;
        this.cur1D2x1.yPixel1 = this.cur1D2x2.yPixel1 = this.yPixel0 - 5;
        this.cur1D2x1.yPixel0 = this.cur1D2x2.yPixel0 = this.yPixel1 + 6;
        if (this.imageView == null) {
            this.pin1Dy1.xPixel0 = this.pin1Dy01.xPixel0 = this.xPixel1 + 5;
            this.pin1Dy0.xPixel0 = this.pin1Dy01.xPixel0;
            this.pin1Dy1.xPixel1 = this.pin1Dy01.xPixel1 = this.xPixel1;
            this.pin1Dy0.xPixel1 = this.pin1Dy01.xPixel1;
        } else {
            this.pin1Dy1.xPixel0 = this.pin1Dy01.xPixel0 = this.imageView.xPixel1 + 15;
            this.pin1Dy0.xPixel0 = this.pin1Dy01.xPixel0;
            this.pin1Dy1.xPixel1 = this.pin1Dy01.xPixel1 = this.imageView.xPixel1 + 10;
            this.pin1Dy0.xPixel1 = this.pin1Dy01.xPixel1;
            this.pin2Dx1.yPixel0 = this.pin2Dx01.yPixel0 = this.yPixel0 - 5;
            this.pin2Dx0.yPixel0 = this.pin2Dx01.yPixel0;
            this.pin2Dx1.yPixel1 = this.pin2Dx01.yPixel1 = this.yPixel0;
            this.pin2Dx0.yPixel1 = this.pin2Dx01.yPixel1;
            this.pin2Dy1.xPixel0 = this.pin2Dy01.xPixel0 = this.imageView.xPixel1 + 5;
            this.pin2Dy0.xPixel0 = this.pin2Dy01.xPixel0;
            this.pin2Dy1.xPixel1 = this.pin2Dy01.xPixel1 = this.imageView.xPixel1;
            this.pin2Dy0.xPixel1 = this.pin2Dy01.xPixel1;
            this.cur2Dx0.yPixel0 = this.cur2Dx1.yPixel0 = this.yPixel1 + 6;
            this.cur2Dx0.yPixel1 = this.cur2Dx1.yPixel1 = this.yPixel0 - 5;
            this.cur2Dx0.yPixel0 = this.cur2Dx1.yPixel0 = this.yPixel1 + 6;
            this.cur2Dx1.yPixel1 = this.cur2Dx1.yPixel1 = this.yPixel0 - 5;
            this.cur2Dy.xPixel0 = doDraw1DObjects ? (this.xPixel1 + this.imageView.xPixel0) / 2 : this.imageView.xPixel0 - 6;
            this.cur2Dy.xPixel1 = this.imageView.xPixel1 + 5;
        }
    }

    private void setDerivedPins(int subIndex) {
        this.triggered = true;
        if (this.gs2dLinkedX != null) {
            this.cur1D2x1.setX(this.cur1D2x1.getXVal(), this.toPixelX(this.cur1D2x1.getXVal()));
        }
        if (this.gs2dLinkedY != null) {
            this.cur1D2x2.setX(this.cur1D2x2.getXVal(), this.toPixelX(this.cur1D2x2.getXVal()));
        }
        this.pin1Dx01.setX(0.0, (this.pin1Dx0.xPixel0 + this.pin1Dx1.xPixel0) / 2);
        this.pin1Dy01.setY(0.0, (this.pin1Dy0.yPixel0 + this.pin1Dy1.yPixel0) / 2);
        this.pin1Dx01.setEnabled(Math.min(this.pin1Dx0.xPixel0, this.pin1Dx1.xPixel0) > this.xPixel0 || Math.max(this.pin1Dx0.xPixel0, this.pin1Dx1.xPixel0) < this.xPixel1);
        this.pin1Dy01.setEnabled(Math.min(this.pin1Dy0.yPixel0, this.pin1Dy1.yPixel0) > Math.min(this.toPixelY(this.getScale().minY), this.toPixelY(this.getScale().maxY)) || Math.max(this.pin1Dy0.yPixel0, this.pin1Dy1.yPixel0) < Math.max(this.toPixelY(this.getScale().minY), this.toPixelY(this.getScale().maxY)));
        if (this.imageView == null) {
            return;
        }
        double x = this.pin1Dx0.getXVal();
        this.cur2Dx0.setX(x, this.imageView.toPixelX(x));
        x = this.pin1Dx1.getXVal();
        this.cur2Dx1.setX(x, this.imageView.toPixelX(x));
        x = this.imageView.toX(this.imageView.xPixel0);
        this.pin2Dx0.setX(x, this.imageView.toPixelX0(x));
        x = this.imageView.toX(this.imageView.xPixel1);
        this.pin2Dx1.setX(x, this.imageView.toPixelX0(x));
        this.pin2Dx01.setX(0.0, (this.pin2Dx0.xPixel0 + this.pin2Dx1.xPixel0) / 2);
        double y = this.imageView.imageHeight - 1 - this.imageView.yView1;
        this.pin2Dy0.setY(y, this.imageView.toPixelY0(y));
        y = this.imageView.imageHeight - 1 - this.imageView.yView2;
        this.pin2Dy1.setY(y, this.imageView.toPixelY0(y));
        this.pin2Dy01.setY(0.0, (this.pin2Dy0.yPixel0 + this.pin2Dy1.yPixel0) / 2);
        this.cur2Dy.yPixel0 = this.cur2Dy.yPixel1 = this.imageView.subIndexToPixelY(subIndex);
        this.pin2Dx01.setEnabled(Math.min(this.pin2Dx0.xPixel0, this.pin2Dx1.xPixel0) != this.imageView.xPixel0 || Math.max(this.pin2Dx0.xPixel0, this.pin2Dx1.xPixel1) != this.imageView.xPixel1);
        this.pin2Dy01.setEnabled(Math.min(this.pin2Dy0.yPixel0, this.pin2Dy1.yPixel0) != this.yPixel0 || Math.max(this.pin2Dy0.yPixel0, this.pin2Dy1.yPixel1) != this.yPixel1);
    }

    synchronized void doZoom(double initX, double initY, double finalX, double finalY, boolean is1D, boolean is1DY, boolean checkRange, boolean checkLinked, boolean addZoom) {
        double y2;
        double y1;
        boolean isXOnly;
        boolean is2D;
        boolean is2DGrayScaleChange;
        if (initX == finalX) {
            initX = this.getScale().minXOnScale;
            finalX = this.getScale().maxXOnScale;
        } else if (this.isLinked && checkLinked) {
            this.pd.doZoomLinked(this, initX, finalX, addZoom, checkRange, is1D);
        }
        if (initX > finalX) {
            double tempX = initX;
            initX = finalX;
            finalX = tempX;
        }
        if (initY > finalY) {
            double tempY = initY;
            initY = finalY;
            finalY = tempY;
        }
        boolean bl = is2DGrayScaleChange = !is1D && this.imageView != null && (this.imageView.minZ != initY || this.imageView.maxZ != finalY);
        if (!this.zoomEnabled && !is2DGrayScaleChange) {
            return;
        }
        if (checkRange) {
            if (!this.getScale().isInRangeX(initX) && !this.getScale().isInRangeX(finalX)) {
                return;
            }
            if (!this.getScale().isInRangeX(initX)) {
                initX = this.getScale().minX;
            } else if (!this.getScale().isInRangeX(finalX)) {
                finalX = this.getScale().maxX;
            }
        }
        this.pd.setTaintedAll();
        ScaleData[] viewScales = this.viewData.getScaleData();
        int[] startIndices = new int[this.nSpectra];
        int[] endIndices = new int[this.nSpectra];
        this.graphsTemp.clear();
        Lst<Spectrum> subspecs = this.getSpectrumAt(0).getSubSpectra();
        boolean dontUseSubspecs = subspecs == null || subspecs.size() == 2;
        boolean bl2 = is2D = !this.getSpectrumAt(0).is1D();
        if (!is2D && !dontUseSubspecs) {
            this.graphsTemp.addLast(this.getSpectrum());
            if (!ScaleData.setDataPointIndices(this.graphsTemp, initX, finalX, 3, startIndices, endIndices)) {
                return;
            }
        } else if (!ScaleData.setDataPointIndices(this.spectra, initX, finalX, 3, startIndices, endIndices)) {
            return;
        }
        boolean bl3 = isXOnly = (y1 = initY) == (y2 = finalY);
        if (isXOnly) {
            double f;
            double d = f = !is2DGrayScaleChange && is1D ? (f = this.getScale().spectrumScaleFactor) : 1.0;
            if (Math.abs(f - 1.0) < 1.0E-4) {
                y1 = this.getScale().minYOnScale;
                y2 = this.getScale().maxYOnScale;
            }
        }
        ScaleData[] yScales = null;
        if (isXOnly || is1DY) {
            this.getCurrentView();
            yScales = this.viewData.getNewScales(this.iSpectrumSelected, isXOnly, y1, y2);
        }
        this.getView(initX, finalX, y1, y2, startIndices, endIndices, viewScales, yScales);
        this.setXPixelMovedTo(1.0E10, Double.MAX_VALUE, 0, 0);
        this.setWidgetX(this.pin1Dx0, initX);
        this.setWidgetX(this.pin1Dx1, finalX);
        this.setWidgetY(this.pin1Dy0, y1);
        this.setWidgetY(this.pin1Dy1, y2);
        if (this.imageView == null) {
            this.updateDialogs();
        } else {
            int isub = this.getSpectrumAt(0).getSubIndex();
            int ifix = this.imageView.fixSubIndex(isub);
            if (ifix != isub) {
                this.setCurrentSubSpectrum(ifix);
            }
            if (is2DGrayScaleChange) {
                this.update2dImage(false);
            }
        }
        if (addZoom) {
            this.addCurrentZoom();
        }
    }

    private void updateDialogs() {
        this.updateDialog(Annotation.AType.PeakList, -1);
        this.updateDialog(Annotation.AType.Measurements, -1);
    }

    private void setCurrentSubSpectrum(int i) {
        Spectrum spec0 = this.getSpectrumAt(0);
        i = spec0.setCurrentSubSpectrum(i);
        if (spec0.isForcedSubset()) {
            this.viewData.setXRangeForSubSpectrum(this.getSpectrum().getXYCoords());
        }
        this.pd.notifySubSpectrumChange(i, this.getSpectrum());
    }

    private void addCurrentZoom() {
        if (this.viewList.size() > this.currentZoomIndex + 1) {
            for (int i = this.viewList.size() - 1; i > this.currentZoomIndex; --i) {
                this.viewList.removeItemAt(i);
            }
        }
        this.viewList.addLast(this.viewData);
        ++this.currentZoomIndex;
    }

    private void setZoomTo(int i) {
        this.currentZoomIndex = i;
        this.viewData = (ViewData)this.viewList.get(i);
        this.resetPinsFromView();
    }

    void clearViews() {
        if (this.isLinked) {
            this.pd.clearLinkViews(this);
        }
        this.setZoom(0.0, 0.0, 0.0, 0.0);
        int i = this.viewList.size();
        while (--i >= 1) {
            this.viewList.removeItemAt(i);
        }
    }

    private void drawAll(Object gMain, Object gFront, Object gBack, int iSplit, boolean needNewPins, boolean doAll) {
        Object g2;
        this.g2d = this.pd.g2d;
        this.gMain = gMain;
        Spectrum spec0 = this.getSpectrumAt(0);
        int subIndex = spec0.getSubIndex();
        boolean bl = this.is2DSpectrum = !(spec0.is1D() || !this.isLinked && !this.pd.getBoolean(ScriptToken.DISPLAY2D) || this.imageView == null && !this.get2DImage(spec0));
        if (this.imageView != null && doAll) {
            if (this.pd.isPrinting && this.g2d != this.pd.g2d0) {
                this.g2d.newGrayScaleImage(gMain, this.image2D, this.imageView.imageWidth, this.imageView.imageHeight, this.imageView.getBuffer());
            }
            if (this.is2DSpectrum) {
                this.setPositionForFrame(iSplit);
            }
            this.draw2DImage();
        }
        int iSelected = this.stackSelected || !this.showAllStacked ? this.iSpectrumSelected : -1;
        boolean doYScale = !this.showAllStacked || this.nSpectra == 1 || iSelected >= 0;
        boolean doDraw1DObjects = this.imageView == null || this.pd.display1D;
        int n = iSelected >= 0 ? 1 : 0;
        int iSpectrumForScale = this.getFixedSelectedSpectrumIndex();
        if (doDraw1DObjects && doAll) {
            this.fillBox(gMain, this.xPixel0, this.yPixel0, this.xPixel1, this.yPixel1, ScriptToken.PLOTAREACOLOR);
            if (iSelected < 0) {
                doYScale = true;
                for (int i = 0; i < this.nSpectra; ++i) {
                    if (!this.doPlot(i, iSplit) || n++ == 0) continue;
                    doYScale &= this.viewData.areYScalesSame(i - 1, i);
                }
            }
        }
        int iSpecForFrame = this.nSpectra == 1 ? 0 : (!this.showAllStacked ? this.iSpectrumMovedTo : this.iSpectrumSelected);
        Object object = g2 = gBack == gMain ? gFront : gBack;
        if (doAll) {
            boolean addCurrentBox = this.pd.getCurrentGraphSet() == this && !this.isLinked && (!this.isSplittable || this.nSplit == 1 || this.pd.currentSplitPoint == iSplit);
            boolean drawUpDownArrows = !(!this.zoomEnabled || this.isDrawNoSpectra() || !this.pd.isCurrentGraphSet(this) || !((Spectrum)this.spectra.get(0)).isScalable() || !addCurrentBox && this.nSpectra != 1 || this.nSplit != 1 && this.pd.currentSplitPoint != this.iSpectrumMovedTo);
            boolean addSplitBox = this.isSplittable;
            this.drawFrame(gMain, iSpecForFrame, addCurrentBox, addSplitBox, drawUpDownArrows);
        }
        if (this.pd.isCurrentGraphSet(this) && iSplit == this.pd.currentSplitPoint && (n < 2 || this.iSpectrumSelected >= 0)) {
            this.haveSelectedSpectrum = true;
        }
        boolean bl2 = this.showAllStacked && this.nSpectra > 1 ? this.allowStackedYScale && doYScale : (this.haveSingleYScale = true);
        if (doDraw1DObjects) {
            int yOffsetPixels = (int)((float)this.yPixels * ((float)this.yStackOffsetPercent / 100.0f));
            this.haveLeftRightArrows = false;
            int offset = 0;
            for (int i = 0; i < this.nSpectra; ++i) {
                boolean hasPendingIntegral;
                boolean doDraw1DY;
                if (!this.doPlot(i, iSplit)) continue;
                boolean isGrey = this.stackSelected && this.iSpectrumSelected >= 0 && this.iSpectrumSelected != i;
                IntegralData ig = !this.reversePlot && this.getShowAnnotation(Annotation.AType.Integration, i) && (!this.showAllStacked || this.iSpectrumSelected == i) ? (IntegralData)this.getDialog(Annotation.AType.Integration, i).getData() : null;
                this.setScale(i);
                Spectrum spec = (Spectrum)this.spectra.get(i);
                if (this.nSplit > 1) {
                    iSpectrumForScale = i;
                }
                boolean doDrawWidgets = !isGrey && (this.nSplit == 1 || this.showAllStacked || this.iSpectrumSelected == iSplit);
                boolean bl3 = doDraw1DY = doDrawWidgets && this.haveSelectedSpectrum && i == iSpectrumForScale;
                if (doDrawWidgets) {
                    this.resetPinsFromView();
                    this.drawWidgets(gFront, g2, subIndex, needNewPins, doDraw1DObjects, doDraw1DY, false);
                }
                if (this.haveSingleYScale && i == iSpectrumForScale && doAll) {
                    this.drawGrid(gMain);
                    if (this.pd.isPrinting && this.nSplit > 1) {
                        this.drawSpectrumSource(gMain, i);
                    }
                }
                if (doDrawWidgets) {
                    this.drawWidgets(gFront, g2, subIndex, false, doDraw1DObjects, doDraw1DY, true);
                }
                if (!this.isDrawNoSpectra() && (this.nSpectra == 1 || this.iSpectrumSelected >= 0) && (this.haveSingleYScale && i == iSpectrumForScale || this.showAllStacked && this.stackSelected && i == this.iSpectrumSelected)) {
                    this.drawHighlightsAndPeakTabs(gFront, g2, i);
                }
                if (doAll) {
                    if ((n == 1 && this.iSpectrumSelected < 0 || this.iSpectrumSelected == i && this.pd.isCurrentGraphSet(this)) && this.pd.titleOn && !this.pd.titleDrawn) {
                        this.pd.drawTitle(gMain, this.height, this.width, this.pd.getDrawTitle(this.pd.isPrinting));
                        this.pd.titleDrawn = true;
                    }
                    if (this.haveSingleYScale && i == iSpectrumForScale) {
                        if (this.pd.getBoolean(ScriptToken.YSCALEON)) {
                            this.drawYScale(gMain, this);
                        }
                        if (this.pd.getBoolean(ScriptToken.YUNITSON)) {
                            this.drawYUnits(gMain);
                        }
                    }
                }
                boolean isContinuous = spec.isContinuous();
                boolean onSpectrum = (this.nSplit > 1 ? i == this.iSpectrumMovedTo : this.isLinked || i == iSpectrumForScale) && !this.pd.isPrinting && spec.isContinuous();
                boolean bl4 = hasPendingIntegral = !isGrey && this.pendingIntegral != null && spec == this.pendingIntegral.spec;
                if (doAll || hasPendingIntegral) {
                    this.drawPlot(hasPendingIntegral && !doAll ? gFront : gMain, i, spec, isContinuous, offset, isGrey, null, onSpectrum, hasPendingIntegral);
                }
                this.drawIntegration(gFront, i, offset, isGrey, ig, isContinuous, onSpectrum);
                this.drawMeasurements(gFront, i);
                if (this.pendingMeasurement != null && this.pendingMeasurement.spec == spec) {
                    this.drawMeasurement(gFront, this.pendingMeasurement);
                }
                if (onSpectrum && this.xPixelMovedTo >= 0) {
                    this.drawSpectrumPointer(gFront, spec, offset, ig);
                }
                if (this.nSpectra > 1 && this.nSplit == 1 && this.pd.isCurrentGraphSet(this) && doAll) {
                    this.haveLeftRightArrows = true;
                    if (!this.pd.isPrinting) {
                        this.setScale(0);
                        iSpecForFrame = this.iSpectrumSelected;
                        if (this.nSpectra != 2) {
                            this.setPlotColor(gMain, (iSpecForFrame + this.nSpectra - 1) % this.nSpectra);
                            this.fillArrow(gMain, 1, this.yHArrows, this.xHArrows - 9, true);
                            this.setCurrentBoxColor(gMain);
                            this.fillArrow(gMain, 1, this.yHArrows, this.xHArrows - 9, false);
                        }
                        if (iSpecForFrame >= 0) {
                            this.setPlotColor(gMain, iSpecForFrame);
                            this.fillCircle(gMain, this.xHArrows, this.yHArrows, true);
                        }
                        this.setCurrentBoxColor(gMain);
                        this.fillCircle(gMain, this.xHArrows, this.yHArrows, false);
                        this.setPlotColor(gMain, (iSpecForFrame + 1) % this.nSpectra);
                        this.fillArrow(gMain, 2, this.yHArrows, this.xHArrows + 9, true);
                        this.setCurrentBoxColor(gMain);
                        this.fillArrow(gMain, 2, this.yHArrows, this.xHArrows + 9, false);
                    }
                }
                offset -= yOffsetPixels;
            }
            if (doAll) {
                if (this.pd.getBoolean(ScriptToken.XSCALEON)) {
                    this.drawXScale(gMain, this);
                }
                if (this.pd.getBoolean(ScriptToken.XUNITSON)) {
                    this.drawXUnits(gMain);
                }
            }
        } else {
            if (doAll) {
                if (this.pd.getBoolean(ScriptToken.XSCALEON)) {
                    this.drawXScale(gMain, this.imageView);
                }
                if (this.pd.getBoolean(ScriptToken.YSCALEON)) {
                    this.drawYScale(gMain, this.imageView);
                }
                if (subIndex >= 0) {
                    this.draw2DUnits(gMain);
                }
            }
            this.drawWidgets(gFront, g2, subIndex, needNewPins, doDraw1DObjects, true, false);
            this.drawWidgets(gFront, g2, subIndex, needNewPins, doDraw1DObjects, true, true);
        }
        if (this.annotations != null) {
            this.drawAnnotations(gFront, this.annotations, null);
        }
    }

    private void drawSpectrumSource(Object g, int i) {
        this.pd.printFilePath(g, this.pd.thisWidth - this.pd.right, this.yPixel0, ((Spectrum)this.spectra.get(i)).getFilePath());
    }

    private boolean doPlot(int i, int iSplit) {
        boolean ok;
        boolean isGrey = this.stackSelected && this.iSpectrumSelected >= 0 && this.iSpectrumSelected != i;
        boolean bl = ok = this.showAllStacked || this.iSpectrumSelected == -1 || this.iSpectrumSelected == i;
        return this.nSplit > 1 ? i == iSplit : ok && (!this.pd.isPrinting || !isGrey);
    }

    private void drawSpectrumPointer(Object gFront, Spectrum spec, int yOffset, IntegralData ig) {
        this.setColorFromToken(gFront, ScriptToken.PEAKTABCOLOR);
        int iHandle = this.pd.integralShiftMode;
        if (ig != null) {
            if (!(this.pd.ctrlPressed && !this.pd.isIntegralDrag || this.isOnSpectrum(this.pd.mouseX, this.pd.mouseY, -1))) {
                ig = null;
            } else if (iHandle == 0 && (iHandle = this.getShiftMode(this.pd.mouseX, this.pd.mouseY)) == 0) {
                iHandle = Integer.MAX_VALUE;
            }
        }
        double y0 = this.yValueMovedTo;
        this.yValueMovedTo = ig == null ? spec.getYValueAt(this.xValueMovedTo) : ig.getPercentYValueAt(this.xValueMovedTo);
        this.setCoordStr(this.xValueMovedTo, this.yValueMovedTo);
        if (iHandle != 0) {
            this.setPlotColor(gFront, iHandle == Integer.MAX_VALUE ? -1 : 0);
            if (iHandle < 0 || iHandle == Integer.MAX_VALUE) {
                this.drawHandle(gFront, this.xPixelPlot1, this.yPixelPlot0, 3, false);
            }
            if (iHandle > 0) {
                this.drawHandle(gFront, this.xPixelPlot0, this.yPixelPlot1, 3, false);
            }
            if (iHandle != Integer.MAX_VALUE) {
                return;
            }
        }
        if (ig != null) {
            this.g2d.setStrokeBold(gFront, true);
        }
        if (Double.isNaN(y0) || this.pendingMeasurement != null) {
            this.g2d.drawLine(gFront, this.xPixelMovedTo, this.yPixel0, this.xPixelMovedTo, this.yPixel1);
            if (this.xPixelMovedTo2 >= 0) {
                this.g2d.drawLine(gFront, this.xPixelMovedTo2, this.yPixel0, this.xPixelMovedTo2, this.yPixel1);
            }
            this.yValueMovedTo = Double.NaN;
        } else {
            int y;
            int n = y = ig == null ? yOffset + this.toPixelY(this.yValueMovedTo) : this.toPixelYint(this.yValueMovedTo / 100.0);
            if (y == this.fixY(y)) {
                this.g2d.drawLine(gFront, this.xPixelMovedTo, y - 10, this.xPixelMovedTo, y + 10);
            }
        }
        if (ig != null) {
            this.g2d.setStrokeBold(gFront, false);
        }
    }

    void setScale(int i) {
        this.viewData.setScale(i, this.xPixels, this.yPixels, ((Spectrum)this.spectra.get(i)).isInverted());
    }

    private void draw2DUnits(Object g) {
        String nucleusX = this.getSpectrumAt((int)0).nucleusX;
        String nucleusY = this.getSpectrumAt((int)0).nucleusY;
        this.setColorFromToken(g, ScriptToken.PLOTCOLOR);
        this.drawUnits(g, nucleusX, this.imageView.xPixel1 + 5 * this.pd.scalingFactor, this.yPixel1, 1.0, 1.0);
        this.drawUnits(g, nucleusY, this.imageView.xPixel0 - 5 * this.pd.scalingFactor, this.yPixel0, 1.0, 0.0);
    }

    private void drawPeakTabs(Object gFront, Object g2, Spectrum spec) {
        Lst<PeakInfo> list;
        Lst<PeakInfo> lst = list = this.nSpectra == 1 || this.iSpectrumSelected >= 0 ? spec.getPeakList() : null;
        if (list != null && list.size() > 0) {
            if (this.piMouseOver != null && this.piMouseOver.spectrum == spec && this.pd.isMouseUp()) {
                this.g2d.setGraphicsColor(g2, this.g2d.getColor4(240, 240, 240, 140));
                this.drawPeak(g2, this.piMouseOver, 0);
                spec.setHighlightedPeak(this.piMouseOver);
            } else {
                spec.setHighlightedPeak(null);
            }
            this.setColorFromToken(gFront, ScriptToken.PEAKTABCOLOR);
            int i = list.size();
            while (--i >= 0) {
                PeakInfo p;
                this.drawPeak(gFront, p, (p = (PeakInfo)list.get(i)) == spec.getSelectedPeak() ? 14 : 7);
            }
        }
    }

    private void drawPeak(Object g, PeakInfo pi, int tickSize) {
        double xMax;
        if (this.pd.isPrinting) {
            return;
        }
        double xMin = pi.getXMin();
        if (xMin == (xMax = pi.getXMax())) {
            return;
        }
        this.drawBar(g, pi, xMin, xMax, null, tickSize);
    }

    private void drawWidgets(Object gFront, Object gBack, int subIndex, boolean needNewPins, boolean doDraw1DObjects, boolean doDraw1DY, boolean postGrid) {
        this.setWidgets(needNewPins, subIndex, doDraw1DObjects);
        if (this.pd.isPrinting && (this.imageView == null ? !this.cur1D2Locked : this.sticky2Dcursor)) {
            return;
        }
        if (!this.pd.isPrinting && !postGrid) {
            if (doDraw1DObjects) {
                this.fillBox(gFront, this.xPixel0, this.pin1Dx0.yPixel1, this.xPixel1, this.pin1Dx1.yPixel1 + 2, ScriptToken.GRIDCOLOR);
                this.fillBox(gFront, this.pin1Dx0.xPixel0, this.pin1Dx0.yPixel1, this.pin1Dx1.xPixel0, this.pin1Dx1.yPixel1 + 2, ScriptToken.PLOTCOLOR);
            } else {
                this.fillBox(gFront, this.imageView.xPixel0, this.pin2Dx0.yPixel1, this.imageView.xPixel1, this.pin2Dx0.yPixel1 + 2, ScriptToken.GRIDCOLOR);
                this.fillBox(gFront, this.pin2Dx0.xPixel0, this.pin2Dx0.yPixel1, this.pin2Dx1.xPixel0, this.pin2Dx1.yPixel1 + 2, ScriptToken.PLOTCOLOR);
                this.fillBox(gFront, this.pin2Dy0.xPixel1, this.yPixel1, this.pin2Dy1.xPixel1 + 2, this.yPixel0, ScriptToken.GRIDCOLOR);
                this.fillBox(gFront, this.pin2Dy0.xPixel1, this.pin2Dy0.yPixel1, this.pin2Dy1.xPixel1 + 2, this.pin2Dy1.yPixel0, ScriptToken.PLOTCOLOR);
            }
            this.fillBox(gFront, this.pin1Dy0.xPixel1, this.yPixel1, this.pin1Dy1.xPixel1 + 2, this.yPixel0, ScriptToken.GRIDCOLOR);
            if (doDraw1DY) {
                this.fillBox(gFront, this.pin1Dy0.xPixel1, this.pin1Dy0.yPixel1, this.pin1Dy1.xPixel1 + 2, this.pin1Dy1.yPixel0, ScriptToken.PLOTCOLOR);
            }
        }
        for (int i = 0; i < this.widgets.length; ++i) {
            PlotWidget pw = this.widgets[i];
            if (pw == null || !pw.isPinOrCursor && !this.zoomEnabled) continue;
            boolean isLockedCursor = pw == this.cur1D2x1 || pw == this.cur1D2x2 || pw == this.cur2Dx0 || pw == this.cur2Dx1 || pw == this.cur2Dy;
            if ((pw.isPin || !pw.isPinOrCursor) == postGrid) continue;
            if (pw.is2D) {
                if (pw == this.cur2Dx0 && !doDraw1DObjects) {
                    continue;
                }
            } else {
                boolean isPin1Dy;
                boolean bl = isPin1Dy = pw == this.pin1Dy0 || pw == this.pin1Dy1 || pw == this.pin1Dy01;
                if ((this.imageView != null && doDraw1DObjects == isPin1Dy || isPin1Dy && !doDraw1DY || pw == this.cur1D2x1 && this.gs2dLinkedX == null || pw == this.cur1D2x2 && this.gs2dLinkedY == null || pw == this.zoomBox1D && (this.pd.isIntegralDrag || this.pd.integralShiftMode != 0)) && (!this.isLinked || this.imageView != null)) continue;
            }
            if (this.pd.isPrinting && !isLockedCursor) continue;
            if (pw.isPinOrCursor) {
                this.setColorFromToken(gFront, pw.color);
                this.g2d.drawLine(gFront, pw.xPixel0, pw.yPixel0, pw.xPixel1, pw.yPixel1);
                pw.isVisible = true;
                if (!pw.isPin) continue;
                this.drawHandle(gFront, pw.xPixel0, pw.yPixel0, 2, !pw.isEnabled);
                continue;
            }
            if (pw.xPixel1 == pw.xPixel0) continue;
            this.fillBox(gBack, pw.xPixel0, pw.yPixel0, pw.xPixel1, pw.yPixel1, pw == this.zoomBox1D && this.pd.shiftPressed ? ScriptToken.ZOOMBOXCOLOR2 : ScriptToken.ZOOMBOXCOLOR);
        }
    }

    private void drawBar(Object g, PeakInfo pi, double xMin, double xMax, ScriptToken whatColor, int tickSize) {
        int x2;
        int x1;
        double r = xMax + xMin;
        double d = Math.abs(xMax - xMin);
        double range = Math.abs(this.toX(this.xPixel1) - this.toX(this.xPixel0));
        if (tickSize > 0 && d > range / 20.0) {
            d = range / 20.0;
            xMin = r / 2.0 - d;
            xMax = r / 2.0 + d;
        }
        if ((x1 = this.toPixelX(xMin)) > (x2 = this.toPixelX(xMax))) {
            int tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        x1 = this.fixX(x1);
        if ((x2 = this.fixX(x2)) - x1 < 3) {
            x1 -= 2;
            x2 += 2;
        }
        if (pi != null) {
            pi.setPixelRange(x1, x2);
        }
        if (tickSize == 0) {
            this.fillBox(g, x1, this.yPixel0, x2, this.yPixel0 + this.yPixels, whatColor);
        } else {
            this.fillBox(g, x1, this.yPixel0 + 2, x2, this.yPixel0 + 5, whatColor);
            if (pi != null) {
                x1 = (x1 + x2) / 2;
                this.fillBox(g, x1 - 1, this.yPixel0 + 2, x1 + 1, this.yPixel0 + 2 + tickSize, whatColor);
            }
        }
    }

    private void drawIntegration(Object gFront, int index, int yOffset, boolean isGrey, IntegralData iData, boolean isContinuous, boolean isSelected) {
        Lst<Annotation> ratios;
        if (iData != null) {
            if (this.haveIntegralDisplayed(index)) {
                this.drawPlot(gFront, index, (Spectrum)this.spectra.get(index), true, yOffset, false, iData, true, false);
            }
            this.drawIntegralValues(gFront, index, yOffset);
        }
        if ((ratios = this.getIntegrationRatios(index)) != null) {
            this.drawAnnotations(gFront, ratios, ScriptToken.INTEGRALPLOTCOLOR);
        }
    }

    private MeasurementData getMeasurements(Annotation.AType type, int iSpec) {
        AnnotationData ad = this.getDialog(type, iSpec);
        return ad == null || ad.getData().size() == 0 || !ad.getState() ? null : ad.getData();
    }

    private void drawPlot(Object g, int index, Spectrum spec, boolean isContinuous, int yOffset, boolean isGrey, IntegralData ig, boolean isSelected, boolean hasPendingIntegral) {
        boolean fillPeaks;
        Coordinate[] xyCoords = ig == null ? spec.getXYCoords() : this.getIntegrationGraph(index).getXYCoords();
        boolean isIntegral = ig != null;
        BS bsDraw = isIntegral ? ig.getBitSet() : null;
        boolean bl = fillPeaks = hasPendingIntegral || spec.fillColor != null && isSelected;
        int iColor = isGrey ? -2 : (isIntegral ? -1 : (!this.allowStacking ? 0 : index));
        this.setPlotColor(g, iColor);
        boolean plotOn = true;
        int y0 = this.toPixelY(0.0);
        if (isIntegral) {
            fillPeaks &= y0 == this.fixY(y0);
        } else {
            y0 = this.fixY(y0);
        }
        GenericColor cInt = isIntegral || fillPeaks ? this.pd.getColor(ScriptToken.INTEGRALPLOTCOLOR) : null;
        GenericColor cFill = cInt == null || spec.fillColor == null ? cInt : spec.fillColor;
        int iFirst = this.viewData.getStartingPointIndex(index);
        int iLast = this.viewData.getEndingPointIndex(index);
        if (isContinuous) {
            boolean doLineTo;
            --iLast;
            boolean bl2 = doLineTo = (isIntegral || this.pendingIntegral != null) && this.g2d.canDoLineTo();
            if (doLineTo) {
                this.g2d.doStroke(g, true);
            }
            boolean isDown = false;
            for (int i = iFirst; i <= iLast; ++i) {
                int y2;
                int y1;
                Coordinate point1 = xyCoords[i];
                Coordinate point2 = xyCoords[i + 1];
                int n = y1 = isIntegral ? this.toPixelYint(point1.getYVal()) : this.toPixelY(point1.getYVal());
                if (y1 == Integer.MIN_VALUE) continue;
                int n2 = y2 = isIntegral ? this.toPixelYint(point2.getYVal()) : this.toPixelY(point2.getYVal());
                if (y2 == Integer.MIN_VALUE) continue;
                double xv1 = point1.getXVal();
                double xv2 = point2.getXVal();
                int x1 = this.toPixelX(xv1);
                int x2 = this.toPixelX(xv2);
                y1 = this.fixY(yOffset + y1);
                y2 = this.fixY(yOffset + y2);
                if (isIntegral) {
                    if (i == iFirst) {
                        this.xPixelPlot1 = x1;
                        this.yPixelPlot0 = y1;
                    }
                    this.xPixelPlot0 = x2;
                    this.yPixelPlot1 = y2;
                }
                if (x2 == x1 && y1 == y2) continue;
                if (fillPeaks && hasPendingIntegral && this.pendingIntegral.overlaps(xv1, xv2)) {
                    if (cFill != null) {
                        this.g2d.doStroke(g, false);
                        this.g2d.setGraphicsColor(g, cFill);
                    }
                    this.g2d.fillRect(g, Math.min(x1, x2), Math.min(y0, y1), Math.max(1, Math.abs(x2 - x1)), Math.abs(y0 - y1));
                    if (cFill == null) continue;
                    this.g2d.doStroke(g, false);
                    this.g2d.doStroke(g, true);
                    isDown = false;
                    this.setPlotColor(g, iColor);
                    continue;
                }
                if (y1 == y2 && y1 == this.yPixel0) continue;
                if (bsDraw != null && bsDraw.get(i) != plotOn) {
                    plotOn = bsDraw.get(i);
                    if (doLineTo && isDown) {
                        this.g2d.doStroke(g, false);
                        this.g2d.doStroke(g, true);
                        isDown = false;
                    }
                    if (!this.pd.isPrinting && this.pd.integralShiftMode != 0) {
                        this.setPlotColor(g, 0);
                    } else if (plotOn) {
                        this.setColorFromToken(g, ScriptToken.INTEGRALPLOTCOLOR);
                    } else {
                        this.setPlotColor(g, -3);
                    }
                }
                if (this.pd.isPrinting && !plotOn) continue;
                if (isDown) {
                    this.g2d.lineTo(g, x2, y2);
                    continue;
                }
                this.g2d.drawLine(g, x1, y1, x2, y2);
                isDown = doLineTo;
            }
            if (doLineTo) {
                this.g2d.doStroke(g, false);
            }
        } else {
            int y;
            for (int i = iFirst; i <= iLast; ++i) {
                Coordinate point = xyCoords[i];
                int y2 = this.toPixelY(point.getYVal());
                if (y2 == Integer.MIN_VALUE) continue;
                int x1 = this.toPixelX(point.getXVal());
                int y1 = this.toPixelY(Math.max(this.getScale().minYOnScale, 0.0));
                if ((y1 = this.fixY(yOffset + y1)) == (y2 = this.fixY(yOffset + y2)) && (y1 == this.yPixel0 || y1 == this.yPixel1)) continue;
                this.g2d.drawLine(g, x1, y1, x1, y2);
            }
            if (this.getScale().isYZeroOnScale() && (y = yOffset + this.toPixelY(this.getScale().spectrumYRef)) == this.fixY(y)) {
                this.g2d.drawLine(g, this.xPixel1, y, this.xPixel0, y);
            }
        }
    }

    private void drawFrame(Object g, int iSpec, boolean addCurrentBox, boolean addSplitBox, boolean drawUpDownArrows) {
        if (!this.pd.gridOn || this.pd.isPrinting) {
            this.setColorFromToken(g, ScriptToken.GRIDCOLOR);
            this.g2d.drawRect(g, this.xPixel0, this.yPixel0, this.xPixels, this.yPixels);
            if (this.pd.isPrinting) {
                return;
            }
        }
        this.setCurrentBoxColor(g);
        if (drawUpDownArrows) {
            if (iSpec >= 0) {
                this.setPlotColor(g, iSpec);
                this.fillArrow(g, 3, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 - 9, true);
                this.fillArrow(g, 4, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 + 9, true);
                this.setCurrentBoxColor(g);
            }
            this.fillArrow(g, 3, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 - 9, false);
            this.fillCircle(g, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2, false);
            this.fillArrow(g, 4, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 + 9, false);
        }
        if (this.imageView != null) {
            return;
        }
        if (addCurrentBox) {
            int x1 = this.xPixel00 + 10;
            int x2 = this.xPixel11 - 10;
            int y1 = this.yPixel00 + 1;
            int y2 = this.yPixel11 - 2;
            this.g2d.drawLine(g, x1, y1, x2, y1);
            this.g2d.drawLine(g, x2, y1, x2, y2);
            this.g2d.drawLine(g, x1, y2, x2, y2);
            this.closerX = Integer.MIN_VALUE;
            this.splitterX = Integer.MIN_VALUE;
            this.drawBox(g, x2 - 10, y1, x2, y1 + 10, null);
            this.g2d.drawLine(g, x2 - 10, y1 + 10, x2, y1);
            this.g2d.drawLine(g, x2, y1 + 10, x2 - 10, y1);
            this.closerX = x2 - 10;
            this.closerY = y1;
            if (addSplitBox) {
                this.fillBox(g, (x2 -= 10) - 10, y1, x2, y1 + 10, null);
                this.splitterX = x2 - 10;
                this.splitterY = y1;
            }
        }
    }

    private void drawGrid(Object g) {
        int x;
        double val;
        double lastX;
        if (!this.pd.gridOn || this.imageView != null) {
            return;
        }
        this.setColorFromToken(g, ScriptToken.GRIDCOLOR);
        if (Double.isNaN(this.getScale().firstX)) {
            lastX = this.getScale().maxXOnScale + this.getScale().steps[0] / 2.0;
            for (val = this.getScale().minXOnScale; val < lastX; val += this.getScale().steps[0]) {
                x = this.toPixelX(val);
                this.g2d.drawLine(g, x, this.yPixel0, x, this.yPixel1);
            }
        } else {
            lastX = this.getScale().maxXOnScale * 1.0001;
            for (val = this.getScale().firstX; val <= lastX; val += this.getScale().steps[0]) {
                x = this.toPixelX(val);
                this.g2d.drawLine(g, x, this.yPixel0, x, this.yPixel1);
            }
        }
        for (val = this.getScale().firstY; val < this.getScale().maxYOnScale + this.getScale().steps[1] / 2.0; val += this.getScale().steps[1]) {
            int y = this.toPixelY(val);
            if (y != this.fixY(y)) continue;
            this.g2d.drawLine(g, this.xPixel0, y, this.xPixel1, y);
        }
    }

    private void drawXScale(Object g, XYScaleConverter c) {
        this.setColorFromToken(g, ScriptToken.SCALECOLOR);
        if (this.pd.isPrinting) {
            this.g2d.drawLine(g, c.getXPixel0(), this.yPixel1, c.getXPixel0() + c.getXPixels() - 1, this.yPixel1);
        }
        int precision = this.getScale().precision[0];
        Font font = this.pd.setFont(g, c.getXPixels(), 0, this.pd.isPrinting ? 10.0f : 12.0f, false);
        int y1 = this.yPixel1;
        int y2 = this.yPixel1 + 4 * this.pd.scalingFactor;
        int y3 = this.yPixel1 + 2 * this.pd.scalingFactor;
        int h = font.getHeight();
        double dx = c.toPixelX(this.getScale().steps[0]) - c.toPixelX(0.0);
        double maxWidth = Math.abs(dx * 0.95);
        double firstX = this.getScale().firstX - this.getScale().steps[0];
        double lastX = (this.getScale().maxXOnScale + this.getScale().steps[0]) * 1.0001;
        for (int pass = 0; pass < 2; ++pass) {
            if (pass == 1) {
                ScaleData.fixScale(this.mapX);
            }
            double prevX = 1.0E10;
            block5: for (double val = firstX; val <= lastX; val += this.getScale().steps[0]) {
                int x = c.toPixelX(val);
                Double d = val;
                switch (pass) {
                    case 0: {
                        String s = DF.formatDecimalDbl(val, precision);
                        this.mapX.put(d, s);
                        this.drawTick(g, x, y1, y2, c);
                        dx = Math.abs(prevX - val);
                        int ntick = this.getScale().minorTickCounts[0];
                        if (ntick != 0) {
                            double step = dx / (double)ntick;
                            for (int i = 1; i < ntick; ++i) {
                                double x1 = val - (double)i * step;
                                this.drawTick(g, c.toPixelX(x1), y1, y3, c);
                            }
                        }
                        prevX = val;
                        continue block5;
                    }
                    case 1: {
                        int n;
                        String s = this.mapX.get(d);
                        if (s == null || x != c.fixX(x)) continue block5;
                        int w = this.pd.getStringWidth(s);
                        int n2 = n = x + w / 2 == c.fixX(x + w / 2) ? 2 : 0;
                        if (n > 0) {
                            this.g2d.drawString(g, s, x - w / n, y2 + h);
                        }
                        val += Math.floor((double)w / maxWidth) * this.getScale().steps[0];
                    }
                }
            }
        }
        this.mapX.clear();
    }

    private void drawTick(Object g, int x, int y1, int y2, XYScaleConverter c) {
        if (x == c.fixX(x)) {
            this.g2d.drawLine(g, x, y1, x, y2);
        }
    }

    private void drawYScale(Object g, XYScaleConverter c) {
        ScaleData sd = c.getScale();
        int precision = sd.precision[1];
        Font font = this.pd.setFont(g, c.getXPixels(), 0, this.pd.isPrinting ? 10.0f : 12.0f, false);
        int h = font.getHeight();
        double max = sd.maxYOnScale + sd.steps[1] / 2.0;
        int yLast = Integer.MIN_VALUE;
        this.setColorFromToken(g, ScriptToken.SCALECOLOR);
        for (int pass = 0; pass < 2; ++pass) {
            if (pass == 1) {
                ScaleData.fixScale(this.mapX);
            }
            block5: for (double val = sd.firstY; val < max; val += sd.steps[1]) {
                Double d = val;
                int x1 = c.getXPixel0();
                int y = c.toPixelY(val);
                if (y != c.fixY(y)) continue;
                if (pass == 0) {
                    this.g2d.drawLine(g, x1, y, x1 - 3 * this.pd.scalingFactor, y);
                }
                if (Math.abs(y - yLast) <= h) continue;
                yLast = y;
                switch (pass) {
                    case 0: {
                        String s = DF.formatDecimalDbl(val, precision);
                        this.mapX.put(d, s);
                        continue block5;
                    }
                    case 1: {
                        String s = this.mapX.get(d);
                        if (s == null) continue block5;
                        if (s.startsWith("0") && s.contains("E")) {
                            s = "0";
                        }
                        this.g2d.drawString(g, s, x1 - 4 * this.pd.scalingFactor - this.pd.getStringWidth(s), y + h / 3);
                    }
                }
            }
        }
        this.mapX.clear();
    }

    private void drawXUnits(Object g) {
        String units = ((Spectrum)this.spectra.get(0)).getAxisLabel(true);
        if (units != null) {
            this.drawUnits(g, units, this.xPixel1 + 25 * this.pd.scalingFactor, this.yPixel1 + 5 * this.pd.scalingFactor, 1.0, 1.0);
        }
    }

    private void drawUnits(Object g, String s, int x, int y, double hOff, double vOff) {
        this.setColorFromToken(g, ScriptToken.UNITSCOLOR);
        this.pd.setFont(g, (this.imageView == null ? this : this.imageView).getXPixels(), 3, 10.0f, false);
        this.g2d.drawString(g, s, (int)((double)x - (double)this.pd.getStringWidth(s) * hOff), (int)((double)y + (double)this.pd.getFontHeight() * vOff));
    }

    private void drawYUnits(Object g) {
        String units = ((Spectrum)this.spectra.get(0)).getAxisLabel(false);
        if (units != null) {
            this.drawUnits(g, units, (this.pd.isPrinting ? 30 : 5) * this.pd.scalingFactor, this.yPixel0 + (this.pd.isPrinting ? 0 : 5) * this.pd.scalingFactor, 0.0, -1.0);
        }
    }

    private void drawHighlightsAndPeakTabs(Object gFront, Object gBack, int iSpec) {
        MeasurementData md = this.getMeasurements(Annotation.AType.PeakList, iSpec);
        Spectrum spec = (Spectrum)this.spectra.get(iSpec);
        if (this.pd.isPrinting) {
            if (md != null) {
                this.setColorFromToken(gFront, ScriptToken.PEAKTABCOLOR);
                this.printPeakList(gFront, spec, (PeakData)md);
            }
            return;
        }
        if (md == null) {
            for (int i = 0; i < this.highlights.size(); ++i) {
                Highlight hl = (Highlight)this.highlights.get(i);
                if (hl.spectrum != spec) continue;
                this.pd.setHighlightColor(hl.color);
                this.drawBar(gBack, null, hl.x1, hl.x2, ScriptToken.HIGHLIGHTCOLOR, 0);
            }
            if (this.pd.peakTabsOn) {
                this.drawPeakTabs(gFront, gBack, spec);
            }
        }
        if (md != null) {
            int y = spec.isInverted() ? this.yPixel1 - 10 * this.pd.scalingFactor : this.yPixel0;
            this.setColorFromToken(gFront, ScriptToken.PEAKTABCOLOR);
            int i = md.size();
            while (--i >= 0) {
                Measurement m = (Measurement)md.get(i);
                int x = this.toPixelX(m.getXVal());
                this.g2d.drawLine(gFront, x, y, x, y + 10 * this.pd.scalingFactor);
            }
            if (this.isVisible(this.getDialog(Annotation.AType.PeakList, iSpec)) && (y = this.toPixelY(((PeakData)md).getThresh())) == this.fixY(y) && !this.pd.isPrinting) {
                this.g2d.drawLine(gFront, this.xPixel0, y, this.xPixel1, y);
            }
        }
    }

    private void printPeakList(Object g, Spectrum spec, PeakData data) {
        int i;
        int i2;
        String[][] sdata = data.getMeasurementListArray(null);
        if (sdata.length == 0) {
            return;
        }
        this.pd.setFont(g, this.xPixels, 0, 8.0f, false);
        int h = this.pd.getFontHeight();
        int[] xs = new int[data.size()];
        int[] xs0 = new int[data.size()];
        int dx = 0;
        int s5 = 5 * this.pd.scalingFactor;
        int s10 = 10 * this.pd.scalingFactor;
        int s15 = 15 * this.pd.scalingFactor;
        int s25 = 25 * this.pd.scalingFactor;
        for (i2 = 0; i2 < sdata.length; ++i2) {
            xs0[i2] = this.toPixelX(Double.parseDouble(sdata[i2][1]));
            if (i2 == 0) {
                xs[i2] = xs0[i2];
                continue;
            }
            xs[i2] = Math.max(xs[i2 - 1] + h, xs0[i2] + h);
            dx += xs[i2] - xs0[i2];
        }
        if (xs[0] - (dx /= 2 * sdata.length) < this.xPixel0 + s25) {
            dx = xs[0] - (this.xPixel0 + s25);
        }
        i2 = 0;
        while (i2 < sdata.length) {
            int n = i2++;
            xs[n] = xs[n] - dx;
        }
        boolean inverted = spec.isInverted();
        int y4 = this.pd.getStringWidth("99.9999");
        int y2 = sdata[0].length >= 6 ? this.pd.getStringWidth("99.99") : 0;
        int f = inverted ? -1 : 1;
        int y = (inverted ? this.yPixel1 : this.yPixel0) + f * (y2 + y4 + s15);
        for (i = 0; i < sdata.length; ++i) {
            this.g2d.drawLine(g, xs[i], y, xs[i], y + s5 * f);
            this.g2d.drawLine(g, xs[i], y + s5 * f, xs0[i], y + s10 * f);
            this.g2d.drawLine(g, xs0[i], y + s10 * f, xs0[i], y + s15 * f);
            if (y2 <= 0 || sdata[i][4].length() <= 0) continue;
            this.g2d.drawLine(g, (xs[i] + xs[i - 1]) / 2, y - y4 + s5, (xs[i] + xs[i - 1]) / 2, y - y4 - s5);
        }
        y -= f * 2 * this.pd.scalingFactor;
        if (y2 > 0) {
            this.drawStringRotated(g, -90, xs[0] - s15, y, "  ppm");
            this.drawStringRotated(g, -90, xs[0] - s15, y - y4 - s5, " Hz");
        }
        i = data.size();
        while (--i >= 0) {
            this.drawStringRotated(g, -90 * f, xs[i] + f * h / 3, y, sdata[i][1]);
            if (y2 <= 0 || sdata[i][4].length() <= 0) continue;
            int x = (xs[i] + xs[i - 1]) / 2 + h / 3;
            this.drawStringRotated(g, -90, x, y - y4 - s5, sdata[i][4]);
        }
    }

    private void drawStringRotated(Object g, int angle, int x, int y, String s) {
        this.g2d.drawStringRotated(g, s, x, y, angle);
    }

    private void drawAnnotations(Object g, Lst<Annotation> annotations, ScriptToken whatColor) {
        this.pd.setFont(g, this.xPixels, 1, 18.0f, false);
        int i = annotations.size();
        while (--i >= 0) {
            Annotation note = (Annotation)annotations.get(i);
            this.setAnnotationColor(g, note, whatColor);
            XYScaleConverter c = note.is2D ? this.imageView : this;
            int x = c.toPixelX(note.getXVal());
            int y = note.isPixels() ? (int)((double)(this.yPixel0 + 10 + 10 * this.pd.scalingFactor) - note.getYVal()) : (note.is2D ? this.imageView.subIndexToPixelY((int)note.getYVal()) : this.toPixelY(note.getYVal()));
            this.g2d.drawString(g, note.text, x + note.offsetX * this.pd.scalingFactor, y - note.offsetY * this.pd.scalingFactor);
        }
    }

    private void drawIntegralValues(Object g, int iSpec, int yOffset) {
        MeasurementData integrals = this.getMeasurements(Annotation.AType.Integration, iSpec);
        if (integrals != null) {
            if (this.pd.isPrinting) {
                this.pd.setFont(g, this.xPixels, 0, 8.0f, false);
            } else {
                this.pd.setFont(g, this.xPixels, 1, 12.0f, false);
            }
            this.setColorFromToken(g, ScriptToken.INTEGRALPLOTCOLOR);
            int h = this.pd.getFontHeight();
            this.g2d.setStrokeBold(g, true);
            int i = integrals.size();
            while (--i >= 0) {
                Measurement in = (Measurement)integrals.get(i);
                if (in.getValue() == 0.0) continue;
                int x = this.toPixelX(in.getXVal2());
                int y1 = yOffset * this.pd.scalingFactor + this.toPixelYint(in.getYVal());
                int y2 = yOffset * this.pd.scalingFactor + this.toPixelYint(in.getYVal2());
                if (x != this.fixX(x) || y1 != this.fixY(y1) || y2 != this.fixY(y2)) continue;
                if (!this.pd.isPrinting) {
                    this.g2d.drawLine(g, x, y1, x, y2);
                }
                String s = "  " + in.text;
                this.g2d.drawString(g, s, x, (y1 + y2) / 2 + h / 3);
            }
            this.g2d.setStrokeBold(g, false);
        }
        if (iSpec == this.getFixedSelectedSpectrumIndex()) {
            this.selectedSpectrumIntegrals = integrals;
        }
    }

    private void drawMeasurements(Object g, int iSpec) {
        MeasurementData md = this.getMeasurements(Annotation.AType.Measurements, iSpec);
        if (md != null) {
            int i = md.size();
            while (--i >= 0) {
                this.drawMeasurement(g, (Measurement)md.get(i));
            }
        }
        if (iSpec == this.getFixedSelectedSpectrumIndex()) {
            this.selectedSpectrumMeasurements = md;
        }
    }

    private void drawMeasurement(Object g, Measurement m) {
        if (m.text.length() == 0 && m != this.pendingMeasurement) {
            return;
        }
        this.pd.setFont(g, this.xPixels, 1, 12.0f, false);
        this.g2d.setGraphicsColor(g, m == this.pendingMeasurement ? this.pd.getColor(ScriptToken.PEAKTABCOLOR) : this.pd.BLACK);
        int x1 = this.toPixelX(m.getXVal());
        int y1 = this.toPixelY(m.getYVal());
        int x2 = this.toPixelX(m.getXVal2());
        if (Double.isNaN(m.getXVal()) || x1 != this.fixX(x1) || x2 != this.fixX(x2)) {
            return;
        }
        boolean drawString = Math.abs(x1 - x2) >= 2;
        boolean drawBaseLine = this.getScale().isYZeroOnScale() && m.spec.isHNMR();
        int x = (x1 + x2) / 2;
        this.g2d.setStrokeBold(g, true);
        if (drawString) {
            this.g2d.drawLine(g, x1, y1, x2, y1);
        }
        if (drawBaseLine) {
            this.g2d.drawLine(g, x1 + 1, this.yPixel1 - 1, x2, this.yPixel1 - 1);
        }
        this.g2d.setStrokeBold(g, false);
        if (drawString) {
            this.g2d.drawString(g, m.text, x + m.offsetX, y1 - m.offsetY);
        }
        if (drawBaseLine) {
            this.g2d.drawLine(g, x1, this.yPixel1, x1, this.yPixel1 - 6 * this.pd.scalingFactor);
            this.g2d.drawLine(g, x2, this.yPixel1, x2, this.yPixel1 - 6 * this.pd.scalingFactor);
        }
    }

    private PlotWidget getPinSelected(int xPixel, int yPixel) {
        if (this.widgets != null) {
            for (int i = 0; i < this.widgets.length; ++i) {
                if (this.widgets[i] == null || !this.widgets[i].isPinOrCursor || !this.widgets[i].selected(xPixel, yPixel)) continue;
                return this.widgets[i];
            }
        }
        return null;
    }

    void set2DCrossHairs(int xPixel, int yPixel) {
        if (xPixel == this.imageView.fixX(xPixel) && yPixel == this.fixY(yPixel)) {
            double x = this.imageView.toX(xPixel);
            this.pin1Dx1.setX(x, this.toPixelX(x));
            this.cur2Dx1.setX(x, xPixel);
            this.setCurrentSubSpectrum(this.imageView.toSubspectrumIndex(yPixel));
            if (this.isLinked) {
                double y = this.imageView.toY(yPixel);
                this.pd.set2DCrossHairsLinked(this, x, y, !this.sticky2Dcursor);
            }
        }
    }

    private void reset2D(boolean isX) {
        if (isX) {
            this.imageView.setView0(this.imageView.xPixel0, this.pin2Dy0.yPixel0, this.imageView.xPixel1, this.pin2Dy1.yPixel0);
            this.doZoom(0.0, this.getScale().minY, 0.0, this.getScale().maxY, true, false, false, false, true);
        } else {
            this.imageView.setView0(this.pin2Dx0.xPixel0, this.imageView.yPixel0, this.pin2Dx1.xPixel0, this.imageView.yPixel1);
        }
    }

    private boolean setAnnotationText(Annotation a) {
        String sval = this.pd.getInput("New text?", "Set Label", a.text);
        if (sval == null) {
            return false;
        }
        if (sval.length() == 0) {
            this.annotations.removeObj(a);
        } else {
            a.text = sval;
        }
        return true;
    }

    private boolean checkIntegral(double x1, double x2, boolean isFinal) {
        AnnotationData ad = this.getDialog(Annotation.AType.Integration, -1);
        if (ad == null) {
            return false;
        }
        Integral integral = ((IntegralData)ad.getData()).addIntegralRegion(x1, x2);
        if (isFinal && ad instanceof JSVDialog) {
            ((JSVDialog)ad).update(null, 0.0, 0);
        }
        if (Double.isNaN(x2)) {
            return false;
        }
        this.pendingIntegral = isFinal ? null : integral;
        this.pd.isIntegralDrag = !isFinal;
        this.selectedSpectrumIntegrals = null;
        return true;
    }

    private void setToolTipForPixels(int xPixel, int yPixel) {
        if (this.iSpectrumMovedTo != this.iSpectrumClicked || this.pd.getCurrentGraphSet() != this) {
            this.pd.setToolTipText("click spectrum to activate");
            return;
        }
        if (this.isSplitWidget(xPixel, yPixel)) {
            this.pd.setToolTipText("click to " + (this.nSplit > 1 ? "combine" : "split"));
            return;
        }
        if (this.isCloserWidget(xPixel, yPixel)) {
            this.pd.setToolTipText("click to close");
            return;
        }
        PlotWidget pw = this.getPinSelected(xPixel, yPixel);
        int precisionX = this.getScale().precision[0];
        int precisionY = this.getScale().precision[1];
        if (pw != null) {
            String s;
            if (this.setStartupPinTip()) {
                return;
            }
            if (pw == this.pin1Dx01 || pw == this.pin2Dx01) {
                s = DF.formatDecimalDbl(Math.min(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()), precisionX) + " - " + DF.formatDecimalDbl(Math.max(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()), precisionX);
            } else if (pw == this.pin1Dy01) {
                s = DF.formatDecimalDbl(Math.min(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()), precisionY) + " - " + DF.formatDecimalDbl(Math.max(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()), precisionY);
            } else if (pw == this.cur2Dy) {
                int isub = this.imageView.toSubspectrumIndex(pw.yPixel0);
                s = this.get2DYLabel(isub, precisionX);
            } else {
                s = pw == this.pin2Dy01 ? "" + (int)Math.min(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) + " - " + (int)Math.max(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) : (pw.isXtype ? DF.formatDecimalDbl(pw.getXVal(), precisionX) : (pw.is2D ? "" + (int)pw.getYVal() : DF.formatDecimalDbl(pw.getYVal(), precisionY)));
            }
            this.pd.setToolTipText(s);
            return;
        }
        if (this.imageView != null) {
            if (this.imageView.fixX(xPixel) == xPixel && this.fixY(yPixel) == yPixel) {
                int isub = this.imageView.toSubspectrumIndex(yPixel);
                String s = "y=" + this.get2DYLabel(isub, precisionX) + " / x=" + DF.formatDecimalDbl(this.imageView.toX(xPixel), precisionX) + " " + this.getSpectrum().getAxisLabel(true);
                this.pd.setToolTipText(s);
                this.pd.coordStr = s;
                return;
            }
            if (!this.pd.display1D) {
                this.pd.setToolTipText("");
                this.pd.coordStr = "";
                return;
            }
        }
        double xPt = this.toX(this.fixX(xPixel));
        double yPt = this.imageView != null && this.imageView.isXWithinRange(xPixel) ? (double)this.imageView.toSubspectrumIndex(this.fixY(yPixel)) : this.toY(this.fixY(yPixel));
        String xx = this.setCoordStr(xPt, yPt);
        int iSpec = this.getFixedSelectedSpectrumIndex();
        if (!this.isInPlotRegion(xPixel, yPixel)) {
            yPt = Double.NaN;
        } else if (this.nSpectra != 1 && this.haveIntegralDisplayed(iSpec)) {
            yPt = this.getIntegrationGraph(iSpec).getPercentYValueAt(xPt);
            xx = xx + ", " + DF.formatDecimalDbl(yPt, 1);
        }
        this.pd.setToolTipText((String)(this.selectedIntegral != null ? "click to set value" : (this.pendingMeasurement != null || this.selectedMeasurement != null ? (this.pd.hasFocus() ? "Press ESC to delete " + (this.selectedIntegral != null ? "integral, DEL to delete all visible, or N to normalize" : (this.pendingMeasurement == null ? "\"" + this.selectedMeasurement.text + "\" or DEL to delete all visible" : "measurement")) : "") : (Double.isNaN(yPt) ? null : xx))));
    }

    private boolean isFrameBox(int xPixel, int yPixel, int boxX, int boxY) {
        return Math.abs(xPixel - (boxX + 5)) < 5 && Math.abs(yPixel - (boxY + 5)) < 5;
    }

    private String setCoordStr(double xPt, double yPt) {
        String xx = DF.formatDecimalDbl(xPt, this.getScale().precision[0]);
        this.pd.coordStr = "(" + xx + (this.haveSingleYScale || this.iSpectrumSelected >= 0 ? ", " + DF.formatDecimalDbl(yPt, this.getScale().precision[1]) : "") + ")";
        return xx;
    }

    private boolean setStartupPinTip() {
        if (this.pd.startupPinTip == null) {
            return false;
        }
        this.pd.setToolTipText(this.pd.startupPinTip);
        this.pd.startupPinTip = null;
        return true;
    }

    private String get2DYLabel(int isub, int precision) {
        Spectrum spec = (Spectrum)this.getSpectrumAt(0).getSubSpectra().get(isub);
        return DF.formatDecimalDbl(spec.getY2DPPM(), precision) + " PPM" + (spec.y2DUnits.equals("HZ") ? " (" + DF.formatDecimalDbl(spec.getY2D(), precision) + " HZ) " : "");
    }

    private boolean isOnSpectrum(int xPixel, int yPixel, int index) {
        boolean isIntegral;
        Coordinate[] xyCoords = null;
        boolean isContinuous = true;
        boolean bl = isIntegral = index < 0;
        if (isIntegral) {
            AnnotationData ad = this.getDialog(Annotation.AType.Integration, -1);
            if (ad == null) {
                return false;
            }
            xyCoords = ((IntegralData)ad.getData()).getXYCoords();
            index = this.getFixedSelectedSpectrumIndex();
        } else {
            this.setScale(index);
            Spectrum spec = (Spectrum)this.spectra.get(index);
            xyCoords = spec.xyCoords;
            isContinuous = spec.isContinuous();
        }
        int yOffset = index * (int)((float)this.yPixels * ((float)this.yStackOffsetPercent / 100.0f));
        int ix0 = this.viewData.getStartingPointIndex(index);
        int ix1 = this.viewData.getEndingPointIndex(index);
        if (isContinuous) {
            for (int i = ix0; i < ix1; ++i) {
                int y2;
                Coordinate point1 = xyCoords[i];
                Coordinate point2 = xyCoords[i + 1];
                int x1 = this.toPixelX(point1.getXVal());
                int x2 = this.toPixelX(point2.getXVal());
                int y1 = isIntegral ? this.toPixelYint(point1.getYVal()) : this.toPixelY(point1.getYVal());
                int n = y2 = isIntegral ? this.toPixelYint(point2.getYVal()) : this.toPixelY(point2.getYVal());
                if (y1 == Integer.MIN_VALUE || y2 == Integer.MIN_VALUE || !GraphSet.isOnLine(xPixel, yPixel, x1, y1 = this.fixY(y1) - yOffset, x2, y2 = this.fixY(y2) - yOffset)) continue;
                return true;
            }
        } else {
            for (int i = ix0; i <= ix1; ++i) {
                Coordinate point = xyCoords[i];
                int y2 = this.toPixelY(point.getYVal());
                if (y2 == Integer.MIN_VALUE) continue;
                int x1 = this.toPixelX(point.getXVal());
                int y1 = this.toPixelY(Math.max(this.getScale().minYOnScale, 0.0));
                if ((y1 = this.fixY(y1)) == (y2 = this.fixY(y2)) && (y1 == this.yPixel0 || y1 == this.yPixel1) || !GraphSet.isOnLine(xPixel, yPixel, x1, y1, x1, y2)) continue;
                return true;
            }
        }
        return false;
    }

    private static double distance(int dx, int dy) {
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static GraphSet findCompatibleGraphSet(Lst<GraphSet> graphSets, Spectrum spec) {
        for (int i = 0; i < graphSets.size(); ++i) {
            if (!Spectrum.areXScalesCompatible(spec, ((GraphSet)graphSets.get(i)).getSpectrum(), false, false)) continue;
            return (GraphSet)graphSets.get(i);
        }
        return null;
    }

    private static boolean isGoodEvent(PlotWidget zOrP, PlotWidget p, boolean asX) {
        return p == null ? Math.abs(zOrP.xPixel1 - zOrP.xPixel0) > 5 && Math.abs(zOrP.yPixel1 - zOrP.yPixel0) > 5 : (asX ? Math.abs(zOrP.xPixel0 - p.xPixel0) > 5 : Math.abs(zOrP.yPixel0 - p.yPixel0) > 5);
    }

    private static boolean isOnLine(int xPixel, int yPixel, int x1, int y1, int x2, int y2) {
        int dx1 = Math.abs(x1 - xPixel);
        if (dx1 < 2 && Math.abs(y1 - yPixel) < 2) {
            return true;
        }
        int dx2 = x2 - xPixel;
        if (Math.abs(dx2) < 2 && Math.abs(y2 - yPixel) < 2) {
            return true;
        }
        int dy12 = y1 - y2;
        if (Math.abs(dy12) > 2 && y1 < yPixel == y2 < yPixel) {
            return false;
        }
        int dx12 = x1 - x2;
        if (Math.abs(dx12) > 2 && x1 < xPixel == x2 < xPixel) {
            return false;
        }
        return GraphSet.distance(dx1, y1 - yPixel) + GraphSet.distance(dx2, yPixel - y2) < GraphSet.distance(dx12, dy12) + 2.0;
    }

    private static void setFractionalPositions(PanelData pd, Lst<GraphSet> graphSets, PanelData.LinkMode linkMode) {
        int n = graphSets.size();
        double f = 0.0;
        int n2d = 1;
        double y = 0.0;
        boolean bl = pd.isLinked = linkMode != PanelData.LinkMode.NONE;
        if (linkMode == PanelData.LinkMode.NONE) {
            GraphSet gs;
            int i;
            for (i = 0; i < n; ++i) {
                gs = (GraphSet)graphSets.get(i);
                f += (double)((gs.getSpectrumAt(0).is1D() ? 1 : n2d) * gs.nSplit);
            }
            f = 1.0 / f;
            for (i = 0; i < n; ++i) {
                gs = (GraphSet)graphSets.get(i);
                gs.isLinked = false;
                double g = gs.getSpectrumAt(0).is1D() ? f : (double)n2d * f;
                gs.fX0 = 0.0;
                gs.fY0 = y;
                gs.fracX = 1.0;
                gs.fracY = g;
                y += g * (double)gs.nSplit;
            }
        } else {
            GraphSet gs;
            int i;
            GraphSet gs2d = null;
            int i2d = -1;
            if (n == 2 || n == 3) {
                for (i = 0; i < n; ++i) {
                    gs = (GraphSet)graphSets.get(i);
                    if (gs.getSpectrum().is1D()) continue;
                    gs2d = gs;
                    if (i2d >= 0) {
                        i = -2;
                    }
                    i2d = i;
                    break;
                }
            }
            if (i2d == -2 || i2d == -1 && n != 2) {
                GraphSet.setFractionalPositions(pd, graphSets, PanelData.LinkMode.NONE);
                return;
            }
            for (i = 0; i < n; ++i) {
                gs = (GraphSet)graphSets.get(i);
                gs.isLinked = true;
                Spectrum s1 = gs.getSpectrumAt(0);
                boolean is1D = s1.is1D();
                if (is1D) {
                    if (gs2d != null) {
                        Spectrum s2 = gs2d.getSpectrumAt(0);
                        if (Spectrum.areLinkableX(s1, s2)) {
                            gs.gs2dLinkedX = gs2d;
                        }
                        if (Spectrum.areLinkableY(s1, s2)) {
                            gs.gs2dLinkedY = gs2d;
                        }
                    }
                    gs.fX0 = 0.0;
                    gs.fY0 = y;
                    gs.fracX = gs2d == null ? 1.0 : 0.5;
                    gs.fracY = n == 3 || gs2d == null ? 0.5 : 1.0;
                    y += 0.5;
                    continue;
                }
                gs.fX0 = 0.5;
                gs.fY0 = 0.0;
                gs.fracX = 0.5;
                gs.fracY = 1.0;
            }
        }
    }

    String addAnnotation(Lst<String> args, String title) {
        Annotation annotation;
        if (args.size() == 0 || args.size() == 1 && ((String)args.get(0)).equalsIgnoreCase("none")) {
            this.annotations = null;
            this.lastAnnotation = null;
            return null;
        }
        if (args.size() < 4 && this.lastAnnotation == null) {
            this.lastAnnotation = this.getAnnotation((this.getScale().maxXOnScale + this.getScale().minXOnScale) / 2.0, (this.getScale().maxYOnScale + this.getScale().minYOnScale) / 2.0, title, false, false, 0, 0);
        }
        if ((annotation = this.getAnnotation(args, this.lastAnnotation)) == null) {
            return null;
        }
        if (this.annotations == null && args.size() == 1 && ((String)args.get(0)).charAt(0) == '\"') {
            String s = annotation.text;
            this.getSpectrum().setTitle(s);
            return s;
        }
        this.lastAnnotation = annotation;
        this.addAnnotation(annotation, false);
        return null;
    }

    void addHighlight(double x1, double x2, Spectrum spec, GenericColor color) {
        Highlight hl;
        if (spec == null) {
            spec = this.getSpectrumAt(0);
        }
        if (!this.highlights.contains(hl = new Highlight(x1, x2, spec, color == null ? this.pd.getColor(ScriptToken.HIGHLIGHTCOLOR) : color))) {
            this.highlights.addLast(hl);
        }
    }

    void addPeakHighlight(PeakInfo peakInfo) {
        int i = this.spectra.size();
        while (--i >= 0) {
            String peak;
            Spectrum spec = (Spectrum)this.spectra.get(i);
            this.removeAllHighlights(spec);
            if (peakInfo == null || peakInfo.isClearAll() || spec != peakInfo.spectrum || (peak = peakInfo.toString()) == null) continue;
            String xMin = PT.getQuotedAttribute(peak, "xMin");
            String xMax = PT.getQuotedAttribute(peak, "xMax");
            if (xMin == null || xMax == null) {
                return;
            }
            float x1 = PT.parseFloat(xMin);
            float x2 = PT.parseFloat(xMax);
            if (Float.isNaN(x1) || Float.isNaN(x2)) {
                return;
            }
            this.pd.addHighlight(this, x1, x2, spec, 200, 140, 140, 100);
            spec.setSelectedPeak(peakInfo);
            if (this.getScale().isInRangeX(x1) || this.getScale().isInRangeX(x2) || (double)x1 < this.getScale().minX && this.getScale().maxX < (double)x2) continue;
            this.setZoomTo(0);
        }
    }

    void advanceSubSpectrum(int dir) {
        Spectrum spec0 = this.getSpectrumAt(0);
        int i = spec0.advanceSubSpectrum(dir);
        if (spec0.isForcedSubset()) {
            this.viewData.setXRangeForSubSpectrum(this.getSpectrum().getXYCoords());
        }
        this.pd.notifySubSpectrumChange(i, this.getSpectrum());
    }

    synchronized boolean checkSpectrumClickedEvent(int xPixel, int yPixel, int clickCount) {
        if (this.nextClickForSetPeak != null) {
            return false;
        }
        if (clickCount > 1 || this.pendingMeasurement != null || !this.isInPlotRegion(xPixel, yPixel)) {
            return false;
        }
        if (clickCount == 0) {
            boolean isOnIntegral = this.isOnSpectrum(xPixel, yPixel, -1);
            this.pd.integralShiftMode = isOnIntegral ? this.getShiftMode(xPixel, yPixel) : 0;
            boolean bl = this.pd.isIntegralDrag = this.pd.integralShiftMode == 0 && (isOnIntegral || this.haveIntegralDisplayed(-1) && this.findMeasurement(this.getIntegrationGraph(-1), xPixel, yPixel, 0) != null);
            if (this.pd.integralShiftMode != 0) {
                return false;
            }
        }
        if (!this.showAllStacked) {
            return false;
        }
        this.stackSelected = false;
        for (int i = 0; i < this.nSpectra; ++i) {
            if (!this.isOnSpectrum(xPixel, yPixel, i)) continue;
            this.iPreviousSpectrumClicked = i;
            this.setSpectrumClicked(this.iPreviousSpectrumClicked);
            return false;
        }
        if (this.isDialogOpen()) {
            return false;
        }
        this.setSpectrumClicked(-1);
        this.stackSelected = false;
        return false;
    }

    private int getShiftMode(int xPixel, int yPixel) {
        return this.isStartEndIntegral(xPixel, false) ? yPixel : (this.isStartEndIntegral(xPixel, true) ? -yPixel : 0);
    }

    private boolean isDialogOpen() {
        return this.isVisible(this.getDialog(Annotation.AType.Integration, -1)) || this.isVisible(this.getDialog(Annotation.AType.Measurements, -1)) || this.isVisible(this.getDialog(Annotation.AType.PeakList, -1));
    }

    private boolean isStartEndIntegral(int xPixel, boolean isEnd) {
        return isEnd ? this.xPixelPlot1 - xPixel < 20 : xPixel - this.xPixelPlot0 < 20;
    }

    synchronized boolean checkWidgetEvent(int xPixel, int yPixel, boolean isPress) {
        if (!this.triggered) {
            return false;
        }
        this.triggered = false;
        if (isPress) {
            if (this.pd.clickCount == 2 && this.lastIntDragX != xPixel && !this.is2dClick(xPixel, yPixel)) {
                if (this.pendingMeasurement == null) {
                    if (this.iSpectrumClicked == -1 && this.iPreviousSpectrumClicked >= 0) {
                        this.setSpectrumClicked(this.iPreviousSpectrumClicked);
                    }
                    this.processPendingMeasurement(xPixel, yPixel, 2);
                    return true;
                }
            } else if (!this.is2dClick(xPixel, yPixel)) {
                if (this.isOnSpectrum(xPixel, yPixel, -1)) {
                    this.checkIntegral(this.toX(xPixel), Double.NaN, false);
                }
                if (this.lastIntDragX == xPixel) {
                    this.pd.isIntegralDrag = true;
                    if (!this.checkIntegral(this.toX(xPixel), this.toX(xPixel), false)) {
                        return false;
                    }
                }
            }
            if (this.pendingMeasurement != null) {
                return true;
            }
            PlotWidget widget = this.getPinSelected(xPixel, yPixel);
            if (widget == null) {
                yPixel = this.fixY(yPixel);
                if (xPixel < this.xPixel1) {
                    if (this.pd.shiftPressed) {
                        this.setSpectrumClicked(this.iPreviousSpectrumClicked);
                    }
                    xPixel = this.fixX(xPixel);
                    if (this.zoomBox1D == null) {
                        this.newPins();
                    }
                    this.zoomBox1D.setX(this.toX(xPixel), xPixel);
                    this.zoomBox1D.yPixel0 = yPixel;
                    widget = this.zoomBox1D;
                } else if (this.imageView != null && xPixel < this.imageView.xPixel1) {
                    this.zoomBox2D.setX(this.imageView.toX(xPixel), this.imageView.fixX(xPixel));
                    this.zoomBox2D.yPixel0 = yPixel;
                    widget = this.zoomBox2D;
                }
            }
            this.pd.thisWidget = widget;
            return false;
        }
        this.nextClickForSetPeak = null;
        PlotWidget widget = this.pd.thisWidget;
        if (widget == null) {
            return false;
        }
        if (widget == this.zoomBox1D) {
            this.zoomBox1D.xPixel1 = this.fixX(xPixel);
            this.zoomBox1D.yPixel1 = this.fixY(yPixel);
            if (this.pd.isIntegralDrag && this.zoomBox1D.xPixel0 != this.zoomBox1D.xPixel1) {
                if (this.lastIntDragX <= xPixel != this.zoomBox1D.xPixel0 <= xPixel) {
                    this.zoomBox1D.xPixel0 = this.lastIntDragX;
                    this.zoomBox1D.xPixel1 = xPixel;
                    this.zoomBox1D.setXVal(this.toX(this.zoomBox1D.xPixel0));
                }
                this.lastIntDragX = xPixel;
                this.checkIntegral(this.zoomBox1D.getXVal(), this.toX(this.zoomBox1D.xPixel1), false);
            }
            return false;
        }
        if (!this.zoomEnabled) {
            return false;
        }
        if (widget == this.zoomBox2D) {
            this.zoomBox2D.xPixel1 = this.imageView.fixX(xPixel);
            this.zoomBox2D.yPixel1 = this.fixY(yPixel);
            return true;
        }
        if (widget == this.cur2Dy) {
            this.cur2Dy.yPixel0 = this.cur2Dy.yPixel1 = (yPixel = this.fixY(yPixel));
            this.setCurrentSubSpectrum(this.imageView.toSubspectrumIndex(yPixel));
            return true;
        }
        if (widget == this.cur2Dx0 || widget == this.cur2Dx1) {
            return false;
        }
        if (widget == this.pin1Dx0 || widget == this.pin1Dx1 || widget == this.pin1Dx01) {
            xPixel = this.fixX(xPixel);
            widget.setX(this.toX0(xPixel), xPixel);
            if (widget == this.pin1Dx01) {
                int dp = xPixel - (this.pin1Dx0.xPixel0 + this.pin1Dx1.xPixel0) / 2;
                int dp1 = dp < 0 ? dp : dp;
                int dp2 = dp < 0 ? dp : dp;
                xPixel = this.pin1Dx0.xPixel0 + dp2;
                int xPixel1 = this.pin1Dx1.xPixel0 + dp1;
                if (dp == 0 || this.fixX(xPixel) != xPixel || this.fixX(xPixel1) != xPixel1) {
                    return true;
                }
                this.pin1Dx0.setX(this.toX0(xPixel), xPixel);
                this.pin1Dx1.setX(this.toX0(xPixel1), xPixel1);
            }
            this.doZoom(this.pin1Dx0.getXVal(), 0.0, this.pin1Dx1.getXVal(), 0.0, true, false, false, true, false);
            return true;
        }
        if (widget == this.pin1Dy0 || widget == this.pin1Dy1 || widget == this.pin1Dy01) {
            yPixel = this.fixY(yPixel);
            widget.setY(this.toY0(yPixel), yPixel);
            if (widget == this.pin1Dy01) {
                double y1;
                int dp = yPixel - (this.pin1Dy0.yPixel0 + this.pin1Dy1.yPixel0) / 2 + 1;
                yPixel = this.pin1Dy0.yPixel0 + dp;
                int yPixel1 = this.pin1Dy1.yPixel0 + dp;
                double y0 = this.toY0(yPixel);
                if (Math.min(y0, y1 = this.toY0(yPixel1)) == this.getScale().minY || Math.max(y0, y1) == this.getScale().maxY) {
                    return true;
                }
                this.pin1Dy0.setY(y0, yPixel);
                this.pin1Dy1.setY(y1, yPixel1);
            }
            this.doZoom(0.0, this.pin1Dy0.getYVal(), 0.0, this.pin1Dy1.getYVal(), this.imageView == null, this.imageView == null, false, false, false);
            return true;
        }
        if (widget == this.pin2Dx0 || widget == this.pin2Dx1 || widget == this.pin2Dx01) {
            xPixel = this.imageView.fixX(xPixel);
            widget.setX(this.imageView.toX0(xPixel), xPixel);
            if (widget == this.pin2Dx01) {
                int dp = xPixel - (this.pin2Dx0.xPixel0 + this.pin2Dx1.xPixel0) / 2 + 1;
                xPixel = this.pin2Dx0.xPixel0 + dp;
                int xPixel1 = this.pin2Dx1.xPixel0 + dp;
                if (this.imageView.fixX(xPixel) != xPixel || this.imageView.fixX(xPixel1) != xPixel1) {
                    return true;
                }
                this.pin2Dx0.setX(this.imageView.toX0(xPixel), xPixel);
                this.pin2Dx1.setX(this.imageView.toX0(xPixel1), xPixel1);
            }
            if (!GraphSet.isGoodEvent(this.pin2Dx0, this.pin2Dx1, true)) {
                this.reset2D(true);
                return true;
            }
            this.imageView.setView0(this.pin2Dx0.xPixel0, this.pin2Dy0.yPixel0, this.pin2Dx1.xPixel0, this.pin2Dy1.yPixel0);
            this.doZoom(this.pin2Dx0.getXVal(), this.getScale().minY, this.pin2Dx1.getXVal(), this.getScale().maxY, false, false, false, true, false);
            return true;
        }
        if (widget == this.pin2Dy0 || widget == this.pin2Dy1 || widget == this.pin2Dy01) {
            yPixel = this.fixY(yPixel);
            widget.setY(this.imageView.toSubspectrumIndex(yPixel), yPixel);
            if (widget == this.pin2Dy01) {
                int dp = yPixel - (this.pin2Dy0.yPixel0 + this.pin2Dy1.yPixel0) / 2 + 1;
                yPixel = this.pin2Dy0.yPixel0 + dp;
                int yPixel1 = this.pin2Dy1.yPixel0 + dp;
                if (yPixel != this.fixY(yPixel) || yPixel1 != this.fixY(yPixel1)) {
                    return true;
                }
                this.pin2Dy0.setY(this.imageView.toSubspectrumIndex(yPixel), yPixel);
                this.pin2Dy1.setY(this.imageView.toSubspectrumIndex(yPixel1), yPixel1);
            }
            if (!GraphSet.isGoodEvent(this.pin2Dy0, this.pin2Dy1, false)) {
                this.reset2D(false);
                return true;
            }
            this.imageView.setView0(this.pin2Dx0.xPixel0, this.pin2Dy0.yPixel0, this.pin2Dx1.xPixel1, this.pin2Dy1.yPixel1);
            return true;
        }
        return false;
    }

    void clearIntegrals() {
        this.checkIntegral(Double.NaN, 0.0, false);
    }

    void clearMeasurements() {
        this.removeDialog(this.getFixedSelectedSpectrumIndex(), Annotation.AType.Measurements);
    }

    static Lst<GraphSet> createGraphSetsAndSetLinkMode(PanelData pd, JSVPanel jsvp, Lst<Spectrum> spectra, int startIndex, int endIndex, PanelData.LinkMode linkMode) {
        int i;
        Lst<GraphSet> graphSets = new Lst<GraphSet>();
        for (i = 0; i < spectra.size(); ++i) {
            GraphSet graphSet;
            Spectrum spec = (Spectrum)spectra.get(i);
            GraphSet graphSet2 = graphSet = linkMode == PanelData.LinkMode.NONE ? GraphSet.findCompatibleGraphSet(graphSets, spec) : null;
            if (graphSet == null) {
                graphSet = new GraphSet(jsvp.getPanelData());
                graphSets.addLast(graphSet);
            }
            graphSet.addSpec(spec);
        }
        GraphSet.setFractionalPositions(pd, graphSets, linkMode);
        i = graphSets.size();
        while (--i >= 0) {
            ((GraphSet)graphSets.get(i)).initGraphSet(startIndex, endIndex);
            Logger.info("JSVGraphSet " + (i + 1) + " nSpectra = " + ((GraphSet)graphSets.get((int)i)).nSpectra);
        }
        return graphSets;
    }

    synchronized void drawGraphSet(Object gMain, Object gFront, Object gBack, int width, int height, int left, int right, int top, int bottom, boolean isResized, boolean taintedAll) {
        this.zoomEnabled = this.pd.getBoolean(ScriptToken.ENABLEZOOM);
        this.height = height * this.pd.scalingFactor;
        this.width = width * this.pd.scalingFactor;
        this.left = left * this.pd.scalingFactor;
        this.right = right * this.pd.scalingFactor;
        this.top = top * this.pd.scalingFactor;
        this.bottom = bottom * this.pd.scalingFactor;
        this.haveSelectedSpectrum = false;
        this.selectedSpectrumIntegrals = null;
        this.selectedSpectrumMeasurements = null;
        if (!this.pd.isPrinting && this.widgets != null) {
            for (int j = 0; j < this.widgets.length; ++j) {
                if (this.widgets[j] == null) continue;
                this.widgets[j].isVisible = false;
            }
        }
        for (int iSplit = 0; iSplit < this.nSplit; ++iSplit) {
            this.setPositionForFrame(iSplit);
            this.drawAll(gMain, gFront, gBack, iSplit, isResized || this.nSplit > 1, taintedAll);
        }
        this.setPositionForFrame(this.nSplit > 1 ? this.pd.currentSplitPoint : 0);
        if (this.pd.isPrinting) {
            return;
        }
    }

    synchronized void escapeKeyPressed(boolean isDEL) {
        if (this.zoomBox1D != null) {
            this.zoomBox1D.xPixel1 = 0;
            this.zoomBox1D.xPixel0 = 0;
        }
        if (this.zoomBox2D != null) {
            this.zoomBox2D.xPixel1 = 0;
            this.zoomBox2D.xPixel0 = 0;
        }
        if (!this.inPlotMove) {
            return;
        }
        if (this.pendingMeasurement != null) {
            this.pendingMeasurement = null;
            return;
        }
        this.pd.thisWidget = null;
        this.pendingMeasurement = null;
        if (this.selectedSpectrumMeasurements != null && this.selectedMeasurement != null) {
            if (isDEL) {
                this.selectedSpectrumMeasurements.clear(this.getScale().minXOnScale, this.getScale().maxXOnScale);
            } else {
                this.selectedSpectrumMeasurements.removeObj(this.selectedMeasurement);
            }
            this.selectedMeasurement = null;
            this.updateDialog(Annotation.AType.Measurements, -1);
        }
        if (this.selectedSpectrumIntegrals != null && this.selectedIntegral != null) {
            if (isDEL) {
                this.selectedSpectrumIntegrals.clear(this.getScale().minXOnScale, this.getScale().maxXOnScale);
            } else {
                this.selectedSpectrumIntegrals.removeObj(this.selectedIntegral);
            }
            this.selectedIntegral = null;
            this.updateDialog(Annotation.AType.Integration, -1);
        }
    }

    static GraphSet findGraphSet(Lst<GraphSet> graphSets, int xPixel, int yPixel) {
        int i = graphSets.size();
        while (--i >= 0) {
            if (!((GraphSet)graphSets.get(i)).hasPoint(xPixel, yPixel)) continue;
            return (GraphSet)graphSets.get(i);
        }
        return null;
    }

    PeakInfo findMatchingPeakInfo(PeakInfo pi) {
        PeakInfo pi2 = null;
        for (int i = 0; i < this.spectra.size() && (pi2 = ((Spectrum)this.spectra.get(i)).findMatchingPeakInfo(pi)) == null; ++i) {
        }
        return pi2;
    }

    int getCurrentSpectrumIndex() {
        return this.nSpectra == 1 ? 0 : this.iSpectrumSelected;
    }

    Integral getSelectedIntegral() {
        return this.selectedIntegral;
    }

    boolean getShowAnnotation(Annotation.AType type, int i) {
        AnnotationData id = this.getDialog(type, i);
        return id != null && id.getState();
    }

    boolean hasFileLoaded(String filePath) {
        int i = this.spectra.size();
        while (--i >= 0) {
            if (!((Spectrum)this.spectra.get(i)).getFilePathForwardSlash().equals(filePath)) continue;
            return true;
        }
        return false;
    }

    boolean haveSelectedSpectrum() {
        return this.haveSelectedSpectrum;
    }

    synchronized void mouseClickedEvent(int xPixel, int yPixel, int clickCount, boolean isControlDown) {
        this.selectedMeasurement = null;
        this.selectedIntegral = null;
        Double isNextClick = this.nextClickForSetPeak;
        this.nextClickForSetPeak = null;
        if (this.checkArrowUpDownClick(xPixel, yPixel) || this.checkArrowLeftRightClick(xPixel, yPixel)) {
            return;
        }
        this.lastClickX = Double.NaN;
        this.lastPixelX = Integer.MAX_VALUE;
        if (this.isSplitWidget(xPixel, yPixel)) {
            this.splitStack(this.nSplit == 1);
            return;
        }
        if (this.isCloserWidget(xPixel, yPixel)) {
            this.pd.closeSpectrum();
            return;
        }
        PlotWidget pw = this.getPinSelected(xPixel, yPixel);
        if (pw != null) {
            this.setWidgetValueByUser(pw);
            return;
        }
        boolean is2D = this.is2dClick(xPixel, yPixel);
        if (clickCount == 2 && this.iSpectrumClicked == -1 && this.iPreviousSpectrumClicked >= 0) {
            this.setSpectrumClicked(this.iPreviousSpectrumClicked);
        }
        if (!is2D && isControlDown) {
            this.setSpectrumClicked(this.iPreviousSpectrumClicked);
            if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(xPixel, yPixel, -3);
            } else if (this.iSpectrumClicked >= 0) {
                this.processPendingMeasurement(xPixel, yPixel, 3);
            }
            return;
        }
        this.lastXMax = Double.NaN;
        if (clickCount == 2) {
            if (is2D) {
                if (this.sticky2Dcursor) {
                    this.addAnnotation(this.getAnnotation(this.imageView.toX(xPixel), this.imageView.toSubspectrumIndex(yPixel), this.pd.coordStr, false, true, 5, 5), true);
                }
                this.sticky2Dcursor = true;
                this.set2DCrossHairs(xPixel, yPixel);
                return;
            }
            if (this.isInTopBar(xPixel, yPixel)) {
                this.doZoom(this.toX0(this.xPixel0), 0.0, this.toX0(this.xPixel1), 0.0, true, false, false, true, true);
            } else if (this.isInRightBar(xPixel, yPixel)) {
                this.doZoom(this.getScale().minXOnScale, ((ViewData)this.viewList.get((int)0)).getScale().minYOnScale, this.getScale().maxXOnScale, ((ViewData)this.viewList.get((int)0)).getScale().maxYOnScale, true, true, false, false, false);
            } else if (this.isInTopBar2D(xPixel, yPixel)) {
                this.reset2D(true);
            } else if (this.isInRightBar2D(xPixel, yPixel)) {
                this.reset2D(false);
            } else if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(xPixel, yPixel, -2);
            } else if (this.iSpectrumClicked >= 0) {
                this.processPendingMeasurement(xPixel, yPixel, 2);
            }
            return;
        }
        if (is2D) {
            Coordinate xy;
            Annotation a;
            if (this.annotations != null && (a = this.findAnnotation2D(xy = new Coordinate().set(this.imageView.toX(xPixel), this.imageView.toSubspectrumIndex(yPixel)))) != null && this.setAnnotationText(a)) {
                return;
            }
            if (clickCount == 1) {
                this.sticky2Dcursor = false;
            }
            this.set2DCrossHairs(xPixel, yPixel);
            return;
        }
        if (this.isInPlotRegion(xPixel, yPixel)) {
            if (this.selectedSpectrumIntegrals != null && this.checkIntegralNormalizationClick(xPixel, yPixel)) {
                return;
            }
            if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(xPixel, yPixel, 1);
                return;
            }
            this.setCoordClicked(xPixel, this.toX(xPixel), this.toY(yPixel));
            this.updateDialog(Annotation.AType.PeakList, -1);
            if (isNextClick != null) {
                this.nextClickForSetPeak = isNextClick;
                this.shiftSpectrum(4, Double.NaN, Double.NaN);
                this.nextClickForSetPeak = null;
                return;
            }
        } else {
            this.setCoordClicked(0, Double.NaN, 0.0);
        }
        this.pd.notifyPeakPickedListeners(null);
    }

    private boolean is2dClick(int xPixel, int yPixel) {
        return this.imageView != null && xPixel == this.imageView.fixX(xPixel) && yPixel == this.fixY(yPixel);
    }

    private void updateDialog(Annotation.AType type, int iSpec) {
        AnnotationData ad = this.getDialog(type, iSpec);
        if (ad == null || !this.isVisible(ad)) {
            return;
        }
        double xRange = this.toX(this.xPixel1) - this.toX(this.xPixel0);
        int yOffset = this.getSpectrum().isInverted() ? this.yPixel1 - this.pd.mouseY : this.pd.mouseY - this.yPixel0;
        ((JSVDialog)ad).update(this.pd.coordClicked, xRange, yOffset);
    }

    private boolean isVisible(AnnotationData ad) {
        return ad instanceof JSVDialog && ad.isVisible();
    }

    public void mousePressedEvent(int xPixel, int yPixel, int clickCount) {
        this.checkWidgetEvent(xPixel, yPixel, true);
    }

    synchronized void mouseReleasedEvent(int xPixel, int yPixel) {
        if (this.pendingMeasurement != null) {
            if (Math.abs(this.toPixelX(this.pendingMeasurement.getXVal()) - xPixel) < 2) {
                this.pendingMeasurement = null;
            }
            this.processPendingMeasurement(xPixel, yPixel, -2);
            this.setToolTipForPixels(xPixel, yPixel);
            return;
        }
        if (this.pd.integralShiftMode != 0) {
            this.pd.integralShiftMode = 0;
            this.zoomBox1D.xPixel1 = this.zoomBox1D.xPixel0;
            return;
        }
        if (this.iSpectrumMovedTo >= 0) {
            this.setScale(this.iSpectrumMovedTo);
        }
        PlotWidget thisWidget = this.pd.thisWidget;
        if (this.pd.isIntegralDrag) {
            if (GraphSet.isGoodEvent(this.zoomBox1D, null, true)) {
                this.checkIntegral(this.toX(this.zoomBox1D.xPixel0), this.toX(this.zoomBox1D.xPixel1), true);
            }
            this.zoomBox1D.xPixel0 = 0;
            this.zoomBox1D.xPixel1 = 0;
            this.pendingIntegral = null;
            this.pd.isIntegralDrag = false;
        } else if (thisWidget == this.zoomBox2D) {
            if (!GraphSet.isGoodEvent(this.zoomBox2D, null, true)) {
                return;
            }
            this.imageView.setZoom(this.zoomBox2D.xPixel0, this.zoomBox2D.yPixel0, this.zoomBox2D.xPixel1, this.zoomBox2D.yPixel1);
            this.zoomBox2D.xPixel1 = this.zoomBox2D.xPixel0;
            this.doZoom(this.imageView.toX(this.imageView.xPixel0), this.getScale().minY, this.imageView.toX(this.imageView.xPixel0 + this.imageView.xPixels - 1), this.getScale().maxY, false, false, false, true, true);
        } else if (thisWidget == this.zoomBox1D) {
            if (!GraphSet.isGoodEvent(this.zoomBox1D, null, true)) {
                return;
            }
            int x1 = this.zoomBox1D.xPixel1;
            boolean doY = this.pd.shiftPressed;
            this.doZoom(this.toX(this.zoomBox1D.xPixel0), doY ? this.toY(this.zoomBox1D.yPixel0) : 0.0, this.toX(x1), doY ? this.toY(this.zoomBox1D.yPixel1) : 0.0, true, doY, true, true, true);
            this.zoomBox1D.xPixel1 = this.zoomBox1D.xPixel0;
        } else if (thisWidget == this.pin1Dx0 || thisWidget == this.pin1Dx1 || thisWidget == this.cur2Dx0 || thisWidget == this.cur2Dx1) {
            this.addCurrentZoom();
        }
    }

    synchronized void mouseMovedEvent(int xPixel, int yPixel) {
        if (this.nSpectra > 1) {
            int iFrame = this.getSplitPoint(yPixel);
            this.setPositionForFrame(iFrame);
            this.setSpectrumMovedTo(this.nSplit > 1 ? iFrame : this.iSpectrumSelected);
            if (this.iSpectrumMovedTo >= 0) {
                this.setScale(this.iSpectrumMovedTo);
            }
        }
        this.inPlotMove = this.isInPlotRegion(xPixel, yPixel);
        this.setXPixelMovedTo(Double.MAX_VALUE, Double.MAX_VALUE, this.inPlotMove ? xPixel : -1, -1);
        if (this.inPlotMove) {
            this.xValueMovedTo = this.toX(this.xPixelMovedTo);
            this.yValueMovedTo = this.getSpectrum().getYValueAt(this.xValueMovedTo);
        }
        if (this.pd.integralShiftMode != 0) {
            AnnotationData ad = this.getDialog(Annotation.AType.Integration, -1);
            Coordinate[] xy = ((IntegralData)ad.getData()).getXYCoords();
            double y = xy[this.pd.integralShiftMode > 0 ? xy.length - 1 : 0].getYVal();
            ((IntegralData)ad.getData()).shiftY(this.pd.integralShiftMode, this.toPixelYint(y) + yPixel - (this.pd.integralShiftMode > 0 ? this.yPixelPlot1 : this.yPixelPlot0), this.yPixel0, this.yPixels);
        } else if (!this.pd.isIntegralDrag) {
            if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(xPixel, yPixel, 0);
                this.setToolTipForPixels(xPixel, yPixel);
            } else {
                this.selectedMeasurement = this.inPlotMove && this.selectedSpectrumMeasurements != null ? this.findMeasurement(this.selectedSpectrumMeasurements, xPixel, yPixel, 0) : null;
                this.selectedIntegral = null;
                if (this.inPlotMove && this.selectedSpectrumIntegrals != null && this.selectedMeasurement == null) {
                    this.selectedIntegral = (Integral)this.findMeasurement(this.selectedSpectrumIntegrals, xPixel, yPixel, 0);
                    if (this.selectedIntegral == null) {
                        this.selectedIntegral = (Integral)this.findMeasurement(this.selectedSpectrumIntegrals, xPixel, yPixel, -5);
                    }
                }
                this.setToolTipForPixels(xPixel, yPixel);
                if (this.imageView == null) {
                    Spectrum spec;
                    int iSpec;
                    this.piMouseOver = null;
                    int n = iSpec = this.nSplit > 1 ? this.iSpectrumMovedTo : this.iSpectrumClicked;
                    if (!this.isDrawNoSpectra() && iSpec >= 0 && (spec = (Spectrum)this.spectra.get(iSpec)).getPeakList() != null) {
                        this.coordTemp.setXVal(this.toX(xPixel));
                        this.coordTemp.setYVal(this.toY(yPixel));
                        this.piMouseOver = spec.findPeakByCoord(xPixel, this.coordTemp);
                    }
                } else if (!this.pd.display1D && this.sticky2Dcursor) {
                    this.set2DCrossHairs(xPixel, yPixel);
                }
            }
        }
    }

    void nextView() {
        if (this.currentZoomIndex + 1 < this.viewList.size()) {
            this.setZoomTo(this.currentZoomIndex + 1);
        }
    }

    void previousView() {
        if (this.currentZoomIndex > 0) {
            this.setZoomTo(this.currentZoomIndex - 1);
        }
    }

    void resetView() {
        this.setZoomTo(0);
    }

    void removeAllHighlights() {
        this.removeAllHighlights(null);
    }

    void removeHighlight(int index) {
        this.highlights.removeItemAt(index);
    }

    void removeHighlight(double x1, double x2) {
        int i = this.highlights.size();
        while (--i >= 0) {
            Highlight h = (Highlight)this.highlights.get(i);
            if (h.x1 != x1 || h.x2 != x2) continue;
            this.highlights.removeItemAt(i);
        }
    }

    void scaleYBy(double factor) {
        if (this.imageView == null && !this.zoomEnabled) {
            return;
        }
        this.viewData.scaleSpectrum(this.imageView == null ? this.iSpectrumSelected : -2, factor);
        if (this.imageView != null) {
            this.update2dImage(false);
            this.resetPinsFromView();
        }
        this.pd.refresh();
    }

    boolean selectSpectrum(String filePath, String type, String model) {
        boolean haveFound = false;
        int i = this.spectra.size();
        while (--i >= 0) {
            if (filePath != null && !this.getSpectrumAt(i).getFilePathForwardSlash().equals(filePath) || !this.getSpectrumAt(i).matchesPeakTypeModel(type, model)) continue;
            this.setSpectrumSelected(i);
            if (this.nSplit > 1) {
                this.splitStack(true);
            }
            haveFound = true;
        }
        if (this.nSpectra > 1 && !haveFound && this.iSpectrumSelected >= 0 && !this.pd.isCurrentGraphSet(this)) {
            this.setSpectrumSelected(Integer.MIN_VALUE);
        }
        return haveFound;
    }

    PeakInfo selectPeakByFileIndex(String filePath, String index, String atomKey) {
        int i = this.spectra.size();
        while (--i >= 0) {
            PeakInfo pi = this.getSpectrumAt(i).selectPeakByFileIndex(filePath, index, atomKey);
            if (pi == null) continue;
            return pi;
        }
        return null;
    }

    void setSelected(int i) {
        if (i < 0) {
            this.bsSelected.clearAll();
            this.setSpectrumClicked(-1);
            return;
        }
        this.bsSelected.set(i);
        this.setSpectrumClicked(this.bsSelected.cardinality() == 1 ? i : -1);
        if (this.nSplit > 1 && i >= 0) {
            this.pd.currentSplitPoint = i;
        }
    }

    void setSelectedIntegral(double val) {
        Spectrum spec = this.selectedIntegral.getSpectrum();
        this.getIntegrationGraph(this.getSpectrumIndex(spec)).setSelectedIntegral(this.selectedIntegral, val);
    }

    void setShowAnnotation(Annotation.AType type, Boolean tfToggle) {
        AnnotationData id = this.getDialog(type, -1);
        if (id == null) {
            if (tfToggle != null && tfToggle != Boolean.TRUE) {
                return;
            }
            if (type == Annotation.AType.PeakList || type == Annotation.AType.Integration || type == Annotation.AType.Measurements) {
                this.pd.showDialog(type);
            }
            return;
        }
        if (tfToggle == null) {
            if (id instanceof JSVDialog) {
                ((JSVDialog)id).setVisible(!((JSVDialog)id).isVisible());
            } else {
                this.pd.showDialog(type);
            }
            return;
        }
        boolean isON = tfToggle;
        if (isON) {
            id.setState(isON);
        }
        if (isON || id instanceof JSVDialog) {
            this.pd.showDialog(type);
        }
        if (!isON && id instanceof JSVDialog) {
            ((JSVDialog)id).setVisible(false);
        }
    }

    boolean checkIntegralParams(Parameters parameters, String value) {
        Spectrum spec = this.getSpectrum();
        if (!spec.canIntegrate() || this.reversePlot) {
            return false;
        }
        int iSpec = this.getFixedSelectedSpectrumIndex();
        AnnotationData ad = this.getDialog(Annotation.AType.Integration, -1);
        if (value == null) {
            return true;
        }
        switch (IntegralData.IntMode.getMode(value.toUpperCase())) {
            case NA: {
                return false;
            }
            case CLEAR: {
                this.integrate(iSpec, null);
                this.integrate(iSpec, parameters);
                break;
            }
            case ON: {
                if (ad == null) {
                    this.integrate(iSpec, parameters);
                    break;
                }
                ad.setState(true);
                break;
            }
            case OFF: {
                if (ad == null) break;
                ad.setState(false);
                break;
            }
            case TOGGLE: {
                if (ad == null) {
                    this.integrate(iSpec, parameters);
                    break;
                }
                ad.setState(!ad.getState());
                break;
            }
            case AUTO: {
                if (ad == null) {
                    this.checkIntegralParams(parameters, "ON");
                    ad = this.getDialog(Annotation.AType.Integration, -1);
                }
                if (ad == null) break;
                ((IntegralData)ad.getData()).autoIntegrate();
                break;
            }
            case LIST: {
                this.pd.showDialog(Annotation.AType.Integration);
                break;
            }
            case MARK: {
                if (ad == null) {
                    this.checkIntegralParams(parameters, "ON");
                    ad = this.getDialog(Annotation.AType.Integration, -1);
                }
                if (ad == null) break;
                ((IntegralData)ad.getData()).addMarks(value.substring(4).trim());
                break;
            }
            case MIN: {
                if (ad == null) break;
                try {
                    double val = Double.parseDouble((String)ScriptToken.getTokens(value).get(1));
                    ((IntegralData)ad.getData()).setMinimumIntegral(val);
                }
                catch (Exception exception) {}
                break;
            }
            case UPDATE: {
                if (ad == null) break;
                ((IntegralData)ad.getData()).update(parameters);
            }
        }
        this.updateDialog(Annotation.AType.Integration, -1);
        return true;
    }

    void setSpectrum(int iSpec, boolean fromSplit) {
        if (fromSplit && this.nSplit > 1) {
            if (this.nSplit > 1) {
                this.setSpectrumClicked(iSpec);
            }
        } else {
            this.setSpectrumClicked(iSpec);
            this.stackSelected = false;
            this.showAllStacked = false;
        }
        if (iSpec >= 0) {
            this.dialogsToFront(this.getSpectrum());
        }
    }

    void setSpectrumJDX(Spectrum spec) {
        int pt = this.getFixedSelectedSpectrumIndex();
        this.spectra.removeItemAt(pt);
        this.spectra.add(pt, spec);
        this.pendingMeasurement = null;
        this.clearViews();
        this.viewData.newSpectrum(this.spectra);
    }

    void setZoom(double x1, double y1, double x2, double y2) {
        this.setZoomTo(0);
        if (x1 == 0.0 && x2 == 0.0 && y1 == 0.0 && y2 == 0.0) {
            this.newPins();
            this.imageView = null;
            x1 = this.getScale().minXOnScale;
            x2 = this.getScale().maxXOnScale;
        } else {
            this.doZoom(x1, y1, x2, y2, true, y1 != y2, false, true, true);
        }
    }

    boolean shiftSpectrum(int mode, double xOld, double xNew) {
        Spectrum spec = this.getSpectrum();
        if (!spec.isNMR() || !spec.is1D()) {
            return false;
        }
        String ok = null;
        double dx = 0.0;
        if (xNew == Double.MAX_VALUE) {
            dx = -spec.addSpecShift(0.0);
        } else {
            switch (mode) {
                case 3: {
                    dx = xNew;
                    break;
                }
                case 1: 
                case 2: {
                    this.nextClickMode = mode;
                    if (Double.isNaN(xOld)) {
                        ok = this.pd.getInput("Click on " + (mode == 1 ? "or beside a peak to set its chemical shift" : "the spectrum set the chemical shift at that point") + (xNew == -2.147483648E9 ? "" : " to " + xNew) + ".", "Set Reference " + (mode == 1 ? "for Peak" : "at Point"), "OK");
                        this.nextClickForSetPeak = "OK".equals(ok) ? Double.valueOf(xNew) : null;
                        return false;
                    }
                    this.nextClickForSetPeak = null;
                }
                case 4: {
                    if (this.nextClickForSetPeak != null) {
                        xNew = this.nextClickForSetPeak;
                        this.nextClickForSetPeak = null;
                    }
                    if (Double.isNaN(xOld)) {
                        xOld = this.lastClickX;
                    }
                    if (this.nextClickMode == 1) {
                        xOld = this.getNearestPeak(spec, xOld, this.toY(this.pd.mouseY));
                    }
                    if (Double.isNaN(xNew)) {
                        try {
                            String s = this.pd.getInput("New chemical shift (set blank to reset)", "Set Reference", DF.formatDecimalDbl(xOld, this.getScale().precision[0])).trim();
                            xNew = s.length() == 0 ? xOld - spec.addSpecShift(0.0) : Double.parseDouble(s);
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    dx = xNew - xOld;
                }
            }
        }
        if (dx == 0.0) {
            return false;
        }
        spec.addSpecShift(dx);
        if (this.annotations != null) {
            int i = this.annotations.size();
            while (--i >= 0) {
                if (((Annotation)this.annotations.get((int)i)).spec != spec) continue;
                ((Annotation)this.annotations.get(i)).addSpecShift(dx);
            }
        }
        if (this.dialogs != null) {
            for (Map.Entry<String, AnnotationData> e : this.dialogs.entrySet()) {
                if (e.getValue().getSpectrum() != spec) continue;
                e.getValue().setSpecShift(dx);
            }
        }
        this.getScale().addSpecShift(dx);
        if (!Double.isNaN(this.lastClickX)) {
            this.lastClickX += dx;
        }
        this.updateDialogs();
        this.doZoom(0.0, this.getScale().minYOnScale, 0.0, this.getScale().maxYOnScale, true, true, false, true, false);
        this.pd.setTaintedAll();
        this.pd.repaint();
        return true;
    }

    void toPeak(int istep) {
        Coordinate coord;
        Spectrum spec;
        int iPeak;
        istep *= this.drawXAxisLeftToRight ? 1 : -1;
        if (Double.isNaN(this.lastClickX)) {
            this.lastPixelX = 0;
            this.lastClickX = 0;
        }
        if ((iPeak = (spec = this.getSpectrum()).setNextPeak(coord = this.setCoordClicked(this.lastPixelX, this.lastClickX, 0.0), istep)) < 0) {
            return;
        }
        PeakInfo peak = (PeakInfo)spec.getPeakList().get(iPeak);
        spec.setSelectedPeak(peak);
        this.setCoordClicked(peak.getXPixel(), peak.getX(), 0.0);
        this.pd.notifyPeakPickedListeners(new PeakPickEvent(this.jsvp, this.pd.coordClicked, peak));
    }

    void scaleSelectedBy(double f) {
        int i = this.bsSelected.nextSetBit(0);
        while (i >= 0) {
            this.viewData.scaleSpectrum(i, f);
            i = this.bsSelected.nextSetBit(i + 1);
        }
    }

    public String toString() {
        return "gs: " + this.nSpectra + " " + this.spectra + " " + ((Spectrum)this.spectra.get(0)).getFilePath();
    }

    void setXPointer(Spectrum spec, double x) {
        if (spec != null) {
            this.setSpectrumClicked(this.getSpectrumIndex(spec));
        }
        this.xValueMovedTo = this.lastClickX = x;
        this.lastPixelX = this.toPixelX(x);
        this.setXPixelMovedTo(x, Double.MAX_VALUE, 0, 0);
        this.yValueMovedTo = Double.NaN;
    }

    void setXPointer2(Spectrum spec, double x) {
        if (spec != null) {
            this.setSpectrumClicked(this.getSpectrumIndex(spec));
        }
        this.setXPixelMovedTo(Double.MAX_VALUE, x, 0, 0);
    }

    boolean hasCurrentMeasurement(Annotation.AType type) {
        return (type == Annotation.AType.Integration ? this.selectedSpectrumIntegrals : this.selectedSpectrumMeasurements) != null;
    }

    AnnotationData getDialog(Annotation.AType type, int iSpec) {
        if (iSpec == -1) {
            iSpec = this.getCurrentSpectrumIndex();
        }
        return this.dialogs == null || iSpec < 0 ? null : this.dialogs.get((Object)((Object)type) + "_" + iSpec);
    }

    void removeDialog(int iSpec, Annotation.AType type) {
        if (this.dialogs != null && iSpec >= 0) {
            this.dialogs.remove((Object)((Object)type) + "_" + iSpec);
        }
    }

    AnnotationData addDialog(int iSpec, Annotation.AType type, AnnotationData dialog) {
        if (this.dialogs == null) {
            this.dialogs = new Hashtable<String, AnnotationData>();
        }
        String key = (Object)((Object)type) + "_" + iSpec;
        dialog.setGraphSetKey(key);
        this.dialogs.put(key, dialog);
        return dialog;
    }

    void removeDialog(JSVDialog dialog) {
        String key = dialog.getGraphSetKey();
        this.dialogs.remove(key);
        MeasurementData data = dialog.getData();
        if (data != null) {
            this.dialogs.put(key, data);
        }
    }

    MeasurementData getPeakListing(int iSpec, Parameters p, boolean forceNew) {
        if (iSpec < 0) {
            iSpec = this.getCurrentSpectrumIndex();
        }
        if (iSpec < 0) {
            return null;
        }
        AnnotationData dialog = this.getDialog(Annotation.AType.PeakList, -1);
        if (dialog == null) {
            if (!forceNew) {
                return null;
            }
            dialog = new PeakData(Annotation.AType.PeakList, this.getSpectrum());
            this.addDialog(iSpec, Annotation.AType.PeakList, dialog);
        }
        ((PeakData)dialog.getData()).setPeakList(p, Integer.MIN_VALUE, this.viewData.getScale());
        if (dialog instanceof JSVDialog) {
            ((JSVDialog)dialog).setFields();
        }
        return dialog.getData();
    }

    void setPeakListing(Boolean tfToggle) {
        boolean isON;
        JSVDialog ad;
        AnnotationData dialog = this.getDialog(Annotation.AType.PeakList, -1);
        JSVDialog jSVDialog = ad = dialog instanceof JSVDialog ? (JSVDialog)dialog : null;
        boolean bl = tfToggle == null ? ad == null || !ad.isVisible() : (isON = tfToggle.booleanValue());
        if (isON) {
            this.pd.showDialog(Annotation.AType.PeakList);
        } else if (dialog instanceof JSVDialog) {
            ((JSVDialog)dialog).setVisible(false);
        }
    }

    boolean haveIntegralDisplayed(int i) {
        AnnotationData ad = this.getDialog(Annotation.AType.Integration, i);
        return ad != null && ad.getState();
    }

    IntegralData getIntegrationGraph(int i) {
        AnnotationData ad = this.getDialog(Annotation.AType.Integration, i);
        return ad == null ? null : (IntegralData)ad.getData();
    }

    void setIntegrationRatios(String value) {
        int iSpec = this.getFixedSelectedSpectrumIndex();
        if (this.aIntegrationRatios == null) {
            this.aIntegrationRatios = new Object[this.nSpectra];
        }
        this.aIntegrationRatios[iSpec] = IntegralData.getIntegrationRatiosFromString(this.getSpectrum(), value);
    }

    Lst<Annotation> getIntegrationRatios(int i) {
        return (Lst)(this.aIntegrationRatios == null ? null : this.aIntegrationRatios[i]);
    }

    boolean integrate(int iSpec, Parameters parameters) {
        Spectrum spec = this.getSpectrumAt(iSpec);
        if (parameters == null || !spec.canIntegrate()) {
            this.removeDialog(iSpec, Annotation.AType.Integration);
            return false;
        }
        this.addDialog(iSpec, Annotation.AType.Integration, new IntegralData(spec, parameters));
        return true;
    }

    IntegralData getIntegration(int iSpec, Parameters p, boolean forceNew) {
        if (iSpec < 0) {
            iSpec = this.getCurrentSpectrumIndex();
        }
        if (iSpec < 0) {
            return null;
        }
        AnnotationData dialog = this.getDialog(Annotation.AType.Integration, -1);
        if (dialog == null) {
            if (!forceNew) {
                return null;
            }
            dialog = this.addDialog(iSpec, Annotation.AType.Integration, new IntegralData(this.getSpectrum(), p));
        }
        return (IntegralData)dialog.getData();
    }

    Map<String, Object> getMeasurementInfo(Annotation.AType type, int iSpec) {
        MeasurementData md;
        switch (type) {
            case PeakList: {
                md = this.getPeakListing(iSpec, null, false);
                break;
            }
            case Integration: {
                md = this.getIntegration(iSpec, null, false);
                break;
            }
            default: {
                return null;
            }
        }
        if (md == null) {
            return null;
        }
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        md.getInfo(info);
        return info;
    }

    Map<String, Object> getInfo(String key, int iSpec) {
        Hashtable<String, Object> spectraInfo = new Hashtable<String, Object>();
        if ("".equals(key)) {
            spectraInfo.put("KEYS", "viewInfo spectra");
        } else if ("viewInfo".equalsIgnoreCase(key)) {
            return this.getScale().getInfo(spectraInfo);
        }
        Lst<Map<String, Object>> specInfo = new Lst<Map<String, Object>>();
        spectraInfo.put("spectra", specInfo);
        for (int i = 0; i < this.nSpectra; ++i) {
            if (iSpec >= 0 && i != iSpec) continue;
            Spectrum spec = (Spectrum)this.spectra.get(i);
            Map<String, Object> info = spec.getInfo(key);
            if (iSpec >= 0 && key != null && (info.size() == 2 || key.equalsIgnoreCase("id"))) {
                if (info.size() == 2) {
                    info.remove("id");
                }
                return info;
            }
            Parameters.putInfo(key, info, "type", spec.getDataType());
            Parameters.putInfo(key, info, "titleLabel", spec.getTitleLabel());
            Parameters.putInfo(key, info, "filePath", spec.getFilePath().replace('\\', '/'));
            Parameters.putInfo(key, info, "PeakList", Parameters.isMatch(key, "PeakList") ? this.getMeasurementInfo(Annotation.AType.PeakList, i) : null);
            Parameters.putInfo(key, info, "Integration", Parameters.isMatch(key, "Integration") ? this.getMeasurementInfo(Annotation.AType.Integration, i) : null);
            if (iSpec >= 0) {
                return info;
            }
            specInfo.addLast(info);
        }
        return spectraInfo;
    }

    String getTitle(boolean forPrinting) {
        return this.nSpectra == 1 || this.iSpectrumSelected >= 0 && (!forPrinting || this.nSplit == 1) ? this.getSpectrum().getTitle() : null;
    }

    ScaleData getCurrentView() {
        this.setScale(this.getFixedSelectedSpectrumIndex());
        return this.viewData.getScale();
    }

    void set2DXY(double x, double y, boolean isLocked) {
        int p;
        if (this.gs2dLinkedX != null) {
            p = this.toPixelX(x);
            if (p != this.fixX(p)) {
                p = Integer.MIN_VALUE;
                x = Double.MAX_VALUE;
            }
            this.cur1D2x1.setX(x, p);
        }
        if (this.gs2dLinkedY != null) {
            p = this.toPixelX(y);
            if (p != this.fixX(p)) {
                p = Integer.MIN_VALUE;
                y = Double.MAX_VALUE;
            }
            this.cur1D2x2.setX(y, p);
        }
        this.cur1D2Locked = isLocked;
    }

    void dialogsToFront(Spectrum spec) {
        if (this.dialogs == null) {
            return;
        }
        if (spec == null) {
            spec = this.getSpectrum();
        }
        for (Map.Entry<String, AnnotationData> e : this.dialogs.entrySet()) {
            AnnotationData ad = e.getValue();
            if (!this.isVisible(ad)) continue;
            if (spec == null) {
                ((JSVDialog)ad).setVisible(true);
                continue;
            }
            ((JSVDialog)ad).setFocus(ad.getSpectrum() == spec);
        }
    }

    void setPlotColors(Object oColors) {
        GenericColor[] colors = (GenericColor[])oColors;
        if (colors.length > this.nSpectra) {
            GenericColor[] tmpPlotColors = new GenericColor[this.nSpectra];
            System.arraycopy(colors, 0, tmpPlotColors, 0, this.nSpectra);
            colors = tmpPlotColors;
        } else if (this.nSpectra > colors.length) {
            GenericColor[] tmpPlotColors = new GenericColor[this.nSpectra];
            int numAdditionColors = this.nSpectra - colors.length;
            System.arraycopy(colors, 0, tmpPlotColors, 0, colors.length);
            int i = 0;
            int j = colors.length;
            while (i < numAdditionColors) {
                tmpPlotColors[j] = this.generateRandomColor();
                ++i;
                ++j;
            }
            colors = tmpPlotColors;
        }
        this.plotColors = colors;
    }

    private void disposeImage() {
        this.image2D = null;
        this.jsvp = null;
        this.pd = null;
        this.highlights = null;
        this.plotColors = null;
    }

    private GenericColor generateRandomColor() {
        int blue;
        int green;
        int red;
        GenericColor randomColor;
        while ((randomColor = this.g2d.getColor3(red = (int)(Math.random() * 255.0), green = (int)(Math.random() * 255.0), blue = (int)(Math.random() * 255.0))).getRGB() == 0) {
        }
        return randomColor;
    }

    void setPlotColor0(Object oColor) {
        this.plotColors[0] = (GenericColor)oColor;
    }

    GenericColor getPlotColor(int index) {
        if (index >= this.plotColors.length) {
            return null;
        }
        return this.plotColors[index];
    }

    private void setColorFromToken(Object og, ScriptToken whatColor) {
        if (whatColor != null) {
            this.g2d.setGraphicsColor(og, whatColor == ScriptToken.PLOTCOLOR ? this.plotColors[0] : this.pd.getColor(whatColor));
        }
    }

    private void setPlotColor(Object og, int i) {
        GenericColor c;
        switch (i) {
            case -3: {
                c = veryLightGrey;
                break;
            }
            case -2: {
                c = this.pd.BLACK;
                break;
            }
            case -1: {
                c = this.pd.getColor(ScriptToken.INTEGRALPLOTCOLOR);
                break;
            }
            default: {
                c = this.plotColors[i];
            }
        }
        this.g2d.setGraphicsColor(og, c);
    }

    private void draw2DImage() {
        if (this.imageView != null) {
            this.g2d.drawGrayScaleImage(this.gMain, this.image2D, this.imageView.xPixel0, this.imageView.yPixel0, this.imageView.xPixel0 + this.imageView.xPixels - 1, this.imageView.yPixel0 + this.imageView.yPixels - 1, this.imageView.xView1, this.imageView.yView1, this.imageView.xView2, this.imageView.yView2);
        }
    }

    private boolean get2DImage(Spectrum spec0) {
        this.imageView = new ImageView();
        this.imageView.set(((ViewData)this.viewList.get(0)).getScale());
        if (!this.update2dImage(true)) {
            return false;
        }
        this.imageView.resetZoom();
        this.sticky2Dcursor = true;
        return true;
    }

    private boolean update2dImage(boolean isCreation) {
        this.imageView.set(this.viewData.getScale());
        Spectrum spec = this.getSpectrumAt(0);
        int[] buffer = this.imageView.get2dBuffer(spec, !isCreation);
        if (buffer == null) {
            this.image2D = null;
            this.imageView = null;
            return false;
        }
        if (isCreation) {
            buffer = this.imageView.adjustView(spec, this.viewData);
            this.imageView.resetView();
        }
        this.image2D = this.g2d.newGrayScaleImage(this.gMain, this.image2D, this.imageView.imageWidth, this.imageView.imageHeight, buffer);
        this.setImageWindow();
        return true;
    }

    private Annotation getAnnotation(double x, double y, String text, boolean isPixels, boolean is2d, int offsetX, int offsetY) {
        return new ColoredAnnotation().setCA(x, y, this.getSpectrum(), text, this.pd.BLACK, isPixels, is2d, offsetX, offsetY);
    }

    private Annotation getAnnotation(Lst<String> args, Annotation lastAnnotation) {
        return Annotation.getColoredAnnotation(this.g2d, this.getSpectrum(), args, lastAnnotation);
    }

    private void fillBox(Object g, int x0, int y0, int x1, int y1, ScriptToken whatColor) {
        this.setColorFromToken(g, whatColor);
        this.g2d.fillRect(g, Math.min(x0, x1), Math.min(y0, y1), Math.abs(x0 - x1), Math.abs(y0 - y1));
    }

    private void drawBox(Object g, int x0, int y0, int x1, int y1, ScriptToken whatColor) {
        this.setColorFromToken(g, whatColor);
        this.g2d.drawRect(g, Math.min(x0, x1), Math.min(y0, y1), Math.abs(x0 - x1) - 1, Math.abs(y0 - y1) - 1);
    }

    private void drawHandle(Object g, int x, int y, int size, boolean outlineOnly) {
        if (outlineOnly) {
            this.g2d.drawRect(g, x - size, y - size, size * 2, size * 2);
        } else {
            this.g2d.fillRect(g, x - size, y - size, size * 2 + 1, size * 2 + 1);
        }
    }

    private void setCurrentBoxColor(Object g) {
        this.g2d.setGraphicsColor(g, this.pd.BLACK);
    }

    private void fillArrow(Object g, int type, int x, int y, boolean doFill) {
        int f = 1;
        switch (type) {
            case 1: 
            case 3: {
                f = -1;
            }
        }
        int[] axPoints = new int[]{x - 5, x - 5, x + 5, x + 5, x + 8, x, x - 8};
        int[] ayPoints = new int[]{y + 5 * f, y - f, y - f, y + 5 * f, y + 5 * f, y + 10 * f, y + 5 * f};
        switch (type) {
            case 1: 
            case 2: {
                if (doFill) {
                    this.g2d.fillPolygon(g, ayPoints, axPoints, 7);
                    break;
                }
                this.g2d.drawPolygon(g, ayPoints, axPoints, 7);
                break;
            }
            case 3: 
            case 4: {
                if (doFill) {
                    this.g2d.fillPolygon(g, axPoints, ayPoints, 7);
                    break;
                }
                this.g2d.drawPolygon(g, axPoints, ayPoints, 7);
            }
        }
    }

    private void fillCircle(Object g, int x, int y, boolean doFill) {
        if (doFill) {
            this.g2d.fillCircle(g, x - 4, y - 4, 8);
        } else {
            this.g2d.drawCircle(g, x - 4, y - 4, 8);
        }
    }

    void setAnnotationColor(Object g, Annotation note, ScriptToken whatColor) {
        if (whatColor != null) {
            this.setColorFromToken(g, whatColor);
            return;
        }
        GenericColor color = null;
        if (note instanceof ColoredAnnotation) {
            color = ((ColoredAnnotation)note).getColor();
        }
        if (color == null) {
            color = this.pd.BLACK;
        }
        this.g2d.setGraphicsColor(g, color);
    }

    public void setSolutionColor(VisibleInterface vi, boolean isNone, boolean asFitted) {
        for (int i = 0; i < this.nSpectra; ++i) {
            Spectrum spec = (Spectrum)this.spectra.get(i);
            int color = isNone || !spec.canShowSolutionColor() ? -1 : vi.getColour(spec, asFitted);
            spec.setFillColor(color == -1 ? null : this.pd.vwr.parameters.getColor1(color));
        }
    }

    public void setIRMode(Spectrum.IRMode mode, String type) {
        for (int i = 0; i < this.nSpectra; ++i) {
            Spectrum spec2;
            Spectrum spec = (Spectrum)this.spectra.get(i);
            if (!spec.dataType.equals(type) || (spec2 = Spectrum.taConvert(spec, mode)) == spec) continue;
            this.pd.setSpecForIRMode(spec2);
        }
    }

    public int getSpectrumCount() {
        return 0;
    }

    public void invertYAxis() {
        ((ViewData)this.viewList.get(0)).init(null, 0.0, 0.0, this.getSpectrum().invertYAxis().isContinuous());
        this.resetViewCompletely();
    }

    private class Highlight {
        double x1;
        double x2;
        GenericColor color;
        Spectrum spectrum;

        public String toString() {
            return "highlight " + this.x1 + " " + this.x2 + " " + this.spectrum;
        }

        Highlight(double x1, double x2, Spectrum spec, GenericColor color) {
            this.x1 = x1;
            this.x2 = x2;
            this.color = color;
            this.spectrum = spec;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Highlight)) {
                return false;
            }
            Highlight hl = (Highlight)obj;
            return hl.x1 == this.x1 && hl.x2 == this.x2;
        }
    }
}

