/*
 * Decompiled with CFR 0.152.
 */
package jspecview.dialog;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import jspecview.api.JSVPanel;
import jspecview.api.PlatformDialog;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.Spectrum;
import jspecview.dialog.JSVDialog;
import jspecview.source.JDXSource;

public abstract class DialogManager {
    protected JSViewer vwr;
    private Map<Object, String> htSelectors;
    protected Map<String, JSVDialog> htDialogs;
    private Map<String, Object> options;
    public static final int PLAIN_MESSAGE = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;

    public DialogManager set(JSViewer jSViewer) {
        this.vwr = jSViewer;
        this.htSelectors = new Hashtable<Object, String>();
        this.htDialogs = new Hashtable<String, JSVDialog>();
        return this;
    }

    public abstract PlatformDialog getDialog(JSVDialog var1);

    public abstract String getDialogInput(Object var1, String var2, String var3, int var4, Object var5, Object[] var6, String var7);

    public abstract int[] getLocationOnScreen(Object var1);

    public abstract int getOptionFromDialog(Object var1, String[] var2, JSVPanel var3, String var4, String var5);

    public abstract void showMessageDialog(Object var1, String var2, String var3, int var4);

    public abstract void showProperties(Object var1, Spectrum var2);

    public abstract void showMessage(Object var1, String var2, String var3);

    protected String registerDialog(JSVDialog jSVDialog) {
        String string = jSVDialog.optionKey;
        if (!string.endsWith("!")) {
            string = String.valueOf(string) + " " + ("" + Math.random()).substring(3);
        }
        if (this.htDialogs.containsKey(string)) {
            this.htDialogs.get(string).dispose();
        }
        this.htDialogs.put(string, jSVDialog);
        return string;
    }

    public void registerSelector(String string, Object object) {
        this.htSelectors.put(object, string);
    }

    protected String getSelectorName(Object object) {
        return this.htSelectors.get(object);
    }

    public void showSourceErrors(Object object, JDXSource jDXSource) {
        if (jDXSource == null) {
            this.showMessageDialog(object, "Please Select a Spectrum.", "Select Spectrum", 2);
            return;
        }
        String string = jDXSource.getErrorLog();
        if (string != null && string.length() > 0) {
            this.showMessage(object, string, DialogManager.fixTitle(jDXSource.getFilePath()));
        } else {
            this.showMessageDialog(object, "No errors found.", "Error Log", 1);
        }
    }

    public void showSource(Object object, String string) {
        if (string == null) {
            this.showMessageDialog(object, "Please Select a Spectrum", "Select Spectrum", 2);
            return;
        }
        try {
            String string2 = JSVFileManager.getFileAsString(string);
            if (this.vwr.isJS) {
                string2 = PT.rep(string2, "<", "&lt;");
            }
            this.showMessage(null, string2, DialogManager.fixTitle(string));
        }
        catch (Exception exception) {
            this.showMessageDialog(object, "File Not Found", "SHOWSOURCE", 0);
        }
    }

    protected void processClick(String string) {
        int n = string.lastIndexOf("/");
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        this.dialogCallback(string3, string2, null);
    }

    protected void processTableEvent(String string, int n, int n2, boolean bl) {
        int n3 = string.lastIndexOf("/");
        String string2 = string.substring(0, n3);
        String string3 = string.substring(n3 + 1);
        String string4 = "&selector=" + string3 + "&index=" + n + (n2 < 0 ? "&adjusting=" + bl : "&index2=" + n2);
        this.dialogCallback(string2, "tableSelect", string4);
    }

    protected void processWindowClosing(String string) {
        this.dialogCallback(string, "windowClosing", null);
        this.htDialogs.remove(string);
    }

    private void dialogCallback(String string, String string2, String string3) {
        JSVDialog jSVDialog = this.htDialogs.get(string);
        if (jSVDialog != null) {
            jSVDialog.callback(string2, string3);
        }
    }

    Map<String, Object> getDialogOptions() {
        if (this.options == null) {
            this.options = new Hashtable<String, Object>();
        }
        return this.options;
    }

    public static String fixTitle(String string) {
        return string.length() > 50 ? String.valueOf(string.substring(0, 50)) + "..." : string;
    }
}

