/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.quantum.QS;
import org.jmol.util.Logger;

public abstract class BasisFunctionReader
extends AtomSetCollectionReader {
    public Lst<int[]> shells;
    public Map<String, Object> moData = new Hashtable<String, Object>();
    public Lst<Map<String, Object>> orbitals = new Lst();
    protected int nOrbitals = 0;
    protected boolean ignoreMOs = false;
    protected String alphaBeta = "";
    protected int[][] dfCoefMaps;
    private String[] filterTokens;
    private boolean filterIsNot;
    private String spin;
    Map<String, String> orbitalMaps = new Hashtable<String, String>();
    private int[] highLEnabled = new int[QS.idSpherical.length];
    protected int nCoef;

    protected boolean filterMO() {
        boolean bl;
        boolean bl2 = bl = this.line.indexOf(10) == 0;
        if (!bl && !this.doReadMolecularOrbitals) {
            return false;
        }
        boolean bl3 = true;
        this.line = String.valueOf(this.line) + " " + this.alphaBeta;
        String string = this.line.toUpperCase();
        if (this.filter != null) {
            int n = 0;
            if (this.filterTokens == null) {
                this.filterIsNot = this.filter.indexOf("!") >= 0;
                this.filterTokens = PT.getTokens(this.filter.replace('!', ' ').replace(',', ' ').replace(';', ' '));
            }
            int n2 = 0;
            while (n2 < this.filterTokens.length) {
                if (string.indexOf(this.filterTokens[n2]) >= 0) {
                    if (!this.filterIsNot) {
                        n = this.filterTokens.length;
                        break;
                    }
                } else if (this.filterIsNot) {
                    ++n;
                }
                ++n2;
            }
            boolean bl4 = bl3 = n == this.filterTokens.length;
            if (!bl) {
                Logger.info("filter MOs: " + bl3 + " for \"" + this.line + "\"");
            }
        }
        this.spin = string.indexOf("ALPHA") >= 0 ? "alpha" : (string.indexOf("BETA") >= 0 ? "beta" : null);
        return bl3;
    }

    public void setMO(Map<String, Object> map) {
        if (this.dfCoefMaps != null) {
            map.put("dfCoefMaps", this.dfCoefMaps);
        }
        this.orbitals.addLast(map);
        map.put("index", this.orbitals.size());
        if (this.spin != null) {
            map.put("spin", this.spin);
        }
        this.moData.put("highLEnabled", this.highLEnabled);
    }

    protected boolean getDFMap(String string, String string2, int n, String string3, int n2) {
        this.orbitalMaps.put(string, string2);
        this.moData.put("orbitalMaps", this.orbitalMaps);
        this.enableShell(n);
        if (string2.equals(string3)) {
            return true;
        }
        this.getDfCoefMaps();
        boolean bl = QS.createDFMap(this.dfCoefMaps[n], string2, string3, n2);
        if (!bl) {
            Logger.error("Disabling orbitals of type " + n + " -- Cannot read orbital order for: " + string2 + "\n expecting: " + string3);
        }
        return bl;
    }

    protected void enableShell(int n) {
        this.highLEnabled[n] = 1;
    }

    public int[][] getDfCoefMaps() {
        return this.dfCoefMaps == null ? (this.dfCoefMaps = QS.getNewDfCoefMap()) : this.dfCoefMaps;
    }

    protected static final String canonicalizeQuantumSubshellTag(String string) {
        char c = string.charAt(0);
        if (c == 'X' || c == 'Y' || c == 'Z') {
            char[] cArray = string.toCharArray();
            Arrays.sort(cArray);
            return new String(cArray);
        }
        return string;
    }

    protected int fixSlaterTypes(int n, int n2) {
        if (this.shells == null) {
            return 0;
        }
        this.nCoef = 0;
        int n3 = this.shells.size();
        while (--n3 >= 0) {
            int[] nArray = (int[])this.shells.get(n3);
            if (nArray[1] == n) {
                nArray[1] = n2;
            }
            int n4 = this.getDfCoefMaps()[nArray[1]].length;
            this.nCoef += n4;
        }
        return this.nCoef;
    }

    public static int getQuantumShellTagIDSpherical(String string) {
        return QS.getQuantumShellTagIDSpherical(string);
    }

    public static int getQuantumShellTagID(String string) {
        return QS.getQuantumShellTagID(string);
    }

    public static String getQuantumShellTag(int n) {
        return QS.getQuantumShellTag(n);
    }

    @Override
    protected void discardPreviousAtoms() {
        this.asc.discardPreviousAtoms();
        this.moData.remove("mos");
        this.orbitals.clear();
    }

    protected void clearOrbitals() {
        this.orbitals = new Lst();
        this.moData = new Hashtable<String, Object>();
        this.alphaBeta = "";
    }

    public class MOEnergySorter
    implements Comparator<Object> {
        @Override
        public int compare(Object object, Object object2) {
            float f;
            float f2 = ((Float)((Map)object).get("energy")).floatValue();
            return f2 < (f = ((Float)((Map)object2).get("energy")).floatValue()) ? -1 : (f2 > f ? 1 : 0);
        }
    }
}

