/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterStructureIterator;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.CarbohydrateMonomer;
import org.jmol.modelsetbio.CarbohydratePolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.PhosphorusMonomer;
import org.jmol.modelsetbio.PhosphorusPolymer;
import org.jmol.script.SV;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public final class BioResolver
implements Comparator<String[]> {
    public static final Map<String, Short> htGroup = new Hashtable<String, Short>();
    private Viewer vwr;
    private V3 vAB;
    private V3 vNorm;
    private P4 plane;
    private ModelLoader ml;
    private ModelSet ms;
    private BS bsAddedMask;
    private int lastSetH = Integer.MIN_VALUE;
    private int maxSerial = 0;
    private boolean haveHsAlready;
    private BS bsAddedHydrogens;
    private BS bsAtomsForHs;
    private Map<String, String> htBondMap;
    private Map<String, Boolean> htGroupBonds;
    private String[] hNames;
    private int baseBondIndex = 0;
    private BS bsAssigned;
    private static STR[] types = new STR[]{STR.HELIXPI, STR.HELIXALPHA, STR.SHEET, STR.HELIX310, STR.TURN};
    private static int[] mytypes;
    private static Map<String, String[][]> htPdbBondInfo;
    public static final String[] pdbBondInfo;
    private static final int[] pdbHydrogenCount;
    private static final String allCarbohydrates = ",[AHR],[ALL],[AMU],[ARA],[ARB],[BDF],[BDR],[BGC],[BMA],[FCA],[FCB],[FRU],[FUC],[FUL],[GAL],[GLA],[GLC],[GXL],[GUP],[LXC],[MAN],[RAM],[RIB],[RIP],[XYP],[XYS],[CBI],[CT3],[CTR],[CTT],[LAT],[MAB],[MAL],[MLR],[MTT],[SUC],[TRE],[GCU],[MTL],[NAG],[NDG],[RHA],[SOR],[SOL],[SOE],[XYL],[A2G],[LBT],[NGA],[SIA],[SLB],[AFL],[AGC],[GLB],[NAN],[RAA]";
    private static int group3Count;
    static final char[] predefinedGroup1Names;
    public static short group3NameCount;
    private static final String[] predefinedGroup3Names;
    private static final String[] specialAtomNames;
    public static final int ATOMID_MAX;
    private static Map<String, Byte> htSpecialAtoms;
    private static final int[] argbsAmino;
    private static final int[] argbsNucleic;
    private static final int[] argbsChainAtom;
    private static final int[] argbsChainHetero;
    private static final int[] argbsShapely;

    static {
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 6;
        mytypes = nArray;
        pdbBondInfo = new String[]{"", "N N CA HA C O CB HB?", "N N CA HA C O CB B CG G CD D NE HE CZ NH1 NH1 HH11@HH12 NH2 HH22@HH21", "N N CA HA C O CB B CG OD1 ND2 HD21@HD22", "N N CA HA C O CB B CG OD1", "N N CA HA C O CB B SG HG", "N N CA HA C O CB B CG G CD OE1 NE2 HE22@HE21", "N N CA HA C O CB B CG G CD OE1", "N N CA HA2@HA3 C O", "N N CA HA C O CB B CG CD2 ND1 CE1 ND1 HD1 CD2 HD2 CE1 HE1 NE2 HE2", "N N CA HA C O CB HB CG1 HG13@HG12 CG2 HG2? CD1 HD1?", "N N CA HA C O CB B CG HG CD1 HD1? CD2 HD2?", "N N CA HA C O CB B CG G CD HD2@HD3 CE HE3@HE2 NZ HZ?", "N N CA HA C O CB B CG G CE HE?", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 CD2 HD2 CE1 CZ CE1 HE1 CE2 HE2 CZ HZ", "N H CA HA C O CB B CG G CD D", "N N CA HA C O CB B OG HG", "N N CA HA C O CB HB OG1 HG1 CG2 HG2?", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 NE1 HE1 CE3 CZ3 CE3 HE3 CZ2 CH2 CZ2 HZ2 CZ3 HZ3 CH2 HH2", "N N CA HA C O CB B CG CD1 CD1 HD1 CD2 CE2 CD2 HD2 CE1 CZ CE1 HE1 CE2 HE2 OH HH", "N N CA HA C O CB HB CG1 HG1? CG2 HG2?", "N N CA HA C O CB B", "N N CA HA C O CB B CG G", "", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 N2 H22@H21 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C2 O2 N3 C4 N4 H41@H42 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 N1 N6 H61@H62 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C7 H7? C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' H2' O2' HO2' C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 N2 H22@H21 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 C4 N4 H41@H42 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 N1 N6 H61@H62 C2 N3 C2 H2 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C7 H7? C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C2 O2 N3 H3 C4 O4 C5 C6 C5 H5 C6 H6 O3' HO3' O5' HO5'", "P OP1 C5' 5 C4' H4' C3' H3' C2' 2 C1' H1' C8 N7 C8 H8 C5 C4 C6 O6 N1 H1 C2 N3 C2 H2 O3' HO3' O5' HO5'"};
        int[] nArray2 = new int[36];
        nArray2[1] = 6;
        nArray2[2] = 16;
        nArray2[3] = 7;
        nArray2[4] = 6;
        nArray2[5] = 6;
        nArray2[6] = 9;
        nArray2[7] = 8;
        nArray2[8] = 4;
        nArray2[9] = 9;
        nArray2[10] = 12;
        nArray2[11] = 12;
        nArray2[12] = 14;
        nArray2[13] = 10;
        nArray2[14] = 10;
        nArray2[15] = 8;
        nArray2[16] = 6;
        nArray2[17] = 8;
        nArray2[18] = 11;
        nArray2[19] = 10;
        nArray2[20] = 10;
        nArray2[21] = 3;
        nArray2[22] = 5;
        nArray2[24] = 13;
        nArray2[25] = 13;
        nArray2[26] = 13;
        nArray2[27] = -1;
        nArray2[28] = 12;
        nArray2[29] = 12;
        nArray2[30] = 13;
        nArray2[31] = 13;
        nArray2[32] = 13;
        nArray2[33] = 14;
        nArray2[34] = 12;
        nArray2[35] = 12;
        pdbHydrogenCount = nArray2;
        char[] cArray = new char[42];
        cArray[1] = 65;
        cArray[2] = 82;
        cArray[3] = 78;
        cArray[4] = 68;
        cArray[5] = 67;
        cArray[6] = 81;
        cArray[7] = 69;
        cArray[8] = 71;
        cArray[9] = 72;
        cArray[10] = 73;
        cArray[11] = 76;
        cArray[12] = 75;
        cArray[13] = 77;
        cArray[14] = 70;
        cArray[15] = 80;
        cArray[16] = 83;
        cArray[17] = 84;
        cArray[18] = 87;
        cArray[19] = 89;
        cArray[20] = 86;
        cArray[21] = 65;
        cArray[22] = 71;
        cArray[23] = 63;
        cArray[24] = 71;
        cArray[25] = 67;
        cArray[26] = 65;
        cArray[27] = 84;
        cArray[28] = 85;
        cArray[29] = 73;
        cArray[30] = 71;
        cArray[31] = 67;
        cArray[32] = 65;
        cArray[33] = 84;
        cArray[34] = 85;
        cArray[35] = 73;
        cArray[36] = 71;
        cArray[37] = 67;
        cArray[38] = 65;
        cArray[39] = 84;
        cArray[40] = 85;
        cArray[41] = 73;
        predefinedGroup1Names = cArray;
        predefinedGroup3Names = new String[]{"   ", "ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "ASX", "GLX", "UNK", "G  ", "C  ", "A  ", "T  ", "U  ", "I  ", "DG ", "DC ", "DA ", "DT ", "DU ", "DI ", "+G ", "+C ", "+A ", "+T ", "+U ", "+I ", "HOH", "DOD", "WAT", "UREA", "PO4", "SO4", "UNL"};
        String[] stringArray = new String[101];
        stringArray[1] = "N";
        stringArray[2] = "CA";
        stringArray[3] = "C";
        stringArray[4] = "O";
        stringArray[5] = "O1";
        stringArray[6] = "O5'";
        stringArray[7] = "C5'";
        stringArray[8] = "C4'";
        stringArray[9] = "C3'";
        stringArray[10] = "O3'";
        stringArray[11] = "C2'";
        stringArray[12] = "C1'";
        stringArray[13] = "P";
        stringArray[14] = "OD1";
        stringArray[15] = "OD2";
        stringArray[16] = "OE1";
        stringArray[17] = "OE2";
        stringArray[18] = "SG";
        stringArray[32] = "N1";
        stringArray[33] = "C2";
        stringArray[34] = "N3";
        stringArray[35] = "C4";
        stringArray[36] = "C5";
        stringArray[37] = "C6";
        stringArray[38] = "O2";
        stringArray[39] = "N7";
        stringArray[40] = "C8";
        stringArray[41] = "N9";
        stringArray[42] = "N4";
        stringArray[43] = "N2";
        stringArray[44] = "N6";
        stringArray[45] = "C5M";
        stringArray[46] = "O6";
        stringArray[47] = "O4";
        stringArray[48] = "S4";
        stringArray[49] = "C7";
        stringArray[50] = "H1";
        stringArray[51] = "H2";
        stringArray[52] = "H3";
        stringArray[64] = "OXT";
        stringArray[65] = "H";
        stringArray[66] = "1H";
        stringArray[67] = "2H";
        stringArray[68] = "3H";
        stringArray[69] = "HA";
        stringArray[70] = "1HA";
        stringArray[71] = "2HA";
        stringArray[72] = "H5T";
        stringArray[73] = "O5T";
        stringArray[74] = "O1P";
        stringArray[75] = "OP1";
        stringArray[76] = "O2P";
        stringArray[77] = "OP2";
        stringArray[78] = "O4'";
        stringArray[79] = "O2'";
        stringArray[80] = "1H5'";
        stringArray[81] = "2H5'";
        stringArray[82] = "H4'";
        stringArray[83] = "H3'";
        stringArray[84] = "1H2'";
        stringArray[85] = "2H2'";
        stringArray[86] = "2HO'";
        stringArray[87] = "H1'";
        stringArray[88] = "H3T";
        stringArray[89] = "HO3'";
        stringArray[90] = "HO5'";
        stringArray[91] = "HA2";
        stringArray[92] = "HA3";
        stringArray[93] = "HA2";
        stringArray[94] = "H5'";
        stringArray[95] = "H5''";
        stringArray[96] = "H2'";
        stringArray[97] = "H2''";
        stringArray[98] = "HO2'";
        stringArray[99] = "O3P";
        stringArray[100] = "OP3";
        specialAtomNames = stringArray;
        ATOMID_MAX = specialAtomNames.length;
        argbsAmino = new int[]{-4284306, -3618616, -15443201, -16720676, -1701366, -1645056, -16720676, -1701366, -1315861, -8224046, -15760881, -15760881, -15443201, -1645056, -13487446, -2320766, -354816, -354816, -4957516, -13487446, -15760881, -38476, -38476, -4284306};
        argbsNucleic = new int[]{-4284306, -6250336, -15760881, -1645056, -1701366, -15443201, -16720676, -16720676, -15760881, -1645056, -1701366, -15443201, -16720676, -16720676, -15760881, -1645056, -1701366, -15443201, -16720676, -16720676};
        argbsChainAtom = new int[]{-1, -4140801, -5177424, -16184, -128, -16129, -5181200, -12176, -1015680, -663885, -16728065, -3318692, -10039894, -6632142, -1146130, -16724271, -16711809, -12799119, -16777077, -4343957, -16751616, -8388608, -8355840, -8388480, -16744320, -4684277, -5103070};
        argbsChainHetero = new int[]{-1, -7298865, -8335464, -3174224, -3158160, -3174193, -8339264, -3170208, -4173712, -3821949, -16734257, -4895668, -11094638, -7686870, -4296002, -16730463, -16724113, -13329567, -16777029, -5922981, -16739328, -5242880, -5197824, -5242704, -16731984, -1526253, -4050382};
        argbsShapely = new int[]{-65281, -16777092, -33680, -7536756, -6291390, -144, -46004, -10092544, -1, -9408257, -16757760, -12231099, -12105800, -11318190, -4677566, -11382190, -36798, -4699136, -11581952, -7573428, -29441, -65281, -65281, -65281, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073};
        if (argbsShapely.length != 42) {
            Logger.error("argbsShapely wrong length");
            throw new NullPointerException();
        }
        if (argbsAmino.length != 24) {
            Logger.error("argbsAmino wrong length");
            throw new NullPointerException();
        }
        if (argbsChainHetero.length != argbsChainAtom.length) {
            Logger.error("argbsChainHetero wrong length");
            throw new NullPointerException();
        }
    }

    public BioResolver setLoader(ModelLoader modelLoader) {
        this.ml = modelLoader;
        this.bsAddedMask = null;
        this.lastSetH = Integer.MIN_VALUE;
        this.maxSerial = 0;
        this.haveHsAlready = false;
        if (modelLoader == null) {
            this.ms = null;
            this.bsAssigned = null;
            this.bsAtomsForHs = null;
            this.bsAddedHydrogens = null;
            this.htBondMap = null;
            this.htGroupBonds = null;
            this.hNames = null;
        } else {
            Group.specialAtomNames = specialAtomNames;
            this.ms = modelLoader.ms;
            this.vwr = modelLoader.ms.vwr;
            modelLoader.specialAtomIndexes = new int[ATOMID_MAX];
        }
        return this;
    }

    public BioResolver setViewer(Viewer viewer) {
        this.vwr = viewer;
        if (Group.standardGroupList == null) {
            SB sB = new SB();
            int n = 1;
            while (n < 42) {
                sB.append(",[").append(predefinedGroup3Names[n]).append("]");
                ++n;
            }
            sB.append(allCarbohydrates);
            group3Count = sB.length() / 6;
            Group.standardGroupList = sB.toString();
            n = 0;
            int n2 = predefinedGroup3Names.length;
            while (n < n2) {
                BioResolver.addGroup3Name(predefinedGroup3Names[n].trim());
                ++n;
            }
        }
        return this;
    }

    public Model getBioModel(int n, int n2, String string, Properties properties, Map<String, Object> map) {
        return new BioModel(this.ms, n, n2, string, properties, map);
    }

    public Group distinguishAndPropagateGroup(Chain chain, String string, int n, int n2, int n3, int[] nArray, Atom[] atomArray) {
        int n4 = 0;
        int n5 = ATOMID_MAX;
        while (--n5 >= 0) {
            nArray[n5] = Integer.MIN_VALUE;
        }
        n5 = n3;
        while (n5 >= n2) {
            byte by = atomArray[n5].atomID;
            if (by > 0) {
                if (by < 14) {
                    n4 |= 1 << by;
                }
                nArray[by] = n5;
            }
            --n5;
        }
        Monomer monomer = null;
        if ((n4 & 0xE) == 14) {
            monomer = AminoMonomer.validateAndAllocate(chain, string, n, n2, n3, nArray, atomArray);
        } else if (n4 == 4) {
            monomer = AlphaMonomer.validateAndAllocateA(chain, string, n, n2, n3, nArray);
        } else if ((n4 & 0x1FC0) == 8128) {
            monomer = NucleicMonomer.validateAndAllocate(chain, string, n, n2, n3, nArray);
        } else if (n4 == 8192) {
            monomer = PhosphorusMonomer.validateAndAllocateP(chain, string, n, n2, n3, nArray);
        } else if (BioResolver.checkCarbohydrate(string)) {
            monomer = CarbohydrateMonomer.validateAndAllocate(chain, string, n, n2, n3);
        }
        return monomer != null && monomer.leadAtomIndex >= 0 ? monomer : null;
    }

    public void setHaveHsAlready(boolean bl) {
        this.haveHsAlready = bl;
    }

    public void initializeHydrogenAddition() {
        this.baseBondIndex = this.ms.bondCount;
        this.bsAddedHydrogens = new BS();
        this.bsAtomsForHs = new BS();
        this.htBondMap = new Hashtable<String, String>();
        this.htGroupBonds = new Hashtable<String, Boolean>();
        this.hNames = new String[3];
        this.vAB = new V3();
        this.vNorm = new V3();
        this.plane = new P4();
    }

    public void addImplicitHydrogenAtoms(JmolAdapter jmolAdapter, int n, int n2) {
        int n3;
        String string = this.ml.getGroup3(n);
        if (this.haveHsAlready || string == null || (n3 = BioResolver.getStandardPdbHydrogenCount(string)) == 0) {
            return;
        }
        n2 = n3 < 0 ? -1 : n3 + n2;
        Object object = null;
        int n4 = this.ml.getFirstAtomIndex(n);
        int n5 = this.ms.ac;
        if (n2 < 0) {
            if (n5 - n4 == 1) {
                return;
            }
            object = this.vwr.getLigandModel(string, "ligand_", "_data", null);
            if (object == null) {
                return;
            }
            n2 = jmolAdapter.getHydrogenAtomCount(object);
            if (n2 < 1) {
                return;
            }
        }
        this.getBondInfo(jmolAdapter, string, object);
        this.ms.am[this.ms.at[n4].mi].isPdbWithMultipleBonds = true;
        this.bsAtomsForHs.setBits(n4, n5);
        this.bsAddedHydrogens.setBits(n5, n5 + n2);
        boolean bl = this.ms.at[n4].isHetero();
        P3 p3 = P3.new3(Float.NaN, Float.NaN, Float.NaN);
        Atom atom = this.ms.at[n4];
        int n6 = 0;
        while (n6 < n2) {
            this.ms.addAtom(atom.mi, atom.group, 1, "H", null, 0, atom.getSeqID(), 0, p3, Float.NaN, null, 0, 0.0f, 1.0f, 0.0f, null, bl, (byte)0, null).delete(null);
            ++n6;
        }
    }

    private void getBondInfo(JmolAdapter jmolAdapter, String string, Object object) {
        String[][] stringArray;
        if (this.htGroupBonds.get(string) != null) {
            return;
        }
        String[][] stringArray2 = stringArray = object == null ? this.getPdbBondInfo(string, this.vwr.g.legacyHAddition) : this.getLigandBondInfo(jmolAdapter, object, string);
        if (stringArray == null) {
            return;
        }
        this.htGroupBonds.put(string, Boolean.TRUE);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                if (stringArray[n][1].charAt(0) == 'H') {
                    this.htBondMap.put(String.valueOf(string) + "." + stringArray[n][0], stringArray[n][1]);
                } else {
                    this.htBondMap.put(String.valueOf(string) + ":" + stringArray[n][0] + ":" + stringArray[n][1], stringArray[n][2]);
                }
            }
            ++n;
        }
    }

    private String[][] getLigandBondInfo(JmolAdapter jmolAdapter, Object object, String string) {
        String[][] stringArray = jmolAdapter.getBondList(object);
        Hashtable<String, P3> hashtable = new Hashtable<String, P3>();
        JmolAdapterAtomIterator jmolAdapterAtomIterator = jmolAdapter.getAtomIterator(object);
        while (jmolAdapterAtomIterator.hasNext()) {
            hashtable.put(jmolAdapterAtomIterator.getAtomName(), jmolAdapterAtomIterator.getXYZ());
        }
        String[][] stringArray2 = new String[stringArray.length * 2][];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String[] stringArray3 = stringArray[n2];
            if (stringArray3[0].charAt(0) != 'H') {
                stringArray2[n++] = new String[]{stringArray3[0], stringArray3[1], stringArray3[2], stringArray3[1].startsWith("H") ? "0" : "1"};
            }
            if (stringArray3[1].charAt(0) != 'H') {
                stringArray2[n++] = new String[]{stringArray3[1], stringArray3[0], stringArray3[2], stringArray3[0].startsWith("H") ? "0" : "1"};
            }
            ++n2;
        }
        Arrays.sort(stringArray2, this);
        int n3 = 0;
        block6: while (n3 < n) {
            String[] stringArray4 = stringArray2[n3];
            String string2 = stringArray4[0];
            int n4 = 0;
            int n5 = 0;
            while (n3 < n && (stringArray4 = stringArray2[n3])[0].equals(string2)) {
                if (stringArray4[3].equals("0")) {
                    ++n4;
                } else if (stringArray4[3].equals("1")) {
                    ++n5;
                }
                ++n3;
            }
            int n6 = n3 - n4 - n5;
            if (n4 == 1) continue;
            switch (n5) {
                case 1: {
                    char c = n4 == 2 ? (char)'@' : '|';
                    int n7 = 1;
                    while (n7 < n4) {
                        String[] stringArray5 = stringArray2[n6];
                        stringArray5[1] = String.valueOf(stringArray5[1]) + c + stringArray2[n6 + n7][1];
                        stringArray2[n6 + n7] = null;
                        ++n7;
                    }
                    continue block6;
                }
                case 2: {
                    if (n4 != 2) continue block6;
                    String string3 = stringArray2[n6][0];
                    String string4 = stringArray2[n6 + n4][1];
                    String string5 = stringArray2[n6 + n4 + 1][1];
                    int n8 = string4.compareTo(string5);
                    Measure.getPlaneThroughPoints((T3)hashtable.get(string4), (T3)hashtable.get(string3), (T3)hashtable.get(string5), this.vNorm, this.vAB, this.plane);
                    float f = Measure.distanceToPlane(this.plane, (T3)hashtable.get(stringArray2[n6][1])) * (float)n8;
                    stringArray2[n6][1] = f > 0.0f ? String.valueOf(stringArray2[n6][1]) + "@" + stringArray2[n6 + 1][1] : String.valueOf(stringArray2[n6 + 1][1]) + "@" + stringArray2[n6][1];
                    stringArray2[n6 + 1] = null;
                }
            }
        }
        n3 = 0;
        while (n3 < n) {
            String[] stringArray6 = stringArray2[n3];
            if (stringArray6 != null && stringArray6[1].charAt(0) != 'H' && stringArray6[0].compareTo(stringArray6[1]) > 0) {
                stringArray2[n3] = null;
            } else if (stringArray6 != null) {
                Logger.info(" ligand " + string + ": " + stringArray2[n3][0] + " - " + stringArray2[n3][1] + " order " + stringArray2[n3][2]);
            }
            ++n3;
        }
        return stringArray2;
    }

    @Override
    public int compare(String[] stringArray, String[] stringArray2) {
        return stringArray2 == null ? (stringArray == null ? 0 : -1) : (stringArray == null ? 1 : (stringArray[0].compareTo(stringArray2[0]) < 0 ? -1 : (stringArray[0].compareTo(stringArray2[0]) > 0 ? 1 : (stringArray[3].compareTo(stringArray2[3]) < 0 ? -1 : (stringArray[3].compareTo(stringArray2[3]) > 0 ? 1 : (stringArray[1].compareTo(stringArray2[1]) < 0 ? -1 : (stringArray[1].compareTo(stringArray2[1]) > 0 ? 1 : 0)))))));
    }

    public void finalizeHydrogens() {
        this.vwr.getLigandModel(null, null, null, null);
        this.finalizePdbMultipleBonds();
        this.addHydrogens();
    }

    private void addHydrogens() {
        if (this.bsAddedHydrogens.nextSetBit(0) < 0) {
            return;
        }
        this.bsAddedMask = BSUtil.copy(this.bsAddedHydrogens);
        this.finalizePdbCharges();
        int[] nArray = new int[1];
        P3[][] p3Array = this.ms.calculateHydrogens(this.bsAtomsForHs, nArray, true, false, null);
        Group group = null;
        int n = 0;
        int n2 = 0;
        while (n2 < p3Array.length) {
            if (p3Array[n2] != null) {
                Atom atom = this.ms.at[n2];
                Group group2 = atom.group;
                if (group2 != group) {
                    group = group2;
                    n = group2.lastAtomIndex;
                    while (this.bsAddedHydrogens.get(n)) {
                        --n;
                    }
                }
                String string = atom.getGroup3(false);
                String string2 = atom.getAtomName();
                String string3 = this.htBondMap.get(String.valueOf(string) + "." + string2);
                if (string3 != null) {
                    boolean bl = string3.contains("@");
                    boolean bl2 = string3.endsWith("?") || string3.indexOf("|") >= 0;
                    int n3 = p3Array[n2].length;
                    if (n3 == 3 && !bl2 && string3.equals("H@H2")) {
                        string3 = "H|H2|H3";
                        bl2 = true;
                        bl = false;
                    }
                    if (bl && n3 == 3 || bl2 != (n3 == 3)) {
                        Logger.info("Error adding H atoms to " + string + group2.getResno() + ": " + p3Array[n2].length + " atoms should not be added to " + string2);
                    } else {
                        int n4 = string3.indexOf("@");
                        switch (p3Array[n2].length) {
                            case 1: {
                                if (n4 > 0) {
                                    string3 = string3.substring(0, n4);
                                }
                                this.setHydrogen(n2, ++n, string3, p3Array[n2][0]);
                                break;
                            }
                            case 2: {
                                String string4;
                                String string5;
                                float f = -1.0f;
                                Bond[] bondArray = atom.bonds;
                                if (bondArray != null) {
                                    switch (bondArray.length) {
                                        case 2: {
                                            Atom atom2 = bondArray[0].getOtherAtom(atom);
                                            Atom atom3 = bondArray[1].getOtherAtom(atom);
                                            int n5 = atom2.getAtomName().compareTo(atom3.getAtomName());
                                            f = Measure.distanceToPlane(Measure.getPlaneThroughPoints(atom2, atom, atom3, this.vNorm, this.vAB, this.plane), p3Array[n2][0]) * (float)n5;
                                        }
                                    }
                                }
                                if (n4 < 0) {
                                    Logger.info("Error adding H atoms to " + string + group2.getResno() + ": expected to only need 1 H but needed 2");
                                    string5 = "H";
                                    string4 = "H";
                                } else if (f < 0.0f) {
                                    string5 = string3.substring(0, n4);
                                    string4 = string3.substring(n4 + 1);
                                } else {
                                    string4 = string3.substring(0, n4);
                                    string5 = string3.substring(n4 + 1);
                                }
                                this.setHydrogen(n2, ++n, string4, p3Array[n2][0]);
                                this.setHydrogen(n2, ++n, string5, p3Array[n2][1]);
                                break;
                            }
                            case 3: {
                                int n6 = string3.indexOf(124);
                                if (n6 >= 0) {
                                    int n7 = string3.lastIndexOf(124);
                                    this.hNames[0] = string3.substring(0, n6);
                                    this.hNames[1] = string3.substring(n6 + 1, n7);
                                    this.hNames[2] = string3.substring(n7 + 1);
                                } else {
                                    this.hNames[0] = string3.replace('?', '1');
                                    this.hNames[1] = string3.replace('?', '2');
                                    this.hNames[2] = string3.replace('?', '3');
                                }
                                this.setHydrogen(n2, ++n, this.hNames[0], p3Array[n2][0]);
                                this.setHydrogen(n2, ++n, this.hNames[1], p3Array[n2][2]);
                                this.setHydrogen(n2, ++n, this.hNames[2], p3Array[n2][1]);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        this.deleteUnneededAtoms();
        this.ms.fixFormalCharges(BSUtil.newBitSet2(this.ml.baseAtomIndex, this.ml.ms.ac));
    }

    private void deleteUnneededAtoms() {
        BS bS = new BS();
        int n = this.bsAtomsForHs.nextSetBit(0);
        while (n >= 0) {
            Atom atom = this.ms.at[n];
            if (atom.isHetero() && atom.getElementNumber() == 8 && atom.getFormalCharge() == 0 && atom.getCovalentBondCount() == 2) {
                Bond[] bondArray;
                Bond[] bondArray2 = atom.bonds;
                Bond[] bondArray3 = bondArray2[0].getOtherAtom(atom);
                Atom atom2 = bondArray2[1].getOtherAtom(atom);
                if (bondArray3.getElementNumber() == 1) {
                    bondArray = bondArray3;
                    bondArray3 = atom2;
                    atom2 = bondArray;
                }
                if (atom2.getElementNumber() == 1) {
                    bondArray = bondArray3.bonds;
                    int n2 = 0;
                    while (n2 < bondArray.length) {
                        Atom atom3;
                        if (bondArray[n2].order == 2 && (atom3 = bondArray[n2].getOtherAtom((Atom)bondArray3)).getElementNumber() == 8) {
                            this.bsAddedHydrogens.set(atom2.i);
                            atom2.delete(bS);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            n = this.bsAtomsForHs.nextSetBit(n + 1);
        }
        this.ms.deleteBonds(bS, true);
        this.deleteAtoms(this.bsAddedHydrogens);
    }

    private void deleteAtoms(BS bS) {
        int[] nArray = new int[this.ms.ac];
        int[] nArray2 = new int[this.ms.ac - bS.cardinality()];
        int n = this.ml.baseAtomIndex;
        Model[] modelArray = this.ms.am;
        Atom[] atomArray = this.ms.at;
        int n2 = this.ml.baseAtomIndex;
        while (n2 < this.ms.ac) {
            modelArray[atomArray[n2].mi].bsAtoms.clear(n2);
            modelArray[atomArray[n2].mi].bsAtomsDeleted.clear(n2);
            if (bS.get(n2)) {
                nArray[n2] = n - 1;
                --modelArray[atomArray[n2].mi].act;
            } else {
                nArray2[n] = n2;
                nArray[n2] = n++;
            }
            ++n2;
        }
        this.ms.msInfo.put("bsDeletedAtoms", bS);
        n2 = this.ml.baseGroupIndex;
        while (n2 < this.ml.groups.length) {
            Group group = this.ml.groups[n2];
            if (group.firstAtomIndex >= this.ml.baseAtomIndex) {
                group.firstAtomIndex = nArray[group.firstAtomIndex];
                group.lastAtomIndex = nArray[group.lastAtomIndex];
                if (group.leadAtomIndex >= 0) {
                    group.leadAtomIndex = nArray[group.leadAtomIndex];
                }
            }
            ++n2;
        }
        this.ms.adjustAtomArrays(nArray2, this.ml.baseAtomIndex, n);
        this.ms.calcBoundBoxDimensions(null, 1.0f);
        this.ms.resetMolecules();
        this.ms.validateBspf(false);
        this.bsAddedMask = BSUtil.deleteBits(this.bsAddedMask, bS);
        n2 = this.ml.baseModelIndex;
        while (n2 < this.ms.mc) {
            this.fixAnnotations(n2, "domains", 1073741925);
            this.fixAnnotations(n2, "validation", 1073742189);
            ++n2;
        }
    }

    private void fixAnnotations(int n, String string, int n2) {
        Object object;
        Object object2 = this.ml.ms.getInfo(n, string);
        if (object2 != null && (object = ((BioModel)this.ms.am[n]).getCachedAnnotationMap(string, object2)) != null) {
            this.vwr.getAnnotationParser(false).fixAtoms(n, (SV)object, this.bsAddedMask, n2, 20);
        }
    }

    private void finalizePdbCharges() {
        Atom[] atomArray = this.ms.at;
        int n = this.bsAtomsForHs.nextSetBit(0);
        while (n >= 0) {
            Atom atom = atomArray[n];
            if (atom.group.getNitrogenAtom() == atom && atom.getCovalentBondCount() == 1) {
                atom.setFormalCharge(1);
            }
            if ((n = this.bsAtomsForHs.nextClearBit(n + 1)) < 0) break;
            n = this.bsAtomsForHs.nextSetBit(n + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void finalizePdbMultipleBonds() {
        void var5_12;
        Object object;
        Object object2;
        Object object3;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int n = this.ms.bondCount;
        Bond[] bondArray = this.ms.bo;
        int n2 = this.baseBondIndex;
        while (n2 < n) {
            Atom object4 = bondArray[n2].atom1;
            object3 = bondArray[n2].atom2;
            object2 = object4.group;
            if (object2 == ((Atom)object3).group) {
                object = new SB().append(((Group)object2).getGroup3());
                ((SB)object).append(":");
                String string = object4.getAtomName();
                String string2 = ((Atom)object3).getAtomName();
                if (string.compareTo(string2) > 0) {
                    ((SB)object).append(string2).append(":").append(string);
                } else {
                    ((SB)object).append(string).append(":").append(string2);
                }
                String string3 = ((SB)object).toString();
                String string4 = this.htBondMap.get(string3);
                if (string4 != null) {
                    hashtable.put(string3, Boolean.TRUE);
                    bondArray[n2].setOrder(PT.parseInt(string4));
                }
            }
            ++n2;
        }
        for (String string : this.htBondMap.keySet()) {
            if (hashtable.get(string) != null) continue;
            if (string.indexOf(":") < 0) {
                hashtable.put(string, Boolean.TRUE);
                continue;
            }
            object3 = this.htBondMap.get(string);
            Logger.info("bond " + string + " was not used; order=" + (String)object3);
            if (!this.htBondMap.get(string).equals("1")) continue;
            hashtable.put(string, Boolean.TRUE);
        }
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        for (String string : this.htBondMap.keySet()) {
            if (hashtable.get(string) != null) continue;
            hashtable2.put(string.substring(0, string.lastIndexOf(":")), this.htBondMap.get(string));
        }
        if (hashtable2.isEmpty()) {
            return;
        }
        boolean bl = false;
        while (var5_12 < n) {
            object3 = bondArray[var5_12].atom1;
            object2 = bondArray[var5_12].atom2;
            if (((Atom)object3).group != ((Atom)object2).group && ((object = (String)hashtable2.get(String.valueOf(((Atom)object3).getGroup3(false)) + ":" + ((Atom)object3).getAtomName())) != null || (object = (String)hashtable2.get(String.valueOf(((Atom)object2).getGroup3(false)) + ":" + ((Atom)object2).getAtomName())) != null)) {
                bondArray[var5_12].setOrder(PT.parseInt((String)object));
                Logger.info("assigning order " + bondArray[var5_12].order + " to bond " + bondArray[var5_12]);
            }
            ++var5_12;
        }
    }

    private void setHydrogen(int n, int n2, String string, P3 p3) {
        if (!this.bsAddedHydrogens.get(n2)) {
            return;
        }
        Atom[] atomArray = this.ms.at;
        if (this.lastSetH == Integer.MIN_VALUE || atomArray[n2].mi != atomArray[this.lastSetH].mi) {
            this.lastSetH = n2;
            this.maxSerial = ((int[])this.ms.getInfo(atomArray[this.lastSetH].mi, "PDB_CONECT_firstAtom_count_max"))[2];
        }
        this.bsAddedHydrogens.clear(n2);
        this.ms.setAtomName(n2, string, false);
        atomArray[n2].setT(p3);
        this.ms.setAtomNumber(n2, ++this.maxSerial, false);
        atomArray[n2].atomSymmetry = atomArray[n].atomSymmetry;
        this.ml.undeleteAtom(n2);
        this.ms.bondAtoms(atomArray[n], atomArray[n2], 1, this.ms.getDefaultMadFromOrder(1), null, 0.0f, true, false);
    }

    public Object fixPropertyValue(BS bS, Object object, boolean bl) {
        Atom[] atomArray = this.ms.at;
        float[] fArray = (float[])object;
        float[] fArray2 = new float[bS.cardinality()];
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            block3: {
                block2: {
                    block1: {
                        if (atomArray[n3].getElementNumber() != 1) break block1;
                        if (bl) break block2;
                        break block3;
                    }
                    f = fArray[n++];
                }
                fArray2[n2] = f;
            }
            n3 = bS.nextSetBit(n3 + 1);
            ++n2;
        }
        return fArray2;
    }

    static BioPolymer allocateBioPolymer(Group[] groupArray, int n, boolean bl, int n2) {
        Object object = null;
        int n3 = 0;
        int n4 = n;
        while (n4 < groupArray.length) {
            Group group = groupArray[n4];
            if (!(group instanceof Monomer)) break;
            Monomer monomer = (Monomer)group;
            if (monomer.bioPolymer != null || object != null && object.getClass() != monomer.getClass() || bl && !monomer.isConnectedAfter((Monomer)object)) break;
            object = monomer;
            ++n3;
            ++n4;
        }
        if (n3 < 2) {
            return null;
        }
        Monomer[] monomerArray = new Monomer[n3];
        int n5 = 0;
        while (n5 < n3) {
            monomerArray[n5] = (Monomer)groupArray[n + n5];
            ++n5;
        }
        if (object instanceof AminoMonomer) {
            return new AminoPolymer(monomerArray, n2);
        }
        if (object instanceof AlphaMonomer) {
            return new AlphaPolymer(monomerArray, n2);
        }
        if (object instanceof NucleicMonomer) {
            return new NucleicPolymer(monomerArray);
        }
        if (object instanceof PhosphorusMonomer) {
            return new PhosphorusPolymer(monomerArray);
        }
        if (object instanceof CarbohydrateMonomer) {
            return new CarbohydratePolymer(monomerArray);
        }
        Logger.error("Polymer.allocatePolymer() ... no matching polymer for monomor " + object);
        throw new NullPointerException();
    }

    public void iterateOverAllNewStructures(JmolAdapter jmolAdapter, Object object) {
        JmolAdapterStructureIterator jmolAdapterStructureIterator = jmolAdapter.getStructureIterator(object);
        if (jmolAdapterStructureIterator == null) {
            return;
        }
        BS bS = jmolAdapterStructureIterator.getStructuredModels();
        if (bS != null) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.ml.structuresDefinedInFile.set(this.ml.baseModelIndex + n);
                n = bS.nextSetBit(n + 1);
            }
        }
        while (jmolAdapterStructureIterator.hasNext()) {
            if (jmolAdapterStructureIterator.getStructureType() == STR.TURN) continue;
            this.setStructure(jmolAdapterStructureIterator);
        }
        jmolAdapterStructureIterator = jmolAdapter.getStructureIterator(object);
        while (jmolAdapterStructureIterator.hasNext()) {
            if (jmolAdapterStructureIterator.getStructureType() != STR.TURN) continue;
            this.setStructure(jmolAdapterStructureIterator);
        }
    }

    private void setStructure(JmolAdapterStructureIterator jmolAdapterStructureIterator) {
        int n;
        int n2;
        STR sTR = jmolAdapterStructureIterator.getSubstructureType();
        String string = jmolAdapterStructureIterator.getStructureID();
        int n3 = jmolAdapterStructureIterator.getSerialID();
        int n4 = jmolAdapterStructureIterator.getStrandCount();
        int[] nArray = jmolAdapterStructureIterator.getAtomIndices();
        int[] nArray2 = jmolAdapterStructureIterator.getModelIndices();
        BS[] bSArray = jmolAdapterStructureIterator.getBSAll();
        Model[] modelArray = this.ms.am;
        if (this.ml.isTrajectory) {
            n = n2 = nArray2[0];
        } else {
            n = nArray2[0] + this.ml.baseModelIndex;
            n2 = nArray2[1] + this.ml.baseModelIndex;
        }
        this.ml.structuresDefinedInFile.setBits(n, n2 + 1);
        if (bSArray != null) {
            int n5 = n;
            while (n5 <= n2) {
                Model model = modelArray[n5];
                if (model instanceof BioModel) {
                    int n6 = 0;
                    while (n6 < 5) {
                        int n7 = mytypes[n6];
                        BS bS = bSArray[n7];
                        if (bS != null) {
                            ((BioModel)model).addStructureByBS(0, n7, types[n6], bS);
                        }
                        ++n6;
                    }
                }
                ++n5;
            }
            return;
        }
        int n8 = jmolAdapterStructureIterator.getStartChainID();
        int n9 = jmolAdapterStructureIterator.getStartSequenceNumber();
        char c = jmolAdapterStructureIterator.getStartInsertionCode();
        int n10 = jmolAdapterStructureIterator.getEndSequenceNumber();
        int n11 = jmolAdapterStructureIterator.getEndChainID();
        char c2 = jmolAdapterStructureIterator.getEndInsertionCode();
        STR sTR2 = sTR == STR.NOT ? STR.NONE : sTR;
        int n12 = Group.getSeqcodeFor(n9, c);
        int n13 = Group.getSeqcodeFor(n10, c2);
        if (this.bsAssigned == null) {
            this.bsAssigned = new BS();
        }
        int n14 = n;
        int n15 = 0;
        while (n14 <= n2) {
            Model model = modelArray[n14];
            if (model instanceof BioModel) {
                n15 = model.firstAtomIndex;
                ((BioModel)model).addSecondaryStructure(sTR2, string, n3, n4, n8, n12, n11, n13, n15 + nArray[0], n15 + nArray[1], this.bsAssigned);
            }
            ++n14;
        }
    }

    public void setGroupLists(int n) {
        this.ml.group3Lists[n + 1] = Group.standardGroupList;
        this.ml.group3Counts[n + 1] = new int[group3Count + 10];
        if (this.ml.group3Lists[0] == null) {
            this.ml.group3Lists[0] = Group.standardGroupList;
            this.ml.group3Counts[0] = new int[group3Count + 10];
        }
    }

    public boolean isKnownPDBGroup(String string, int n) {
        short s = BioResolver.knownGroupID(string);
        return s > 0 ? s < n : n == Integer.MAX_VALUE && BioResolver.checkCarbohydrate(string);
    }

    public byte lookupSpecialAtomID(String string) {
        Byte by;
        if (htSpecialAtoms == null) {
            htSpecialAtoms = new Hashtable<String, Byte>();
            int n = specialAtomNames.length;
            while (--n >= 0) {
                String string2 = specialAtomNames[n];
                if (string2 == null) continue;
                htSpecialAtoms.put(string2, (byte)n);
            }
        }
        return (by = htSpecialAtoms.get(string)) == null ? (byte)0 : by;
    }

    private String[][] getPdbBondInfo(String string, boolean bl) {
        String[][] stringArray;
        if (htPdbBondInfo == null) {
            htPdbBondInfo = new Hashtable<String, String[][]>();
        }
        if ((stringArray = htPdbBondInfo.get(string)) != null) {
            return stringArray;
        }
        int n = BioResolver.knownGroupID(string);
        if (n < 0 || n > pdbBondInfo.length) {
            return null;
        }
        String string2 = pdbBondInfo[n];
        if (bl && (n = string2.indexOf("O3'")) >= 0) {
            string2 = string2.substring(0, n);
        }
        String[] stringArray2 = PT.getTokens(string2);
        stringArray = new String[stringArray2.length / 2][];
        int n2 = 0;
        int n3 = 0;
        while (n2 < stringArray.length) {
            String string3;
            String string4 = stringArray2[n3++];
            if ((string3 = stringArray2[n3++]).length() == 1) {
                switch (string3.charAt(0)) {
                    case 'N': {
                        string3 = "H@H2";
                        break;
                    }
                    case 'B': {
                        string3 = "HB3@HB2";
                        break;
                    }
                    case 'D': {
                        string3 = "HD3@HD2";
                        break;
                    }
                    case 'G': {
                        string3 = "HG3@HG2";
                        break;
                    }
                    case '2': {
                        string3 = "H2'@H2''";
                        break;
                    }
                    case '5': {
                        string3 = "H5''@H5'";
                    }
                }
            }
            if (string3.charAt(0) != 'H' && string4.compareTo(string3) > 0) {
                string2 = string3;
                string3 = string4;
                string4 = string2;
            }
            stringArray[n2] = new String[]{string4, string3, string3.startsWith("H") ? "1" : "2"};
            ++n2;
        }
        htPdbBondInfo.put(string, stringArray);
        return stringArray;
    }

    public static short knownGroupID(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        Short s = htGroup.get(string);
        return s == null ? (short)-1 : (short)s;
    }

    private static final boolean checkCarbohydrate(String string) {
        return string != null && allCarbohydrates.indexOf("[" + string.toUpperCase() + "]") >= 0;
    }

    public boolean isHetero(String string) {
        switch (string.length()) {
            case 1: {
                string = String.valueOf(string) + "  ";
                break;
            }
            case 2: {
                string = String.valueOf(string) + " ";
                break;
            }
            case 3: {
                break;
            }
            default: {
                return true;
            }
        }
        int n = Group.standardGroupList.indexOf(string);
        return n < 0 || n / 6 + 1 >= 42;
    }

    public String toStdAmino3(String string) {
        int n;
        if (string.length() == 0) {
            return "";
        }
        SB sB = new SB();
        int n2 = BioResolver.knownGroupID("==A");
        if (n2 < 0) {
            n = 1;
            while (n <= 20) {
                n2 = BioResolver.knownGroupID(predefinedGroup3Names[n]);
                htGroup.put("==" + predefinedGroup1Names[n], (short)n2);
                ++n;
            }
        }
        n = 0;
        int n3 = string.length();
        while (n < n3) {
            char c = string.charAt(n);
            n2 = BioResolver.knownGroupID("==" + c);
            if (n2 < 0) {
                n2 = 23;
            }
            sB.append(" ").append(predefinedGroup3Names[n2]);
            ++n;
        }
        return sB.toString().substring(1);
    }

    public short getGroupID(String string) {
        return BioResolver.getGroupIdFor(string);
    }

    static short getGroupIdFor(String string) {
        short s;
        if (string != null) {
            string = string.trim();
        }
        return (s = BioResolver.knownGroupID(string)) == -1 ? BioResolver.addGroup3Name(string) : s;
    }

    private static synchronized short addGroup3Name(String string) {
        if (group3NameCount == Group.group3Names.length) {
            Group.group3Names = AU.doubleLengthS(Group.group3Names);
        }
        short s = group3NameCount;
        group3NameCount = (short)(s + 1);
        short s2 = s;
        Group.group3Names[s2] = string;
        htGroup.put(string, s2);
        return s2;
    }

    private static int getStandardPdbHydrogenCount(String string) {
        short s = BioResolver.knownGroupID(string);
        return s < 0 || s >= pdbHydrogenCount.length ? -1 : pdbHydrogenCount[s];
    }

    static final String getSpecialAtomName(int n) {
        return specialAtomNames[n];
    }

    public int[] getArgbs(int n) {
        switch (n) {
            case 0x20000E: {
                return argbsNucleic;
            }
            case 0x200002: {
                return argbsAmino;
            }
            case 0x40000140: {
                return argbsShapely;
            }
            case 0x44000001: {
                return argbsChainAtom;
            }
            case 0x60200006: {
                return argbsChainHetero;
            }
        }
        return null;
    }
}

