/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.PT;
import jspecview.application.MainFrame;
import org.jmol.api.JSVInterface;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolSyncInterface;
import org.jmol.c.CBK;
import org.jmol.dialog.Dialog;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.JmolPlugin;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.jmolpanel.console.AppConsole;
import org.openscience.jmol.app.webexport.WebExport;

class StatusListener
implements JmolStatusListener,
JmolSyncInterface,
JSVInterface {
    private JmolPanel jmol;
    private DisplayPanel display;
    private Viewer vwr;
    private MainFrame jSpecViewFrame;
    private boolean jSpecViewForceNew;
    private Map<String, Object> nboOptions;
    private int modificationMode;
    private String lastSimulate;
    private static String propertiesFileName = "jspecview.properties";

    void setViewer(Viewer viewer) {
        this.vwr = viewer;
    }

    StatusListener(JmolPanel jmolPanel, DisplayPanel displayPanel) {
        this.jmol = jmolPanel;
        this.display = displayPanel;
    }

    @Override
    public boolean notifyEnabled(CBK cBK) {
        switch (cBK) {
            case ANIMFRAME: 
            case ECHO: 
            case IMAGE: 
            case LOADSTRUCT: 
            case MEASURE: 
            case MESSAGE: 
            case SERVICE: 
            case PICK: 
            case SCRIPT: 
            case SYNC: 
            case STRUCTUREMODIFIED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyCallback(CBK cBK, Object[] objectArray) {
        JmolCallbackListener jmolCallbackListener;
        if (!this.jmol.plugins.isEmpty()) {
            for (JmolPlugin object2 : this.jmol.plugins.values()) {
                object2.notifyCallback(cBK, objectArray);
            }
        }
        String string = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
        switch (cBK) {
            case LOADSTRUCT: {
                this.notifyFileLoaded(string, (String)objectArray[2], (String)objectArray[3], (String)objectArray[4], (Boolean)objectArray[8]);
                if (this.jmol.gaussianDialog != null) {
                    this.jmol.gaussianDialog.updateModel(-2);
                }
                return;
            }
            case ANIMFRAME: {
                int[] jmolCallbackListener2 = (int[])objectArray[1];
                int n = jmolCallbackListener2[0];
                if (n <= -2) {
                    n = -2 - n;
                }
                if (this.display.haveDisplay) {
                    String n2 = (String)objectArray[2];
                    if (n2.equals("0.0: ")) {
                        n2 = "";
                    }
                    this.display.status.setStatus(1, n2);
                    if (this.jmol.frame != null) {
                        this.jmol.frame.setTitle(n2);
                    }
                }
                return;
            }
            case SCRIPT: {
                int n = (Integer)objectArray[3];
                if (n == 0 && objectArray[2] != null && this.display.haveDisplay) {
                    this.display.status.setStatus(1, (String)objectArray[2]);
                }
                return;
            }
            case ECHO: {
                break;
            }
            case MEASURE: {
                String string2 = (String)objectArray[3];
                if (string2.indexOf("Sequence") >= 0) break;
                if (string2.indexOf("Pending") < 0 && this.display.haveDisplay) {
                    this.display.measurementTable.updateTables();
                }
                if (string2.indexOf("Picked") >= 0) {
                    this.notifyAtomPicked(string);
                    break;
                }
                if (string2.indexOf("Completed") >= 0) break;
                return;
            }
            case MESSAGE: {
                break;
            }
            case SERVICE: {
                if (this.display == null) {
                    return;
                }
                Map map = (Map)objectArray[1];
                try {
                    String exception = (String)map.get("service");
                    if ("nbo".equals(exception) && "showPanel".equals(map.get("action"))) {
                        this.jmol.startNBO(map);
                    }
                }
                catch (Exception n) {
                    // empty catch block
                }
                return;
            }
            case PICK: {
                this.notifyAtomPicked(string);
                if (this.jmol.gaussianDialog == null) break;
                this.jmol.gaussianDialog.updateModel((Integer)objectArray[2]);
                break;
            }
            case STRUCTUREMODIFIED: {
                int n = (Integer)objectArray[1];
                int n3 = (Integer)objectArray[2];
                int n4 = (Integer)objectArray[3];
                this.notifyStructureModified(n3, n4, n);
                if (this.jmol.gaussianDialog == null) break;
                this.jmol.gaussianDialog.updateModel(-1);
                break;
            }
            case SYNC: {
                String string3;
                String string4 = string3 = string == null ? "" : string.toLowerCase();
                if (string3.startsWith("jspecview")) {
                    this.setJSpecView(string.substring(9).trim(), false, false);
                    return;
                }
                if (string3.equals("getpreference")) {
                    objectArray[0] = objectArray[2] == null ? this.jmol.preferencesDialog : this.jmol.getPreference(objectArray[2].toString());
                    return;
                }
                if (string != null && string.toLowerCase().startsWith("nbo:")) {
                    if (this.nboOptions == null) {
                        this.nboOptions = new Hashtable<String, Object>();
                    }
                    this.nboOptions.put("options", string);
                    this.jmol.startNBO(this.nboOptions);
                    return;
                }
                this.jmol.sendNioMessage((Integer)objectArray[3], string);
                return;
            }
            case APPLETREADY: 
            case ATOMMOVED: 
            case AUDIO: 
            case CLICK: 
            case DRAGDROP: 
            case ERROR: 
            case EVAL: 
            case HOVER: 
            case IMAGE: 
            case MINIMIZATION: 
            case RESIZE: {
                return;
            }
        }
        if (this.jmol.service != null) {
            this.jmol.service.scriptCallback(string);
        }
        if ((jmolCallbackListener = (JmolCallbackListener)this.vwr.getProperty("DATA_API", "getAppConsole", null)) != null) {
            jmolCallbackListener.notifyCallback(cBK, objectArray);
        }
    }

    private void notifyStructureModified(int n, int n2, int n3) {
        this.modificationMode = n3;
        if (n3 < 0) {
            switch (n3) {
                case -5: 
                case -4: 
                case -3: 
                case -2: 
                case -1: {
                    this.checkJSpecView(false);
                    return;
                }
            }
        }
    }

    @Override
    public void setCallbackFunction(String string, String string2) {
        if (string.equals("modelkit")) {
            if (string2.equals("ON")) {
                this.display.buttonModelkit.setSelected(true);
            } else {
                this.display.buttonRotate.setSelected(true);
            }
            return;
        }
        if (string.equalsIgnoreCase("language")) {
            AppConsole appConsole;
            JmolResourceHandler.clear();
            Dialog.setupUIManager();
            if (this.jmol.webExport != null) {
                WebExport.saveHistory();
                WebExport.dispose();
                this.jmol.createWebExport();
            }
            if ((appConsole = (AppConsole)this.vwr.getProperty("DATA_API", "getAppConsole", null)) != null) {
                appConsole.sendConsoleEcho(null);
            }
            this.jmol.updateLabels();
            return;
        }
    }

    @Override
    public String eval(String string) {
        String string2 = "# this funcationality is implemented only for the applet.\n" + string;
        this.sendConsoleMessage(string2);
        return string2;
    }

    @Override
    public String createImage(String string, String string2, Object object, int n) {
        return null;
    }

    private void notifyAtomPicked(String string) {
        if (this.display.haveDisplay) {
            this.display.status.setStatus(1, string);
        }
    }

    private void notifyFileLoaded(String string, String string2, String string3, String string4, Boolean bl) {
        if (string4 != null) {
            return;
        }
        if (!this.display.haveDisplay) {
            return;
        }
        String string5 = "Jmol";
        if (string2 != null && string2.startsWith("DROP_")) {
            string2 = string2.substring(5);
        }
        if (string3 != null && string2 != null) {
            string5 = String.valueOf(string2.contains("&") ? "" : String.valueOf(string2) + " - ") + string3;
        } else if (string2 != null) {
            string5 = string2;
        } else if (string3 != null) {
            string5 = string3;
        }
        this.jmol.notifyFileOpen(string == null ? null : String.valueOf(string) + (bl == Boolean.TRUE ? " (*)" : ""), string5);
        this.checkJSpecView(string == null);
    }

    private void sendConsoleMessage(String string) {
        JmolAppConsoleInterface jmolAppConsoleInterface = (JmolAppConsoleInterface)this.vwr.getProperty("DATA_API", "getAppConsole", null);
        if (jmolAppConsoleInterface != null) {
            jmolAppConsoleInterface.sendConsoleMessage(string);
        }
    }

    @Override
    public void showUrl(String string) {
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Method method = clazz.getMethod("getDesktop", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("browse", URI.class);
            Object[] objectArray = new Object[]{new URI(string)};
            method2.invoke(object, objectArray);
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
            JmolAppConsoleInterface jmolAppConsoleInterface = (JmolAppConsoleInterface)this.vwr.getProperty("DATA_API", "getAppConsole", null);
            if (jmolAppConsoleInterface != null) {
                jmolAppConsoleInterface.sendConsoleMessage("Java 6 Desktop.browse() capability unavailable. Could not open " + string);
            }
            Logger.error("Java 6 Desktop.browse() capability unavailable. Could not open " + string);
        }
    }

    @Override
    public float[][] functionXY(String string, int n, int n2) {
        n = Math.abs(n);
        n2 = Math.abs(n2);
        float[][] fArray = new float[n][n2];
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                float f = (float)n3 / 5.0f;
                float f2 = (float)n4 / 5.0f;
                fArray[n3][n4] = f * f + f2;
                if (!Float.isNaN(fArray[n3][n4])) continue;
                fArray[n3][n4] = -((float)Math.sqrt(-f * f - f2));
            }
        }
        return fArray;
    }

    @Override
    public float[][][] functionXYZ(String string, int n, int n2, int n3) {
        n = Math.abs(n);
        n2 = Math.abs(n2);
        n3 = Math.abs(n3);
        float[][][] fArray = new float[n][n2][n3];
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                int n6 = n3;
                while (--n6 >= 0) {
                    float f = (float)n4 / ((float)(n - 1) / 2.0f) - 1.0f;
                    float f2 = (float)n5 / ((float)(n2 - 1) / 2.0f) - 1.0f;
                    float f3 = (float)n6 / ((float)(n3 - 1) / 2.0f) - 1.0f;
                    fArray[n4][n5][n6] = f * f + f2 * f2 - f3 * f3;
                }
            }
        }
        return fArray;
    }

    @Override
    public Map<String, Object> getRegistryInfo() {
        return null;
    }

    @Override
    public int[] resizeInnerPanel(String string) {
        return this.jmol.resizeInnerPanel(string);
    }

    private void checkJSpecView(boolean bl) {
        if (this.jSpecViewFrame != null && this.modificationMode <= 0) {
            this.jSpecViewForceNew = this.jSpecViewFrame.isVisible();
            this.setJSpecView(bl ? "none" : "", true, true);
            this.jSpecViewForceNew = true;
        }
    }

    public void setJSpecView(String string, boolean bl, boolean bl2) {
        if (string.startsWith(":")) {
            string = string.substring(1);
        }
        if (string.equals("none") || string.equals("NONESimulate:")) {
            if (this.jSpecViewFrame != null) {
                this.jSpecViewFrame.syncScript("close ALL");
                this.jSpecViewFrame.awaken(false);
            }
            return;
        }
        boolean bl3 = string.equals("C13Simulate:");
        boolean bl4 = string.equals("H1Simulate:") || bl3;
        boolean bl5 = string.length() == 0 || bl4;
        boolean bl6 = bl4 && !string.equals(this.lastSimulate);
        String string2 = null;
        if (bl4 && ((string2 = this.vwr.extractMolData(null)) == null || string2.length() == 0)) {
            return;
        }
        if (this.jSpecViewFrame == null) {
            this.jSpecViewFrame = new MainFrame(this.vwr.getBoolean(603979869) ? (Component)this.vwr.display : null, this);
            this.jSpecViewFrame.setSize(Math.max(1000, this.jmol.frame.getWidth() + 50), 600);
            this.jSpecViewFrame.setLocation(this.jmol.frame.getLocation().x + 10, this.jmol.frame.getLocation().y + 100);
            this.jSpecViewFrame.register("Jmol", this);
            this.vwr.setBooleanProperty("_jspecview", true);
            if (bl5) {
                bl = true;
            }
        }
        if (bl || this.jSpecViewForceNew || bl6) {
            String string3 = "" + this.vwr.getP("_modelType");
            if (string3.equalsIgnoreCase("jcampdx")) {
                this.jSpecViewForceNew = false;
                String string4 = "" + this.vwr.getP("_modelFile");
                if (string4.indexOf("/") < 0) {
                    return;
                }
                string = "hidden true; load CHECK " + PT.esc(string4) + ";hidden false" + (bl6 && bl3 ? ";scaleby 0.5" : null);
            } else {
                if (bl2 && !this.jSpecViewForceNew && !bl6) {
                    return;
                }
                this.jSpecViewForceNew = false;
                if (bl6) {
                    this.lastSimulate = string;
                }
                String string5 = "" + this.vwr.getP("_modelNumber");
                if (string2 == null) {
                    string = "hidden false";
                } else {
                    string2 = PT.replaceAllCharacters(string2, "&", "_");
                    string = "hidden true; load CHECK " + (string.equals("H1Simulate:") ? "H1 " : "C13 ") + PT.esc("id='~" + string5 + "';" + string2) + ";hidden false #SYNC_PEAKS";
                }
                bl5 = false;
            }
        }
        if (!this.jSpecViewFrame.isVisible()) {
            if (string.contains("<PeakData")) {
                return;
            }
            this.jSpecViewFrame.awaken(true);
            this.display.setViewer(this.vwr);
        }
        if (bl5) {
            string = "HIDDEN false";
        }
        this.jSpecViewFrame.syncScript(string);
    }

    @Override
    public void register(String string, JmolSyncInterface jmolSyncInterface) {
    }

    @Override
    public void syncScript(String string) {
        this.jmol.syncScript(string);
    }

    @Override
    public void setProperties(Properties properties) {
        try {
            FileInputStream fileInputStream = new FileInputStream(propertiesFileName);
            properties.load(fileInputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void saveProperties(Properties properties) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(propertiesFileName);
            properties.store(fileOutputStream, "JSpecView Application Properties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void exitJSpecView(boolean bl, Object object) {
    }

    @Override
    public void runScript(String string) {
        this.jSpecViewFrame.runScriptNow(string);
    }

    @Override
    public void syncToJmol(String string) {
    }

    @Override
    public Map<String, Object> getJSpecViewProperty(String string) {
        if (string.toLowerCase().startsWith("jspecview")) {
            if ((string = string.substring(9)).startsWith(":")) {
                string = string.substring(1);
            }
            return this.jSpecViewFrame == null ? null : this.jSpecViewFrame.getJSpecViewProperty(string);
        }
        return null;
    }
}

