/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import javajs.util.BS;
import javax.swing.filechooser.FileSystemView;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.webexport.LogPanel;

class JmolInstance {
    String name;
    String javaname;
    String script;
    int width;
    int height;
    int bgColor;
    boolean spinOn;
    String pictFile;
    BS whichWidgets;
    boolean pictIsScratchFile;
    JmolViewer vwr;

    public static JmolInstance getInstance(JmolViewer jmolViewer, String string, int n, int n2, int n3) {
        JmolInstance jmolInstance = new JmolInstance(jmolViewer, string, n, n2, n3);
        return jmolInstance.script == null ? null : jmolInstance;
    }

    private JmolInstance(JmolViewer jmolViewer, String string, int n, int n2, int n3) {
        boolean bl;
        this.vwr = jmolViewer;
        this.name = string;
        this.width = n;
        this.height = n2;
        this.script = jmolViewer.getStateInfo();
        this.spinOn = jmolViewer.getBooleanProperty("_spinning");
        if (this.script == null) {
            LogPanel.log("Error trying to get Jmol State when saving view/instance.");
            return;
        }
        this.bgColor = jmolViewer.getBackgroundArgb();
        this.javaname = string.replaceAll("[^a-zA-Z_0-9-]", "_");
        this.whichWidgets = BS.newN(n3);
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File file = fileSystemView.getHomeDirectory();
        String string2 = file.getPath();
        String string3 = String.valueOf(string2) + "/.jmol_WPM";
        File file2 = new File(string3);
        if (!file2.exists() && !(bl = file2.mkdir())) {
            LogPanel.log(GT.$("Attempt to make scratch directory failed."));
        }
        this.pictFile = String.valueOf(string3) + "/" + this.javaname + ".png";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("fileName", this.pictFile);
        hashtable.put("type", "PNG");
        hashtable.put("quality", 2);
        hashtable.put("width", n);
        hashtable.put("height", n2);
        jmolViewer.outputToFile(hashtable);
        this.pictIsScratchFile = true;
    }

    boolean movepict(String string) throws IOException {
        String string2 = String.valueOf(string) + "/" + this.javaname + ".png";
        if (this.pictFile.equals(string2)) {
            return false;
        }
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(this.pictFile);
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(string2);
        int n = fileInputStream.read();
        while (n != -1) {
            fileOutputStream.write(n);
            n = fileInputStream.read();
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        fileInputStream.close();
        return true;
    }

    boolean delete() throws IOException {
        File file = new File(this.pictFile);
        if (file.exists() && !file.delete()) {
            throw new IOException("Failed to delete scratch file " + this.pictFile + ".");
        }
        return true;
    }

    boolean addWidget(int n) {
        if (n > this.whichWidgets.size()) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        this.whichWidgets.set(n);
        return true;
    }

    boolean deleteWidget(int n) {
        if (n > this.whichWidgets.size()) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        this.whichWidgets.clear(n);
        return true;
    }
}

