/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.util;

import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.util.Printer;
import org.jruby.org.objectweb.asm.util.TraceAnnotationVisitor;

public final class TraceMethodVisitor
extends MethodVisitor {
    public final Printer p;

    public TraceMethodVisitor(Printer printer) {
        this(null, printer);
    }

    public TraceMethodVisitor(MethodVisitor methodVisitor, Printer printer) {
        super(0x1070000, methodVisitor);
        this.p = printer;
    }

    public void visitParameter(String name2, int access) {
        this.p.visitParameter(name2, access);
        super.visitParameter(name2, access);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        Printer annotationPrinter = this.p.visitMethodAnnotation(descriptor, visible);
        return new TraceAnnotationVisitor(super.visitAnnotation(descriptor, visible), annotationPrinter);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        Printer annotationPrinter = this.p.visitMethodTypeAnnotation(typeRef, typePath, descriptor, visible);
        return new TraceAnnotationVisitor(super.visitTypeAnnotation(typeRef, typePath, descriptor, visible), annotationPrinter);
    }

    public void visitAttribute(Attribute attribute) {
        this.p.visitMethodAttribute(attribute);
        super.visitAttribute(attribute);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        Printer annotationPrinter = this.p.visitAnnotationDefault();
        return new TraceAnnotationVisitor(super.visitAnnotationDefault(), annotationPrinter);
    }

    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        this.p.visitAnnotableParameterCount(parameterCount, visible);
        super.visitAnnotableParameterCount(parameterCount, visible);
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        Printer annotationPrinter = this.p.visitParameterAnnotation(parameter, descriptor, visible);
        return new TraceAnnotationVisitor(super.visitParameterAnnotation(parameter, descriptor, visible), annotationPrinter);
    }

    public void visitCode() {
        this.p.visitCode();
        super.visitCode();
    }

    public void visitFrame(int type2, int nLocal, Object[] local2, int nStack, Object[] stack) {
        this.p.visitFrame(type2, nLocal, local2, nStack, stack);
        super.visitFrame(type2, nLocal, local2, nStack, stack);
    }

    public void visitInsn(int opcode) {
        this.p.visitInsn(opcode);
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.p.visitIntInsn(opcode, operand);
        super.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int var) {
        this.p.visitVarInsn(opcode, var);
        super.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String type2) {
        this.p.visitTypeInsn(opcode, type2);
        super.visitTypeInsn(opcode, type2);
    }

    public void visitFieldInsn(int opcode, String owner2, String name2, String descriptor) {
        this.p.visitFieldInsn(opcode, owner2, name2, descriptor);
        super.visitFieldInsn(opcode, owner2, name2, descriptor);
    }

    @Deprecated
    public void visitMethodInsn(int opcode, String owner2, String name2, String descriptor) {
        if (this.api >= 327680) {
            super.visitMethodInsn(opcode, owner2, name2, descriptor);
            return;
        }
        this.p.visitMethodInsn(opcode, owner2, name2, descriptor);
        if (this.mv != null) {
            this.mv.visitMethodInsn(opcode, owner2, name2, descriptor);
        }
    }

    public void visitMethodInsn(int opcode, String owner2, String name2, String descriptor, boolean isInterface) {
        if (this.api < 327680) {
            super.visitMethodInsn(opcode, owner2, name2, descriptor, isInterface);
            return;
        }
        this.p.visitMethodInsn(opcode, owner2, name2, descriptor, isInterface);
        if (this.mv != null) {
            this.mv.visitMethodInsn(opcode, owner2, name2, descriptor, isInterface);
        }
    }

    public void visitInvokeDynamicInsn(String name2, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.p.visitInvokeDynamicInsn(name2, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        super.visitInvokeDynamicInsn(name2, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
    }

    public void visitJumpInsn(int opcode, Label label2) {
        this.p.visitJumpInsn(opcode, label2);
        super.visitJumpInsn(opcode, label2);
    }

    public void visitLabel(Label label2) {
        this.p.visitLabel(label2);
        super.visitLabel(label2);
    }

    public void visitLdcInsn(Object value2) {
        this.p.visitLdcInsn(value2);
        super.visitLdcInsn(value2);
    }

    public void visitIincInsn(int var, int increment) {
        this.p.visitIincInsn(var, increment);
        super.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min2, int max2, Label dflt, Label ... labels) {
        this.p.visitTableSwitchInsn(min2, max2, dflt, labels);
        super.visitTableSwitchInsn(min2, max2, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        this.p.visitLookupSwitchInsn(dflt, keys2, labels);
        super.visitLookupSwitchInsn(dflt, keys2, labels);
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.p.visitMultiANewArrayInsn(descriptor, numDimensions);
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
    }

    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        Printer annotationPrinter = this.p.visitInsnAnnotation(typeRef, typePath, descriptor, visible);
        return new TraceAnnotationVisitor(super.visitInsnAnnotation(typeRef, typePath, descriptor, visible), annotationPrinter);
    }

    public void visitTryCatchBlock(Label start2, Label end2, Label handler, String type2) {
        this.p.visitTryCatchBlock(start2, end2, handler, type2);
        super.visitTryCatchBlock(start2, end2, handler, type2);
    }

    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        Printer annotationPrinter = this.p.visitTryCatchAnnotation(typeRef, typePath, descriptor, visible);
        return new TraceAnnotationVisitor(super.visitTryCatchAnnotation(typeRef, typePath, descriptor, visible), annotationPrinter);
    }

    public void visitLocalVariable(String name2, String descriptor, String signature, Label start2, Label end2, int index2) {
        this.p.visitLocalVariable(name2, descriptor, signature, start2, end2, index2);
        super.visitLocalVariable(name2, descriptor, signature, start2, end2, index2);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start2, Label[] end2, int[] index2, String descriptor, boolean visible) {
        Printer annotationPrinter = this.p.visitLocalVariableAnnotation(typeRef, typePath, start2, end2, index2, descriptor, visible);
        return new TraceAnnotationVisitor(super.visitLocalVariableAnnotation(typeRef, typePath, start2, end2, index2, descriptor, visible), annotationPrinter);
    }

    public void visitLineNumber(int line, Label start2) {
        this.p.visitLineNumber(line, start2);
        super.visitLineNumber(line, start2);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.p.visitMaxs(maxStack, maxLocals);
        super.visitMaxs(maxStack, maxLocals);
    }

    public void visitEnd() {
        this.p.visitMethodEnd();
        super.visitEnd();
    }
}

