/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/TraceBasedCollector;", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "mainCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "mainCallReportTarget", "reportedErrors", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "addFallbackErrorIfNecessary", "", "badDescription", "message", "", "reportOn", "Lorg/jetbrains/kotlin/psi/KtElement;", "contractNotAllowed", "flushDiagnostics", "hasErrors", "", "unsupportedFeature", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
public final class TraceBasedCollector
implements ContractParsingDiagnosticsCollector {
    private final List<Diagnostic> reportedErrors;
    private final KtExpression mainCallReportTarget;
    private final BindingTrace bindingTrace;

    @Override
    public void contractNotAllowed(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        Collection collection = this.reportedErrors;
        ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = Errors.CONTRACT_NOT_ALLOWED.on((KtElement)((PsiElement)this.mainCallReportTarget), message);
        boolean bl = false;
        collection.add(parametrizedDiagnostic);
    }

    @Override
    public void badDescription(@NotNull String message, @NotNull KtElement reportOn) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Collection collection = this.reportedErrors;
        ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)reportOn), message);
        boolean bl = false;
        collection.add(parametrizedDiagnostic);
    }

    @Override
    public void unsupportedFeature(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Collection collection = this.reportedErrors;
        ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.UNSUPPORTED_FEATURE.on(this.mainCallReportTarget, TuplesKt.to(LanguageFeature.AllowContractsForCustomFunctions, languageVersionSettings));
        boolean bl = false;
        collection.add(parametrizedDiagnostic);
    }

    @Override
    public void addFallbackErrorIfNecessary() {
        if (this.reportedErrors.isEmpty()) {
            Collection collection = this.reportedErrors;
            ParametrizedDiagnostic<KtElement> parametrizedDiagnostic = Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)this.mainCallReportTarget), "Error in contract description");
            boolean bl = false;
            collection.add(parametrizedDiagnostic);
        }
    }

    @Override
    public void flushDiagnostics() {
        Iterable $this$forEach$iv = this.reportedErrors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Diagnostic it = (Diagnostic)element$iv;
            boolean bl = false;
            this.bindingTrace.report(it);
        }
    }

    @Override
    public boolean hasErrors() {
        Collection collection = this.reportedErrors;
        boolean bl = false;
        return !collection.isEmpty();
    }

    public TraceBasedCollector(@NotNull BindingTrace bindingTrace, @NotNull KtExpression mainCall) {
        KtExpression ktExpression;
        List list2;
        Intrinsics.checkParameterIsNotNull(bindingTrace, "bindingTrace");
        Intrinsics.checkParameterIsNotNull(mainCall, "mainCall");
        this.bindingTrace = bindingTrace;
        TraceBasedCollector traceBasedCollector = this;
        boolean bl = false;
        traceBasedCollector.reportedErrors = list2 = (List)new ArrayList();
        KtExpression ktExpression2 = mainCall;
        if (!(ktExpression2 instanceof KtCallExpression)) {
            ktExpression2 = null;
        }
        if ((ktExpression = (KtCallExpression)ktExpression2) == null || (ktExpression = ktExpression.getCalleeExpression()) == null) {
            ktExpression = mainCall;
        }
        Intrinsics.checkExpressionValueIsNotNull(ktExpression, "(mainCall as? KtCallExpr\u2026leeExpression ?: mainCall");
        this.mainCallReportTarget = ktExpression;
    }
}

