/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.reflection;

import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.reflection.ObjectRecorder;
import info.monitorenter.util.TimeStampedValue;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ObjRecorder2Trace2DAdapter
implements ChangeListener {
    private String m_fieldname;
    private ObjectRecorder m_inspector;
    private long m_start = System.currentTimeMillis();
    private ITrace2D m_view;

    public ObjRecorder2Trace2DAdapter(ITrace2D view, Object toinspect, String fieldname, long interval) {
        this.m_view = view;
        this.m_fieldname = fieldname;
        this.m_inspector = new ObjectRecorder(toinspect, interval);
        this.m_inspector.addChangeListener(this);
    }

    public void setInterval(long interval) {
        this.m_inspector.setInterval(interval);
    }

    public void stateChanged(ChangeEvent e) {
        TimeStampedValue last;
        try {
            last = this.m_inspector.getLastValue(this.m_fieldname);
        }
        catch (Exception f) {
            f.printStackTrace();
            return;
        }
        if (last != null) {
            double tmpx = last.getTime() - this.m_start;
            double tmpy = Double.parseDouble(last.getValue().toString());
            this.m_view.addPoint(tmpx, tmpy);
        }
    }
}

