/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public abstract class BaseGeoShapeFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "geo_shape";
    protected Explicit<Boolean> coerce;
    protected Explicit<Boolean> ignoreMalformed;
    protected Explicit<Boolean> ignoreZValue;

    protected BaseGeoShapeFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.coerce = coerce;
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        BaseGeoShapeFieldMapper gsfm = (BaseGeoShapeFieldMapper)mergeWith;
        if (gsfm.coerce.explicit()) {
            this.coerce = gsfm.coerce;
        }
        if (gsfm.ignoreMalformed.explicit()) {
            this.ignoreMalformed = gsfm.ignoreMalformed;
        }
        if (gsfm.ignoreZValue.explicit()) {
            this.ignoreZValue = gsfm.ignoreZValue;
        }
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        BaseGeoShapeFieldType ft = (BaseGeoShapeFieldType)this.fieldType();
        if (includeDefaults || ft.orientation() != Defaults.ORIENTATION.value()) {
            builder.field(Names.ORIENTATION.getPreferredName(), (Object)ft.orientation());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field(Names.COERCE.getPreferredName(), this.coerce.value());
        }
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.ignoreZValue.explicit()) {
            builder.field(GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName(), this.ignoreZValue.value());
        }
    }

    public Explicit<Boolean> coerce() {
        return this.coerce;
    }

    public Explicit<Boolean> ignoreMalformed() {
        return this.ignoreMalformed;
    }

    public Explicit<Boolean> ignoreZValue() {
        return this.ignoreZValue;
    }

    public ShapeBuilder.Orientation orientation() {
        return ((BaseGeoShapeFieldType)this.fieldType).orientation();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static abstract class BaseGeoShapeFieldType
    extends MappedFieldType {
        protected ShapeBuilder.Orientation orientation = Defaults.ORIENTATION.value();

        protected BaseGeoShapeFieldType() {
            this.setIndexOptions(IndexOptions.DOCS);
            this.setTokenized(false);
            this.setStored(false);
            this.setStoreTermVectors(false);
            this.setOmitNorms(true);
        }

        protected BaseGeoShapeFieldType(BaseGeoShapeFieldType ref) {
            super(ref);
            this.orientation = ref.orientation;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            BaseGeoShapeFieldType that = (BaseGeoShapeFieldType)((Object)o);
            return this.orientation == that.orientation;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.orientation});
        }

        @Override
        public String typeName() {
            return BaseGeoShapeFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts) {
            super.checkCompatibility(fieldType, conflicts);
        }

        public ShapeBuilder.Orientation orientation() {
            return this.orientation;
        }

        public void setOrientation(ShapeBuilder.Orientation orientation) {
            this.checkIfFrozen();
            this.orientation = orientation;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Geo fields do not support exact searching, use dedicated geo queries instead", new Object[0]);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Boolean coerce = null;
            Boolean ignoreZ = null;
            Boolean ignoreMalformed = null;
            ShapeBuilder.Orientation orientation = null;
            LegacyGeoShapeFieldMapper.DeprecatedParameters deprecatedParameters = new LegacyGeoShapeFieldMapper.DeprecatedParameters();
            boolean parsedDeprecatedParams = false;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (LegacyGeoShapeFieldMapper.DeprecatedParameters.parse(name, fieldName, fieldNode = entry.getValue(), deprecatedParameters)) {
                    parsedDeprecatedParams = true;
                    iterator.remove();
                    continue;
                }
                if (Names.ORIENTATION.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                    orientation = ShapeBuilder.Orientation.fromString(fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if ("ignore_malformed".equals(fieldName)) {
                    ignoreMalformed = XContentMapValues.nodeBooleanValue(fieldNode, name + ".ignore_malformed");
                    iterator.remove();
                    continue;
                }
                if (Names.COERCE.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                    coerce = XContentMapValues.nodeBooleanValue(fieldNode, name + "." + Names.COERCE.getPreferredName());
                    iterator.remove();
                    continue;
                }
                if (!GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName().equals(fieldName)) continue;
                ignoreZ = XContentMapValues.nodeBooleanValue(fieldNode, name + "." + GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName());
                iterator.remove();
            }
            Builder builder = parsedDeprecatedParams || parserContext.indexVersionCreated().before(Version.V_6_6_0) ? new LegacyGeoShapeFieldMapper.Builder(name, deprecatedParameters) : new GeoShapeFieldMapper.Builder(name);
            if (coerce != null) {
                builder.coerce(coerce);
            }
            if (ignoreZ != null) {
                builder.ignoreZValue(ignoreZ);
            }
            if (ignoreMalformed != null) {
                builder.ignoreMalformed(ignoreMalformed);
            }
            if (orientation != null) {
                builder.orientation(orientation);
            }
            return builder;
        }
    }

    public static abstract class Builder<T extends Builder, Y extends BaseGeoShapeFieldMapper>
    extends FieldMapper.Builder<T, Y> {
        protected Boolean coerce;
        protected Boolean ignoreMalformed;
        protected Boolean ignoreZValue;
        protected ShapeBuilder.Orientation orientation;

        public Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType) {
            super(name, fieldType, defaultFieldType);
        }

        public Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType, boolean coerce, boolean ignoreMalformed, ShapeBuilder.Orientation orientation, boolean ignoreZ) {
            super(name, fieldType, defaultFieldType);
            this.coerce = coerce;
            this.ignoreMalformed = ignoreMalformed;
            this.orientation = orientation;
            this.ignoreZValue = ignoreZ;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return this;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        public Builder orientation(ShapeBuilder.Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        protected Explicit<ShapeBuilder.Orientation> orientation() {
            if (this.orientation != null) {
                return new Explicit<ShapeBuilder.Orientation>(this.orientation, true);
            }
            return Defaults.ORIENTATION;
        }

        @Override
        protected boolean defaultDocValues(Version indexCreated) {
            return false;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return this;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        protected Explicit<Boolean> ignoreZValue() {
            if (this.ignoreZValue != null) {
                return new Explicit<Boolean>(this.ignoreZValue, true);
            }
            return Defaults.IGNORE_Z_VALUE;
        }

        public Builder ignoreZValue(boolean ignoreZValue) {
            this.ignoreZValue = ignoreZValue;
            return this;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            if (this.name().isEmpty()) {
                throw new IllegalArgumentException("name cannot be empty string");
            }
            BaseGeoShapeFieldType ft = (BaseGeoShapeFieldType)this.fieldType();
            ft.setOrientation(this.orientation().value());
        }
    }

    public static class Defaults {
        public static final Explicit<ShapeBuilder.Orientation> ORIENTATION = new Explicit<ShapeBuilder.Orientation>(ShapeBuilder.Orientation.RIGHT, false);
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(false, false);
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final Explicit<Boolean> IGNORE_Z_VALUE = new Explicit<Boolean>(true, false);
    }

    public static class Names {
        public static final ParseField ORIENTATION = new ParseField("orientation", new String[0]);
        public static final ParseField COERCE = new ParseField("coerce", new String[0]);
    }
}

