/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.readers.quantum.NBOParser;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class GenNBOReader
extends MOReader {
    private boolean isOutputFile;
    private String nboType = "";
    private int nOrbitals0;
    private boolean is47File;
    private boolean isOpenShell;
    private boolean alphaOnly;
    private boolean betaOnly;
    private int nAOs;
    private int nNOs;
    private String topoType = "A";
    private int nStructures = 0;
    NBOParser nboParser;
    private boolean addBetaSet;
    private static String P_LIST = "101   102   103";
    private static String SP_LIST = "1     101   102   103";
    private static String DS_LIST = "255   252   253   254   251";
    private static String DC_LIST = "201   204   206   202   203   205";
    private static String FS_LIST = "351   352   353   354   355   356   357";
    private static String FC_LIST = "301   307   310   304   302   303   306   309   308   305";
    private static String GS_LIST = "451   452   453   454   455   456   457   458   459";
    private static String GC_LIST = "415   414   413   412   411   410   409   408   407   406   405   404   403   402   401";
    private static String HS_LIST = "551   552   553   554   555   556   557   558   559   560   561";
    private static String HC_LIST = "521   520   519   518   517   516   515   514   513   512   511   510   509   508   507   506   505   504   503   502   501";
    private static String IS_LIST = "651   652   653   654   655   656   657   658   659   660   661   662   663";
    private static String IC_LIST = "628   627   626   625   624   623   622   621   620   619   618   617   616   615   614   613   612   611   610   609   608   607   606   605   604   603   602   601";

    @Override
    protected void initializeReader() throws Exception {
        boolean bl;
        String string = this.rd().trim().toUpperCase();
        boolean bl2 = this.is47File = string.indexOf("$GENNBO") >= 0 || string.indexOf("$NBO") >= 0;
        if (this.is47File) {
            if (string.indexOf("BOHR") >= 0) {
                this.fileOffset = new P3();
                this.fileScaling = P3.new3(0.5291772f, 0.5291772f, 0.5291772f);
            }
            this.readData47();
            return;
        }
        this.alphaOnly = this.checkFilterKey("ALPHA");
        this.betaOnly = this.checkFilterKey("BETA");
        String string2 = this.rd();
        this.line = String.valueOf(string) + string2;
        boolean bl3 = this.isOutputFile = string2.indexOf("****") >= 0;
        if (this.isOutputFile) {
            bl = this.getFile31();
            super.initializeReader();
        } else if (string2.indexOf("s in the AO basis:") >= 0) {
            this.nboType = string2.substring(1, string2.indexOf("s"));
            this.asc.setCollectionName(String.valueOf(string) + ": " + this.nboType + "s");
            bl = this.getFile31();
        } else {
            this.nboType = "AO";
            this.asc.setCollectionName(String.valueOf(string) + ": " + this.nboType + "s");
            bl = this.readData31(string);
        }
        if (!bl) {
            Logger.error("Unimplemented shell type -- no orbitals available: " + this.line);
        }
        if (this.isOutputFile) {
            return;
        }
        if (bl) {
            this.readMOs();
        }
        this.continuing = false;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.appendLoadNote("NBO type " + this.nboType);
        if (this.isOpenShell) {
            this.asc.setCurrentModelInfo("isOpenShell", Boolean.TRUE);
        }
        this.finalizeReaderASCR();
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("SECOND ORDER PERTURBATION THEORY ANALYSIS") >= 0 && !this.orbitalsRead) {
            this.nboType = "NBO";
            String string = this.getFileData(".37");
            if (string == null) {
                return true;
            }
            BufferedReader bufferedReader = this.reader;
            this.reader = Rdr.getBR(string);
            this.rd();
            this.rd();
            this.readMOs();
            this.reader = bufferedReader;
            this.orbitalsRead = false;
            return true;
        }
        if (this.line.indexOf("$NRTSTRA") >= 0) {
            this.getStructures("NRTSTRA");
            return true;
        }
        if (this.line.indexOf("$NRTSTRB") >= 0) {
            this.getStructures("NRTSTRB");
            return true;
        }
        if (this.line.indexOf("$NRTSTR") >= 0) {
            this.getStructures("NRTSTR");
            return true;
        }
        if (this.line.indexOf(" TOPO ") >= 0) {
            this.getStructures("TOPO" + this.topoType);
            this.topoType = "B";
            return true;
        }
        if (this.line.indexOf("$CHOOSE") >= 0) {
            this.getStructures("CHOOSE");
            return true;
        }
        return this.checkNboLine();
    }

    private void getStructures(String string) throws Exception {
        if (this.nboParser == null) {
            this.nboParser = new NBOParser();
        }
        Lst<Object> lst = this.getStructureList();
        SB sB = new SB();
        while (!this.rd().trim().equals("$END")) {
            sB.append(this.line).append("\n");
        }
        this.nStructures = this.nboParser.getStructures(sB.toString(), string, lst);
        this.appendLoadNote(String.valueOf(this.nStructures) + " NBO " + string + " resonance structures");
    }

    private Lst<Object> getStructureList() {
        Lst lst = (Lst)this.asc.getAtomSetAuxiliaryInfo(this.asc.iSet).get("nboStructures");
        if (lst == null) {
            lst = new Lst();
            this.asc.setCurrentModelInfo("nboStructures", lst);
        }
        return lst;
    }

    private String getFileData(String string) throws Exception {
        boolean bl;
        String string2 = (String)this.htParams.get("fullPathName");
        int n = string2.lastIndexOf(".");
        if (n < 0) {
            n = string2.length();
        }
        string2 = string2.substring(0, n);
        this.moData.put("nboRoot", string2);
        string2 = String.valueOf(string2) + string;
        String string3 = this.vwr.getFileAsString3(string2, false, null);
        Logger.info(String.valueOf(string3.length()) + " bytes read from " + string2);
        boolean bl2 = bl = string3.indexOf("java.io.") >= 0;
        if (string3.length() == 0 || bl && this.nboType != "AO") {
            throw new Exception(" supplemental file " + string2 + " was not found");
        }
        return bl ? null : string3;
    }

    private boolean getFile31() throws Exception {
        String string;
        block3: {
            try {
                string = this.getFileData(".31");
                if (string != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        BufferedReader bufferedReader = this.reader;
        this.reader = Rdr.getBR(string);
        return this.readData31(null) && (this.reader = bufferedReader) != null;
    }

    private void getFile46() throws Exception {
        String string = this.getFileData(".46");
        if (string == null) {
            return;
        }
        BufferedReader bufferedReader = this.reader;
        this.reader = Rdr.getBR(string);
        this.readData46();
        this.reader = bufferedReader;
    }

    private void readData47() throws Exception {
        Object[] objectArray;
        this.allowNoOrbitals = true;
        this.discardLinesUntilContains("$COORD");
        this.asc.newAtomSet();
        this.asc.setAtomSetName(this.rd().trim());
        while (this.rd().indexOf("$END") < 0) {
            objectArray = this.getTokens();
            this.addAtomXYZSymName((String[])objectArray, (int)2, null, null).elementNumber = (short)this.parseIntStr(objectArray[0]);
        }
        if (this.doReadMolecularOrbitals && !this.getFile31()) {
            this.alphaOnly = true;
            this.betaOnly = false;
            this.discardLinesUntilContains("$BASIS");
            this.appendLoadNote("basis AOs are unnormalized");
            objectArray = this.getIntData();
            int[] nArray = this.getIntData();
            this.discardLinesUntilContains("NSHELL =");
            this.shellCount = this.parseIntAt(this.line, 10);
            this.gaussianCount = this.parseIntAt(this.rd(), 10);
            this.rd();
            int[] nArray2 = this.getIntData();
            int[] nArray3 = this.getIntData();
            int[] nArray4 = this.getIntData();
            this.shells = new Lst();
            this.gaussians = AU.newFloat2(this.gaussianCount);
            int n = 0;
            while (n < this.gaussianCount) {
                this.gaussians[n] = new float[6];
                ++n;
            }
            this.nOrbitals = 0;
            n = 0;
            String string = this.line;
            int n2 = 0;
            while (n2 < this.shellCount) {
                int[] nArray5 = new int[4];
                int n3 = nArray2[n2];
                nArray5[0] = (int)objectArray[n];
                this.line = "";
                int n4 = 0;
                while (n4 < n3) {
                    this.line = String.valueOf(this.line) + nArray[n++] + " ";
                    ++n4;
                }
                if (!this.fillSlater(nArray5, n3, nArray4[n2] - 1, nArray3[n2])) {
                    return;
                }
                ++n2;
            }
            this.line = string;
            this.getAlphasAndExponents();
            this.nboType = "AO";
            this.readMOs();
        }
        this.continuing = false;
    }

    private int[] getIntData() throws Exception {
        while (this.line.indexOf("=") < 0) {
            this.rd();
        }
        String string = this.line.substring(this.line.indexOf("=") + 1);
        this.line = "";
        while (this.rd().indexOf("=") < 0 && this.line.indexOf("$") < 0) {
            string = String.valueOf(string) + this.line;
        }
        String[] stringArray = PT.getTokens(string);
        int[] nArray = new int[stringArray.length];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = this.parseIntStr(stringArray[n]);
        }
        return nArray;
    }

    private boolean fillSlater(int[] nArray, int n, int n2, int n3) {
        this.nOrbitals += n;
        switch (n) {
            case 1: {
                nArray[1] = 0;
                break;
            }
            case 3: {
                if (!this.getDFMap("P", this.line, 1, P_LIST, 3)) {
                    return false;
                }
                nArray[1] = 1;
                break;
            }
            case 4: {
                if (!this.getDFMap("SP", this.line, 2, SP_LIST, 1)) {
                    return false;
                }
                nArray[1] = 2;
                break;
            }
            case 5: {
                if (!this.getDFMap("DS", this.line, 3, DS_LIST, 3)) {
                    return false;
                }
                nArray[1] = 3;
                break;
            }
            case 6: {
                if (!this.getDFMap("DC", this.line, 4, DC_LIST, 3)) {
                    return false;
                }
                nArray[1] = 4;
                break;
            }
            case 7: {
                if (!this.getDFMap("FS", this.line, 5, FS_LIST, 3)) {
                    return false;
                }
                nArray[1] = 5;
                break;
            }
            case 10: {
                if (!this.getDFMap("FC", this.line, 6, FC_LIST, 3)) {
                    return false;
                }
                nArray[1] = 6;
                break;
            }
            case 9: {
                if (!this.getDFMap("GS", this.line, 7, GS_LIST, 3)) {
                    return false;
                }
                nArray[1] = 7;
                break;
            }
            case 15: {
                if (!this.getDFMap("GC", this.line, 8, GC_LIST, 3)) {
                    return false;
                }
                nArray[1] = 8;
                break;
            }
            case 11: {
                if (!this.getDFMap("HS", this.line, 9, HS_LIST, 3)) {
                    return false;
                }
                nArray[1] = 9;
                break;
            }
            case 21: {
                if (!this.getDFMap("HC", this.line, 10, HC_LIST, 3)) {
                    return false;
                }
                nArray[1] = 10;
                break;
            }
            case 13: {
                if (!this.getDFMap("IS", this.line, 11, IS_LIST, 3)) {
                    return false;
                }
                nArray[1] = 11;
                break;
            }
            case 28: {
                if (!this.getDFMap("IC", this.line, 12, IC_LIST, 3)) {
                    return false;
                }
                nArray[1] = 12;
                break;
            }
            default: {
                Logger.error("Unrecognized orbital slater count: " + n);
            }
        }
        nArray[2] = n2 + 1;
        nArray[3] = n3;
        this.shells.addLast(nArray);
        return true;
    }

    private void getAlphasAndExponents() throws Exception {
        int n = 0;
        while (n < 5) {
            if (this.line.indexOf("=") < 0) {
                this.rd();
            }
            if (this.line.indexOf("$END") >= 0) break;
            this.line = this.line.substring(this.line.indexOf("=") + 1);
            float[] fArray = this.fillFloatArray(this.line, 0, new float[this.gaussianCount]);
            int n2 = 0;
            while (n2 < this.gaussianCount) {
                this.gaussians[n2][n] = fArray[n2];
                if (n > 1) {
                    float[] fArray2 = this.gaussians[n2];
                    fArray2[5] = fArray2[5] + fArray[n2];
                }
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < this.gaussianCount) {
            if (this.gaussians[n][1] == 0.0f) {
                this.gaussians[n][1] = this.gaussians[n][5];
            }
            ++n;
        }
        if (this.debugging) {
            Logger.debug(String.valueOf(this.shells.size()) + " slater shells read");
            Logger.debug(String.valueOf(this.gaussians.length) + " gaussian primitives read");
        }
    }

    private boolean readData31(String string) throws Exception {
        if (string == null) {
            string = this.rd();
            this.rd();
        }
        this.rd();
        String[] stringArray = PT.getTokens(this.rd());
        int n = this.parseIntStr(stringArray[0]);
        this.shellCount = this.parseIntStr(stringArray[1]);
        this.gaussianCount = this.parseIntStr(stringArray[2]);
        if (stringArray.length < 4) {
            Logger.error("NOTE! .31 file is old; d orbitals are not normalized");
        }
        this.rd();
        this.asc.newAtomSet();
        this.asc.setAtomSetName(String.valueOf(this.nboType) + "s: " + string.trim());
        this.asc.setCurrentModelInfo("nboType", this.nboType);
        int n2 = 0;
        while (n2 < n) {
            stringArray = PT.getTokens(this.rd());
            int n3 = this.parseIntStr(stringArray[0]);
            if (n3 >= 0) {
                Atom atom = this.asc.addNewAtom();
                atom.elementNumber = (short)n3;
                this.setAtomCoordTokens(atom, stringArray, 1);
            }
            ++n2;
        }
        this.shells = new Lst();
        this.gaussians = AU.newFloat2(this.gaussianCount);
        n2 = 0;
        while (n2 < this.gaussianCount) {
            this.gaussians[n2] = new float[6];
            ++n2;
        }
        this.rd();
        this.nOrbitals = 0;
        n2 = 0;
        while (n2 < this.shellCount) {
            stringArray = PT.getTokens(this.rd());
            int[] nArray = new int[4];
            nArray[0] = this.parseIntStr(stringArray[0]);
            int n4 = this.parseIntStr(stringArray[1]);
            int n5 = this.parseIntStr(stringArray[2]) - 1;
            int n6 = this.parseIntStr(stringArray[3]);
            this.line = this.rd();
            int n7 = (n4 - 1) / 10;
            while (--n7 >= 0) {
                this.line = String.valueOf(this.line) + this.rd().substring(1);
            }
            this.line = this.line.trim();
            System.out.println(this.line);
            if (!this.fillSlater(nArray, n4, n5, n6)) {
                return false;
            }
            ++n2;
        }
        this.rd();
        this.getAlphasAndExponents();
        return true;
    }

    private void readData46() throws Exception {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        String[] stringArray = new String[]{};
        this.rd();
        this.nNOs = this.nAOs = this.nOrbitals;
        int n = this.nAOs;
        String string = GenNBOReader.getLabelKey(this.nboType);
        while (this.line != null && this.line.length() > 0) {
            stringArray = PT.getTokens(this.line);
            String string2 = stringArray[0];
            this.isOpenShell = stringArray.length == 3;
            String string3 = this.isOpenShell ? stringArray[1] : "";
            String string4 = stringArray[stringArray.length - 1];
            String string5 = String.valueOf(string3.equals("BETA") ? "beta_" : "") + string2;
            if (this.parseIntStr(string4) != this.nOrbitals) {
                Logger.error("file 46 number of orbitals for " + this.line + " (" + string4 + ") does not match nOrbitals: " + this.nOrbitals + "\n");
                n = this.parseIntStr(string4);
            }
            if (string2.equals(string)) {
                this.nNOs = n;
            }
            SB sB = new SB();
            while (this.rd() != null && this.line.length() > 4 && " NA NB AO NH".indexOf(this.line.substring(1, 4)) < 0) {
                sB.append(this.line.substring(1));
            }
            System.out.println(sB.length());
            stringArray = new String[sB.length() / 10];
            int n2 = 0;
            int n3 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = PT.rep(sB.substring2(n3, n3 + 10), " ", "");
                ++n2;
                n3 += 10;
            }
            hashtable.put(string5, stringArray);
        }
        stringArray = (String[])hashtable.get(String.valueOf(this.betaOnly ? "beta_" : "") + string);
        this.moData.put("nboLabelMap", hashtable);
        if (stringArray == null) {
            stringArray = new String[n];
            int n4 = 0;
            while (n4 < n) {
                stringArray[n4] = String.valueOf(this.nboType) + (n4 + 1);
                ++n4;
            }
            hashtable.put(string, stringArray);
            if (this.isOpenShell) {
                hashtable.put("beta_" + string, stringArray);
            }
        }
        this.moData.put("nboLabels", stringArray);
        boolean bl = this.addBetaSet = this.isOpenShell && !this.betaOnly && !this.is47File;
        if (this.addBetaSet) {
            this.nOrbitals *= 2;
        }
        int n5 = 0;
        while (n5 < this.nOrbitals) {
            this.setMO(new Hashtable<String, Object>());
            ++n5;
        }
        GenNBOReader.setNboLabels(stringArray, n, this.orbitals, this.nOrbitals0, this.nboType);
        if (this.addBetaSet) {
            this.moData.put("firstBeta", n);
            GenNBOReader.setNboLabels((String[])hashtable.get("beta_" + string), n, this.orbitals, this.nOrbitals0 + n, this.nboType);
        }
        Lst<Object> lst = this.getStructureList();
        NBOParser.getStructures46((String[])hashtable.get("NBO"), "alpha", lst, this.asc.ac);
        NBOParser.getStructures46((String[])hashtable.get("beta_NBO"), "beta", lst, this.asc.ac);
    }

    private static String getLabelKey(String string) {
        if (string.startsWith("P")) {
            string = string.substring(1);
        }
        if (string.equals("NLMO")) {
            string = "NBO";
        }
        if (string.equals("MO")) {
            string = "NO";
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readNBOCoefficients(Map<String, Object> map, String string, Viewer viewer) {
        int n;
        int n2 = ";AO;  ;PNAO;;NAO; ;PNHO;;NHO; ;PNBO;;NBO; ;PNLMO;NLMO;;MO;  ;NO;".indexOf(";" + string + ";");
        n2 = n2 / 6 + 31;
        boolean bl = string.equals("AO");
        boolean bl2 = string.equals("NBO");
        boolean bl3 = PT.isOneOf(string, ";AO;PNAO;NAO;");
        Map map2 = (Map)map.get("nboLabelMap");
        int n3 = ((String[])map2.get("AO")).length;
        String string2 = GenNBOReader.getLabelKey(string);
        String[] stringArray = (String[])map2.get(string2);
        if (stringArray == null) {
            stringArray = new String[n3];
            n = 0;
            while (n < n3) {
                stringArray[n] = String.valueOf(string) + (n + 1);
                ++n;
            }
            string2 = string;
            map2.put(string2, stringArray);
            if (!bl3) {
                map2.put("beta_" + string2, stringArray);
            }
        }
        n = stringArray.length;
        try {
            Lst<Map<String, Object>> lst = (Lst<Map<String, Object>>)map.get(String.valueOf(string) + "_coefs");
            if (lst == null) {
                Map<String, float[]> map3;
                String string3 = null;
                if (!bl) {
                    String string4 = map.get("nboRoot") + "." + n2;
                    string3 = viewer.getFileAsString3(string4, true, null);
                    if (string3 == null) {
                        return false;
                    }
                    string3 = string3.substring(string3.indexOf("--\n") + 3).toLowerCase();
                    if (n2 == 33) {
                        string3 = string3.substring(0, string3.indexOf("--\n") + 3);
                    }
                }
                lst = (Lst)map.get("mos");
                Object v = ((Map)lst.get(0)).get("dfCoefMaps");
                lst = new Lst<Map<String, Object>>();
                int n4 = 0;
                int[] nArray = null;
                int n5 = n;
                if (!bl) {
                    if (string3.indexOf("alpha") >= 0) {
                        n5 *= 2;
                        string3 = string3.substring(string3.indexOf("alpha") + 10);
                    }
                    n4 = string3.length();
                    nArray = new int[1];
                }
                int n6 = n5;
                while (--n6 >= 0) {
                    map3 = new Hashtable();
                    lst.addLast(map3);
                    if (v == null) continue;
                    map3.put("dfCoefMaps", (float[])v);
                }
                GenNBOReader.setNboLabels(stringArray, n, lst, 0, string);
                n6 = 0;
                while (n6 < n5) {
                    if (!bl && n6 == n) {
                        if (bl2) {
                            GenNBOReader.getNBOOccupanciesStatic(lst, n, 0, string3, n4, nArray);
                        }
                        stringArray = (String[])map2.get("beta_" + string2);
                        nArray[0] = bl3 ? 0 : string3.indexOf("beta  spin") + 12;
                    }
                    map3 = (Map)lst.get(n6);
                    float[] fArray = new float[n3];
                    if (bl) {
                        fArray[n6 % n3] = 1.0f;
                    } else if (n6 >= n3 && bl3) {
                        fArray = (float[])((Map)lst.get(n6 % n3)).get("coefficients");
                    } else {
                        int n7 = 0;
                        while (n7 < n3) {
                            fArray[n7] = PT.parseFloatChecked(string3, n4, nArray, false);
                            if (Float.isNaN(fArray[n7])) {
                                System.out.println("oops = IsoExt ");
                            }
                            ++n7;
                        }
                    }
                    map3.put("coefficients", fArray);
                    ++n6;
                }
                if (bl2) {
                    GenNBOReader.getNBOOccupanciesStatic(lst, n, n5 - n, string3, n4, nArray);
                }
                map.put(String.valueOf(string) + "_coefs", lst);
            }
            map.put("nboType", string);
            map.put("nboLabels", stringArray);
            map.put("mos", lst);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static void getNBOOccupanciesStatic(Lst<Map<String, Object>> lst, int n, int n2, String string, int n3, int[] nArray) {
        float[] fArray = new float[n];
        int n4 = 0;
        while (n4 < n) {
            fArray[n4] = PT.parseFloatChecked(string, n3, nArray, false);
            ++n4;
        }
        n4 = 0;
        while (n4 < n) {
            Map map = (Map)lst.get(n2 + n4);
            map.put("occupancy", Float.valueOf(fArray[n4]));
            ++n4;
        }
    }

    private void readMOs() throws Exception {
        boolean bl = this.nboType.equals("AO");
        boolean bl2 = this.nboType.equals("NBO");
        boolean bl3 = PT.isOneOf(this.nboType, ";NBO;NLMO;");
        boolean bl4 = PT.isOneOf(this.nboType, ";AO;PNAO;NAO;");
        this.nOrbitals0 = this.orbitals.size();
        this.getFile46();
        if (this.betaOnly) {
            this.discardLinesUntilContains("BETA");
            this.filterMO();
        }
        this.nOrbitals = this.orbitals.size();
        if (this.nOrbitals == 0) {
            return;
        }
        this.line = null;
        int n = 0;
        int n2 = this.nOrbitals0;
        int n3 = this.nOrbitals0 + this.nOrbitals;
        while (n2 < n3) {
            if (n == this.nNOs) {
                if (bl2) {
                    this.readNBO37Occupancies(n);
                }
                if (bl3) {
                    this.discardLinesUntilContains2("BETA", "beta");
                }
            }
            Map map = (Map)this.orbitals.get(n2);
            float[] fArray = new float[this.nAOs];
            if (bl) {
                fArray[n % this.nAOs] = 1.0f;
            } else if (n >= this.nNOs && bl4) {
                fArray = (float[])((Map)this.orbitals.get(n % this.nNOs)).get("coefficients");
            } else {
                if (this.line == null) {
                    while (this.rd() != null && Float.isNaN(this.parseFloatStr(this.line))) {
                        this.filterMO();
                    }
                } else {
                    this.line = null;
                }
                this.fillFloatArray(this.line, 0, fArray);
                this.line = null;
            }
            map.put("coefficients", fArray);
            ++n2;
            ++n;
        }
        if (bl2) {
            this.readNBO37Occupancies(n);
        }
        this.moData.put(String.valueOf(this.nboType) + "_coefs", this.orbitals);
        this.setMOData(false);
        this.moData.put("nboType", this.nboType);
        Logger.info(String.valueOf(this.orbitals.size() - this.nOrbitals0) + " orbitals read");
    }

    private void readNBO37Occupancies(int n) throws Exception {
        float[] fArray = new float[this.nNOs];
        this.fillFloatArray(null, 0, fArray);
        int n2 = 0;
        while (n2 < this.nNOs) {
            Map map = (Map)this.orbitals.get(this.nOrbitals0 + n - this.nNOs + n2);
            map.put("occupancy", Float.valueOf(fArray[n2]));
            ++n2;
        }
    }

    public static void setNboLabels(String[] stringArray, int n, Lst<Map<String, Object>> lst, int n2, String string) {
        boolean bl;
        boolean bl2 = lst.size() == n * 2;
        boolean bl3 = bl = !PT.isOneOf(string, ";AO;NAO;PNAO;MO;NO;");
        String string2 = !bl2 ? "" : (n2 == 0 ? " alpha" : " beta");
        int n3 = 0;
        while (n3 < n) {
            Map map = (Map)lst.get(n3 + n2);
            String string3 = stringArray[n3];
            map.put("type", String.valueOf(string) + " " + string3 + string2);
            if (bl) {
                map.put("occupancy", Float.valueOf(bl2 ? 1 : (string3.indexOf("*") >= 0 || string3.indexOf("(ry)") >= 0 ? 0 : 2)));
            }
            ++n3;
        }
    }
}

