/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.io.ByteArrayOutputStream;
import java.util.Map;
import javajs.awt.Font;
import javajs.util.A4;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.export._VrmlExporter;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class _StlExporter
extends _VrmlExporter {
    private boolean isDebug;
    private String header;
    private OC oc;
    private ByteArrayOutputStream bos;
    private M4 m4;
    Lst<M4> lstMatrix;
    private M4 m4a = new M4();
    private int nTri;

    public _StlExporter() {
        this.useTable = null;
        this.noColor = true;
        this.isDebug = Logger.debugging;
        if (!this.isDebug) {
            this.oc = new OC();
            this.oc.setBigEndian(false);
            this.bos = new ByteArrayOutputStream();
            this.oc.setParams(null, null, false, this.bos);
        }
    }

    @Override
    protected void outputHeader() {
        this.header = ("solid model generated by Jmol " + Viewer.getJmolVersion() + "                                                                                ").substring(0, 80);
        if (this.isDebug) {
            this.out.append(this.header);
            this.out.append("\n");
        } else {
            this.oc.write(this.header.getBytes(), 0, 80);
            this.oc.write(new byte[4], 0, 4);
        }
        this.lstMatrix = new Lst();
        this.m4 = new M4();
        this.m4.setIdentity();
        this.lstMatrix.addLast(this.m4);
        this.outputInitialTransform();
    }

    @Override
    protected void pushMatrix() {
        this.lstMatrix.addLast(this.m4);
        this.m4 = M4.newM4(this.m4);
    }

    @Override
    protected void popMatrix() {
        this.m4 = this.lstMatrix.removeItemAt(this.lstMatrix.size() - 1);
    }

    @Override
    protected void output(String string) {
    }

    @Override
    protected void outputChildStart() {
    }

    @Override
    protected void outputChildClose() {
    }

    @Override
    protected void outputRotation(A4 a4) {
        this.m4a.setToAA(a4);
        this.m4.mul(this.m4a);
    }

    @Override
    protected void outputAttrPt(String string, T3 t3) {
        this.outputAttr(string, t3.x, t3.y, t3.z);
    }

    @Override
    protected void outputAttr(String string, float f, float f2, float f3) {
        this.m4a.setIdentity();
        if (string == "scale") {
            this.m4a.m00 = f;
            this.m4a.m11 = f2;
            this.m4a.m22 = f3;
        } else if (string == "translation") {
            this.m4a.m03 = f;
            this.m4a.m13 = f2;
            this.m4a.m23 = f3;
        }
        this.m4.mul(this.m4a);
    }

    @Override
    protected void outputGeometry(T3[] t3Array, T3[] t3Array2, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, BS bS, int n3, Lst<Short> lst, Map<Short, Integer> map, P3 p3) {
        int n4 = 0;
        while (n4 < n2) {
            if (bS == null || bS.get(n4)) {
                int[] nArray2 = nArray[n4];
                this.writeFacet(t3Array, nArray2, 0, 1, 2);
                if (n3 == 4 && nArray2.length >= 4 && nArray2[2] != nArray2[3]) {
                    this.writeFacet(t3Array, nArray2, 2, 3, 0);
                }
            }
            ++n4;
        }
    }

    private void writeFacet(T3[] t3Array, int[] nArray, int n, int n2, int n3) {
        this.tempQ1.setT(t3Array[nArray[n]]);
        this.tempQ2.setT(t3Array[nArray[n2]]);
        this.tempQ3.setT(t3Array[nArray[n3]]);
        this.m4.rotTrans(this.tempQ1);
        this.m4.rotTrans(this.tempQ2);
        this.m4.rotTrans(this.tempQ3);
        Measure.calcNormalizedNormal(this.tempQ1, this.tempQ2, this.tempQ3, this.tempV1, this.tempV2);
        if (Float.isNaN(this.tempV1.x)) {
            return;
        }
        this.writePoint("facet normal", this.tempV1);
        this.writePoint("outer loop\nvertex", this.tempQ1);
        this.writePoint("vertex", this.tempQ2);
        this.writePoint("vertex", this.tempQ3);
        if (this.isDebug) {
            this.out.append("endloop\nendfacet\n");
        } else {
            this.oc.writeByteAsInt(0);
            this.oc.writeByteAsInt(0);
        }
        ++this.nTri;
    }

    @Override
    protected String finalizeOutput() {
        if (this.isDebug) {
            this.out.append("endsolid model\n");
        } else {
            byte[] byArray = this.bos.toByteArray();
            byArray[80] = (byte)(this.nTri & 0xFF);
            byArray[81] = (byte)(this.nTri >> 8 & 0xFF);
            byArray[82] = (byte)(this.nTri >> 16 & 0xFF);
            byArray[83] = (byte)(this.nTri >> 24 & 0xFF);
            this.out.write(byArray, 0, byArray.length);
        }
        return this.finalizeOutput2();
    }

    @Override
    protected void outputCircle(P3 p3, P3 p32, float f, short s, boolean bl) {
    }

    @Override
    void plotText(int n, int n2, int n3, short s, String string, Font font) {
    }

    private void writePoint(String string, T3 t3) {
        if (this.isDebug) {
            this.out.append(string);
        }
        this.writeFloat(t3.x);
        this.writeFloat(t3.y);
        this.writeFloat(t3.z);
        if (this.isDebug) {
            this.out.append("\n");
        }
    }

    private void writeFloat(float f) {
        if (this.isDebug) {
            this.out.append(" " + f);
        } else {
            this.oc.writeInt(Float.floatToIntBits(f));
        }
    }
}

