/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javajs.J2SIgnoreImport;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.translation.PO;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

@J2SIgnoreImport(value={ResourceBundle.class, Locale.class})
class Resource {
    private ResourceBundle resource;
    private Map<String, String> resourceMap;

    private Resource(Object object, String string) {
        if (string == null) {
            this.resourceMap = (Map)object;
        } else {
            this.resource = (ResourceBundle)object;
        }
    }

    static Resource getResource(Viewer viewer, String string, String string2) {
        String string3 = null;
        if (viewer != null && viewer.isApplet) {
            String string4 = String.valueOf(Viewer.appletIdiomaBase) + "/" + string2 + ".po";
            Logger.info("Loading language resource " + string4);
            string3 = viewer.getFileAsString3(string4, false, "gt");
        } else {
            try {
                BufferedReader bufferedReader = FileManager.getBufferedReaderForResource(viewer, new PO(), "org/jmol/translation/", String.valueOf(string.indexOf("Applet") >= 0 ? "JmolApplet/" : "Jmol/") + string2 + ".po");
                String[] stringArray = new String[1];
                Rdr.readAllAsString(bufferedReader, Integer.MAX_VALUE, false, stringArray, 0);
                string3 = stringArray[0];
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return Resource.getResourceFromPO(string3);
    }

    String getString(String string) {
        try {
            return this.resource == null ? this.resourceMap.get(string) : this.resource.getString(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String getLanguage() {
        String string = null;
        Locale locale = Locale.getDefault();
        if (locale != null) {
            string = locale.getLanguage();
            if (locale.getCountry() != null) {
                string = String.valueOf(string) + "_" + locale.getCountry();
                if (locale.getVariant() != null && locale.getVariant().length() > 0) {
                    string = String.valueOf(string) + "_" + locale.getVariant();
                }
            }
        }
        return string;
    }

    static Resource getResourceFromPO(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String[] stringArray = PT.split(string, "\n");
            int n = 0;
            String string2 = "";
            String string3 = "";
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string4 = stringArray[n2];
                if (string4.length() <= 2) {
                    if (n == 2 && string2.length() != 0 && string3.length() != 0) {
                        hashtable.put(string3, string2);
                    }
                    n = 0;
                } else if (string4.indexOf("msgid") == 0) {
                    n = 1;
                    string3 = Resource.fix(string4);
                } else if (string4.indexOf("msgstr") == 0) {
                    n = 2;
                    string2 = Resource.fix(string4);
                } else if (n == 1) {
                    string3 = String.valueOf(string3) + Resource.fix(string4);
                } else if (n == 2) {
                    string2 = String.valueOf(string2) + Resource.fix(string4);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.info(String.valueOf(hashtable.size()) + " translations loaded");
        return hashtable.size() == 0 ? null : new Resource(hashtable, null);
    }

    static String fix(String string) {
        if (string.indexOf("\\\"") >= 0) {
            string = PT.rep(string, "\\\"", "\"");
        }
        return PT.rep(string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\"")), "\\n", "\n");
    }
}

