/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.turtle.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.rdf.turtle.parser.JavaCharStream;
import org.semanticweb.owlapi.rdf.turtle.parser.ParseException;
import org.semanticweb.owlapi.rdf.turtle.parser.Token;
import org.semanticweb.owlapi.rdf.turtle.parser.TripleHandler;
import org.semanticweb.owlapi.rdf.turtle.parser.TurtleParserConstants;
import org.semanticweb.owlapi.rdf.turtle.parser.TurtleParserTokenManager;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.vocab.XSDVocabulary;

class TurtleParser
implements TurtleParserConstants {
    private Map<String, IRI> string2IRI;
    private IRI base;
    private TripleHandler handler;
    private PrefixManager pm = new DefaultPrefixManager();
    TurtleParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    Token token;
    Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[41];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    TurtleParser(Reader reader, TripleHandler handler, IRI base) {
        this(reader);
        this.handler = handler;
        this.base = base;
        this.string2IRI = new HashMap<String, IRI>();
        this.pm.setDefaultPrefix("http://www.semanticweb.org/owl/owlapi/turtle#");
    }

    TurtleParser(InputStream is, TripleHandler handler, IRI base) {
        this(is);
        this.handler = handler;
        this.base = base;
        this.string2IRI = new HashMap<String, IRI>();
        this.pm.setDefaultPrefix("http://www.semanticweb.org/owl/owlapi/turtle#");
    }

    PrefixManager getPrefixManager() {
        return this.pm;
    }

    void setTripleHandler(TripleHandler handler) {
        this.handler = handler;
    }

    IRI getNextBlankNode(String id) {
        String string = id == null ? NodeID.nextAnonymousIRI() : (NodeID.isAnonymousNodeID(id) ? id : NodeID.getIRIFromNodeID(id));
        IRI iri = this.string2IRI.get(string);
        if (iri == null) {
            iri = IRI.create(string);
            this.string2IRI.put(string, iri);
        }
        return iri;
    }

    protected IRI getIRIFromQName(String qname) {
        int colonIndex = qname.indexOf(58);
        if (colonIndex == -1) {
            throw new ParseException("Not a valid qname (missing ':') " + qname);
        }
        String prefix = qname.substring(0, colonIndex + 1);
        if (prefix.equals("_:")) {
            return this.getIRI("genid" + qname.substring(colonIndex + 1));
        }
        if (!this.pm.containsPrefixMapping(prefix)) {
            throw new ParseException("Prefix not declared: " + prefix);
        }
        return this.pm.getIRI(qname);
    }

    IRI getIRI(String s) {
        IRI iri;
        if (s.charAt(0) == '<') {
            s = s.substring(1, s.length() - 1);
        }
        if ((iri = this.string2IRI.get(s)) == null) {
            iri = IRI.create(s);
            if (!iri.isAbsolute()) {
                iri = IRI.create(this.base.getNamespace().substring(0, this.base.getNamespace().lastIndexOf(47) + 1), s);
            }
            this.string2IRI.put(s, iri);
        }
        return iri;
    }

    final void parseDocument() {
        do {
            if (this.jj_2_1(2)) {
                this.parseDirective();
                this.jj_consume_token(24);
                continue;
            }
            if (this.jj_2_2(2)) {
                this.parseStatement();
                this.jj_consume_token(24);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        } while (this.jj_2_3(2));
        this.jj_consume_token(0);
        this.handler.handleEnd();
    }

    final void parseDirective() {
        if (this.jj_2_4(2)) {
            this.parsePrefixDirective();
        } else if (this.jj_2_5(2)) {
            this.parseBaseDirective();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final void parsePrefixDirective() {
        String prefix = "";
        this.jj_consume_token(26);
        Token t = this.jj_consume_token(40);
        prefix = t.image;
        IRI ns = this.parseIRI();
        this.pm.setPrefix(prefix, ns.toString());
        this.handler.handlePrefixDirective(prefix, ns.toString());
    }

    final void parseBaseDirective() {
        this.jj_consume_token(28);
        Token t = this.jj_consume_token(39);
        this.base = IRI.create(t.image.substring(1, t.image.length() - 1));
        this.handler.handleBaseDirective(this.base);
    }

    final void parseStatement() {
        this.parseTriples();
    }

    final void parseTriples() {
        IRI subject = this.parseSubject();
        if (this.jj_2_6(2)) {
            this.parsePredicateObjectList(subject);
        }
    }

    final IRI parseSubject() {
        IRI iri;
        if (this.jj_2_7(2)) {
            iri = this.parseResource();
        } else if (this.jj_2_8(2)) {
            iri = this.parseBlankNode();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return iri;
    }

    final IRI parseLoneNS() {
        Token t = this.jj_consume_token(40);
        return this.getIRIFromQName(t.image);
    }

    final IRI parseAbbreviatedIRI() {
        Token t = this.jj_consume_token(42);
        return this.getIRIFromQName(t.image);
    }

    final IRI parseIRI() {
        Token t = this.jj_consume_token(39);
        return this.getIRI(t.image);
    }

    final IRI parseBlankNode() {
        IRI iri = null;
        if (this.jj_2_11(2)) {
            iri = this.parseNodeID();
        } else if (this.jj_2_12(2)) {
            this.jj_consume_token(31);
            if (iri == null) {
                iri = this.getNextBlankNode(null);
            }
        } else if (this.jj_2_13(2)) {
            this.jj_consume_token(21);
            if (this.jj_2_10(2)) {
                if (iri == null) {
                    iri = this.getNextBlankNode(null);
                }
                this.parsePredicateObjectList(iri);
                if (this.jj_2_9(2)) {
                    this.jj_consume_token(24);
                }
            }
            this.jj_consume_token(22);
            if (iri == null) {
                iri = this.getNextBlankNode(null);
            }
        } else if (this.jj_2_14(2)) {
            iri = this.parseCollection();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return iri;
    }

    final IRI parseNodeID() {
        Token t = this.jj_consume_token(47);
        return this.getNextBlankNode(t.image);
    }

    final void parsePredicateObjectList(IRI subject) {
        IRI predicate = this.parseVerb();
        this.parseObjectList(subject, predicate);
        while (this.jj_2_15(2)) {
            this.jj_consume_token(25);
            predicate = this.parseVerb();
            this.parseObjectList(subject, predicate);
        }
        if (this.jj_2_16(2)) {
            this.jj_consume_token(25);
        }
    }

    final IRI parseVerb() {
        IRI iri;
        if (this.jj_2_17(2)) {
            this.jj_consume_token(30);
            iri = OWLRDFVocabulary.RDF_TYPE.getIRI();
        } else if (this.jj_2_18(2)) {
            iri = this.parsePredicate();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return iri;
    }

    final IRI parsePredicate() {
        IRI iri = this.parseResource();
        return iri;
    }

    final IRI parseResource() {
        IRI iri;
        if (this.jj_2_19(2)) {
            iri = this.parseIRI();
        } else if (this.jj_2_20(2)) {
            iri = this.parseAbbreviatedIRI();
        } else if (this.jj_2_21(2)) {
            iri = this.parseLoneNS();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return iri;
    }

    final void parseObjectList(IRI subject, IRI predicate) {
        this.parseObject(subject, predicate);
        while (this.jj_2_22(2)) {
            this.jj_consume_token(23);
            this.parseObject(subject, predicate);
        }
    }

    final void parseObject(IRI subject, IRI predicate) {
        if (this.jj_2_25(2)) {
            this.parseLiteral(subject, predicate);
        } else if (this.jj_2_26(2)) {
            IRI resObject;
            if (this.jj_2_23(2)) {
                resObject = this.parseResource();
            } else if (this.jj_2_24(2)) {
                resObject = this.parseBlankNode();
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.handler.handleTriple(subject, predicate, resObject);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final IRI parseCollection() {
        this.jj_consume_token(19);
        IRI iri = this.parseItemList();
        this.jj_consume_token(20);
        return iri;
    }

    final IRI parseItemList() {
        IRI firstSubject = OWLRDFVocabulary.RDF_NIL.getIRI();
        IRI subject = null;
        IRI type = OWLRDFVocabulary.RDF_TYPE.getIRI();
        IRI first = OWLRDFVocabulary.RDF_FIRST.getIRI();
        IRI rest = OWLRDFVocabulary.RDF_REST.getIRI();
        IRI list = OWLRDFVocabulary.RDF_LIST.getIRI();
        IRI nil = OWLRDFVocabulary.RDF_NIL.getIRI();
        while (this.jj_2_27(2)) {
            IRI prevSubject = subject;
            subject = this.getNextBlankNode(null);
            if (prevSubject != null) {
                this.handler.handleTriple(prevSubject, rest, subject);
            } else {
                firstSubject = subject;
            }
            if (subject != null) {
                this.handler.handleTriple(subject, type, list);
            }
            this.parseObject(subject, first);
        }
        if (subject != null) {
            this.handler.handleTriple(subject, rest, nil);
        }
        return firstSubject;
    }

    final void parseLiteral(IRI subject, IRI predicate) {
        String lang = null;
        IRI datatype = null;
        if (this.jj_2_31(2)) {
            String literal = this.parseQuotedString();
            if (this.jj_2_30(2)) {
                if (this.jj_2_28(2)) {
                    this.jj_consume_token(27);
                    datatype = this.parseResource();
                } else if (this.jj_2_29(2)) {
                    this.jj_consume_token(29);
                    Token t = this.jj_consume_token(41);
                    lang = t.image;
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (datatype != null) {
                this.handler.handleTriple(subject, predicate, literal, datatype);
            } else if (lang != null) {
                this.handler.handleTriple(subject, predicate, literal, lang);
            } else {
                this.handler.handleTriple(subject, predicate, literal);
            }
        } else if (this.jj_2_32(2)) {
            String literal = this.parseInteger();
            this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.INTEGER.getIRI());
        } else if (this.jj_2_33(2)) {
            String literal = this.parseDouble();
            this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.DOUBLE.getIRI());
        } else if (this.jj_2_34(2)) {
            String literal = this.parseDecimal();
            this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.DECIMAL.getIRI());
        } else if (this.jj_2_35(2)) {
            String literal = this.parseBoolean();
            this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.BOOLEAN.getIRI());
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final String parseInteger() {
        if (this.jj_2_36(2)) {
            Token t = this.jj_consume_token(15);
            return t.image;
        }
        if (this.jj_2_37(2)) {
            Token t = this.jj_consume_token(14);
            return t.image;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    final String parseDouble() {
        Token t = this.jj_consume_token(16);
        return t.image;
    }

    final String parseDecimal() {
        Token t = this.jj_consume_token(17);
        return t.image;
    }

    final String parseBoolean() {
        Token t;
        if (this.jj_2_38(2)) {
            t = this.jj_consume_token(33);
        } else if (this.jj_2_39(2)) {
            t = this.jj_consume_token(34);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return t.image;
    }

    final String parseQuotedString() {
        String s = this.parseString();
        return s;
    }

    final String parseString() {
        String rawString = "";
        if (this.jj_2_40(2)) {
            Token t = this.jj_consume_token(9);
            rawString = t.image.substring(1, t.image.length() - 1);
        } else if (this.jj_2_41(2)) {
            Token t = this.jj_consume_token(13);
            rawString = t.image.substring(3, t.image.length() - 3);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return EscapeUtils.unescapeString(rawString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    private boolean jj_3R_15() {
        return this.jj_3R_10();
    }

    private boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_32()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_33()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_34()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_35()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_31() {
        if (this.jj_3R_21()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_6() {
        return this.jj_3R_26();
    }

    private boolean jj_3_41() {
        return this.jj_scan_token(13);
    }

    private boolean jj_3_40() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3_5() {
        return this.jj_3R_8();
    }

    private boolean jj_3_17() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_40()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_41()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_18()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_8() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3_2() {
        if (this.jj_3R_6()) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3_10() {
        return this.jj_3R_9();
    }

    private boolean jj_3R_9() {
        if (this.jj_3R_14()) {
            return true;
        }
        return this.jj_3R_27();
    }

    private boolean jj_3_39() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_21() {
        return this.jj_3R_29();
    }

    private boolean jj_3_29() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        return this.jj_scan_token(41);
    }

    private boolean jj_3R_7() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_scan_token(40);
    }

    private boolean jj_3R_12() {
        return this.jj_scan_token(47);
    }

    private boolean jj_3_21() {
        return this.jj_3R_18();
    }

    private boolean jj_3_38() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_39()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_27() {
        return this.jj_3R_19();
    }

    private boolean jj_3R_28() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_27());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_5() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_5()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        return this.jj_3R_7();
    }

    private boolean jj_3_9() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3_14() {
        return this.jj_3R_13();
    }

    private boolean jj_3_1() {
        return this.jj_3R_5();
    }

    private boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_1()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_2()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_13() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(22);
    }

    private boolean jj_3_22() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_19();
    }

    private boolean jj_3R_24() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3_12() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3_11() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_12()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_13()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_14()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_23() {
        return this.jj_scan_token(16);
    }

    private boolean jj_3R_13() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_3R_28()) {
            return true;
        }
        return this.jj_scan_token(20);
    }

    private boolean jj_3_15() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_3R_14();
    }

    private boolean jj_3R_16() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3_18() {
        return this.jj_3R_15();
    }

    private boolean jj_3_8() {
        return this.jj_3R_11();
    }

    private boolean jj_3_37() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3_23() {
        return this.jj_3R_10();
    }

    private boolean jj_3_24() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_17() {
        return this.jj_scan_token(42);
    }

    private boolean jj_3_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_24()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_6() {
        return this.jj_3R_9();
    }

    private boolean jj_3_25() {
        return this.jj_3R_20();
    }

    private boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_36()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_37()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_19() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_25()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_26()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_36() {
        return this.jj_scan_token(15);
    }

    private boolean jj_3_28() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        return this.jj_3R_10();
    }

    private boolean jj_3_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_29()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_20() {
        return this.jj_3R_17();
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(40);
    }

    private boolean jj_3_16() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_27() {
        return this.jj_3R_19();
    }

    private boolean jj_3_35() {
        return this.jj_3R_25();
    }

    private boolean jj_3_34() {
        return this.jj_3R_24();
    }

    private boolean jj_3_33() {
        return this.jj_3R_23();
    }

    private boolean jj_3_32() {
        return this.jj_3R_22();
    }

    private boolean jj_3_7() {
        return this.jj_3R_10();
    }

    private boolean jj_3R_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_8()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_19() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_20()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_21()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_26() {
        if (this.jj_3R_30()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[0];
    }

    TurtleParser(InputStream stream) {
        this(stream, null);
    }

    TurtleParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new TurtleParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    TurtleParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new TurtleParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    TurtleParser(TurtleParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    void ReInit(TurtleParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[49];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 49; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    final void enable_tracing() {
    }

    final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 41; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        TurtleParser.jj_la1_init_0();
        TurtleParser.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

