/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.util;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.protege.editor.owl.ui.util.ProgressView;
import org.protege.editor.owl.ui.util.ProgressViewImpl;

public class ProgressDialog {
    private final JDialog dlg = new JDialog((Frame)null, "", true);
    private final ProgressView view = new ProgressViewImpl();

    public ProgressDialog() {
        this.dlg.setUndecorated(true);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
        this.dlg.setContentPane(contentPane);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.view.asJComponent(), "North");
    }

    public void setVisible(boolean visible) {
        Runnable r = () -> {
            if (visible) {
                this.dlg.pack();
                Dimension prefSize = this.dlg.getPreferredSize();
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Dimension screenSize = toolkit.getScreenSize();
                this.dlg.setLocation((screenSize.width - prefSize.width) / 2, (screenSize.height - prefSize.height) / 2);
                this.dlg.setVisible(true);
            } else {
                this.dlg.dispose();
            }
        };
        if (visible && SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void setMessage(String message) {
        Preconditions.checkNotNull((Object)message);
        Runnable r = () -> this.view.setMessage(message);
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void setSubMessage(String subMessage) {
        Preconditions.checkNotNull((Object)subMessage);
        Runnable r = () -> this.view.setSubMessage(subMessage);
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void clearSubMessage() {
        Runnable r = this.view::clearSubMessage;
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }
}

