//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.2
//
// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.Glacier2;

/**
 * The Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 *
 * @see Router
 **/
public interface PermissionsVerifierPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @return An instance of PermissionsVerifier.CheckPermissionsResult.
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     **/
    default PermissionsVerifier.CheckPermissionsResult checkPermissions(String userId, String password)
        throws PermissionDeniedException
    {
        return checkPermissions(userId, password, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param context The Context map to send with the invocation.
     * @return An instance of PermissionsVerifier.CheckPermissionsResult.
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     **/
    default PermissionsVerifier.CheckPermissionsResult checkPermissions(String userId, String password, java.util.Map<String, String> context)
        throws PermissionDeniedException
    {
        try
        {
            return _iceI_checkPermissionsAsync(userId, password, context, true).waitForResponseOrUserEx();
        }
        catch(PermissionDeniedException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @return A future that will be completed with an instance of PermissionsVerifier.CheckPermissionsResult.
     **/
    default java.util.concurrent.CompletableFuture<PermissionsVerifier.CheckPermissionsResult> checkPermissionsAsync(String userId, String password)
    {
        return _iceI_checkPermissionsAsync(userId, password, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Check whether a user has permission to access the router.
     * @param userId The user id for which to check permission.
     * @param password The user's password.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed with an instance of PermissionsVerifier.CheckPermissionsResult.
     **/
    default java.util.concurrent.CompletableFuture<PermissionsVerifier.CheckPermissionsResult> checkPermissionsAsync(String userId, String password, java.util.Map<String, String> context)
    {
        return _iceI_checkPermissionsAsync(userId, password, context, false);
    }

    /**
     * @hidden
     * @param iceP_userId -
     * @param iceP_password -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<PermissionsVerifier.CheckPermissionsResult> _iceI_checkPermissionsAsync(String iceP_userId, String iceP_password, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<PermissionsVerifier.CheckPermissionsResult> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "checkPermissions", com.zeroc.Ice.OperationMode.Nonmutating, sync, _iceE_checkPermissions);
        f.invoke(true, context, com.zeroc.Ice.FormatType.SlicedFormat, ostr -> {
                     ostr.writeString(iceP_userId);
                     ostr.writeString(iceP_password);
                 }, istr -> {
                     PermissionsVerifier.CheckPermissionsResult ret = new PermissionsVerifier.CheckPermissionsResult();
                     ret.read(istr);
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_checkPermissions =
    {
        PermissionDeniedException.class
    };

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static PermissionsVerifierPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), PermissionsVerifierPrx.class, _PermissionsVerifierPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static PermissionsVerifierPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), PermissionsVerifierPrx.class, _PermissionsVerifierPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static PermissionsVerifierPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), PermissionsVerifierPrx.class, _PermissionsVerifierPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static PermissionsVerifierPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), PermissionsVerifierPrx.class, _PermissionsVerifierPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static PermissionsVerifierPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, PermissionsVerifierPrx.class, _PermissionsVerifierPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static PermissionsVerifierPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, PermissionsVerifierPrx.class, _PermissionsVerifierPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default PermissionsVerifierPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (PermissionsVerifierPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default PermissionsVerifierPrx ice_adapterId(String newAdapterId)
    {
        return (PermissionsVerifierPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default PermissionsVerifierPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (PermissionsVerifierPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default PermissionsVerifierPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (PermissionsVerifierPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default PermissionsVerifierPrx ice_invocationTimeout(int newTimeout)
    {
        return (PermissionsVerifierPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default PermissionsVerifierPrx ice_connectionCached(boolean newCache)
    {
        return (PermissionsVerifierPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default PermissionsVerifierPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (PermissionsVerifierPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default PermissionsVerifierPrx ice_secure(boolean b)
    {
        return (PermissionsVerifierPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default PermissionsVerifierPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (PermissionsVerifierPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default PermissionsVerifierPrx ice_preferSecure(boolean b)
    {
        return (PermissionsVerifierPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default PermissionsVerifierPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (PermissionsVerifierPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default PermissionsVerifierPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (PermissionsVerifierPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default PermissionsVerifierPrx ice_collocationOptimized(boolean b)
    {
        return (PermissionsVerifierPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default PermissionsVerifierPrx ice_twoway()
    {
        return (PermissionsVerifierPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default PermissionsVerifierPrx ice_oneway()
    {
        return (PermissionsVerifierPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default PermissionsVerifierPrx ice_batchOneway()
    {
        return (PermissionsVerifierPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default PermissionsVerifierPrx ice_datagram()
    {
        return (PermissionsVerifierPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default PermissionsVerifierPrx ice_batchDatagram()
    {
        return (PermissionsVerifierPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default PermissionsVerifierPrx ice_compress(boolean co)
    {
        return (PermissionsVerifierPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default PermissionsVerifierPrx ice_timeout(int t)
    {
        return (PermissionsVerifierPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default PermissionsVerifierPrx ice_connectionId(String connectionId)
    {
        return (PermissionsVerifierPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default PermissionsVerifierPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (PermissionsVerifierPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::Glacier2::PermissionsVerifier";
    }
}
