/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.coordination.CoordinationMetaData;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.threadpool.ThreadPool;

public class ClusterFormationFailureHelper {
    private static final Logger logger = LogManager.getLogger(ClusterFormationFailureHelper.class);
    public static final Setting<TimeValue> DISCOVERY_CLUSTER_FORMATION_WARNING_TIMEOUT_SETTING = Setting.timeSetting("discovery.cluster_formation_warning_timeout", TimeValue.timeValueMillis((long)10000L), TimeValue.timeValueMillis((long)1L), Setting.Property.NodeScope);
    private final Supplier<ClusterFormationState> clusterFormationStateSupplier;
    private final ThreadPool threadPool;
    private final TimeValue clusterFormationWarningTimeout;
    private final Runnable logLastFailedJoinAttempt;
    @Nullable
    private volatile WarningScheduler warningScheduler;

    public ClusterFormationFailureHelper(Settings settings, Supplier<ClusterFormationState> clusterFormationStateSupplier, ThreadPool threadPool, Runnable logLastFailedJoinAttempt) {
        this.clusterFormationStateSupplier = clusterFormationStateSupplier;
        this.threadPool = threadPool;
        this.clusterFormationWarningTimeout = DISCOVERY_CLUSTER_FORMATION_WARNING_TIMEOUT_SETTING.get(settings);
        this.logLastFailedJoinAttempt = logLastFailedJoinAttempt;
    }

    public boolean isRunning() {
        return this.warningScheduler != null;
    }

    public void start() {
        assert (this.warningScheduler == null);
        this.warningScheduler = new WarningScheduler();
        this.warningScheduler.scheduleNextWarning();
    }

    public void stop() {
        this.warningScheduler = null;
    }

    static class ClusterFormationState {
        private final Settings settings;
        private final ClusterState clusterState;
        private final List<TransportAddress> resolvedAddresses;
        private final List<DiscoveryNode> foundPeers;
        private final long currentTerm;

        ClusterFormationState(Settings settings, ClusterState clusterState, List<TransportAddress> resolvedAddresses, List<DiscoveryNode> foundPeers, long currentTerm) {
            this.settings = settings;
            this.clusterState = clusterState;
            this.resolvedAddresses = resolvedAddresses;
            this.foundPeers = foundPeers;
            this.currentTerm = currentTerm;
        }

        String getDescription() {
            List clusterStateNodes = StreamSupport.stream(this.clusterState.nodes().spliterator(), false).map(DiscoveryNode::toString).collect(Collectors.toList());
            String discoveryWillContinueDescription = String.format(Locale.ROOT, "discovery will continue using %s from hosts providers and %s from last-known cluster state; node term %d, last-accepted version %d in term %d", this.resolvedAddresses, clusterStateNodes, this.currentTerm, this.clusterState.version(), this.clusterState.term());
            String discoveryStateIgnoringQuorum = String.format(Locale.ROOT, "have discovered %s; %s", this.foundPeers, discoveryWillContinueDescription);
            if (!this.clusterState.nodes().getLocalNode().isMasterNode()) {
                return String.format(Locale.ROOT, "master not discovered yet: %s", discoveryStateIgnoringQuorum);
            }
            if (this.clusterState.getLastAcceptedConfiguration().isEmpty()) {
                String bootstrappingDescription = ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.get(Settings.EMPTY).equals(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.get(this.settings)) ? "[" + ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey() + "] is empty on this node" : String.format(Locale.ROOT, "this node must discover master-eligible nodes %s to bootstrap a cluster", ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.get(this.settings));
                return String.format(Locale.ROOT, "master not discovered yet, this node has not previously joined a bootstrapped (v%d+) cluster, and %s: %s", Version.V_6_6_0.major + 1, bootstrappingDescription, discoveryStateIgnoringQuorum);
            }
            assert (!this.clusterState.getLastCommittedConfiguration().isEmpty());
            if (this.clusterState.getLastCommittedConfiguration().equals(CoordinationMetaData.VotingConfiguration.MUST_JOIN_ELECTED_MASTER)) {
                return String.format(Locale.ROOT, "master not discovered yet and this node was detached from its previous cluster, have discovered %s; %s", this.foundPeers, discoveryWillContinueDescription);
            }
            String quorumDescription = this.clusterState.getLastAcceptedConfiguration().equals(this.clusterState.getLastCommittedConfiguration()) ? this.describeQuorum(this.clusterState.getLastAcceptedConfiguration()) : this.describeQuorum(this.clusterState.getLastAcceptedConfiguration()) + " and " + this.describeQuorum(this.clusterState.getLastCommittedConfiguration());
            CoordinationState.VoteCollection voteCollection = new CoordinationState.VoteCollection();
            this.foundPeers.forEach(voteCollection::addVote);
            String isQuorumOrNot = CoordinationState.isElectionQuorum(voteCollection, this.clusterState) ? "is a quorum" : "is not a quorum";
            return String.format(Locale.ROOT, "master not discovered or elected yet, an election requires %s, have discovered %s which %s; %s", quorumDescription, this.foundPeers, isQuorumOrNot, discoveryWillContinueDescription);
        }

        private String describeQuorum(CoordinationMetaData.VotingConfiguration votingConfiguration) {
            Set<String> nodeIds = votingConfiguration.getNodeIds();
            assert (!nodeIds.isEmpty());
            int requiredNodes = nodeIds.size() / 2 + 1;
            HashSet<String> realNodeIds = new HashSet<String>(nodeIds);
            realNodeIds.removeIf(ClusterBootstrapService::isBootstrapPlaceholder);
            assert (requiredNodes <= realNodeIds.size()) : nodeIds;
            if (nodeIds.size() == 1) {
                return "a node with id " + realNodeIds;
            }
            if (nodeIds.size() == 2) {
                return "two nodes with ids " + realNodeIds;
            }
            if (requiredNodes < realNodeIds.size()) {
                return "at least " + requiredNodes + " nodes with ids from " + realNodeIds;
            }
            return requiredNodes + " nodes with ids " + realNodeIds;
        }
    }

    private class WarningScheduler {
        private WarningScheduler() {
        }

        private boolean isActive() {
            return ClusterFormationFailureHelper.this.warningScheduler == this;
        }

        void scheduleNextWarning() {
            ClusterFormationFailureHelper.this.threadPool.scheduleUnlessShuttingDown(ClusterFormationFailureHelper.this.clusterFormationWarningTimeout, "generic", new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    logger.debug("unexpected exception scheduling cluster formation warning", (Throwable)e);
                }

                @Override
                protected void doRun() {
                    if (WarningScheduler.this.isActive()) {
                        ClusterFormationFailureHelper.this.logLastFailedJoinAttempt.run();
                        logger.warn(((ClusterFormationState)ClusterFormationFailureHelper.this.clusterFormationStateSupplier.get()).getDescription());
                    }
                }

                @Override
                public void onAfter() {
                    if (WarningScheduler.this.isActive()) {
                        WarningScheduler.this.scheduleNextWarning();
                    }
                }

                public String toString() {
                    return "emit warning if cluster not formed";
                }
            });
        }
    }
}

